<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * panelPattern()
 * used in text.columns, text.transform, text.expandable
 *         panels.panel
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function panelPattern($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	        
     // html content
     $form[] = NgeFields::editor($objectPrefix .'html', '', '', NGE::translate('COM_NGE_FAKE_TEXT'));
        
    return implode($form);
}

/**
 * longpanelPattern()
 * used in text.columns, text.transform, text.expandable
 *         panels.panel
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function longpanelPattern($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	        
     // html content
     $form[] = NgeFields::editor($objectPrefix .'html', '', '', NGE::translate('COM_NGE_FAKE_LONGTEXT'));
        
    return implode($form);
}

/**
 * headerPattern()
 * used in text.columns, text.expandable
 *         panels.panel, panels.thumbnails
 *         images.image, images.zoomable
 *         media.video, media.flash
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function headerPattern($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // header label
    $form[] =  NgeFields::text($objectPrefix . 'label', 'COM_NGE_TITLE', 'COM_NGE_DESCRIPTION_TITLE', NGE::translate('COM_NGE_FAKE_TITLE'), array('attributes' => 'class="span6"'));

    // header glyph
    $form[] =  NgeFields::glyph($objectPrefix . 'glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH',NGE::translate('COM_NGE_FAKE_GLYPH'), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

    return implode($form);
    
}

/**
 * legendPattern()
 * used in text.columns, text.expandable
 *         panels.panel, panels.thumbnails
 *         images.image, images.zoomable
 *         media.video, media.flash
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 * @return
 */
function legendPattern($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // legend html editor
	$form[] =  NgeFields::editor($objectPrefix . 'html');

	return implode($form);
    
}

/**
 * badgePattern()
 * used in panel
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function badgePattern($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // badge label
    $form[] =  NgeFields::text($objectPrefix . 'label', 'COM_NGE_BADGE', 'COM_NGE_DESCRIPTION_BADGE', '', array('attributes' => 'class="span6"'));
    $form[] = NgeFields::glyph($objectPrefix . '.glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');

        $form[] = NgeFields::radio($objectPrefix . 'link.type','COM_NGE_LINK','COM_NGE_LINK_ON_CLINK','none', array(
        array('none', 'COM_NGE_NONE','data-success="false"'),
        array('menu', 'COM_NGE_LINK_TYPES_MENU','data-target="field:menu field:target"'),
        array('article', 'COM_NGE_LINK_TYPES_JOOMLA','data-target="field:article field:target"'),
        array('url', 'COM_NGE_CONTENT_URLLINK','data-target="field:url field:target"')
    ), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
    $form[] = NgeFields::select($objectPrefix . 'link.menu','COM_NGE_LINK_TYPES_MENU','COM_NGE_DESCRIPTION_LINK_MENU','', $multiple, $multipleIndex, 
        array(
            "ajax" => true,
            "options" => null,
            "target" => "joomla.menuitems",
            "multiple" => false
        )
    );
    $form[] = NgeFields::article($objectPrefix .'link.article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
    $form[] = NgeFields::url($objectPrefix .'link.url','COM_NGE_CONTENT_URLLINK','COM_NGE_DESCRIPTION_LINK_URL', array('attributes' => 'class="span12"'));
    
    return implode($form);
    
}

/**
 * multipleContentTitle()
 * used in panels.thumbnails
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function multiplePatternTitle($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // header label
    $form[] =  NgeFields::text($objectPrefix . 'header.label', 'COM_NGE_TITLE', 'COM_NGE_DESCRIPTION_TITLE', '', array('attributes' => 'class="span6"'));

    // header glyph
    $form[] =  NgeFields::glyph($objectPrefix . 'header.glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');

    return implode($form);
    
}

/**
  * multipleContentImage()
  * used in all multiple media widgets
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multiplePatternImage($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $tabsId = str_replace('.', '_', $objectPrefix);
    
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'source','COM_NGE_CONTENT','COM_NGE_DESCRIPTION_SOURCE','image', array(
        array('image', 'COM_NGE_IMAGE','data-target="field:image"'),
        array('video', 'COM_NGE_VIDEO','data-target="#' . $tabsId . '_videocontent"')
    ));
    
    $form[] = NgeFields::filemanager($objectPrefix . 'image','COM_NGE_CONTENT_IMAGE','','', 'images');
    
    $form[] = '<div id="' . $tabsId . '_videocontent">';
        
    $form[] = NgeFields::radio($objectPrefix . 'video.source','COM_NGE_VIDEO_SOURCE','','youtube', array(
        /*array('file', 'COM_NGE_CONTENT_FILE','data-target="field:content_video_files[]"'),*/
        array('youtube', 'COM_NGE_VIDEO_YOUTUBE','data-target="field:youtube"'),
        array('vimeo', 'COM_NGE_VIDEO_VIMEO','data-target="field:vimeo"'),
        array('dailymotion', 'COM_NGE_VIDEO_DAILYMOTION','data-target="field:dailymotion"'),
    array('file', 'COM_NGE_CONTENT_FILE','data-target="field:file"')
    ));
    /*$form[] = NgeFields::filemanager($objectPrefix . 'content_video_files','COM_NGE_CONTENT_FILE','COM_NGE_DESCRIPTION_CONTENT_FILE','', $multiple, $multipleIndex, 'videos');*/
    $form[] = NgeFields::text($objectPrefix . 'video.youtube', 'COM_NGE_VIDEO_EMBED_CODE', 'COM_NGE_VIDEO_EMBED_CODE_YOUTUBE', '', array('attributes' => 'class="span6"'));
    $form[] = NgeFields::text($objectPrefix . 'video.vimeo', 'COM_NGE_VIDEO_EMBED_CODE', 'COM_NGE_VIDEO_EMBED_CODE_VIMEO', '', array('attributes' => 'class="span6"'));
    $form[] = NgeFields::text($objectPrefix . 'video.dailymotion', 'COM_NGE_VIDEO_EMBED_CODE', 'COM_NGE_VIDEO_EMBED_CODE_DAILYMOTION', '', array('attributes' => 'class="span6"'));  
    $form[] = NgeFields::filemanager($objectPrefix . 'video.file','COM_NGE_CONTENT_FILE','COM_NGE_DESCRIPTION_CONTENT_FILE','', 'video');
    $form[] = '</div>';
    
    $form[] = NgeFields::radio($objectPrefix . 'link.type','COM_NGE_LINK','COM_NGE_LINK_ON_CLINK','none', array(
        array('none', 'COM_NGE_NONE','data-success="false"'),
        array('menu', 'COM_NGE_LINK_TYPES_MENU','data-target="field:menu field:target"'),
        array('article', 'COM_NGE_LINK_TYPES_JOOMLA','data-target="field:article field:target"'),
        array('url', 'COM_NGE_CONTENT_URLLINK','data-target="field:url field:target"')
    ), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
    $form[] = NgeFields::select($objectPrefix . 'link.menu','COM_NGE_LINK_TYPES_MENU','COM_NGE_DESCRIPTION_LINK_MENU','', $multiple, $multipleIndex, 
        array(
            "ajax" => true,
            "options" => null,
            "target" => "joomla.menuitems",
            "multiple" => false
        )
    );
    $form[] = NgeFields::article($objectPrefix .'link.article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
    $form[] = NgeFields::url($objectPrefix .'link.url','COM_NGE_CONTENT_URLLINK','COM_NGE_DESCRIPTION_LINK_URL', array('attributes' => 'class="span12"'));
    
    return implode($form);
}