<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
	

/**
 * config_headers()
 * complete title config screen
 * used in text.columns
 *         panels.panel, panels.thumbnails, panels.slider
 * @param mixed $objectPrefix
 
 * @return
 */
function config_tableheader($objectPrefix, $multiple=false, $multipleIndex=0){

    $form=array();
    $suffixRef = $multiple ? '_' . $multipleIndex : '';
    $form[] = ' 
                		<div class="tabbable tabs-left">
                			<ul id="tabs" class="nav nav-tabs" data-tabs="tabs">
                				<li class="active"><a href="#tabtableheaderdisplay'.$suffixRef.'" data-toggle="tab">'.NGE::translate('COM_NGE_DISPLAY' ).'</a></li>
                				<li><a href="#tabtableheaderfont'.$suffixRef.'" data-toggle="tab">'.NGE::translate('COM_NGE_FONT' ).'</a></li>
                				<li><a href="#tabtableheaderborder'.$suffixRef.'" data-toggle="tab">'.NGE::translate( 'COM_NGE_BORDER' ).'</a></li>
                				<li><a href="#tabtableheaderbackground'.$suffixRef.'" data-toggle="tab">'.NGE::translate( 'COM_NGE_BACKGROUND' ).'</a></li>
                			</ul>
                			<div class="tab-content">
                				<div class="tab-pane active" id="tabtableheaderdisplay'.$suffixRef.'">';
     $form[] =     					NgeFields::formlayout('parts.data.table', 'tableDisplay', 'tableheader');
     $form[] = '   				</div>
                				<div class="tab-pane" id="tabtableheaderfont'.$suffixRef.'">';
     $form[] =     					NgeFields::formlayout('parts.data.table', 'tableFont', 'tableheader');
     $form[] = '				</div>
                				<div class="tab-pane" id="tabtableheaderborder'.$suffixRef.'">';
     $form[] =     					NgeFields::formlayout('parts.core.base', 'border', 'tableheader.border');
     $form[] = '				</div>
                				<div class="tab-pane" id="tabtableheaderbackground'.$suffixRef.'">';
     $form[] =     					NgeFields::formlayout('parts.core.base', 'background', 'tableheader.background');
      $form[] = '				</div>
                			</div>
                		</div>';
    
    return implode($form);
}



/**
 * config_header()
 * complete title config screen
 * used in text.columns
 *         panels.panel, panels.thumbnails, panels.slider
 * @param mixed $objectPrefix
 
 * @return
 */
function config_tablebody($objectPrefix, $multiple=false, $multipleIndex=0){
    //$objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = ' <div id="content_tableheader_display">
                	<div class="tab-pane" id="tabtableheader">
                		<div class="tabbable tabs-left">
                			<ul id="tabs" class="nav nav-tabs" data-tabs="tabs">
                				<li class="active"><a href="#tabtablebodydisplay" data-toggle="tab">'.NGE::translate('COM_NGE_DISPLAY' ).'</a></li>
                				<li><a href="#tabtablebodyfont" data-toggle="tab">'.NGE::translate('COM_NGE_FONT' ).'</a></li>
                				<li><a href="#tabtablebodyborder" data-toggle="tab">'.NGE::translate( 'COM_NGE_BORDER' ).'</a></li>
                				<li><a href="#tabtablebodybackground" data-toggle="tab">'.NGE::translate( 'COM_NGE_BACKGROUND' ).'</a></li>
                			</ul>
                			<div class="tab-content">
                				<div class="tab-pane active" id="tabtablebodydisplay">';
     $form[] =     					NgeFields::formlayout('parts.data.table', 'tableDisplay', 'body');
     $form[] = '   				</div>
                				<div class="tab-pane" id="tabtablebodyfont">';
     $form[] =     					NgeFields::formlayout('parts.data.table', 'tableFont', 'body');
     $form[] = '				</div>
                				<div class="tab-pane" id="tabtablebodyborder">';
     $form[] =     					NgeFields::formlayout('parts.core.base', 'border', 'body.border');
     $form[] = '				</div>
                				<div class="tab-pane" id="tabtablebodybackground">';
     $form[] =     					NgeFields::formlayout('parts.core.base', 'background', 'body.background');
      $form[] = '				</div>
                			</div>
                		</div>
                	</div>
                </div>';


    
    return implode($form);
}


/**
 * titleDisplay()
 * used in formlayout config_header
 *         panels.thumbnails
 *         galleries.thumbnails
 * 
 * @param mixed $objectPrefix
 
 * @return
 */
function tableDisplay($objectPrefix, $multiple=false, $multipleIndex=0) {
    $form=array();
    
    // horizontal align
    $form[] = NGEFields::radio($objectPrefix . '.align', 'COM_NGE_TEXT_ALIGN', 'COM_NGE_DESCRIPTION_TEXT_ALIGN', 'left', array(
    	array('left', 'COM_NGE_TEXT_ALIGN_LEFT'), 
    	array('center', 'COM_NGE_TEXT_ALIGN_CENTER'), 
    	array('right', 'COM_NGE_TEXT_ALIGN_RIGHT')
    	));

    // horizontal padding
        $form[] = NGEFields::slider($objectPrefix . '.hpadding','COM_NGE_HPADDING','COM_NGE_DESCRIPTION_HPADDING','6', 'min="0" max="100"step="1"');

    // vertical padding
        $form[] = NGEFields::slider($objectPrefix . '.vpadding','COM_NGE_VPADDING','COM_NGE_DESCRIPTION_VPADDING','2', 'min="0" max="100"step="1"');

	return implode($form);
    
}


/**
 * optionsFont()
 * used in formlayout config_header
 * used in text.label, navigation.button
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function tableFont($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = $objectPrefix != "" ? $objectPrefix . '.' : "";
    $form=array();

    // font style
    $form[] = NGEFields::radio($objectPrefix . 'font.style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active field:weight field:italic field:case"'), 
    	array('class', 'COM_NGE_FONT_CLASSCSS','data-target="field:class"')
    	));
    
    // font class
    $form[] = NGEFields::text($objectPrefix .'font.class', 'COM_NGE_FONT_CLASSNAME', 'COM_NGE_DESCRIPTION_FONT_CLASSNAME');

    // font name
    $form[] = NGEFields::font($objectPrefix .'font.name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME');
	
    // font color
    $form[] = NGEFields::color($objectPrefix .'font.color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666');
	
    // font color hover
    $form[] = NGEFields::color($objectPrefix .'font.color_hover', 'COM_NGE_FONT_COLOR_HOVER', 'COM_NGE_DESCRIPTION_FONT_COLOR_HOVER');

    // font size
    $form[] = NGEFields::slider($objectPrefix .'font.size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '12', 'min="0" max="72"step="1"');
    
    // font letter spacing
	$form[] = NGEFields::slider($objectPrefix .'font.letter_spacing', 'COM_NGE_FONT_LETTER_SPACING', 'COM_NGE_DESCRIPTION_FONT_LETTER_SPACING', '0', 'min="-5" max="10"step="1"');
    
    // font weight				    
	$form[] = NGEFields::radio($objectPrefix .'font.weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
	    array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
	    array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
	    array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
	    array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
	    ));
        
     // font italic
	$form[] = NGEFields::radio($objectPrefix .'font.italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0');

    // font case				    
	$form[] = NGEFields::radio($objectPrefix .'font.case', 'COM_NGE_FONT_CASE', 'COM_NGE_DESCRIPTION_FONT', 'none', array(
	    array('none', 'COM_NGE_DEFAULT', ''),
	    array('capitalize', 'COM_NGE_FONT_CASE_CAPITALIZE'),
	    array('uppercase', 'COM_NGE_FONT_CASE_UPPERCASE'),
	    array('lowercase', 'COM_NGE_FONT_CASE_LOWERCASE')
	    ));

	return implode($form);
    
}


/**
 * config_headers()
 * complete title config screen
 * used in text.columns
 *         panels.panel, panels.thumbnails, panels.slider
 * @param mixed $objectPrefix
 
 * @return
 */
function config_tablecolumns($objectPrefix, $multiple=false, $multipleIndex=0){
    //$objectPrefix = (isset($objectPrefix) && $objectPrefix != "" && $objectPrefix[strlen($objectPrefix)-1]!='.') ? $objectPrefix . '.' : "";
    $form=array();
    $suffixRef = $multiple ? '_' . str_replace('.', '_',$objectPrefix) . $multipleIndex : '';
    $selfId = '_' . str_replace('.', '_',$objectPrefix);
    $form[] = ' 
                		<div class="tabbable tabs-left">
                			<ul id="tabs" class="nav nav-tabs" data-tabs="tabs">
                				<li class="active"><a href="#tabdisplay'.$selfId.'" data-toggle="tab">'.NGE::translate('COM_NGE_DISPLAY' ).'</a></li>
                				<li><a href="#tabfont'.$selfId.'" data-toggle="tab">'.NGE::translate('COM_NGE_FONT' ).'</a></li>
                				<li><a href="#tabborder'.$selfId.'" data-toggle="tab">'.NGE::translate( 'COM_NGE_BORDER' ).'</a></li>
                				<li><a href="#tabbackground'.$selfId.'" data-toggle="tab">'.NGE::translate( 'COM_NGE_BACKGROUND' ).'</a></li>
                			</ul>
                			<div class="tab-content">
                				<div class="tab-pane active" id="tabdisplay'.$selfId.'">';
     $form[] =     					NgeFields::formlayout('parts.data.table', 'tableDisplays', $objectPrefix);
     $form[] = '   				</div>
                				<div class="tab-pane" id="tabfont'.$selfId.'">';
     $form[] =     					NgeFields::formlayout('parts.data.table', 'tableFonts', $objectPrefix);
     $form[] = '				</div>
                				<div class="tab-pane" id="tabborder'.$selfId.'">';
     $form[] =     					NgeFields::formlayout('parts.core.base', 'borderDefault', $objectPrefix . 'border');
     $form[] = '				</div>
                				<div class="tab-pane" id="tabbackground'.$selfId.'">';
     $form[] =     					NgeFields::formlayout('parts.core.base', 'backgroundDefault', $objectPrefix . 'background');
      $form[] = '				</div>
                			</div>
                		</div>';
    
    return implode($form);
}


/**
 * titleDisplay()
 * used in formlayout config_header
 *         panels.thumbnails
 *         galleries.thumbnails
 * 
 * @param mixed $objectPrefix
 
 * @return
 */
function tableDisplays($objectPrefix, $multiple=false, $multipleIndex=0) {

    $form=array();
    
    // horizontal align
    $form[] = NGEFields::radio($objectPrefix . 'align', 'COM_NGE_TEXT_ALIGN', 'COM_NGE_DESCRIPTION_TEXT_ALIGN', 'left', array(
    	array('left', 'COM_NGE_TEXT_ALIGN_LEFT'), 
    	array('center', 'COM_NGE_TEXT_ALIGN_CENTER'), 
    	array('right', 'COM_NGE_TEXT_ALIGN_RIGHT')
    	), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

    // horizontal padding
        $form[] = NGEFields::slider($objectPrefix . 'hpadding','COM_NGE_HPADDING','COM_NGE_DESCRIPTION_HPADDING','12', 'min="0" max="100"step="1"', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

    // vertical padding
        $form[] = NGEFields::slider($objectPrefix . 'vpadding','COM_NGE_VPADDING','COM_NGE_DESCRIPTION_VPADDING','8', 'min="0" max="100"step="1"', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

    return implode($form);
    
}


/**
 * optionsFont()
 * used in formlayout config_header
 * used in text.label, navigation.button
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function tableFonts($objectPrefix, $multiple=false, $multipleIndex=0) {

    $form=array();

    // font style
    $form[] = NGEFields::radio($objectPrefix . 'font.style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active field:weight field:italic field:case"'), 
    	array('class', 'COM_NGE_FONT_CLASSCSS','data-target="field:class"')
    	), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
    
    // font class
    $form[] = NGEFields::text($objectPrefix .'font.class', 'COM_NGE_FONT_CLASSNAME', 'COM_NGE_DESCRIPTION_FONT_CLASSNAME', '', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

    // font name
    $form[] = NGEFields::font($objectPrefix .'font.name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME', '', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
	
    // font color
    $form[] = NGEFields::color($objectPrefix .'font.color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
	
    // font color hover
    $form[] = NGEFields::color($objectPrefix .'font.color_hover', 'COM_NGE_FONT_COLOR_HOVER', 'COM_NGE_DESCRIPTION_FONT_COLOR_HOVER', '', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

    // font size
    $form[] = NGEFields::slider($objectPrefix .'font.size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '12', 'min="0" max="72"step="1"', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
    
    // font letter spacing
	$form[] = NGEFields::slider($objectPrefix .'font.letter_spacing', 'COM_NGE_FONT_LETTER_SPACING', 'COM_NGE_DESCRIPTION_FONT_LETTER_SPACING', '0', 'min="-5" max="10"step="1"', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
    
    // font weight				    
	$form[] = NGEFields::radio($objectPrefix .'font.weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
	    array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
	    array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
	    array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
	    array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
	    ), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));
        
     // font italic
	$form[] = NGEFields::radio($objectPrefix .'font.italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0', array(), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

    // font case				    
	$form[] = NGEFields::radio($objectPrefix .'font.case', 'COM_NGE_FONT_CASE', 'COM_NGE_DESCRIPTION_FONT', 'none', array(
	    array('none', 'COM_NGE_DEFAULT', ''),
	    array('capitalize', 'COM_NGE_FONT_CASE_CAPITALIZE'),
	    array('uppercase', 'COM_NGE_FONT_CASE_UPPERCASE'),
	    array('lowercase', 'COM_NGE_FONT_CASE_LOWERCASE')
	    ), array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

	return implode($form);
}
