<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;


/**
 * config_search()
 * complete search config screen
 * used in text.columns
 *         panels.panel, panels.thumbnails, panels.slider
 * @param mixed $objectPrefix

 * @return
 */
 function searchOptions($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
        $form[] = NGEFields::radio('search.style', 'Style', "Options pour les lignes du tableau.", 'default', array(
				array('default', 'COM_NGE_DEFAULT'),
				array('custom', 'COM_NGE_CUSTOM', 'data-target="#tabsearchcustom"'),
				array('pattern', 'COM_NGE_PATTERN', 'data-target="#field_search_pattern"')
			    ));
	$form[] = NGEFields::pattern('search.pattern', 'Modèle', "Modèle général d'affichage des lignes.", 'part.option', 'panel.search');

    $form[] = '<div class="tab-pane" id="tabsearchcustom">
                		<div class="tabbable tabs-left">
                			<ul id="tabs" class="nav nav-tabs" data-tabs="tabs">
                				<li class="active"><a href="#tabsearchdisplay" data-toggle="tab">'.NGE::translate('COM_NGE_DISPLAY' ).'</a></li>
                				<li><a href="#tabsearchfont" data-toggle="tab">'.NGE::translate( 'COM_NGE_FONT' ).'</a></li>
                				<li><a href="#tabsearchborder" data-toggle="tab">'.NGE::translate( 'COM_NGE_BORDER' ).'</a></li>
                				<li><a href="#tabsearchbackground" data-toggle="tab">'.NGE::translate( 'COM_NGE_BACKGROUND' ).'</a></li>
                			</ul>
                			<div class="tab-content">
                				<div class="tab-pane active" id="tabsearchdisplay">';
    $form[] =     					NgeFields::formlayout('parts.core.base', 'optionsLegend', 'search');
    $form[] = '    				</div>
                				<div class="tab-pane" id="tabsearchfont">';
    $form[] =     					NgeFields::formlayout('parts.core.base', 'fontBody', 'search.font');
    $form[] = '    				</div>
                				<div class="tab-pane" id="tabsearchborder">';
    $form[] =     					NgeFields::formlayout('parts.core.base', 'border', 'search.border');
    $form[] = '   				</div>
                				<div class="tab-pane" id="tabsearchbackground">';
    $form[] =     					NgeFields::formlayout('parts.core.base', 'background', 'search.background');
    $form[] = '            		</div>
                			</div>
                		</div>
                </div>';
    return implode($form);
}