<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
	

/**
 * linkContent()
 * 
 * @param mixed $objectPrefix
 
 * @return
 */
function linkContent($objectPrefix, $multiple=false, $multipleIndex=0) {
    $form=array();
    
    $form[] = NGEFields::radio($objectPrefix . '.source', 'COM_NGE_CONTENT', 'COM_NGE_DESCRIPTION_SOURCE', 'database.input', array(
    array('database.input', 'COM_NGEDATA_CONTENT_INPUT','data-target="field:input"'),
    array('database.file', 'COM_NGE_CONTENT_FILE','data-target="field:file"'),
    array('database.query', 'COM_NGEDATA_CONTENT_QUERY','data-target="field:query"')
    ));

    // data personnalisées (handsontable)
    $form[] = NgeFields::handsontable($objectPrefix . '.database.input', 'Saisie de données manuelle', 'Saisie de données manuelle', '', 0, false, 
	array(
	    "render" => "", 
	    "start_cols" => 2, 
	    "start_rows" => 5,
	    "stretchH" => "all",
	    "height" => "280px",
	    "colHeadersOptions" => array(
		"defaultValue" => ["Libellé", "Lien"]
                    )
	)	    
    );

    $form[] = NgeFields::filemanager($objectPrefix . '.file','COM_NGE_CONTENT_FILE','COM_NGE_DESCRIPTION_CONTENT_FILE','', 'images');
    $form[] = NgeFields::textarea($objectPrefix . '.query', 'Sql query', 'select ref, nom, price FROM jos_jea_properties ORDER BY ref ');			
	
return implode($form);
    
}


/**
 * linkContent()
 * 
 * @param mixed $objectPrefix
 
 * @return
 */
function displayContent($objectPrefix, $multiple=false, $multipleIndex=0) {
    $form=array();
    
    $form[] = NGEFields::radio($objectPrefix . '.source', 'COM_NGE_SOURCE', 'COM_NGE_DESCRIPTION_SOURCE', 'database.input', array(
    array('database.input', 'COM_NGEDATA_CONTENT_INPUT','data-target="field:input"'),
    array('database.file', 'COM_NGE_CONTENT_FILE','data-target="field:name"'),
    array('database.db', 'COM_NGEDATA_CONTENT_QUERY','data-target="field:query"'),
    array('database.webservice', 'COM_NGEDATA_CONTENT_WEBSERVICE','data-target="field:url"'),
    ));

    // data personnalisées (handsontable)
    $form[] = NgeFields::handsontable($objectPrefix . '.database.input', 'Saisie de données manuelle', 'Saisie de données manuelle', '', 0, false, 
	array(
	    "render" => "", 
	    "start_cols" => 5, 
	    "start_rows" => 10,
	    "stretchH" => "all",
	    "height" => "280px"
	)
    );

    $form[] = NgeFields::filemanager($objectPrefix . '.database.file.name','COM_NGE_CONTENT_FILE','COM_NGE_DESCRIPTION_CONTENT_FILE','', 'images');
    $form[] = NgeFields::textarea($objectPrefix . '.database.db.query', 'Sql query', 'select ref, nom, price FROM jos_jea_properties ORDER BY ref ');			
    $form[] = NgeFields::text($objectPrefix . '.database.webservice.url', 'Url', '');
return implode($form);
    
}