<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * transform_option()
 * used in text.transform
 * 
 * @param mixed $objectPrefix
 * @return
 */
function optionsTransform($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // trigger
    $form[] = NgeFields::radio($objectPrefix . 'trigger', 'COM_NGE_TRIGGER', 'COM_NGE_DESCRIPTION_TRIGGER', 'display', array(
    	array('display', 'COM_NGE_ALWAYS','data-target="field:rotate field:scalex field:scaley field:translatex field:translatey field:skewx field:skewy field:"'), 
    	array('hover', 'COM_NGE_HOVER','data-target="field:rotate field:scalex field:scaley field:translatex field:translatey field:skewx field:skewy field:"'), 
    	array('outside', 'COM_NGE_OUTSIDE','data-target="field:rotate field:scalex field:scaley field:translatex field:translatey field:skewx field:skewy field:"')
	)); 

    // rotate
    $form[] = NgeFields::slider($objectPrefix . 'rotate','COM_NGE_TRANSFORM_ROTATE','COM_NGE_DESCRIPTION_TRANSFORM_ROTATE','0', 'min="0" max="360"step="1"');

    // scale x
    $form[] = NgeFields::slider($objectPrefix . 'scalex','COM_NGE_TRANSFORM_HORIZONTAL_SCALE','COM_NGE_DESCRIPTION_TRANSFORM_HORIZONTAL_SCALE','1', 'min="0" max="2"step="0.1"');
    
    // scale y
    $form[] = NgeFields::slider($objectPrefix . 'scaley','COM_NGE_TRANSFORM_VERTICAL_SCALE','COM_NGE_DESCRIPTION_TRANSFORM_VERTICAL_SCALE','1', 'min="0" max="2"step="0.1"');
    
    // translation x
    $form[] = NgeFields::slider($objectPrefix . 'translatex','COM_NGE_TRANSFORM_HORIZONTAL_TRANSLATE','COM_NGE_DESCRIPTION_TRANSFORM_HORIZONTAL_TRANSLATE','0', 'min="-100" max="100"step="1"');
    
    // translation y
    $form[] = NgeFields::slider($objectPrefix . 'translatey','COM_NGE_TRANSFORM_VERTICAL_TRANSLATE','COM_NGE_DESCRIPTION_TRANSFORM_VERTICAL_TRANSLATE','0', 'min="-100" max="100"step="1"');

    // skew x
    $form[] = NgeFields::slider($objectPrefix . 'skewx','COM_NGE_TRANSFORM_HORIZONTAL_SKEW','COM_NGE_DESCRIPTION_TRANSFORM_HORIZONTAL_SKEW','0', 'min="0" max="45"step="1"');

    // skew y
    $form[] = NgeFields::slider($objectPrefix . 'skewy','COM_NGE_TRANSFORM_VERTICAL_SKEW','COM_NGE_DESCRIPTION_TRANSFORM_VERTICAL_SKEW','0', 'min="0" max="45"step="1"');
    

    
 	return implode($form);
    
}