<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
	
    
 /**
  * multipleThumbnailsContent()
  * used in panels.thumbnails
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleThumbnailsContent($objectPrefix, $multiple=false, $multipleIndex=0){
    $form=array();
    
    $tabPrefix = str_replace('.', '_', $objectPrefix);
    $form[] = '<div class="tab-pane tabs">
    		      <ul class="nav nav-tabs" data-tabs="tabs">
    			     <li class="active"><a href="#'.$tabPrefix . '_content" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT').'</a></li>			
    			     <li><a href="#'.$tabPrefix . '_title" data-toggle="tab">'.NGE::translate('COM_NGE_TITLE').'</a></li>			
    			     <li><a href="#'.$tabPrefix . '_link" data-toggle="tab">'.NGE::translate('COM_NGE_LINK').'</a></li>													
    		      </ul>
    		      <div class="tab-content">
        			<div class="tab-pane active" id="'.$tabPrefix . '_content">';

    $form[] =             NgeFields::formlayout('parts.core.content', 'panelContent', $objectPrefix);
    $form[] = '		</div>
        			<div class="tab-pane" id="'.$tabPrefix . '_title">';
    $form[] =             NgeFields::formlayout('parts.core.content', 'multipleContentTitle', $objectPrefix);
    $form[] = '		</div>					
        			<div class="tab-pane" id="'.$tabPrefix . '_link">';
    $form[] =             NgeFields::formlayout('parts.core.base', 'contentLink', $objectPrefix . '.link');
    $form[] = '		</div>    
    
    		      </div>
    		</div>';	
    
    return implode($form);
}

    
 /**
  * multipleThumbnailsContent()
  * used in panels.thumbnails
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleLayoutThumbnailsContent($objectPrefix, $multiple=false, $multipleIndex=0){
    $form=array();
    
    $tabPrefix = str_replace('.', '_', $objectPrefix);
    $form[] = '<div class="tab-pane tabs">
    		      <ul class="nav nav-tabs" data-tabs="tabs">
    			     <li class="active"><a href="#'.$tabPrefix . '_content" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT').'</a></li>			
    			     <li><a href="#'.$tabPrefix . '_title" data-toggle="tab">'.NGE::translate('COM_NGE_TITLE').'</a></li>			
    			     <li><a href="#'.$tabPrefix . '_link" data-toggle="tab">'.NGE::translate('COM_NGE_LINK').'</a></li>													
    		      </ul>
    		      <div class="tab-content">
        			<div class="tab-pane active" id="'.$tabPrefix . '_content">';

    $form[] =             NgeFields::formlayout('parts.core.content', 'panelContent', $objectPrefix);
    $form[] = '		</div>
        			<div class="tab-pane" id="'.$tabPrefix . '_title">';
    $form[] =             NgeFields::formlayout('parts.core.content', 'multipleContentTitle', $objectPrefix);
    $form[] = '		</div>					
        			<div class="tab-pane" id="'.$tabPrefix . '_link">';
    $form[] =             NgeFields::formlayout('parts.core.base', 'contentLink', $objectPrefix . '.link');
    $form[] = '		</div>    
    
    		      </div>
    		</div>';	
    
    return implode($form);
}


 /**
  * multipleThumbnailsContentMedia()
  * used in galleries.thumbnails
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleThumbnailsContentMedia($objectPrefix, $multiple=false, $multipleIndex=0){
     $form=array();

     $tabPrefix = str_replace('.', '_', $objectPrefix);
    $form[] = '
    <div class="tab-pane tabs">
        <ul class="nav nav-tabs" data-tabs="tabs">
            <li class="active"><a href="#' . $tabPrefix . '_content" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT_IMAGE').'</a></li>
            <li><a href="#' . $tabPrefix . '_hover" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT_CAPTION').'</a></li>
            <li><a href="#'.$tabPrefix . '_link" data-toggle="tab">'.NGE::translate('COM_NGE_LINK').'</a></li>		
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="'.$tabPrefix . '_content">';    
	$form[] = NgeFields::formlayout('parts.core.content', 'multipleContentImage', $objectPrefix);
    $form[] = '
            </div>
            <div class="tab-pane" id="'.$tabPrefix . '_hover">';
	$form[] = NgeFields::editor($objectPrefix . '.caption.html');
    $form[] = '
            </div>
            <div class="tab-pane" id="'.$tabPrefix . '_link">';
    $form[] =             NgeFields::formlayout('parts.core.base', 'contentLink', $objectPrefix . '.link', $multiple, $multipleIndex);
    $form[] = '		</div>	    
          </div>
    </div>';	
    
    return implode($form);
}


 /**
  * multipleThumbnailsContentMedia()
  * used in galleries.thumbnails
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleLayoutThumbnailsContentMedia($objectPrefix, $multiple=false, $multipleIndex=0){
     $form=array();

     $tabPrefix = str_replace('.', '_', $objectPrefix);
    $form[] = '
    <div class="tab-pane tabs">
        <ul class="nav nav-tabs" data-tabs="tabs">
            <li class="active"><a href="#' . $tabPrefix . '_content" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT_IMAGE').'</a></li>
            <li><a href="#' . $tabPrefix . '_hover" data-toggle="tab">'.NGE::translate('COM_NGE_CONTENT_CAPTION').'</a></li>			
        </ul>
        <div class="tab-content">
            <div class="tab-pane active" id="'.$tabPrefix . '_content">';    
	$form[] = NgeFields::formlayout('parts.core.content', 'multipleContentImage', $objectPrefix);
    $form[] = '
            </div>
            <div class="tab-pane" id="'.$tabPrefix . '_hover">';
	$form[] = NgeFields::editor($objectPrefix . '.caption.html');
    $form[] = '
            </div>
          </div>
    </div>';	
    
    return implode($form);
}

/**
 * thumbnailOptionsHorizontal()
 * used in panels.thumbnails
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function thumbnailOptionsHorizontal($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
        
    // items by row
    $form[] = NgeFields::radio($objectPrefix . 'width.itemsbyrow', 'COM_NGE_PANELS_THUMBNAILS_NUMBERROW', 'COM_NGE_DESCRIPTION_PANELS_THUMBNAILS_NUMBERROW', '3', array(
    	array('1', '1'),
        array('2', '2'),
        array('3', '3'),
        array('4', '4'),
        array('6', '6'),
        array('12', '12')
    	)); 
	
    return implode($form);     
}

/**
 * thumbnailOptionsVertical()
 * used in panels.thumbnails
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function thumbnailOptionsVertical($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // vertical height
    $form[] = NgeFields::radio($objectPrefix . 'height.mode', 'COM_NGE_HEIGHT_MODE', 'COM_NGE_DESCRIPTION_HEIGHT_MODE', 'maxheight', array(
    	array('content', 'COM_NGE_CONTENT'), 
    	array('maxheight', 'COM_NGE_HEIGHT_MAXHEIGHT'),
    	array('square', 'COM_NGE_HEIGHT_SQUARE')
    	)); 
     
    return implode($form);
}

/**
 * textThumbnailOptions()
 * use in panels.grid
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 
 * @return
 */
function textThumbnailOptions($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

        $form[] = '<div class="tabbable tabs-left">
		    <ul id="tabs" class="nav nav-tabs" data-tabs="tabs">
			    <li class="active"><a href="#tabbodyoptions" data-toggle="tab">' . NGE::translate('COM_NGE_DISPLAY') . '</a></li>
			    <li><a href="#tabbodyheader" data-toggle="tab">' . NGE::translate('COM_NGE_TITLE') . '</a></li>
			    <li><a href="#tabbodyborder" data-toggle="tab">' . NGE::translate('COM_NGE_BORDER') . '</a></li>
			    <li><a href="#tabbodybackground" data-toggle="tab">' . NGE::translate('COM_NGE_BACKGROUND') . '</a></li>
			    <li><a href="#tabbodyshadow" data-toggle="tab">' . NGE::translate('COM_NGE_SHADOW') . '</a></li>
		    </ul>
		    <div class="tab-content">
			    <div class="tab-pane active" id="tabbodyoptions">';
					// thumbnails padding
				           $form[] =  NGEFields::slider($objectPrefix . 'body.padding', 'COM_NGE_PADDING', 'COM_NGE_DESCRIPTION_PADDING', '10', false, 0,'min="0" max="50" step="1"');
				    //animation effects
					$form[] =  '
			    </div>
			    <div class="tab-pane" id="tabbodyheader">
				    <div class="tabbable tabs-left">
					    <ul id="tabs" class="nav nav-tabs" data-tabs="tabs">
						    <li class="active"><a href="#tabbodyheaderdisplay" data-toggle="tab">' . NGE::translate('COM_NGE_DISPLAY') . '</a></li>
						    <li><a href="#tabbodyheaderfont" data-toggle="tab">' . NGE::translate('COM_NGE_FONT') . '</a></li>
						    <li><a href="#tabbodyheadericon" data-toggle="tab">' . NGE::translate('COM_NGE_GLYPH') . '</a></li>
						    <li><a href="#tabbodyheaderborder" data-toggle="tab">' . NGE::translate('COM_NGE_BORDER') . '</a></li>
						    <li><a href="#tabbodyheaderbackground" data-toggle="tab">' . NGE::translate('COM_NGE_BACKGROUND') . '</a></li>
					    </ul>
					    <div class="tab-content">
						    <div class="tab-pane active" id="tabbodyheaderdisplay">';
							$form[] =  NgeFields::formLayout('parts.core.base', 'titleDisplay', 'thumbnails.header');
						    $form[] =  '</div>
						    <div class="tab-pane" id="tabbodyheaderfont">';
						    $form[] =  NgeFields::formLayout('parts.core.base', 'titleFont', 'thumbnails.header.font');
						    $form[] =  '</div>';
						    $form[] =  '<div class="tab-pane" id="tabbodyheadericon">';
							        $form[] =  NgeFields::formLayout('parts.core.base', 'glyph', 'thumbnails.header.glyph');
						    $form[] =  '</div>';
						    $form[] =  '<div class="tab-pane" id="tabbodyheaderborder">';
							        $form[] =  NgeFields::formLayout('parts.core.base', 'border', 'thumbnails.header.border');
						    $form[] =  '</div>';
						    $form[] =  '<div class="tab-pane" id="tabbodyheaderbackground">';
							        $form[] =  NgeFields::formLayout('parts.core.base', 'background', 'thumbnails.header.background');
						    $form[] =  '</div>
					    </div>
				    </div>
			    </div>';
			    $form[] =  '<div class="tab-pane" id="tabbodyborder">';
				        $form[] =  NgeFields::formLayout('parts.core.base', 'border', 'thumbnails.body.border');
			    $form[] =  '</div>';
			    $form[] =  '<div class="tab-pane" id="tabbodybackground">';
				        $form[] =  NgeFields::formLayout('parts.core.base', 'background', 'thumbnails.body.background');
			    $form[] =  '</div>';				
			    $form[] =  '<div class="tab-pane" id="tabbodyshadow">';
				        $form[] =  NgeFields::formLayout('parts.core.base', 'shadow', 'thumbnails.body.shadow');
			    $form[] =  '</div>
		    </div>
	    </div>';	
	return implode($form);			    
}
