<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

 /**
  * multipleTabsContent()
  * used in panels.tabs
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleTabsContent($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // tab label
	$form[] =  NgeFields::text($objectPrefix . 'label', 'COM_NGE_PANELS_TABS_BODY_LABEL', 'COM_NGE_DESCRIPTION_PANELS_TABS_BODY_LABEL', '', array('attributes' => 'class="span4"'));
	
    // tab label glyph
    $form[] =  NgeFields::glyph($objectPrefix . 'glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');
	
    // content source
    $form[] = NgeFields::radio($objectPrefix . 'source', 'COM_NGE_CONTENT', 'COM_NGE_DESCRIPTION_SOURCE', 'html', array(
    	array('html', 'COM_NGE_CONTENT_TEXT_HTML','data-target="field:html"'),
    	array('article', 'COM_NGE_CONTENT_ARTICLE','data-target="field:article"'),
    	array('module', 'COM_NGE_CONTENT_MODULE','data-target="field:module"')/*,
    	array('k2item', 'COM_NGE_CONTENT_K2ITEM','data-target="field:k2item[]"')*/
    	));  
     // html content
     $form[] = NgeFields::editor($objectPrefix .'html');
     
     // article content
     $form[] = NgeFields::article($objectPrefix .'article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
     
     // module content
     $form[] = NgeFields::module($objectPrefix .'module','COM_NGE_CONTENT_MODULE','COM_NGE_DESCRIPTION_CONTENT_MODULE');

     // k2item content
    // $form[] = NgeFields::k2item($objectPrefix .'k2item','COM_NGE_CONTENT_K2ITEM','COM_NGE_DESCRIPTION_CONTENT_K2ITEM', $multiple, $multipleIndex,'required="false"');

    return implode($form);
}

/**
  * multipleTabsContentMedia()
  * used in galleries.tabs
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleTabsContentMedia($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    
    $form=array();
    
    $form[] = NgeFields::filemanager($objectPrefix . 'image','COM_NGE_CONTENT_IMAGE','COM_NGE_DESCRIPTION_CONTENT_PICTURE','', 'images');
    $form[] = NgeFields::radio($objectPrefix . 'sources', 'COM_NGE_CONTENT', 'COM_NGE_DESCRIPTION_SOURCE', 'html', array(
    	array('html', 'COM_NGE_CONTENT_TEXT_HTML','data-target="field:html"'),
    	array('article', 'COM_NGE_CONTENT_ARTICLE','data-target="field:article"'),
    	array('module', 'COM_NGE_CONTENT_MODULE','data-target="field:module"')
    ));
    $form[] = NgeFields::editor($objectPrefix .'html');
    $form[] = NgeFields::article($objectPrefix .'article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
    $form[] = NgeFields::module($objectPrefix .'module','COM_NGE_CONTENT_MODULE','COM_NGE_DESCRIPTION_CONTENT_MODULE');
     
    return implode($form);
}


/**
 * tabsOptionsItemsDisplay()
 * used in panels.tabs
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function tabsOptionsItemsDisplay($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // width mode
    $form[] = NgeFields::radio($objectPrefix . 'width.mode', 'COM_NGE_WIDTH', 'COM_NGE_BUTTONBAR_WIDTH_DESC', 'default', array(
    	array('default', 'COM_NGE_CONTENT'),
    	array('evenly', 'COM_NGE_EVENLY','data-target="field:align"'),
    	array('available', 'COM_NGE_AVAILABLE','data-target="field:align"'),
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:value field:align"')
    	));  
        
    // width value
    $form[] = NgeFields::slider($objectPrefix . 'width.value','COM_NGE_WIDTH','COM_NGE_DESCRIPTION_WIDTH','100', 'min="1" max="500"step="5"');

    // items align
    $form[] = NgeFields::radio($objectPrefix . 'align', 'COM_NGE_TEXT_ALIGN', 'COM_NGE_DESCRIPTION_TABS_ALIGN', 'left', array(
    	array('left', 'COM_NGE_TEXT_ALIGN_LEFT'),
    	array('center', 'COM_NGE_TEXT_ALIGN_CENTER'),
    	array('right', 'COM_NGE_TEXT_ALIGN_RIGHT')
    	));  
        
    // horizontal padding
    $form[] = NgeFields::slider($objectPrefix . 'hpadding','COM_NGE_HPADDING','COM_NGE_DESCRIPTION_HPADDING','12', 'min="0" max="100"step="1"');

    // vertical padding
    $form[] = NgeFields::slider($objectPrefix . 'vpadding','COM_NGE_VPADDING','COM_NGE_DESCRIPTION_VPADDING','8', 'min="0" max="100"step="1"');

    // margins
    $form[] = NgeFields::slider($objectPrefix . 'spacing','COM_NGE_MARGIN','COM_NGE_DESCRIPTION_VPADDING','0', 'min="0" max="100"step="1"');

    return implode($form);
}


/**
 * tabsOptionsItemsStyle()
 * used in galleries.tabs
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function tabsOptionsItemsStyle($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_STYLE', 'COM_NGE_DESCRIPTION_PANELS_TABS_STYLE', 'tabs', array(
        array('tabs', 'COM_NGE_TABS'),
        array('pills', 'COM_NGE_PILLS') ,
        array('flat', 'COM_NGE_FLAT', 'data-target="field:color field:color_hover field:color_active"') ,
        array('underline', 'COM_NGE_UNDERLINE', 'data-target="field:color field:color_hover field:color_active"')
    ));  
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_COLOR','#aaaaaa');
    $form[] = NgeFields::color($objectPrefix . 'color_hover','COM_NGE_COLOR_HOVER','COM_NGE_DESCRIPTION_COLOR_HOVER','#777777');
    $form[] = NgeFields::color($objectPrefix . 'color_active','COM_NGE_COLOR_ACTIVE','COM_NGE_DESCRIPTION_COLOR_ACTIVE','#777777');

    return implode($form);
}
