<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
	
/**
 * optionSliderGeneral()
 * used in panels.slider
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionSliderGeneral($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // slider orientation
    $form[] = NgeFields::radio($objectPrefix . 'orientation', 'COM_NGE_ORIENTATION', 'COM_NGE_SLIDER_ORIENTATION_DESC', 'horizontal', array(
    	array('horizontal', 'COM_NGE_HORIZONTAL'), 
    	array('vertical', 'COM_NGE_VERTICAL')
    ));
    
    return implode($form);
}


/**
 * optionSliderGeneralText()
 * used in panels.slider
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionSliderGeneralText($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // slider orientation
    $form[] = NgeFields::radio($objectPrefix . 'orientation', 'COM_NGE_ORIENTATION', 'COM_NGE_SLIDER_ORIENTATION_DESC', 'horizontal', array(
    	array('horizontal', 'COM_NGE_HORIZONTAL'), 
    	array('vertical', 'COM_NGE_VERTICAL')
    	));  
   
    return implode($form);
}

/**
 * optionCarouselGeneral()
 * used in galleries.carousel
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionCarouselGeneral($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

$form[] = NgeFields::slider($objectPrefix . 'slidesnumber','COM_NGE_SLIDER_NUMBER_VISIBLE','COM_NGE_SLIDER_NUMBER_VISIBLE_DESC','3', 'min="2" max="50" step="1"');
    
    return implode($form);
}

/**
 * optionSliderPlaying()
 * used in panels.slider
 *         galleries.ticker
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionSliderPlaying($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::slider($objectPrefix . 'playing.speed','COM_NGE_SLIDER_PLAYING_SPEED','COM_NGE_SLIDER_PLAYING_SPEED_DESC','5000', 'min="0" max="10000" step="100"');
        
    return implode($form);
}

/**
 * optionSliderPlaying()
 * used in panels.slider
 *         galleries.ticker
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionTickerPlaying($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::slider($objectPrefix . 'playing.transition.speed','COM_NGE_SLIDER_TRANSITION_SPEED','COM_NGE_SLIDER_TRANSITION_SPEED_DESC','5000', 'min="100" max="10000" step="100"');

    return implode($form);
}


/**
 * sliderOptionsArrowsStyle()
 * used in panels.slider
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function sliderOptionsArrowsStyle($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // arrow display
    $form[] = NgeFields::radio($objectPrefix . 'navigator.arrows.display','COM_NGE_DISPLAY','COM_NGE_SLIDER_ARROWS_DISPLAY_DESC','hover', array(
        array('always','COM_NGE_ALWAYS','data-target="field:style"'), 
        array('hover','COM_NGE_HOVER','data-target="field:style"'), 
        array('never','COM_NGE_NEVER','data-success="false"')
    ));

    // arrow style
    $form[] = NgeFields::radio($objectPrefix . 'navigator.arrows.style','COM_NGE_STYLE','COM_NGE_SLIDER_ARROWS_STYLE_DESC','square', array(
        array('square','COM_NGE_SQUARE'), 
        array('circle','COM_NGE_CIRCLE'), 	
        array('chevron','COM_NGE_CHEVRON')
    ));
        
    return implode($form);
}

/**
 * sliderOptionsBulletsStyle()
 * used in panels.slider
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function sliderBulletsOptions($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
// bullets display
    $form[] = NgeFields::radio($objectPrefix . 'navigator.bullets.display','COM_NGE_DISPLAY','COM_NGE_SLIDER_BULLETS_DISPLAY_DESC','always', array(
        array('always','COM_NGE_ALWAYS','data-target="field:style"'), 
        array('hover','COM_NGE_HOVER','data-target="field:style"'), 
        array('never','COM_NGE_NEVER','data-success="false"')
    ));


    // bullets style
    $form[] = NgeFields::radio($objectPrefix . 'navigator.bullets.style','COM_NGE_STYLE','COM_NGE_SLIDER_BULLETS_STYLE_DESC','circle', array(
        array('circle','COM_NGE_CIRCLE'), 
        array('square','COM_NGE_SQUARE')
    ));
    return implode($form);
}

/**
 * sliderTickerGeneral()
 * used in galleries.ticker
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function sliderTickerGeneral($objectPrefix, $multiple=false, $multipleIndex=0) {
     if($objectPrefix!='')
	 $objectPrefix = $objectPrefix . '.';
    $form=array();
    
    $form[] = NgeFields::slider($objectPrefix . 'slidesnumber','COM_NGE_SLIDER_NUMBER_VISIBLE','COM_NGE_SLIDER_NUMBER_VISIBLE_DESC','8', ' min="2" max="50"step="1"');
    
    return implode($form);
}