<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
	
 /**
  * popover_content_group()
  * used in text.label
  *         navigation.button
  * 
  * @param mixed $objectPrefix
  * @return
  */
 function popoverContent($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
   
    //title
    $form[] = NgeFields::text($objectPrefix .'caption', 'COM_NGE_TITLE', 'COM_NGE_DESCRIPTION_TEXT_LABEL_POPOVER_TITLE','', array('attributes' => 'class="span6"'));
    
    // content source
    $form[] = NgeFields::radio($objectPrefix . 'source', 'COM_NGE_CONTENT', 'COM_NGE_DESCRIPTION_TEXT_LABEL_POPOVER_CONTENT', 'html', array(
    	array('html', 'COM_NGE_CONTENT_TEXT_HTML','data-target="field:html"'),
    	array('article', 'COM_NGE_CONTENT_ARTICLE','data-target="field:article"'),
    	array('module', 'COM_NGE_CONTENT_MODULE','data-target="field:module"'),
    	array('image', 'COM_NGE_CONTENT_IMAGE','data-target="field:image"')
    	//array('query', 'COM_NGE_DATABASE_QUERY','data-target="field:query"')
    	));  
        
    // html cntent
	$form[] = NgeFields::editor($objectPrefix . 'html');

    // article content
    $form[] = NgeFields::article($objectPrefix . 'article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
    
    // module content
    $form[] = NgeFields::module($objectPrefix . 'module','COM_NGE_CONTENT_MODULE','COM_NGE_DESCRIPTION_CONTENT_MODULE');

    // image content
    $form[] = NgeFields::filemanager($objectPrefix . 'image','COM_NGE_CONTENT_IMAGE','COM_NGE_DESCRIPTION_CONTENT_PICTURE','', 'images');
    
    // sql content
    // TODO: sql content field
    
	return implode($form);
 }
 