<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * contentMenu()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function contentMenu($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::select($objectPrefix . 'content.menu.menutype','COM_NGE_MENU_SELECT','COM_NGE_MENU_SELECT_DESC','mainmenu', $multiple, $multipleIndex, 
        array(
            "ajax" => true,
            "options" => null,
            "target" => "joomla.menus",
            "multiple" => false
        )
    );
    $form[] = NgeFields::radio($objectPrefix . 'content.menu.showallchildren', 'COM_NGE_MENU_SHOW_SUBMENU', 'COM_NGE_MENU_SHOW_SUBMENU_DESC', '1', array(
    	array('1', 'JYES', 'data-target="field:trigger field:animation"'),
    	array('0', 'JNO','data-success="false"')
    ));
    
    return implode($form); 
}

/**
 * contentMenuSimple()
 * used in joomla.menus.expandable
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function contentMenuSimple($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::select($objectPrefix . 'content.menu.menutype','COM_NGE_MENU_SELECT','COM_NGE_MENU_SELECT_DESC','mainmenu', $multiple, $multipleIndex, 
        array(
            "ajax" => true,
            "options" => null,
            "target" => "joomla.menus",
            "multiple" => false
        )
    );
    
    return implode($form); 
}

/**
 * optionsBar()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function optionsBar($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'valign', 'COM_NGE_TEXT_ALIGN', 'COM_NGE_DESCRIPTION_TEXT_ALIGN', 'top', array(
    	array('top', 'COM_NGE_POSITION_TOP'), 
    	array('middle', 'COM_NGE_POSITION_MIDDLE'), 
    	array('bottom', 'COM_NGE_POSITION_BOTTOM')
    ));
    $form[] = NgeFields::radio($objectPrefix . 'align','COM_NGE_TEXT_ALIGN','COM_NGE_DESCRIPTION_TEXT_ALIGN','left', array(
        array('left','COM_NGE_TEXT_ALIGN_LEFT'),
        array('center','COM_NGE_TEXT_ALIGN_CENTER'),
        array('right','COM_NGE_TEXT_ALIGN_RIGHT')
    ));
    $form[] = NgeFields::radio($objectPrefix . 'height.mode','COM_NGE_HEIGHT','COM_NGE_DESCRIPTION_BORDER_STYLE','default', array(
        array('default','COM_NGE_DEFAULT'),
        array('custom','COM_NGE_CUSTOM', 'data-target="field:value"')
    ));
    $form[] = NgeFields::text($objectPrefix .'height.value', 'COM_NGE_HEIGHT_MODE_PX', 'COM_NGE_DESCRIPTION_HEIGHT','50');
    
    return implode($form); 
}

