<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * multipleListContent()
 * used in navigation.list
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function listContent($objectPrefix, $multiple=false, $multipleIndex=0) {        
    $form=array();
    
    $form[] = NgeFields::text($objectPrefix . '.label', 'COM_NGE_LIST_LABEL', 'COM_NGE_LIST_LABEL_DESC', '', array('attributes' => 'class="inputbox"'));
    $form[] = NgeFields::glyph($objectPrefix . '.glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');    
    return implode($form);
}

/**
 * multipleListContent()
 * used in navigation.list
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function listLinkContent($objectPrefix, $multiple=false, $multipleIndex=0) {
        
    $form=array();
    
    $form[] = NgeFields::text($objectPrefix . '.label', 'COM_NGE_LIST_LABEL', 'COM_NGE_LIST_LABEL_DESC', '', array('attributes' => 'class="inputbox"'));
    $form[] = NgeFields::glyph($objectPrefix . '.glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');
    $form[] =             NgeFields::formlayout('parts.core.base', 'contentLink', $objectPrefix.'.link', $multiple, $multipleIndex);    
    
    return implode($form);
}

/**
 * optionListItems()
 * used in navigation.list
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionListItems($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_BUTTON_STYLE', 'COM_NGE_BUTTON_STYLE_DESC', 'default', array(
    	array('default', 'COM_NGE_DEFAULT',''),
    	array('bootstrap', 'COM_NGE_BOOTSTRAP','data-target="field:theme"')
    ));  
    return implode($form);
}


/**
 * optionListItemsStyle()
 * used in navigation.list
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionListItemsStyle($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'align', 'COM_NGE_ALIGN', 'COM_NGE_LIST_ITEMS_ALIGN_DESC', 'left', array(
    	array('left', 'COM_NGE_POSITION_LEFT'),
    	array('center', 'COM_NGE_POSITION_CENTER'),
    	array('right', 'COM_NGE_POSITION_RIGHT')
    ));
    $form[] = NgeFields::radio($objectPrefix . 'height.mode', 'COM_NGE_HEIGHT_MODE', 'COM_NGE_LIST_ITEMS_HEIGHT_DESC', 'default', array(
    	array('default', 'COM_NGE_CONTENT'),
    	array('custom', 'COM_NGE_CUSTOM', 'data-target="field:items[height][value]"')
    ));  
    $form[] = NgeFields::slider($objectPrefix . 'height.value','COM_NGE_HEIGHT_MODE_PX','COM_NGE_DESCRIPTION_HEIGHT','20', 'min="1" max="100"step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'hpadding','COM_NGE_HPADDING','COM_NGE_DESCRIPTION_HPADDING','12', 'min="0" max="100"step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'vpadding','COM_NGE_VPADDING','COM_NGE_DESCRIPTION_VPADDING','4', 'min="0" max="100"step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'spacing','COM_NGE_MARGIN','COM_NGE_DESCRIPTION_VPADDING','0', 'min="0" max="100"step="1"');

    return implode($form);
}

/**
 * optionListItemsBullets()
 * used in navigation.list
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 * @return
 */
function optionListItemsBullets($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
        
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'items.bullet.style', 'COM_NGE_STYLE', 'COM_NGE_SLIDER_BULLET_STYLE_DESC_EXT', 'none', array(
    	array('none', 'COM_NGE_NONE', 'data-success="false"'), 
    	array('disc', 'Disc','data-target="field:position field:size field:color"'), 
    	array('circle', 'Circle','data-target="field:position field:size field:color"'),
    	array('square', 'Square','data-target="field:position field:size field:color"'),
    	array('decimal', 'Decimal','data-target="field:position field:size field:color"'),
    	array('decimal-leading-zero', 'Decimal (leading zero)','data-target="field:position field:size field:color"'),
    	array('lower-roman', 'Roman (lower)','data-target="field:position field:size field:color"'),
    	array('upper-roman', 'Roman (upper)','data-target="field:position field:size field:color"'),
    	array('lower-alpha', 'Alpha (lower)','data-target="field:position field:size field:color"'),
    	array('upper-alpha', 'Alpha (upper)','data-target="field:position field:size field:color"'),
    	array('lower-greek', 'Greek','data-target="field:position field:size field:color"'),
    	array('lower-latin', 'Latin (lower)','data-target="field:position field:size field:color"'),
    	array('upper-latin', 'Latin (upper)','data-target="field:position field:size field:color"'),
    	array('armenian', 'Armenian','data-target="field:position field:size field:color"'),
    	array('georgian', 'Georgian','data-target="field:position field:size field:color"')
    ));
    $form[] = NgeFields::radio($objectPrefix . 'items.bullet.position', 'COM_NGE_POSITION', 'COM_NGE_LIST_ITEMS_BULLET_POSITION_DESC', 'outside', array(
    	array('outside', 'COM_NGE_OUTSIDE'), 
    	array('inside', 'COM_NGE_INSIDE')
    ));
    $form[] = NgeFields::slider($objectPrefix .'items.bullet.size', 'COM_NGE_SIZE', 'COM_NGE_SLIDER_BULLET_SIZE_DESC', '16', 'min="0" max="72"step="1"');
    $form[] = NgeFields::color($objectPrefix .'items.bullet.color', 'COM_NGE_COLOR', 'COM_NGE_SLIDER_BULLET_COLOR_DESC', '#666666');
    
    return implode($form); 
}

/**
 * optionListItemsGlyphs()
 * used in navigation.list
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function optionListItemsGlyphs($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'position','COM_NGE_GLYPH_PLACEMENT','COM_NGE_DESCRIPTION_GLYPH_PLACEMENT','left', array(
        array('left','COM_NGE_POSITION_LEFT'),
        array('right','COM_NGE_POSITION_RIGHT')
    ));
    $form[] = NgeFields::slider($objectPrefix . 'size','COM_NGE_SIZE','COM_NGE_DESCRIPTION_GLYPH_SIZE','16', ' min="0" max="72"step="1"');
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_GLYPH_COLOR','#666666');
    $form[] = NgeFields::color($objectPrefix . 'color_hover','COM_NGE_COLOR_HOVER','COM_NGE_DESCRIPTION_GLYPH_COLOR_HOVER');
    
    return implode($form);
}


/**
 * optionListHeaders()
 * used in joomla.menus.expandable
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 * @return
 */
function optionListHeaders($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
        
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_STYLE', '', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="#options_headers_custom"'), 
    	array('class', 'COM_NGE_FONT_CLASSCSS','data-target="field:class"')
    ));
    $form[] = NgeFields::text($objectPrefix .'class', 'COM_NGE_FONT_CLASSNAME', 'COM_NGE_DESCRIPTION_FONT_CLASSNAME');
    
    return implode($form);
}

/**
 * optionListHeadersStyle()
 * used in joomla.menus.expandable
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionListHeadersStyle($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'align', 'COM_NGE_ALIGN', 'COM_NGE_LIST_ITEMS_ALIGN_DESC', 'left', array(
    	array('left', 'COM_NGE_POSITION_LEFT'),
    	array('center', 'COM_NGE_POSITION_CENTER'),
    	array('right', 'COM_NGE_POSITION_RIGHT')
    ));
    $form[] = NgeFields::radio($objectPrefix . 'height.mode', 'COM_NGE_HEIGHT_MODE', 'COM_NGE_LIST_ITEMS_HEIGHT_DESC', 'default', array(
    	array('default', 'COM_NGE_CONTENT'),
    	array('custom', 'COM_NGE_CUSTOM', 'data-target="field:[height][value]"')
    ));  
    $form[] = NgeFields::slider($objectPrefix . 'height.value','COM_NGE_HEIGHT_MODE_PX','COM_NGE_DESCRIPTION_HEIGHT','8', 'min="1" max="100"step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'hpadding','COM_NGE_HPADDING','COM_NGE_DESCRIPTION_HPADDING','12', 'min="0" max="100"step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'vpadding','COM_NGE_VPADDING','COM_NGE_DESCRIPTION_VPADDING','8', 'min="0" max="100"step="1"');
    
    return implode($form);
}

/**
 * optionListHeadersFont()
 * used in joomla.menus.expandable
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 * @return
 */
function optionListHeadersFont($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
        
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'font.style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active  field:decoration field:weight field:italic field:italic field:case"'), 
    	array('class', 'COM_NGE_FONT_CLASSCSS','data-target="field:class"')
    ));
    $form[] = NgeFields::text($objectPrefix .'font.class', 'COM_NGE_FONT_CLASSNAME', 'COM_NGE_DESCRIPTION_FONT_CLASSNAME');
    $form[] = NgeFields::font($objectPrefix .'font.name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME');
    $form[] = NgeFields::color($objectPrefix .'font.color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666');
    $form[] = NgeFields::color($objectPrefix .'font.color_hover', 'COM_NGE_FONT_COLOR_HOVER', 'COM_NGE_DESCRIPTION_FONT_COLOR_HOVER');
    $form[] = NgeFields::color($objectPrefix .'font.color_active', 'COM_NGE_FONT_COLOR_ACTIVE', '');
    $form[] = NgeFields::radio($objectPrefix . 'font.decoration', 'COM_NGE_FONT_UNDERLINE', 'COM_NGE_DESCRIPTION_FONT_UNDERLINE', '', array(
    	array('', 'COM_NGE_DEFAULT',''), 
    	array('none', 'COM_NGE_NONE','data-success="false"'), 
    	array('underline', 'COM_NGE_ALWAYS',''),
    	array('underline_hover', 'COM_NGE_HOVER','')
    ));
    $form[] = NgeFields::slider($objectPrefix .'font.size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '12', 'min="0" max="48"step="1"');
    $form[] = NgeFields::slider($objectPrefix .'font.letter_spacing', 'COM_NGE_FONT_LETTER_SPACING', 'COM_NGE_DESCRIPTION_FONT_LETTER_SPACING', '0', 'min="-5" max="10" step="0.1"');			    
    $form[] = NgeFields::radio($objectPrefix .'font.weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
        array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
        array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
        array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
        array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
    ));
    $form[] = NgeFields::radio($objectPrefix .'font.italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0');
    $form[] = NgeFields::radio($objectPrefix .'font.case', 'COM_NGE_FONT_CASE', 'COM_NGE_FONT_CASE_DESC', 'none', array(
        array('none', 'COM_NGE_DEFAULT', ''),
        array('capitalize', 'COM_NGE_FONT_CASE_CAPITALIZE'),
        array('uppercase', 'COM_NGE_FONT_CASE_UPPERCASE'),
        array('lowercase', 'COM_NGE_FONT_CASE_LOWERCASE')
    ));
    
    return implode($form); 
}
