<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * selectImage()
 * used in nothing
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */

function selectImage($objectPrefix, $multiple=false, $multipleIndex=0){  
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
    // image link
    $form[] = NgeFields::filemanager($objectPrefix.'image','COM_NGE_CONTENT_IMAGE','COM_NGE_DESCRIPTION_CONTENT_PICTURE', '', 'images');
    
    return implode($form);
}

/**
 * selectImageAndImageHover()
 * used in images.image
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */

function selectImageAndImageHover($objectPrefix, $multiple=false, $multipleIndex=0, $addImageHover=false){  
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
    // image link
    $form[] = NgeFields::filemanager($objectPrefix.'image','COM_NGE_CONTENT_IMAGE','COM_NGE_DESCRIPTION_CONTENT_PICTURE', '', 'images');
    
    return implode($form);
}

/**
 * imageOptions
 * used in all image widgets
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */

function imageOptions($objectPrefix, $multiple=false, $multipleIndex=0){    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

	$form[] = NGEFields::slider('body.padding','COM_NGE_PADDING','COM_NGE_DESCRIPTION_PADDING','0', false, 0,'min="0" max="50"step="1"');
	
	return implode($form);	
}


/**
 * linkOptions()
 * used in images.image
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */

function linkOptions($objectPrefix, $multiple=false, $multipleIndex=0){    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // link target
    $form[] = NgeFields::radio($objectPrefix . 'target', 'COM_NGE_LINK_TARGET', 'COM_NGE_DESCRIPTION_LINK_TARGET', 'self', array(
        array('self', 'COM_NGE_LINK_TARGET_SELF', 'class="btn"'), 
        array('tab', 'COM_NGE_LINK_TARGET_NEWTAB','class="btn"'), 
        array('window', 'COM_NGE_LINK_TARGET_NEWWINDOW','class="btn"')
    ));

    return implode($form);
}

/**
 * captionDisplay()
 * used in images.image
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */

function captionDisplay($objectPrefix, $multiple=false, $multipleIndex=0){    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'trigger', 'COM_NGE_DISPLAY', 'COM_NGE_DESCRIPTION_DISPLAY_SHADOW', 'always', array(
    array('always', 'COM_NGE_ALWAYS',''),
        array('hover', 'COM_NGE_HOVER', ''), 
        array('outside', 'COM_NGE_OUTSIDE','')
        
    ));
    
    return implode($form);
}
