<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * multipleDropdownContent()
 * used in navigation.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function dropdownContent($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
        
    $form=array();
    $form[] = NgeFields::text($objectPrefix . 'label', 'COM_NGE_LIST_LABEL', 'COM_NGE_LIST_LABEL_DESC', '', array('attributes' => 'class="inputbox"'));
    $form[] = NgeFields::glyph($objectPrefix . 'glyph','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');
    $form[] = NgeFields::formlayout('parts.core.base', 'contentLink', $objectPrefix.'.link', $multiple, $multipleIndex);
    return implode($form);
}

/**
 * optionDropdownItemsStyle()
 * used in navigation.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionDropdownItemsStyle($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_BUTTON_STYLE', 'COM_NGE_BUTTON_STYLE_DESC', 'default', array(
    	array('default', 'COM_NGE_DEFAULT',''),
    	array('custom', 'COM_NGE_CUSTOM','data-target="#options_dropdownitems_custom"')
    ));
    
    return implode($form);
}

/**
 * optionDropdownRendering()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function optionDropdownRendering($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    
    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'rendering.mode','COM_NGE_LIST_RENDERING','COM_NGE_LIST_RENDERING_DESC_DEFAULT','default', array(
        array('default','COM_NGE_DEFAULT', ''),
        array('scroll','COM_NGE_LIST_RENDERING_SCROLL','data-target="field:scroll_visibleitems"'),
        array('columns','COM_NGE_LIST_RENDERING_COLUMNS','data-target="#rendering_columns"')
    ));
    $form[] = NgeFields::slider($objectPrefix . 'rendering.scroll.scroll_visibleitems','COM_NGE_LIST_VISIBLE_ITEMS','COM_NGE_LIST_VISIBLE_ITEMS_DESC','10', 'min="1" max="50"step="1"');

    return implode($form);
}

/**
 * optionDropdownRenderingColumns()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function optionDropdownRenderingColumns($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    
    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'rendering.columns.count', 'COM_NGE_LIST_RENDERING_COLUMNS', 'COM_NGE_LIST_RENDERING_COLUMNS_DESC', 'auto', array(
        array('auto', 'COM_NGE_AUTO','data-target="field:[rendering][columns][visibleitems]"'),
        array('2', '2', ''), 
    	array('3', '3',''), 
    	array('4', '4',''),
    	array('5', '5',''),
    	array('6', '6','')
    ));
    $form[] = NgeFields::slider($objectPrefix . 'rendering.columns.visibleitems','COM_NGE_LIST_PAGER_ITEMS_BY_COLUMNS','COM_NGE_LIST_PAGER_ITEMS_BY_COLUMNS_DESC','10', 'min="1" max="50" step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'rendering.columns.gap','COM_NGE_COLUMNS_GAP','COM_NGE_DESCRIPTION_COLUMNS_GAP','10', 'min="1" max="12" step="1"');   
    
    /*Rules*/
    $form[] = NgeFields::radio($objectPrefix . 'rendering.columns.rules.style', 'COM_NGE_COLUMNS_RULES', 'COM_NGE_DESCRIPTION_COLUMNS_RULES', 'solid', array(
    	array('none', 'COM_NGE_NONE', 'data-success="false"'), 
    	array('solid', 'COM_NGE_BORDER_SOLID','data-target="field:width field:color"'), 
    	array('double', 'COM_NGE_BORDER_DOUBLE','data-target="field:width field:color"'),
    	array('dotted', 'COM_NGE_BORDER_DOTTED','data-target="field:width field:color"'),
    	array('dashed', 'COM_NGE_BORDER_DASHED','data-target="field:width field:color"')
    ));
    $form[] = NgeFields::slider($objectPrefix . 'rendering.columns.rules.width','COM_NGE_WIDTH','COM_NGE_DESCRIPTION_COLUMNS_RULES_WIDTH','1', 'min="1" max="12" step="1"');   
    $form[] = NgeFields::color($objectPrefix . 'rendering.columns.rules.color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_COLUMNS_RULES_COLOR','#CCCCCC');
        
    return implode($form);
}