<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * optionDropcapDisplay()
 * used in text.dropcap
 * 
 * @param mixed $objectPrefix
 * @return
 */
function optionDropcapDisplay($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";

    $form=array();

    // position
    $form[] = NgeFields::radio($objectPrefix . 'position','COM_NGE_GLYPH_PLACEMENT','COM_NGE_DESCRIPTION_GLYPH_PLACEMENT','left', array(
        array('left','COM_NGE_POSITION_LEFT'),
        array('right','COM_NGE_POSITION_RIGHT')
    ));
    
    // horizontal padding
        $form[] = NgeFields::slider($objectPrefix . 'hpadding','COM_NGE_HPADDING','COM_NGE_DESCRIPTION_HPADDING','12', 'min="0" max="100"step="1"');

    // vertical padding
        $form[] = NgeFields::slider($objectPrefix . 'vpadding','COM_NGE_VPADDING','COM_NGE_DESCRIPTION_VPADDING','8', 'min="0" max="100"step="1"');
    
    // horizontal margin
        $form[] = NgeFields::slider($objectPrefix . 'hmargin','COM_NGE_HMARGIN','COM_NGE_DESCRIPTION_HMARGIN','12', 'min="0" max="100"step="1"');

    // vertical margin
        $form[] = NgeFields::slider($objectPrefix . 'vmargin','COM_NGE_VMARGIN','COM_NGE_DESCRIPTION_VMARGIN','0', 'min="0" max="100"step="1"');

/*
    <fieldset name="general">
							
	<field name="hmargin" type="ngeslider" default="12" label="COM_NGE_HMARGIN"
		description="COM_NGE_DESCRIPTION_HMARGIN" first="0" last="100" step="1" />						
	<field name="vmargin" type="ngeslider" default="0" label="COM_NGE_VMARGIN"
		description="COM_NGE_DESCRIPTION_VMARGIN" first="0" last="100" step="1" />								
    </fieldset>
*/
    
	return implode($form);
 }