<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * display_panel()
 * complete display tab in part config screen
 * @param mixed $objectPrefix
 * @return
 */
function display_panel($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = '        <div class="tabbable">';
    $form[] = '<div class="headconfigtitle">'.NGE::translate('COM_NGE_DISPLAY').'</div>';    
    $form[] = '            <ul class="nav nav-tabs headconfigbar" data-tabs="tabs">';
    $form[] = '                <li class="active"><a href="#tabwidth" data-toggle="tab">'.NGE::translate( 'COM_NGE_WIDTH' ).'</a></li>';			
    $form[] = '                <li><a href="#tabmargins" data-toggle="tab">'.NGE::translate( 'COM_NGE_MARGIN' ).'</a></li>';
    $form[] = '            </ul>';
    $form[] = '            <div class="tab-content">';
    $form[] = '                <div class="tab-pane active" id="tabwidth">';
    $form[] =                   NgeFields::radio($objectPrefix . 'size.align','COM_NGE_ALIGN','COM_NGE_DISPLAY_ALIGN_DESC','available', array(
                                    array('left','','data-target="#size_width #size_linebreak"', 'icomoon-paragraph-left'),
                                    array('center','','data-target="#size_width"', 'icomoon-paragraph-center'), 
                                    array('right','','data-target="#size_width #size_linebreak"', 'icomoon-paragraph-right'),
                                    array('available','','','icomoon-paragraph-justify')
                                ));
    $form[] = '                    <div id="size_width">';
    $form[] =                   NgeFields::radio($objectPrefix . 'size.width.mode','COM_NGE_WIDTH','COM_NGE_DISPLAY_WIDTH_DESC','content', array(
		    array('content','COM_NGE_CONTENT'), 
		    array('flexible','COM_NGE_DISPLAY_WIDTH_FLEXIBLE','data-target="field:size[width][flexible_value]"'),
		    array('fixed','COM_NGE_DISPLAY_WIDTH_FIXED','data-target="field:size[width][fixed_value]"') 
		));
    $form[] =	    NgeFields::slider($objectPrefix . 'size.width.flexible_value','COM_NGE_WIDTH','COM_NGE_DISPLAY_WIDTH_FLEXIBLE_DESC','50', 'min="1" max="100" step="1"  suffix="%"');	
    $form[] =	    NgeFields::text($objectPrefix . 'size.width.fixed_value', 'COM_NGE_WIDTH', 'COM_NGE_DISPLAY_WIDTH_FIXED_DESC', '', array('attributes' => 'class="span4"', 'suffix' => 'px'));
    $form[] = '                    </div>';
    $form[] = '                    <div id="size_linebreak">';
    $form[] =                           NgeFields::radio($objectPrefix . 'size.display','COM_NGE_DISPLAY_LINEBREAK','COM_NGE_DISPLAY_LINEBREAK_DESC','block', array(
                                            array('block','JYES'), 
                                            array('inline','JNO', 'data-success="false"') 
                                        ));
    $form[] = '                    </div>';
    $form[] = '                </div>';
    $form[] = '                <div class="tab-pane" id="tabmargins">';
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.top', 'COM_NGE_MARGIN_TOP', 'COM_NGE_MARGIN_TOP_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.bottom', 'COM_NGE_MARGIN_BOTTOM', 'COM_NGE_MARGIN_BOTTOM_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.left', 'COM_NGE_MARGIN_LEFT', 'COM_NGE_MARGIN_LEFT_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.right', 'COM_NGE_MARGIN_RIGHT', 'COM_NGE_MARGIN_RIGHT_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] = '                </div>';
    $form[] = '             </div>';		
    $form[] = '        </div>';
    
    
    return implode($form);
}


/**
 * display_item()
 * complete display tab in part config screen
 * @param mixed $objectPrefix
 * @return
 */
function display_item($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = '        <div class="tabbable">';
    $form[] = '<div class="headconfigtitle">'.NGE::translate('COM_NGE_DISPLAY').'</div>';    
    $form[] = '            <ul class="nav nav-tabs headconfigbar" data-tabs="tabs">';
    $form[] = '                <li class="active"><a href="#tabwidth" data-toggle="tab">'.NGE::translate( 'COM_NGE_WIDTH' ).'</a></li>';			
    $form[] = '                <li><a href="#tabmargins" data-toggle="tab">'.NGE::translate( 'COM_NGE_MARGIN' ).'</a></li>';
    $form[] = '            </ul>';
    $form[] = '            <div class="tab-content">';
    $form[] = '                <div class="tab-pane active" id="tabwidth">';
    $form[] =                       NgeFields::radio($objectPrefix . 'size.align','COM_NGE_ALIGN','COM_NGE_DISPLAY_ALIGN_DESC','left', array(
                                        array('left','','data-target="#size_width #size_linebreak"', 'icomoon-paragraph-left'),
                                        array('center','','data-target="#size_width"', 'icomoon-paragraph-center'), 
                                        array('right','','data-target="#size_width #size_linebreak"', 'icomoon-paragraph-right'),
                                        array('available','','','icomoon-paragraph-justify')
                                    ));
    $form[] = '                    <div id="size_width">';
    $form[] =                           NgeFields::radio($objectPrefix . 'size.width.mode','COM_NGE_WIDTH','COM_NGE_DISPLAY_WIDTH_DESC','content', array(
                                            array('content','COM_NGE_CONTENT'), 
                                            array('flexible','COM_NGE_DISPLAY_WIDTH_FLEXIBLE','data-target="field:size[width][flexible_value]"'),
                                            array('fixed','COM_NGE_DISPLAY_WIDTH_FIXED','data-target="field:size[width][fixed_value]"') 
                                        ));
    $form[] =		NgeFields::slider($objectPrefix . 'size.width.flexible_value','COM_NGE_WIDTH','COM_NGE_DISPLAY_WIDTH_FLEXIBLE_DESC','50', 'min="1" max="100" step="1"  suffix="%"');	
    $form[] =		NgeFields::text($objectPrefix . 'size.width.fixed_value', 'COM_NGE_WIDTH', 'COM_NGE_DISPLAY_WIDTH_FIXED_DESC', '', array('attributes' => 'class="span4"', 'suffix' => 'px'));
    $form[] = '                    </div>';
    $form[] = '                </div>';
    $form[] = '                <div class="tab-pane" id="tabmargins">';
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.top', 'COM_NGE_MARGIN_TOP', 'COM_NGE_MARGIN_TOP_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.bottom', 'COM_NGE_MARGIN_BOTTOM', 'COM_NGE_MARGIN_BOTTOM_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.left', 'COM_NGE_MARGIN_LEFT', 'COM_NGE_MARGIN_LEFT_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] =                      NgeFields::text($objectPrefix . 'size.margin.right', 'COM_NGE_MARGIN_RIGHT', 'COM_NGE_MARGIN_RIGHT_DESC', '0', array('attributes' => 'class="span3"', 'suffix' => NGE::translate('COM_NGE_UNIT_PX_OR_PC')));
    $form[] = '                </div>';
    $form[] = '             </div>';		
    $form[] = '        </div>';

    return implode($form);
}