<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * panelContent()
 * used in text.columns, text.transform, text.expandable
 *         panels.panel
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function panelContent($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
    // content source, with content plugins
    $sources = NGEContent::getSources();
    $availableSources = array();
    foreach ($sources as $source){
	//Testing url target to avoid conflict with target url field
	if ($source['name'] == 'url')
	    $target = $urlField;
	else
	    $target = 'field:' . str_replace('.', '_', $source['name']);
	
	$availableSources[] = array($source['name'], $source['label'],'data-target="' . $target . '"');
    }      
    $form[] = NgeFields::radio($objectPrefix . 'source', 'COM_NGE_CONTENT', 'COM_NGE_DESCRIPTION_SOURCE', 'html', $availableSources);  
        
     // html content
     $form[] = NgeFields::editor($objectPrefix .'html');
     
     // article content
     $form[] = NgeFields::article($objectPrefix .'joomla_article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
     
     // module content
     $form[] = NgeFields::module($objectPrefix .'joomla_module','COM_NGE_CONTENT_MODULE','COM_NGE_DESCRIPTION_CONTENT_MODULE');

     // k2item content
    // $form[] = NgeFields::k2item($objectPrefix .'k2item','COM_NGE_CONTENT_K2ITEM','COM_NGE_DESCRIPTION_CONTENT_K2ITEM', $multiple, $multipleIndex,'required="false"');
        
    return implode($form);
}


/**
 * headerContent()
 * used in text.columns, text.expandable
 *         panels.panel, panels.thumbnails
 *         images.image, images.zoomable
 *         media.video, media.flash
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function headerContent($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // header label
    $form[] =  NgeFields::text($objectPrefix . 'label', 'COM_NGE_TITLE', 'COM_NGE_DESCRIPTION_TITLE', '', array('attributes' => 'class="span6"'));

    // header glyph
    $form[] =  NgeFields::glyph($objectPrefix . 'glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');

	return implode($form);
    
}

/**
 * legendContent()
 * used in text.columns, text.expandable
 *         panels.panel, panels.thumbnails
 *         images.image, images.zoomable
 *         media.video, media.flash
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 * @return
 */
function legendContent($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // legend html editor
	$form[] =  NgeFields::editor($objectPrefix . 'html');

	return implode($form);
    
}

/**
 * multipleContentTitle()
 * used in panels.thumbnails
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */

function multipleContentTitle($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // header label
	$form[] =  NgeFields::text($objectPrefix . 'header.label', 'COM_NGE_TITLE', 'COM_NGE_DESCRIPTION_TITLE', '', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex, 'attributes'=>'class="span6"'));

    // header glyph
    $form[] =  NgeFields::glyph($objectPrefix . 'header.glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH','', array('multiple' => $multiple, 'multipleIndex' => $multipleIndex));

	return implode($form);
    
}

/**
  * multipleContentImage()
  * used in all multiple media widgets
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleContentImage($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $tabsId = str_replace('.', '_', $objectPrefix);
    
    $form=array();
    
    $form[] = NgeFields::hidden($objectPrefix . 'source','image');
    
    $form[] = NgeFields::filemanager($objectPrefix . 'image','COM_NGE_CONTENT_IMAGE','','', 'images');
            
    return implode($form);
}