<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;


/**
 * config_legend()
 * complete legend config screen
 * used in text.columns
 *         panels.panel, panels.thumbnails, panels.slider
 * @param mixed $objectPrefix

 * @return
 */
 function config_legend($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    $form[] = '<div id="content_title_display">
                	<div class="tab-pane" id="tablagend">
                		<div class="tabbable tabs-left">
                			<ul id="tabs" class="nav nav-tabs" data-tabs="tabs">
                				<li class="active"><a href="#tablegendfont" data-toggle="tab">'.NGE::translate( 'COM_NGE_FONT' ).'</a></li>
                				<li><a href="#tablegendborder" data-toggle="tab">'.NGE::translate( 'COM_NGE_BORDER' ).'</a></li>
                				<li><a href="#tablegendbackground" data-toggle="tab">'.NGE::translate( 'COM_NGE_BACKGROUND' ).'</a></li>
                			</ul>
                			<div class="tab-content">
                				<div class="tab-pane" id="tablegendfont">';
    $form[] =     					NgeFields::formlayout('parts.core.base', 'fontWithHoverColor', 'legend');
                					// $jformbase->getControlGroups('legend_font'); 
    $form[] = '    				</div>
                				<div class="tab-pane" id="tablegendborder">';
    //$form[] =     					NgeFields::formlayout('parts.core.base', 'optionsLegendBorder', 'legend');
    $form[] =     					NgeFields::formlayout('parts.core.base', 'border', 'legend.border');    
                					//echo $jformbase->getControlGroups('legend_border'); 
    $form[] = '   				</div>
                				<div class="tab-pane" id="tablegendbackground">';
    //$form[] =     					NgeFields::formlayout('parts.core.base', 'optionsLegendBackground', 'legend');
    $form[] =     					NgeFields::formlayout('parts.core.base', 'background', 'legend.background');
                					//echo $jformbase->getControlGroups('legend_background'); 
    $form[] = '            		</div>
                			</div>
                		</div>
                	</div>
                </div>';
    return implode($form);
}