<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
	
/**
 * optionsColumnsColumns()
 * used in text.columns
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionsColumnsColumns($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // columns count
    $form[] = NgeFields::slider($objectPrefix . 'count','COM_NGE_COLUMNS_COUNT','COM_NGE_DESCRIPTION_COLUMNS_COUNT','2', 'min="1" max="12"step="1"');

	return implode($form);
    
}

/**
 * optionsColumnsRules()
 * used in text.columns
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionsColumnsRules($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // rules style
    $form[] = NgeFields::radio($objectPrefix . 'rules.style', 'COM_NGE_STYLE', 'COM_NGE_DESCRIPTION_COLUMNS_RULES', 'solid', array(
    	array('none', 'COM_NGE_NONE', 'data-success="false"'),
    	array('solid', 'COM_NGE_BORDER_SOLID','data-target="field:width field:color"'), 
    	array('double', 'COM_NGE_BORDER_DOUBLE','data-target="field:width field:color"'),
    	array('dotted', 'COM_NGE_BORDER_DOTTED','data-target="field:width field:color"'),
    	array('dashed', 'COM_NGE_BORDER_DASHED','data-target="field:width field:color"')
    	)); 
      
	return implode($form);
    
}