<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * multipleButtonbarContent()
 * used in navigation.buttonbar
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function buttonbarContent($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
        
    $form=array();
    
    $form[] = NgeFields::text($objectPrefix . 'label', 'COM_NGE_BUTTON_LABEL', 'COM_NGE_BUTTON_LABEL_DESC', '', array('attributes'=>'class="inputbox"'));
    $form[] = NgeFields::glyph($objectPrefix . 'glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');
    $form[] = NgeFields::radio($objectPrefix . 'link.type', 'COM_NGE_STYLE_LINK', 'COM_NGE_DESCRIPTION_LINK_TYPES', 'none', array(
    	array('none', 'COM_NGE_NONE', 'data-success="false"'), 
    	array('menu', 'COM_NGE_LINK_TYPES_MENU','data-target="field:menu"'), 
    	array('article', 'COM_NGE_LINK_TYPES_JOOMLA','data-target="field:article"'),
    	array('url', 'COM_NGE_CONTENT_URLLINK','data-target="field:url"')
    ));
    $form[] = NgeFields::select($objectPrefix . 'link_menus','COM_NGE_LINK_TYPES_MENU','COM_NGE_DESCRIPTION_LINK_MENU','', $multiple, $multipleIndex, 
        array(
            "ajax" => true,
            "options" => null,
            "target" => "joomla.menuitems",
            "multiple" => false
        )
    );

    $form[] = NgeFields::article($objectPrefix .'link.article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
    $form[] = NgeFields::url($objectPrefix .'link.url','COM_NGE_CONTENT_URL','COM_NGE_DESCRIPTION_LINK_URL', array('attributes'=>'class="span12"'));
    
    return implode($form);
}

/**
 * optionButtonbar()
 * used in navigation buttonbar
 * 
 * @param mixed $objectPrefix
 * @return
 */
function optionButtonbar($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";

    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'bar.orientation','COM_NGE_BUTTON_ORIENTATION','COM_NGE_BUTTONBAR_ORIENTATION_DESC','horizontal', array(
        array('horizontal','COM_NGE_HORIZONTAL', 'data-target="field:align"'),
        array('vertical','COM_NGE_VERTICAL')
    ));
    $form[] = NgeFields::radio($objectPrefix . 'bar.align','COM_NGE_POSITION','COM_NGE_BUTTONBAR_POSITION_DESC','left', array(
        array('left','COM_NGE_TEXT_ALIGN_LEFT'),
        array('center','COM_NGE_TEXT_ALIGN_CENTER'),
        array('right','COM_NGE_TEXT_ALIGN_RIGHT')
    ));
 
    return implode($form);
}