<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * buttonBootstrap()
 * used in config_button
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function buttonBootstrap($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
    $form[] = NgeFields::radio($objectPrefix . 'bootstrap.theme', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_COLOR', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_COLOR_DESC', 'default', array(
    	array('default', '-','', 'btn btn-default'),
    	array('primary', '-','', 'btn btn-primary'),
    	array('info', '-','', 'btn btn-info'),
    	array('success', '-', '', 'btn btn-success'),
    	array('warning', '-', '', 'btn btn-warning'),
    	array('danger', '-', '', 'btn btn-danger'),
    	array('inverse', '-', '', 'btn btn-inverse')
    ));
    $form[] = NgeFields::radio($objectPrefix . 'bootstrap.size', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_SIZE', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_SIZE_DESC', 'btn-default', array(
    	array('btn-mini', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_SIZE_MINI'),
    	array('btn-small', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_SIZE_SMALL'),
    	array('btn-default', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_SIZE_DEFAULT'),
    	array('btn-large', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP_SIZE_LARGE')
    ));

    return implode($form);
}

/**
 * buttonFlat()
 * used in config_button
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function buttonFlat($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
    $form[] = NgeFields::color($objectPrefix . 'flat.color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_COLOR','#aaaaaa');
    $form[] = NgeFields::color($objectPrefix . 'flat.color_hover','COM_NGE_COLOR_HOVER','COM_NGE_DESCRIPTION_COLOR_HOVER','#777777');
    
    return implode($form);
}

/**
 * buttonFont()
 * used in config_button
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function buttonFont($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default',  array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active field:weight field:italic field:case"')
    ));
    $form[] = NgeFields::font($objectPrefix .'name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME');
    $form[] = NgeFields::color($objectPrefix .'color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666');
    $form[] = NgeFields::slider($objectPrefix .'size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '13', 'min="0" max="48"step="1"');
    $form[] = NgeFields::radio($objectPrefix .'weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
        array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
        array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
        array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
        array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
    ));
    $form[] = NgeFields::radio($objectPrefix .'italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0');
    
    return implode($form); 
}

/**
 * buttonGlyph()
 * used in config_button
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function buttonGlyph($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::slider($objectPrefix . 'size','COM_NGE_SIZE','COM_NGE_DESCRIPTION_GLYPH_SIZE','16', 'min="0" max="100"step="1"');
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_GLYPH_COLOR');
                    
    return implode($form);   
}
