<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * border group
 * used in text.title, text.label, text.dropcap, text.columns, text.expandable
 *         panels.panel, panels.thumbnails
 *         navigation.button 
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 * @return
 */
function border($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // border style
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_BORDER', 'COM_NGE_DESCRIPTION_BORDER_STYLE', 'none', array(
    	array('none', 'COM_NGE_NONE', 'data-success="false"'),
    	array('solid', 'COM_NGE_BORDER_SOLID','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"'),
    	array('double', 'COM_NGE_BORDER_DOUBLE','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"'),
    	array('dotted', 'COM_NGE_BORDER_DOTTED','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"'),
    	array('dashed', 'COM_NGE_BORDER_DASHED','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"')
    	));  
        
    // border width
    $form[] = NgeFields::slider($objectPrefix . 'width','COM_NGE_THICKNESS','COM_NGE_DESCRIPTION_BORDER_WIDTH','1', 'min="0" max="50"step="1"');

    // border color
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_BORDER_COLOR','#CCCCCC');

    return implode($form);
}


/**
 * borderDefault()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 * @return
 */
function borderDefault($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // border style
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_BORDER', 'COM_NGE_DESCRIPTION_BORDER_STYLE', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'),
	array('none', 'COM_NGE_NONE','data-success="false"'),
    	array('solid', 'COM_NGE_BORDER_SOLID','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"'),
    	array('double', 'COM_NGE_BORDER_DOUBLE','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"'),
    	array('dotted', 'COM_NGE_BORDER_DOTTED','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"'),
    	array('dashed', 'COM_NGE_BORDER_DASHED','data-target="field:positions field:width field:radius_positions field:radius_width field:color field:color_hover"')
    	));  
    
    // border width
    $form[] = NgeFields::slider($objectPrefix . 'width','COM_NGE_THICKNESS','COM_NGE_DESCRIPTION_BORDER_WIDTH','1', 'min="0" max="50"step="1"');

    // border color
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_BORDER_COLOR','#CCCCCC');

    return implode($form);
}


/**
 * glyph group
 * use in text.title, text.dropcap
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 
 * @return
 */
function glyph($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    
    // glyph size
    $form[] = NgeFields::slider($objectPrefix . 'size','COM_NGE_SIZE','COM_NGE_DESCRIPTION_GLYPH_SIZE','30', 'min="0" max="72"step="1"');
    
    // glyph color
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_GLYPH_COLOR','#666666');

    return implode($form);
    
}
/**
 * optionsGlyphSimple()
 * option for glyph, only position and size. no color
 * used in panels.accordion
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionsGlyphSimple($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // glyph placement
    $form[] = NgeFields::radio($objectPrefix . 'glyph.position','COM_NGE_GLYPH_PLACEMENT','COM_NGE_DESCRIPTION_GLYPH_PLACEMENT','left', array(
        array('left','COM_NGE_POSITION_LEFT','data-target="field:name field:size field:color"'),
        array('right','COM_NGE_POSITION_RIGHT','data-target="field:name field:size field:color"')
    ));
    
    // glyph size
    $form[] = NgeFields::slider($objectPrefix . 'glyph.size','COM_NGE_SIZE','COM_NGE_DESCRIPTION_GLYPH_SIZE','30', 'min="0" max="72"step="1"');
        
    return implode($form); 
}


/**
 * background group
 * used in text.title, text.dropcap, text.columns, text.expandable 
 *         panels.panel, panels.thumbnails
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 
 * @return
 */
function background($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // background style
    $form[] = NgeFields::radio($objectPrefix . 'style','COM_NGE_STYLE','COM_NGE_DESCRIPTION_BACKGROUND_STYLE','none', array(
        array('none','COM_NGE_NONE', 'data-success="false"'),
        array('solid','COM_NGE_BACKGROUND_SOLID','data-target="field:color field:color_hover field:opacity"'),
        array('image','COM_NGE_CONTENT_IMAGE','data-target="#'.str_replace('.', '_', $objectPrefix).'imagesdiv"')
    ));

    // background color
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_COLOR','#f9f9f9');
    $form[] = '<div id="'.str_replace('.', '_', $objectPrefix).'imagesdiv">';    
    // background image
    $form[] = NgeFields::filemanager($objectPrefix . 'image.image','COM_NGE_CONTENT_IMAGE','COM_NGE_DESCRIPTION_CONTENT_PICTURE','', 'images');
    $form[] = '</div>';   
    
    return implode($form);
    
}


/**
 * background group
 * used in text.title, text.dropcap, text.columns, text.expandable 
 *         panels.panel, panels.thumbnails
 *         images.image, images.zoomable
 *         galleries.ticker, galleries.slider, galleries.carousel, galleries.tabs
 *         media.video, media.flash
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function backgroundDefault($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // background style
    $form[] = NgeFields::radio($objectPrefix . 'style','COM_NGE_STYLE','COM_NGE_DESCRIPTION_BACKGROUND_STYLE','default', array(
        array('default', 'COM_NGE_DEFAULT',''),	
        array('none','COM_NGE_NONE', 'data-success="false"'),
        array('solid','COM_NGE_BACKGROUND_SOLID','data-target="field:color field:color_hover field:opacity"'),
        array('image','COM_NGE_CONTENT_IMAGE','data-target="#'.str_replace('.', '_', $objectPrefix).'imagesdiv"')
    ));

    // background color
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_COLOR','#f9f9f9');
    
    //Images
    $form[] = '<div id="'.str_replace('.', '_', $objectPrefix).'imagesdiv">'; 
    // background image
    $form[] = NgeFields::filemanager($objectPrefix . 'image.image','COM_NGE_CONTENT_IMAGE','COM_NGE_DESCRIPTION_CONTENT_PICTURE','', 'images');
    $form[] = '</div>';
        
    return implode($form);    
}


/**
 * background group
 * used in navigation.dropdown
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function backgroundDefaultActive($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // background style
    $form[] = NgeFields::radio($objectPrefix . 'style','COM_NGE_STYLE','COM_NGE_DESCRIPTION_BACKGROUND_STYLE','default', array(
        array('default', 'COM_NGE_DEFAULT',''),	
        array('none','COM_NGE_NONE', 'data-success="false"'),
        array('solid','COM_NGE_BACKGROUND_SOLID','data-target="field:color field:color_hover field:color_active field:opacity"'),
        array('gradient','COM_NGE_BACKGROUND_GRADIENT','data-target="field:direction field:color field:color2 field:color_hover field:color_hover2 field:color_active field:color_active2 field:opacity"'),
        array('image','COM_NGE_CONTENT_IMAGE','data-target="#'.str_replace('.', '_', $objectPrefix).'imagesdiv"')
    ));

    // background direction
    $form[] = NgeFields::radio($objectPrefix . 'direction','COM_NGE_BACKGROUND_GRADIENT_DIRECTION','COM_NGE_DESCRIPTION_BACKGROUND_DIRECTION','vertical', array(
        array('vertical','COM_NGE_VERTICAL'), 
        array('horizontal','COM_NGE_HORIZONTAL'),
        array('circle','COM_NGE_CIRCLE'),
        array('ellipse','COM_NGE_ELLIPSE')
    ));

    // background color
    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_COLOR','#f9f9f9');

    // background color 2
    $form[] = NgeFields::color($objectPrefix . 'color2','COM_NGE_COLOR_LAST','COM_NGE_DESCRIPTION_COLOR_LAST','#ffffff');
    
    // background color hover
    $form[] = NgeFields::color($objectPrefix . 'color_hover','COM_NGE_COLOR_HOVER','COM_NGE_DESCRIPTION_COLOR_HOVER');

    // background color hover 2
    $form[] = NgeFields::color($objectPrefix . 'color_hover2','COM_NGE_COLOR_HOVER_LAST','COM_NGE_DESCRIPTION_COLOR_HOVER_LAST');

    // background color active
    $form[] = NgeFields::color($objectPrefix . 'color_active','COM_NGE_COLOR_ACTIVE','COM_NGE_DESCRIPTION_COLOR_ACTIVE');

    // background color active 2
    $form[] = NgeFields::color($objectPrefix . 'color_active2','COM_NGE_COLOR_ACTIVE_LAST','COM_NGE_DESCRIPTION_COLOR_ACTIVE_LAST');
    
    // background opacity
    $form[] = NgeFields::slider($objectPrefix . 'opacity','COM_NGE_OPACITY','COM_NGE_DESCRIPTION_BACKGROUND_OPACITY','100', 'min="0" max="100"step="1"');
    
    //Images
    $form[] = '<div id="'.str_replace('.', '_', $objectPrefix).'imagesdiv">'; 
    // background image
    $form[] = NgeFields::filemanager($objectPrefix . 'image.image','COM_NGE_CONTENT_IMAGE','COM_NGE_DESCRIPTION_CONTENT_PICTURE','', 'images');

    // background image hover
    $form[] = NgeFields::filemanager($objectPrefix . 'image.image_hover','COM_NGE_CONTENT_IMAGE_HOVER','COM_NGE_DESCRIPTION_CONTENT_PICTURE','', 'images');
    
    // background image fit
    $form[] = NgeFields::radio($objectPrefix . 'image.fit','COM_NGE_CONTENT_IMAGE_FIT','COM_NGE_DESCRIPTION_IMAGE_FIT','image', array(
        array('image','COM_NGE_PANEL_IMAGE_FIT_IMAGE_SIZE','data-target="field:repeat"'), 
        array('contain','COM_NGE_PANEL_IMAGE_FIT_IMAGE_CONTAIN',' data-target="field:repeat"'),
        array('cover','COM_NGE_PANEL_IMAGE_FIT_IMAGE_COVER'),
        array('stretch','COM_NGE_PANEL_IMAGE_FIT_IMAGE_STRECH')
    ));
		
    // background image repeat
    $form[] = NgeFields::radio($objectPrefix . 'image.repeat','COM_NGE_BACKGROUND_REPEAT','COM_NGE_DESCRIPTION_BACKGROUND_REPEAT','1', array(
        array('1','JYES'), 
        array('0','JNO','data-success="false"'),
        array('vertical','COM_NGE_VERTICAL'),
        array('horizontal','COM_NGE_HORIZONTAL')
    ));
    $form[] = '</div>';
        
    return implode($form);
    
}


/**
 * shadow group
 * used in text.title, text.dropcap, text.columns
 *         panels.panel, panels.thumbnails
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 
 * @return
 */
function shadow($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // shadow display
    $form[] = NgeFields::radio($objectPrefix . 'display','COM_NGE_DISPLAY','COM_NGE_DESCRIPTION_DISPLAY_SHADOW','none', array(
        array('none','COM_NGE_NONE', 'data-success="false"'), 
        array('always','COM_NGE_ALWAYS',' data-target="field:style field:note"')
    ));


	return implode($form);
    
}


/**
 * optionsDisplay()
 * used in formlayout config_header
 *         panels.thumbnails
 * 
 * @param mixed $objectPrefix
 
 * @return
 */
function titleDisplay($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // horizontal align
    $form[] = NgeFields::radio($objectPrefix . 'align', 'COM_NGE_TEXT_ALIGN', 'COM_NGE_DESCRIPTION_TEXT_ALIGN', 'left', array(
    	array('left', 'COM_NGE_TEXT_ALIGN_LEFT'), 
    	array('center', 'COM_NGE_TEXT_ALIGN_CENTER'), 
    	array('right', 'COM_NGE_TEXT_ALIGN_RIGHT')
    	));

	return implode($form);
    
}

/**
 * titleFont()
 * Default size : 30
 * used in formlayout config_header
 * used in text.label, navigation.button
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function titleFont($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default',  array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active field:weight field:italic field:case"')
    	));
    $form[] = NgeFields::font($objectPrefix .'name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME');
    $form[] = NgeFields::color($objectPrefix .'color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666');
    $form[] = NgeFields::slider($objectPrefix .'size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '30', 'min="0" max="250" step="1"');
	$form[] = NgeFields::radio($objectPrefix .'weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
	    array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
	    array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
	    array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
	    array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
	    ));
	$form[] = NgeFields::radio($objectPrefix .'italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0');

	return implode($form);    
}

/**
 * font()
 * used in tables.table
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 * @return
 */
function labelFont($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
        
    $form=array();
    
    // font style
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default',  array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active field:weight field:italic field:case"')
    	));
    
    // font name
    $form[] = NgeFields::font($objectPrefix .'name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME');
	
    // font color
    $form[] = NgeFields::color($objectPrefix .'color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666');
	
    // font size
    $form[] = NgeFields::slider($objectPrefix .'size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '12', 'min="0" max="72"step="1"');
    
    // font weight				    
	$form[] = NgeFields::radio($objectPrefix .'font.weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
	    array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
	    array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
	    array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
	    array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
	    ));
        
     // font italic
	$form[] = NgeFields::radio($objectPrefix .'italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0');
    
	return implode($form);
    
}

/**
 * labelFontLink()
 * used in navigation.link
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 * @return
 */
function labelFontLink($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
        
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active field:weight field:italic field:case"')
    ));
    $form[] = NgeFields::font($objectPrefix .'name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME');
    $form[] = NgeFields::color($objectPrefix .'color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666');
    $form[] = NgeFields::color($objectPrefix .'color_hover', 'COM_NGE_FONT_COLOR_HOVER', 'COM_NGE_DESCRIPTION_FONT_COLOR_HOVER');
    $form[] = NgeFields::radio($objectPrefix . 'decoration', 'COM_NGE_FONT_UNDERLINE', 'COM_NGE_DESCRIPTION_FONT_UNDERLINE', '', array(
    	array('', 'COM_NGE_DEFAULT',''), 
    	array('none', 'COM_NGE_NONE','data-success="false"'), 
    	array('underline', 'COM_NGE_ALWAYS',''),
    	array('underline_hover', 'COM_NGE_HOVER','')
    ));
    $form[] = NgeFields::slider($objectPrefix .'size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '30', 'min="0" max="72"step="1"');
    $form[] = NgeFields::slider($objectPrefix .'letter_spacing', 'COM_NGE_FONT_LETTER_SPACING', 'COM_NGE_DESCRIPTION_FONT_LETTER_SPACING', '0', 'min="-5" max="10" step="0.1"');			    
    $form[] = NgeFields::radio($objectPrefix .'weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
        array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
        array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
        array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
        array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
    ));
    $form[] = NgeFields::radio($objectPrefix .'italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0');
    
    return implode($form);
    
}

/**
 * fontWithHoverColor()
 * used in formlayout config_legend
 *         text.expandable
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multiple_index 
 
 * @return
 */
function fontWithHoverColor($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    // font style
    $form[] = NgeFields::radio($objectPrefix . 'font.style', 'COM_NGE_FONT', 'COM_NGE_DESCRIPTION_FONT_H', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:name field:size field:letter_spacing field:color field:color_hover field:color_active field:weight field:italic"')
    	));
    
    // font name
    $form[] = NgeFields::font($objectPrefix .'font.name', 'COM_NGE_FONT_NAME', 'COM_NGE_DESCRIPTION_FONT_NAME');
	
    // font color
    $form[] = NgeFields::color($objectPrefix .'font.color', 'COM_NGE_FONT_COLOR', 'COM_NGE_DESCRIPTION_FONT_COLOR', '#666666');
	
    // font color hover
    $form[] = NgeFields::color($objectPrefix .'font.color_hover', 'COM_NGE_FONT_COLOR_HOVER', 'COM_NGE_DESCRIPTION_FONT_COLOR_HOVER');

    // font size
    $form[] = NgeFields::slider($objectPrefix .'font.size', 'COM_NGE_FONT_SIZE', 'COM_NGE_DESCRIPTION_FONT_SIZE', '30', 'min="0" max="72"step="1"');
    
    // font letter spacing
	$form[] = NgeFields::slider($objectPrefix .'font.letter_spacing', 'COM_NGE_FONT_LETTER_SPACING', 'COM_NGE_DESCRIPTION_FONT_LETTER_SPACING', '0', 'min="-5" max="10" step="0.1"');
    
    // font weight				    
	$form[] = NgeFields::radio($objectPrefix .'font.weight', 'COM_NGE_FONT_WEIGHT', 'COM_NGE_DESCRIPTION_FONT_WEIGHT', 'normal', array(
	    array('lighter', 'COM_NGE_FONT_WEIGHT_LIGHTER'),
	    array('normal', 'COM_NGE_FONT_WEIGHT_NORMAL'),
	    array('bold', 'COM_NGE_FONT_WEIGHT_BOLD'),
	    array('bolder', 'COM_NGE_FONT_WEIGHT_BOLDER')
	    ));
        
     // font italic
	$form[] = NgeFields::radio($objectPrefix .'font.italic', 'COM_NGE_FONT_ITALIC', 'COM_NGE_DESCRIPTION_FONT_ITALIC', '0');

	return implode($form);
    
}

/**
 * link()
 * used in navigation.buttonbar, navigation.list, panels.thumbnails
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function contentLink($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";

    $urlField = 'field:' . str_replace('.', '][', preg_replace('/\./', '[', $objectPrefix . 'url', 1)) . ']';    
    $form=array();
    $form[] = NgeFields::radio($objectPrefix . 'type', 'COM_NGE_STYLE_LINK', 'COM_NGE_DESCRIPTION_LINK_TYPES', 'none', array(
    	array('none', 'COM_NGE_NONE', 'data-success="false"'), 
    	array('menu', 'COM_NGE_LINK_TYPES_MENU','data-target="field:menu"'), 
    	array('article', 'COM_NGE_LINK_TYPES_JOOMLA','data-target="field:article"'),
	array('file', 'COM_NGE_CONTENT_FILE','data-target="field:file field:target"'),
    	array('url', 'COM_NGE_CONTENT_URLLINK','data-target="' . $urlField . '"')
    ));
    $form[] = NgeFields::select($objectPrefix . 'menu','COM_NGE_LINK_TYPES_MENU','COM_NGE_DESCRIPTION_LINK_MENU','', $multiple, $multipleIndex, 
        array(
            "ajax" => true,
            "options" => null,
            "target" => "joomla.menuitems",
            "multiple" => false
        )
    );

    $form[] = NgeFields::article($objectPrefix .'article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
    $form[] = NgeFields::filemanager($objectPrefix . 'file','COM_NGE_CONTENT_FILE','COM_NGE_DESCRIPTION_CONTENT_FILE');
    $form[] = NgeFields::url($objectPrefix .'url','COM_NGE_CONTENT_URL','COM_NGE_DESCRIPTION_LINK_URL', array('attributes' => 'class="span12"'));
   
    
    return implode($form);
}
