<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 * optionDropdownItemsStyle()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionItemsStyle($objectPrefix, $multiple=false, $multipleIndex=0){
    
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
	
        $form[] = NgeFields::radio('items.style', 'COM_NGE_BUTTON_STYLE', 'COM_NGE_BUTTON_STYLE_DESC', 'default', array(
    	array('default', 'COM_NGE_BUTTON_STYLE_DEFAUT',''),
    	array('bootstrap', 'COM_NGE_BUTTON_STYLE_BOOTSTRAP','data-target="#options_button_bootstrap"'),
    	array('flat', 'COM_NGE_FLAT','data-target="#options_button_flat"')
    ));    
    
    $form[] = '
    <div id="options_button_bootstrap">
        '.NgeFields::formlayout('parts.core.button', 'buttonBootstrap', 'items').'
    </div>
    <div id="options_button_flat">
        '.NgeFields::formlayout('parts.core.button', 'buttonFlat', 'items').'
    </div>';
    
    return implode($form);
}

/**
 * optionItemsDisplay()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function optionItemsDisplay($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    $form[] = NgeFields::radio($objectPrefix . 'width.mode', 'COM_NGE_WIDTH', 'COM_NGE_MENU_BUTTONS_WIDTH_DESC', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'),
    	array('evenly', 'COM_NGE_EVENLY', 'data-target="field:bar[items][align]"'),
    	array('available', 'COM_NGE_AVAILABLE', 'data-target="field:bar[items][align]"'),
    	array('custom', 'COM_NGE_CUSTOM', 'data-target="field:bar[items][width][value] field:bar[items][align]"')
    ));
    $form[] = NgeFields::slider($objectPrefix . 'width.value','COM_NGE_WIDTH','COM_NGE_DESCRIPTION_WIDTH','100', 'min="1" max="500" step="5"');
    
    $form[] = NgeFields::radio($objectPrefix . 'align', 'COM_NGE_ALIGN', 'COM_NGE_MENU_BUTTONS_ALIGN_DESC', 'center', array(
    	array('left', 'COM_NGE_TEXT_ALIGN_LEFT'),
    	array('center', 'COM_NGE_TEXT_ALIGN_CENTER'),
    	array('right', 'COM_NGE_TEXT_ALIGN_RIGHT')
    )); 
    
    $form[] = NgeFields::radio($objectPrefix . 'height.mode', 'COM_NGE_HEIGHT_MODE', 'COM_NGE_DESCRIPTION_HEIGHT_MODE', 'default', array(
    	array('default', 'COM_NGE_DEFAULT',''),
    	array('custom', 'COM_NGE_CUSTOM','data-target="field:bar[items][height][value] field:valign"')
    ));
    $form[] = NgeFields::slider($objectPrefix . 'height.value','COM_NGE_HEIGHT_MODE_PX','COM_NGE_DESCRIPTION_HEIGHT','50', 'min="1" max="200" step="1"');

        $form[] = NgeFields::radio($objectPrefix . 'valign', 'COM_NGE_TEXT_ALIGN', 'COM_NGE_DESCRIPTION_TEXT_ALIGN', 'middle',  array(
    	array('top', 'COM_NGE_POSITION_TOP'), 
    	array('middle', 'COM_NGE_POSITION_MIDDLE'), 
    	array('bottom', 'COM_NGE_POSITION_BOTTOM')
    	)); 

    $form[] = NgeFields::radio($objectPrefix . 'shape', 'COM_NGE_BUTTON_SHAPE', 'COM_NGE_BUTTON_SHAPE_DESC', 'rectangle', array(
    	array('rectangle', 'COM_NGE_BUTTON_STYLE_CUSTOM_RECTANGLE','data-target="field:hpadding field:vpadding"'),
    	array('square', 'COM_NGE_BUTTON_STYLE_CUSTOM_SQUARE','data-target="field:padding"'),
    	array('circle', 'COM_NGE_BUTTON_STYLE_CUSTOM_CIRCLE','data-target="field:padding"'),
    	array('ellipse', 'COM_NGE_BUTTON_STYLE_CUSTOM_ELLIPSE','data-target="field:hpadding field:vpadding"'),
    ));
    $form[] = NgeFields::slider($objectPrefix . 'padding','COM_NGE_PADDING','COM_NGE_DESCRIPTION_PADDING','12', 'min="0" max="100" step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'hpadding','COM_NGE_HPADDING','COM_NGE_DESCRIPTION_HPADDING','12', 'min="0" max="100" step="1"');
    $form[] = NgeFields::slider($objectPrefix . 'vpadding','COM_NGE_VPADDING','COM_NGE_DESCRIPTION_VPADDING','8', 'min="0" max="100" step="1"');
		
    return implode($form);
}

/**
 * optionItemsGlyph()
 * used in joomla.menus.dropdown
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple 
 * @param integer $multipleIndex 
 
 * @return
 */
function optionItemsGlyph($objectPrefix, $multiple=false, $multipleIndex=0) {
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();

    $form[] = NgeFields::radio($objectPrefix . 'glyph.position','COM_NGE_GLYPH_PLACEMENTBIS','COM_NGE_DESCRIPTION_GLYPH_PLACEMENT','left', array(
        array('left','COM_NGE_POSITION_LEFT'),
        array('right','COM_NGE_POSITION_RIGHT')
    ));
    $form[] = NgeFields::slider($objectPrefix . 'glyph.size','COM_NGE_GLYPH_SIZE','COM_NGE_DESCRIPTION_GLYPH_SIZE','16', ' min="0" max="72"step="1"');
    $form[] = NgeFields::color($objectPrefix . 'glyph.color','COM_NGE_GLYPH_COLOR','COM_NGE_DESCRIPTION_GLYPH_COLOR','#666666');    
    $form[] = NgeFields::color($objectPrefix . 'glyph.color_hover','COM_NGE_GLYPH_COLOR_HOVER','COM_NGE_DESCRIPTION_GLYPH_COLOR_HOVER');    
    
    return implode($form);   
}