<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

 /**
  * multipleAccordionContent()
  * used in panels.accordion
  * 
  * @param mixed $objectPrefix
  * @param bool $multiple
  * @param integer $multipleIndex
  * @return
  */
 function multipleAccordionContent($objectPrefix, $multiple=false, $multipleIndex=0){
    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? $objectPrefix . '.' : "";
    $form=array();
    
    // tab label
	$form[] =  NgeFields::text($objectPrefix . 'label', 'COM_NGE_HEADER', 'COM_NGE_DESCRIPTION_HEADER', '', array('attributes' => 'class="span4"'));

    // tab label glyph
    $form[] =  NgeFields::glyph($objectPrefix . 'glyph.name','COM_NGE_GLYPH','COM_NGE_DESCRIPTION_GLYPH');
	
    // content source
    $form[] = NgeFields::radio($objectPrefix . 'source', 'COM_NGE_CONTENT', 'COM_NGE_DESCRIPTION_SOURCE', 'html', array(
    	array('html', 'COM_NGE_CONTENT_TEXT_HTML','data-target="field:html"'),
    	array('article', 'COM_NGE_CONTENT_ARTICLE','data-target="field:article"'),
    	array('module', 'COM_NGE_CONTENT_MODULE','data-target="field:module"')/*,
    	array('k2item', 'COM_NGE_CONTENT_K2ITEM','data-target="field:k2item[]"')*/
    	));
     // html content
     $form[] = NgeFields::editor($objectPrefix .'html');
     
     // article content
     $form[] = NgeFields::article($objectPrefix .'article','COM_NGE_CONTENT_ARTICLE','COM_NGE_DESCRIPTION_CONTENT_ARTICLE');
     
     // module content
     $form[] = NgeFields::module($objectPrefix .'module','COM_NGE_CONTENT_MODULE','COM_NGE_DESCRIPTION_CONTENT_MODULE');

     // k2item content
    // $form[] = NgeFields::k2item($objectPrefix .'k2item','COM_NGE_CONTENT_K2ITEM','COM_NGE_DESCRIPTION_CONTENT_K2ITEM', $multiple, $multipleIndex,'required="false"');

    return implode($form);
}

/**
 * accordionOptionsHeadingStyle()
 * used in panels.accordion
 * 
 * @param mixed $objectPrefix
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
function accordionOptionsHeadingStyle($objectPrefix, $multiple=false, $multipleIndex=0){
    if($objectPrefix!='')
        $objectPrefix = $objectPrefix . '.';
    $form=array();

    // style
    $form[] = NgeFields::radio($objectPrefix . 'style', 'COM_NGE_STYLE', 'COM_NGE_DESCRIPTION_PANELS_TABS_STYLE', 'default', array(
    	array('default', 'COM_NGE_DEFAULT'), 
    	array('flat', 'COM_NGE_FLAT','data-target="field:color field:color_hover field:color_active"')
    	));  

    $form[] = NgeFields::color($objectPrefix . 'color','COM_NGE_COLOR','COM_NGE_DESCRIPTION_COLOR','#aaaaaa');
    $form[] = NgeFields::color($objectPrefix . 'color_hover','COM_NGE_COLOR_HOVER','COM_NGE_DESCRIPTION_COLOR','#777777');

    return implode($form);
}


