<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

$displayNames = array('panels.panel', 'images.image', 'media.video', 'article');
$navNames = array('joomla.menus.list', 'navigation.link', 'navigation.button', 'navigation.buttonbar');

//Get Current config param info if pk exist else it's a new one
require_once(NGEPATH_CLASSES.'/ngelibrarygalleryhelper.php');

//Loading parts
NgeLibrarygalleryHelper::loadPacksLanguage();
$displayParts = NgeLibrarygalleryHelper::getPartsList($displayNames);
$navParts = NgeLibrarygalleryHelper::getPartsList($navNames);
$allParts = NgeLibrarygalleryHelper::getPartsList();

//Loading modules
    JLoader::import( 'select', JPATH_ADMINISTRATOR .'/components/com_modules/models' );
    $mymodel = JModelLegacy::getInstance('Select', 'ModulesModel');
    $items = $mymodel->getItems();
    
    $list = array();
    $list['mod_articles_archive'] =	array('articles', 'stack');
    $list['mod_articles_latest'] =		array('articles', 'history');
    $list['mod_articles_popular'] =	array('articles', 'trophy');
    $list['mod_banners'] =		array('system', 'file-text');
    $list['mod_breadcrumbs'] =		array('system', 'file-text');
    $list['mod_custom'] =		array('content', 'file-text');
    $list['mod_feed'] =			array('system', 'box-add');
    $list['mod_footer'] =		array('system', 'file-text');
    $list['mod_login'] =		array('users', 'unlocked');
    $list['mod_menu'] =		array('content', 'menu');
    $list['mod_articles_news'] =		array('articles', 'newspaper');
    $list['mod_random_image'] =		array('content', 'images');
    $list['mod_related_items'] =		array('articles', 'copy');
    $list['mod_search'] =		array('system', 'search');
    $list['mod_stats'] =		array('system', 'stats-dots');
    $list['mod_syndicate'] =		array('system', 'box-add');
    $list['mod_users_latest'] =		array('users', 'address-book');
    $list['mod_weblinks'] =		array('content', 'link');
    $list['mod_whosonline'] =		array('users', 'user-check');
    $list['mod_wrapper'] =		array('content', 'profile');
    $list['mod_articles_category'] =	array('articles', 'list');
    $list['mod_articles_categories'] =	array('articles', 'list');
    $list['mod_languages'] =		array('system', 'flag');
    $list['mod_finder'] =		array('system', 'search');
    $list['mod_tags_popular'] =		array('articles', 'trophy');
    $list['mod_tags_similar'] =		array('articles', 'copy');
    $list['mod_k2_comments'] =		array('k2', 'bubble2');
    $list['mod_k2_content'] =		array('k2', 'file-text');
    $list['mod_k2_tools'] =		array('k2', 'wrench');
    $list['mod_k2_users'] =		array('k2', 'users');
    $list['mod_k2_user'] =		array('k2', 'user');
    
    $lists = array();
    foreach ($items as $item){
	if (isset($list[$item->module])){
	    $item->glyph = $list[$item->module][1];
	    $lists[$list[$item->module][0]][] = $item;
	}
	else{
	    $item->glyph = 'file-text';
	    $lists['others'][] = $item;
	}
    }

function getModulesList($items){
	$html = array();
	$html[] = '<div class="ngepresetlist">';
	foreach ($items as &$item){
	    $name    = htmlspecialchars($item->name);
	    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($item->desc)), 200);
	    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($item->desc)), 90);	    
	    $html[] = '<div id="thumbs_module_'.$item->extension_id.'" class="ngepreset ngemodule ngedraggable-mainbar" data-ngedraggable-dest="article position" data-ngedraggable-type="module" data-ngedraggable-ref="'.$item->extension_id.'" data-ngedraggable-title="'.$name.'" data-ngedraggable-module="'.$item->module.'" title="'.$name.'" data-content="'.$desc.'" data-glyph="'.$item->glyph.'"><div><span class="icomoon icomoon-' . $item->glyph . '"></span>'.$name.'</div></div>';	
	}
	$html[] = '</div>';
    return implode($html);
}    

?>
<style>
    <?php include NGEPATH_HELPERS  . '/forms/parts/preset_css.php'; ?>
</style>
<?php
//    $objectPrefix = (isset($objectPrefix) && $objectPrefix != "") ? '.' : "";
    $form=array();
echo '<h3>Add new content ...</h3>';

    $form[] = '<div>';
    $form[] = '<ul id="tabs" class="nav nav-tabs headconfigbar" data-tabs="tabs">';
    $form[] = '    <li class="active"><a href="#tabaddpart" data-toggle="tab">Widget</a></li>';
    $form[] = '    <li><a href="#tabaddmodule" data-toggle="tab">Joomla module</a></li>';
    $form[] = '</ul>';
    $form[] = '<div class="tab-content">';
    $form[] = '    <div class="tab-pane active" id="tabaddpart">';
	$form[] = '<div class="ngepresetlist">';
	//Display
	$form[] = '<h3>Content</h3><br/>';
	foreach ($displayParts as $part){
	    $name    = htmlspecialchars($part->title);
	    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($part->description)), 200);
	    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($desc)), 90);
	    $form[] = '<div class="ngepreset" style="min-width:180px;height:200px;" data-id="'.$part->name.'"><div>';
	    $form[] =  JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name, null, false, true) ? JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name) : '<img src="'.JUri::root().'components/com_nge/assets/images/default_thumb.png" />';
	    $form[] = '<div>' . NGE::translate($name).'</div></div></div>';
	}
	//Nav
	$form[] = '<h3>Links</h3><br/>';
	foreach ($navParts as $part){
	    $name    = htmlspecialchars($part->title);
	    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($part->description)), 200);
	    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($desc)), 90);
	    $form[] = '<div class="ngepreset" style="min-width:180px;height:200px;" data-id="'.$part->name.'"><div>';
	    $form[] =  JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name, null, false, true) ? JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name) : '<img src="'.JUri::root().'components/com_nge/assets/images/default_thumb.png" />';
	    $form[] = '<div>' . NGE::translate($name).'</div></div></div>';
	}
	//Alls
	$form[] = '<h3>All widgets</h3><br/>';
	foreach ($allParts as $part){
	    $name    = htmlspecialchars($part->title);
	    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($part->description)), 200);
	    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($desc)), 90);
	    $form[] = '<div class="ngepreset" data-id="'.$part->name.'"><div>';
	    $form[] =  JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name, null, false, true) ? JHtml::_('image', JUri::root().'components/com_nge/parts/'.str_replace('.', '/', $part->name).'/thumb.png', $part->name) : '<img src="'.JUri::root().'components/com_nge/assets/images/default_thumb.png" />';
	    $form[] = '<div>' . NGE::translate($name).'</div></div></div>';
	}
	$form[] = '</div>';    
    $form[] = '    </div>';
    $form[] = '    <div class="tab-pane" id="tabaddmodule">';
  $form[] = '<div class="row-fluid">';
      $form[] = '<div class="span3" style="text-align:right"><h3>' . NGE::translate('COM_NGE_FIELD_MODULE_LEGEND_TITLE') . '</h3>' . NGE::translate('COM_NGE_FIELD_MODULE_LEGEND') . '<br/><br/><br/><br/><i><a href="' . NGEURL_ROOT . 'administrator/index.php?option=com_modules" target="blank">' . NGE::translate('COM_NGE_FIELD_MODULE_LEGEND_LINK') . '</a></i></div>';
    $form[] = '<div class="span9 manager_body" style="border-left: 1px solid #ddd;">';
	
    /*$form[] = '<ul id="moduletabs" class="nav nav-tabs" data-tabs="tabs">';
	$form[] = '<li class="active"><a href="#tabmodulescontent" data-toggle="tab">CONTENT</a></li>';
	$form[] = '<li><a href="#tabmodulesarticles" data-toggle="tab">ARTICLES</a></li>';
	$form[] = '<li><a href="#tabmodulesusers" data-toggle="tab">USERS</a></li>';
	$form[] = '<li><a href="#tabmodulessystem" data-toggle="tab">SYSTEM</a></li>';
	$form[] = '<li><a href="#tabmodulesk2" data-toggle="tab">K2</a></li>';
	$form[] = '<li><a href="#tabmodulesothers" data-toggle="tab">OTHERS</a></li>';
    $form[] = '</ul>';
    $form[] = '<div class="tab-content">';
	$form[] = '<div class="tab-pane active" id="tabmodulescontent">';	
	    $form[] = getModulesList($lists['content']);
	$form[] = '</div>';
	$form[] = '	<div class="tab-pane" id="tabmodulesarticles">';
	$form[] =       getModulesList($lists['articles']);
	$form[] = '	</div>';
	$form[] = '<div class="tab-pane" id="tabmodulesusers">';
	$form[] =     getModulesList($lists['users']);
	$form[] = '</div>';
	$form[] = '<div class="tab-pane" id="tabmodulessystem">';
	$form[] = getModulesList($lists['system']);
	$form[] = '</div>';
	$form[] = '<div class="tab-pane" id="tabmodulesk2">';
	$form[] = getModulesList($lists['k2']);
	$form[] = '</div>';
	$form[] = '<div class="tab-pane" id="tabmodulesothers">';
	$form[] = getModulesList($lists['others']);
	$form[] = '</div>';
	$form[] = '<div style="max-width:600px;margin-left:65px;margin-right:30px;">';
	$form[] = '<h3 id="moduletitle"></h3>';
	$form[] = '			<div style="position:relative; overflow:hidden;">';
	$form[] = '			<div id="moduleglyph" style="margin-right:20px;float:left;">';
	$form[] = '			</div>';
	$form[] = '			<div id="moduledescription">';

	$form[] = '			</div>';
	$form[] = '		</div>'; 
	$form[] = '  </div>';
    $form[] = '</div>';
    */
	$form[] = '<h4>Content</h4>';
	$form[] = getModulesList($lists['content']);
	$form[] = '<h4>Articles</h4>';
	$form[] =       getModulesList($lists['articles']);
	$form[] = '<h4>Users</h4>';
	$form[] =     getModulesList($lists['users']);
	$form[] = '<h4>System</h4>';
	$form[] = getModulesList($lists['system']);
	$form[] = '<h4>K2</h4>';
	$form[] = getModulesList($lists['k2']);
	$form[] = '<h4>Others</h4>';
	$form[] = getModulesList($lists['others']);

    

$form[] = '</div>';
      $form[] = '</div>';
$form[] = '    </div>';
    $form[] = '</div>';
    $form[] = '</div>';

     
    echo implode($form);
  