<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_PLATFORM') or die;

/**
 * Nge fields helper class
 *
 * @package   
 * @subpackage 
 * @since       $_contentPluginLayouts
 */
abstract class NgeFields {

    protected static $_data; //Existing data bo be filled in the current form
    protected static $_languages; //array of alternate languages
    protected static $_package; //current package formula
    
    /**
     * NgeFields::setData()
     * @param type $data
     * @return type none 
     * Sets the internal data object for existing properties
     */
    public static function setData($formData){
	self::$_data = $formData;
    }

    /**
     * NgeFields::getData()
     * @return type $data
     * Return the internal data object for existing properties
     */
    public static function getData(){
	return self::$_data;
    }

    /**
     * NgeFields::getDataTarget()
     * @return type $string
     * Return the full datatarget notation for a propertyname
     * Full datatarget notation can be used in case of sevaral field ending with the same name in a form
     * For example color
     */
    public static function getDataTarget($propertyName){
	$propertyParts = explode('.', $propertyName);
	for ($i=1,$size=count($propertyParts);$i<$size;$i++){
	    $propertyParts[$i] = '[' . $propertyParts[$i] . ']';
	}
	
	return implode('', $propertyParts);
    }
    
    
    /**
     * NgeFields::setData()
     * @param type $data
     * @return type none 
     * Sets the internal data object for existing properties
     */
    public static function languages(){
	
	if (null == self::$_languages){
	    //Loading installed languages in front-end
	    require_once NGEPATH_HELPERS . '/data/joomla/languagedriver.php';
	    self::$_languages = NgeLanguageDriver::loadList();
	}
	return self::$_languages;
    }
    
    /**
     * NgeFields::data()
     * @param type $name
     * @return type string 
     * Returs the data value from the global object $_data 
     */
    protected static function data($name, $multiple=false, $multipleIndex=0 ){
	$keys = explode('.', $name);
	$propertyPointer = self::$_data;
	for ($i = 0; $i < count($keys); $i++) {
	if (isset($propertyPointer[$keys[$i]]))
		$propertyPointer = & $propertyPointer[$keys[$i]];
	else
	    	$propertyPointer = null;
	}
    
	if($multiple){	    
	    if (isset($propertyPointer[$multipleIndex]))
		$propertyPointer = & $propertyPointer[$multipleIndex];
	    else
		$propertyPointer = null;
	}
	return $propertyPointer;
    }
    
    /**
     * NgeFields::inputName()
     * @param type $name nmae in dot format xxx.xxx.xxx
     * @param type $multiple : is used in multiple fields
     * @return type $name in input format xxx[xxx][xxx]
     */
    protected static function inputName($name, $multiple=false, $multipleIndex=0, $indicedMultiple=false){

	$nameProperties = explode('.', $name);
	$nbProperties = count($nameProperties);
	if ($nbProperties > 1){
	    $nameProperties[0] .= '[';
	    $nameProperties[$nbProperties-1] .= ']';
	}
	for ($i = 1; $i<$nbProperties-1; $i++){
	    $nameProperties[$i] .= '][';
	}
	return implode($nameProperties) . ($multiple ? ( $indicedMultiple ? '['.$multipleIndex.'][]' : '[]') : '');
	
    }
    
    /**
     * NgeFields::getValue()
     * @param type $name name in dot format xxx.xxx.xxx
     * @param type $defaultValue : default field value
     * @return type $value : return value base on name or defaultValue if not exist
     */
    protected static function getValue($name, $defaultValue='', $multiple=false, $multipleIndex=0){
        $current_value = self::data($name,$multiple,$multipleIndex);
        $value = (isset($current_value) && $current_value != null && $current_value != "") ? $current_value : $defaultValue;
	return $value;
    }
    
    /**
     * NgeFields::getId()
     * @param type $name nmae in dot format xxx.xxx.xxx
     * @param bool $multiple
     * @param integer $multipleIndex
     * @return String $id : return html id of current field
     */
    protected static function getId($name, $multiple=false, $multipleIndex=0){
        $id = 'field_' . str_replace('.', '_', $name). ($multiple ? '_'.$multipleIndex : '') ;
	return $id;
    }
    
    /**
     * NgeFields::getLabel()
     * @param String $id : field id
     * @param String $label : label value
     * @param String $help : description
     * @return String $string : return html field label
     */
    protected static function getLabel($id, $label, $help){
	$translatedLabel = NGE::translate($label);
        $string = '<label for="' . $id . '" class="ngeHelpPopover" data-title="' . $translatedLabel . '" data-content="' . NGE::translate($help) . '">' . $translatedLabel . '</label>';
	return $string;
    }
    
        /**
     * NgeFields::getLabel()
     * @param String $id : field id
     * @param String $label : label value
     * @param String $help : description
     * @return String $string : return html field label
     */
    protected static function isSelectDefaultValue($defaultValue, $currentValue){
        $result = false;
        
        if(is_array($defaultValue)){
            $result = (in_array($currentValue, $defaultValue,true)) ? true : false;
        }else{
            $result = ($defaultValue === $currentValue) ? true : false;
        }
        
        return $result;
    }
    
    /**
     * NgeFields::formLayout()
     * 
     * @param mixed $layoutName name of the layout file
     * @param mixed $layoutFunction function to launch
     * @param mixed $layoutObjectPrefix prefix to add before fields names
     * @param bool $multiple 
     * @param integer $multiple_index 
     * @return
     */
    public static function formLayout($layoutName, $layoutFunction, $layoutObjectPrefix='', $multiple=false, $multipleIndex=0  ){
	//Form layouts are in differents diretories among current nge package
	if (!isset(self::$_package))
	    self::$_package = NGE::package();
	//When parts.core, loading in subdirectories, each one for one commercial formula.
	$layoutName = str_replace('parts.core.', 'parts/core/'.self::$_package.'/', $layoutName);
	$fileName = NGEPATH_HELPERS . '/forms/layouts/' . str_replace('.','/',$layoutName).'.php';
	if (file_exists($fileName)){
	    include_once($fileName);
	    return $layoutFunction($layoutObjectPrefix, $multiple, $multipleIndex);
	}
	else
	    return '';
    }
    
    /**
     * NgeFields::multiplelayout()
     * 
     * 	 * Multiple subforms management.
	 * Old naming : xxx[yyy][]

     * @param mixed $name
     * @param mixed $layoutName
     * @param mixed $layoutFunction
     * @param mixed $layoutObjectPrefix
     * @param integer $default_value
     * @return void
     */
    public static function multipleLayout($name, $layoutName, $layoutFunction, $layoutObjectPrefix, $defaultValue=1, $options=array()) {
        
        $html = array();
        $tabsNumber = self::getValue($name, $defaultValue);
        $addable    = true; // TODO: to be complete
        $id = self::getId($name);
	$readyitems = isset($options['readyitems']) ? $options['readyitems'] : 10;
        
    	//Tabs	
	$tabsleft = isset($options['position']) && $options['position'] == 'left' ? ' tabs-left' : '';
    	$html[] = '<div class="tabbable' . $tabsleft . '">';
    	$html[] = '<ul id="'.$id.'_tabs" class="nav nav-tabs ngemultiple" data-tabs="tabs">';
    	for ($i=0;$i<$tabsNumber+$readyitems;$i++){
    		$active = $i==0?  ' class="active"' : '';
    		$hidden = $i>=$tabsNumber ? 'style="display:none"' : '';
    		$html[] = '	<li'.$active.' '.$hidden.' id="'.$id.'tabid'.$i.'"><a href="#'.$id.'tabcontent'.$i.'" data-toggle="tab">'.(string)($i+1).'</a></li>';
    	}
    	if ($addable == '1') //Can add more items
    	    $html[] = '	<li id="tab_more" data-id="'.$id.'"><a title="'.JText::_('COM_NGE_MULTIPLE_TAB_ADD_HELP').'" href="#">+</a></li>';		
    	$html[] = '</ul>';
    	$html[] = '<div class="tab-content">';
    			
        // tabs content	
    	for ($i=0;$i<$tabsNumber+$readyitems;$i++){
            $activeclass = $i==0?  ' active' : '';
    		$html[] = '<div class="tab-pane nge-tab-content'.$activeclass.'" id="'.$id.'tabcontent'.$i.'" nge-tab-index="'.$i.'">';
    		$html[] = '<div style="width:100%;text-align:right" ><div data-number="'.$i.'"  data-id="'.$id.'" class="tabdelete btn deletebtn hastooltip" title="Delete this item" ><span class="icon-remove"></span></div></div>';
    
    		$html[] = self::formLayout($layoutName,$layoutFunction,$layoutObjectPrefix,true,$i);
    
    		$html[] = '	</div>';
    						
    	}
    
    	//$html[] = $this->getTabContent("tabcontent_more", $tabsNumber+10);
    		
    	$html[] = '</div>';				
    	$html[] = '</div>';
    	$html[] = '<input type="hidden" class="ngemultiplecount" id ="'.$id.'_id"  name="'.self::inputName($name).'" value="'.$tabsNumber.'" />';
	if (isset($options['label']) && $options['label'] != ''){
	$html[] = '<script>';
	$html[] = 'jQuery("[name=\'' . $options['label'] . '[]\']").each(function(index){
	    jQuery("#'.$id.'_tabs").children().eq(index).children().text(jQuery(this).val());
	});';
	$html[] = 'jQuery("[name=\'' . $options['label'] . '[]\']").change(function() {
	    jQuery(this).each(function(index){
	    jQuery("#'.$id.'_tabs").children().eq(index).children().text(jQuery(this).val());
	    });
	});';
	$html[] = '</script>';	
	}
	
        
        return implode('',$html);        
        
    }
    

        /**
     * NgeFields::multipleTabs()
     * 
	 * Multiple subforms management.
	 * New naming : xxx[n][yyy]
	 * 
     * @param mixed $name
     * @param mixed $layoutName
     * @param mixed $layoutFunction
     * @param mixed $layoutObjectPrefix
     * @param integer $default_value
     * @return void
     */
    public static function multipleTabs($name, $layoutName, $layoutFunction, $layoutObjectPrefix='items', $defaultValue=1, $options=array()) {
        $html = array();
/*	if ($defaultValue != ''){
	    	echo $name;
		echo "-----------";
		print_r($defaultValue);
		echo "----------------------------------------------------------------------------------------------";
	    print_r(self::$_data);
echo "----------------------------------------------------------------------------------------------";
	    $keys = explode('.', $name);
	    $propertyPointer = & self::$_data;
	    for ($i = 0; $i < count($keys); $i++) {
	    if (isset($propertyPointer[$keys[$i]]))
		    $propertyPointer = & $propertyPointer[$keys[$i]];
	    else
		    $propertyPointer = '';
	    }
	    $propertyPointer = $defaultValue;
	    echo "----------------------------------------------------------------------------------------------";
	    print_r(self::$_data);
	$tabsNumber = $defaultValue['count'];
	}
	else
	    $tabsNumber = 1;
*/	
	
        $tabsNumber = self::getValue($name, $defaultValue);
        $addable    = true; // TODO: to be complete
        $id = self::getId($name);
    $readyitems = isset($options['readyitems']) ? $options['readyitems'] : 0;
   
    	//Tabs	
	$tabsleft = isset($options['position']) && $options['position'] == 'left' ? ' tabs-left' : '';
    	$html[] = '<div id="'.$id.'" class="tabbable' . $tabsleft . ' ngemultiple ngemultipletabs" data-root="' . self::inputName($layoutObjectPrefix) . '">';
    	$html[] = '<ul id="'.$id.'_tabs" class="nav nav-tabs " data-tabs="tabs">';
    	for ($i=0;$i<$tabsNumber+$readyitems;$i++){
    		$active = $i==0?  ' class="active"' : '';
    		$hidden = $i>=$tabsNumber ? 'style="display:none"' : '';
    		$html[] = '	<li'.$active.' '.$hidden.' id="'.$id.'_tab_'.$i.'"><a href="#'.$id.'_content_'.$i.'" data-toggle="tab">'.(string)($i+1).'</a><span class=" ngemultiple-remove" title="Remove">&#10799</span></li>';
    	}
    	if ($addable == '1') //Can add more items
    	    $html[] = '	<li class="ngemultipletabs_more"><a title="'.JText::_('COM_NGE_MULTIPLE_TAB_ADD_HELP').'" href="#'.$id.'_content_more">+</a></li>';		
	//$html[] = '	<li class="ngemultiple_more"><a title="'.JText::_('COM_NGE_MULTIPLE_TAB_ADD_HELP').'" href="#">+</a></li>';		
    	$html[] = '</ul>';
    	$html[] = '<div class="tab-content">';
    			
        // tabs content	
    	for ($i=0;$i<$tabsNumber+$readyitems;$i++){
		$activeclass = $i==0?  ' active' : '';    		
    		$html[] = '<div class="tab-pane nge-tab-content '.$activeclass.'" id="'.$id.'_content_'.$i.'" nge-tab-multiple="1" nge-tab-index="'.$i.'">';
    		$html[] = self::formLayout($layoutName,$layoutFunction,$layoutObjectPrefix . '.' . $i);    
    		$html[] = '	</div>';
    	}
	//More
	$html[] = '<div class="tab-pane" id="'.$id.'_content_more">';    
    	$html[] = self::formLayout($layoutName,$layoutFunction,$layoutObjectPrefix . '.' . $i);    
    	$html[] = '	</div>';
    
    	//$html[] = $this->getTabContent("tabcontent_more", $tabsNumber+10);
    		
    	$html[] = '</div>';				
    	$html[] = '</div>';
    	$html[] = '<input type="hidden" class="ngemultiplecount" id ="'.$id.'_id"  name="'.self::inputName($name).'" value="'.$tabsNumber.'" />';
	if (isset($options['label']) && $options['label'] != ''){
	$html[] = '<script>';
	$html[] = 'jQuery("[name=\'' . $options['label'] . '[]\']").each(function(index){
	    jQuery("#'.$id.'_tabs").children().eq(index).children().text(jQuery(this).val());
	});';
	$html[] = 'jQuery("[name=\'' . $options['label'] . '[]\']").change(function() {
	    jQuery(this).each(function(index){
	    jQuery("#'.$id.'_tabs").children().eq(index).children().text(jQuery(this).val());
	    });
	});';
	$html[] = '</script>';	
	}
	
        
        return implode('',$html);        
        
    }
    
    
    
        /**
     * NgeFields::multipleTabs()
     * 
	 * Multiple subforms management.
	 * New naming : xxx[n][yyy]
	 * 
     * @param mixed $name
     * @param mixed $layoutName
     * @param mixed $layoutFunction
     * @param mixed $layoutObjectPrefix
     * @param integer $default_value
     * @return void
     */
    public static function multipleDynamicTabs($name, $layoutName, $layoutFunction, $layoutObjectPrefix='items', $defaultValue=1, $options=array()) {
        
        $html = array();
        $tabsNumber = self::getValue($name, $defaultValue);
        $addable    = true; // TODO: to be complete
        $id = self::getId($name);
	$itemsData = self::getValue($layoutObjectPrefix);
	
    	//Tabs	
	$tabsleft = isset($options['position']) && $options['position'] == 'left' ? ' tabs-left' : '';
    	$html[] = '<div id="'.$id.'" class="tabbable' . $tabsleft . ' ngemultiple ngemultipletabs" data-root="' . self::inputName($layoutObjectPrefix) . '">';
	$html[] = '<script>var ' . str_replace('.', '_', $layoutObjectPrefix) . '=' . json_encode($itemsData) . ';</script>';
    	$html[] = '<ul id="'.$id.'_tabs" class="nav nav-tabs " data-tabs="tabs">';
    	for ($i=0;$i<$tabsNumber;$i++){
    		$active = $i==0?  ' class="active"' : '';
    		$html[] = '	<li'.$active.' id="'.$id.'_tab_'.$i.'"><a href="#" data-index="' . $i . '">'.(string)($i+1).'</a><span class=" ngemultiple-remove" title="Remove">&#10799</span></li>';
    	}
    	if ($addable == '1') //Can add more items
    	    $html[] = '	<li class="ngemultipletabs_more"><a title="'.JText::_('COM_NGE_MULTIPLE_TAB_ADD_HELP').'" href="#'.$id.'_content_more">+</a></li>';		
	//$html[] = '	<li class="ngemultiple_more"><a title="'.JText::_('COM_NGE_MULTIPLE_TAB_ADD_HELP').'" href="#">+</a></li>';		
    	$html[] = '</ul>';
    	$html[] = '<div class="tab-content">';
    			
        // tabs content	
        $html[] = '<div class="tab-pane nge-tab-content active" id="'.$id.'_content" nge-tab-multiple="1" nge-tab-index="'.$i.'">';
	$html[] = self::formLayout($layoutName,$layoutFunction,$layoutObjectPrefix);
	$html[] = '	</div>';
    	
	//More
	/*$html[] = '<div class="tab-pane" id="'.$id.'_content_more">';    
    	$html[] = self::formLayout($layoutName,$layoutFunction,$layoutObjectPrefix . '.1');
    	$html[] = '	</div>';*/
    
    	//$html[] = $this->getTabContent("tabcontent_more", $tabsNumber+10);
    		
    	$html[] = '</div>';				
    	$html[] = '</div>';
    	$html[] = '<input type="hidden" class="ngemultiplecount" id ="'.$id.'_id"  name="'.self::inputName($name).'" value="'.$tabsNumber.'" />';
	$html[] = '<input type="hidden" id ="'.$id.'_items"  name="'.self::inputName($layoutObjectPrefix).'" value="" />';
	
	
	$html[] = '<script>';			
	$html[] = 'jQuery("#' . $id.'_tabs >li>a").click(function(index){
	    var inputIndex = jQuery(this).attr("data-index");
	    jQuery("#'.$id.'_content").find("[name]").each(function(index){		
		var inputName = jQuery(this).attr("name");
		inputName = inputName.replace(/\]/g, "");
		inputName = inputName.replace(/\[/g, ".");
		
		//Removing object prefix
		inputName = inputName.replace("' . $layoutObjectPrefix . '.", "");
		var inputNameArray = inputName.split(".");
		var propertyValue = ' . str_replace('.', '_', $layoutObjectPrefix) . '[inputIndex];
		for (var i = 0; i < inputNameArray.length; i++) {
		    propertyValue = propertyValue[inputNameArray[i]];
		}
		jQuery(this).val(propertyValue);
	    });
	    updateFields(jQuery("#'.$id.'_content"));
	    });';
	//Loading first tab
	$html[] = 'jQuery("#' . $id.'_tabs >li:first-child>a").click();';
	$html[] = '</script>';	
	
	if (isset($options['label']) && $options['label'] != ''){
	$html[] = '<script>';	
	$html[] = 'jQuery("[name=\'' . $options['label'] . '[]\']").each(function(index){
	    jQuery("#'.$id.'_tabs").children().eq(index).children().text(jQuery(this).val());
	});';
	$html[] = 'jQuery("[name=\'' . $options['label'] . '[]\']").change(function() {
	    jQuery(this).each(function(index){
	    jQuery("#'.$id.'_tabs").children().eq(index).children().text(jQuery(this).val());
	    });
	});';
	$html[] = '</script>';	
	}
	
        
        return implode('',$html);        
        
    }
    
    
    
    
    /**
     * NgeFields::multiplelayout()
     * 
     * @param mixed $name
     * @param mixed $layoutName
     * @param mixed $layoutFunction
     * @param mixed $layoutObjectPrefix
     * @param integer $default_value
     * @return void
     */
    public static function multipleList($name, $layoutName, $layoutFunction, $layoutObjectPrefix='items', $defaultValue=1, $options=array()) {
        
        $html = array();
        $itemsNumber = self::getValue($name, $defaultValue);
        $addable    = true; // TODO: to be complete
        $id = self::getId($name);
	$html[] = '<div id="'.$id.'" class="ngemultiple ngemultiplelist" data-root="' . self::inputName($layoutObjectPrefix) . '">';
    	$html[] = '<ul id="'.$id.'_items" style="list-style-type:none;">';
    	for ($i=0;$i<$itemsNumber+10;$i++){
		$hidden = $i>=$itemsNumber ? 'style="display:none"' : '';
    		$html[] = '<li '.$hidden.' id="itemcontent'.$i.'">';
		$html[] = self::formLayout($layoutName,$layoutFunction,$layoutObjectPrefix . '.' . $i);    
		$html[] = '<span class=" ngemultiple-remove" title="Remove">&#10799</span>';
    		$html[] = '	</li>';
    	}
    	if ($addable == '1') //Can add more items
    	    $html[] = '	<li class="ngemultiplelist_more controls" title="'.JText::_('COM_NGE_MULTIPLE_TAB_ADD_HELP').'"><span style="padding:10px;font-size:18px;" href="#">+</span></li>';
    
    	$html[] = '</ul>';
    	$html[] = '<input type="hidden" class="ngemultiplecount" id ="'.$id.'_id"  name="'.self::inputName($name).'" value="'.$itemsNumber.'" />';
	$html[] = '</div>';
        
        return implode('',$html);        
        
    }
    
    /**
     * NgeFields::languageLayout()
     * 
     * @param mixed $name
     * @param mixed $layoutName
     * @param mixed $layoutFunction
     * @param mixed $layoutObjectPrefix
     * @param integer $default_value
     * @return void
     */
    public static function languageLayout($name, $layoutName, $layoutFunction, $layoutObjectPrefix) {
        
    $html = array();
    $tabsNumber = count(self::$_languages);
    $languages = self::$_languages;
    $addable    = true; // TODO: to be complete
    
	//Tabs		
	$html[] = '<div class="tabbable">';
	$html[] = '<ul id="tabs'.$name.'" class="nav nav-tabs ngemultiple" data-tabs="tabs">';
	for ($i=0;$i<$tabsNumber;$i++){
		$active = $i==0?  ' class="active"' : '';
		$hidden = $i>=$tabsNumber ? 'style="display:none"' : '';
	$html[] = '	<li'.$active.' '.$hidden.' id="tabid'.$i.'"><a href="#tabcontent'.$i.'" data-toggle="tab">'.$languages[$i][0].'</a></li>';
	}
	if ($addable == '1') //Can add more items
	    $html[] = '	<li id="tab_more"><a title="'.JText::_('COM_NGE_MULTIPLE_TAB_ADD_HELP').'" href="#">+</a></li>';		
	$html[] = '</ul>';
	$html[] = '<div class="tab-content">';
			
    // tabs content	
	for ($i=0;$i<$tabsNumber;$i++){
        $activeclass = $i==0?  ' active' : '';	
		$html[] = '<div class="tab-pane nge-tab-content '.$activeclass.'" id="tabcontent'.$i.'" nge-tab-multiple="1" nge-tab-index="'.$i.'">';
		$html[] = '<div style="width:100%;text-align:right" ><div data-number="'.$i.'" class="tabdelete btn deletebtn hastooltip" title="Delete this item"><span class="icon-remove"></span></div></div>';

		$html[] = self::formLayout($layoutName,$layoutFunction,$layoutObjectPrefix,true,$i);

		$html[] = '	</div>';						
	}

	//$html[] = $this->getTabContent("tabcontent_more", $tabsNumber+10);
		
	$html[] = '</div>';				
	$html[] = '</div>';
	$html[] = '<input type="hidden" id ="'.$name.'"  name="'.$name.'" value="'.$tabsNumber.'" />';

    
    return implode('',$html);        
        
    }

    /**
     * 
     * @param type $name
     * @param type $label
     * @param type $help
     * @param type $defaultValue
     * @param type $multiple
     * @param type $multipleIndex
     * @param type $attributes
     * @param type $place_holder
     * @param type $suffix
     * @return type
     * 
     * Text input for content text wich can be multilanguage
     * 
     */
    public static function text_content($name, $label, $help, $defaultValue='', $options=array()){
           
	/*if (NGE::features('content.multilanguage')){
	    return self::text_language($name, $label, $help, $defaultValue='', $options);
        }else{*/
	    return self::text($name, $label, $help, $defaultValue='', $options);
        //}
    }
    
    /**
     * NgeFields::text()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @param string $attributes
     * @return
     */
  //  public static function text($name, $label, $help, $defaultValue='', $multiple=false, $multipleIndex=0 , $attributes='', $place_holder='', $suffix=''){
    public static function text($name, $label, $help, $defaultValue='', $options=array()){	

	//Options
	$multiple = isset($options['multiple']) ? $options['multiple'] : false;
	$multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
	$attributes = isset($options['attributes']) ? $options['attributes'] : '';
	$suffix = isset($options['suffix']) ? $options['suffix'] : false;
	$place_holder = isset($options['place_holder']) ? 'placeholder="'.$options['place_holder'].'"' : '';
	
	$id = self::getId($name, $multiple, $multipleIndex);
	$value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
	$label = self::getLabel($id, $label, $help);

//    	$place_holder = ($place_holder == '') ? '' : 'placeholder="'.$place_holder.'"';
	
	if ($suffix != ''){
	    $prefixTag = '<div class="input-append">';
	    $suffixTag = '<span class="add-on">' . $suffix . '</span></div>';
	}
	else {
	    $prefixTag = '';
	    $suffixTag = '';
	}

	return '<div class="control-group">'
		    .'<div class="control-label">'.$label.'</div>'
		    .'<div class=" controls">' . $prefixTag . '<input type="text" name="' . self::inputName($name, $multiple) . '" id="' . $id . '" value="' . $value . '" '.$attributes.' '.$place_holder.'>' . $suffixTag . '</div>'
		.'</div>';	
    }

    /**
     * NgeFields::text()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @param string $attributes
     * @return
     */
    public static function text_language($name, $label, $help, $defaultValue='', $options){
	
	//Options
	$multiple = isset($options['multiple']) ? $options['multiple'] : false;
	$multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
	$attributes = isset($options['attributes']) ? $options['attributes'] : '';
	//$suffix = isset($options['suffix']) ? $options['suffix'] : false;
	//$place_holder = isset($options['place_holder']) ? 'placeholder="'.$options['place_holder'].'"' : '';

	
	
        // TODO: add a place holder?
    	$id = 'field_' . str_replace('.', '_', $name). ($multiple ? '_'.$multipleIndex : '') ;
    	
    	$result = '<div class="control-group">
    		      <div class="control-label"><label for="' . $id . '" class="ngeHelpPopover" title="">' . NGE::translate($label) . '</label></div>
    		      <div class="controls">
		      
	<div class="input-append">
              <input class="ngelanguageinput ngeactive" type="text" name="' . self::inputName($name) . '" id="' . $id . '" value="' . self::data($name,$multiple,$multipleIndex) . '" '.$attributes.'>';
	foreach (self::languages() as $language){
	    $result .= '<input class="ngelanguageinput" type="text" name="' . self::inputName($language->tag . '.' . $name) . '" id="' . $id .'_'.$language->tag. '" value="' . self::data($language->tag . '.' . $name,$multiple,$multipleIndex) . '" '.$attributes.'>';
	}
	$result.= '<div class="btn-group">
                <button class="btn dropdown-toggle" data-toggle="dropdown">Language <span class="caret"></span></button>
                <ul class="dropdown-menu">
                  <li><a href="#'.$id.'">Default</a></li>
                  <li class="divider"></li>';

	foreach (self::languages() as $language){
	    $result .= '<li><a href="#'.$id.'_'.$language->tag.'">' . $language->name . '</a></li>';
	}
	$result .= '
                </ul>
              </div>
            </div>';

/*	foreach (self::$_languages as $language){
	    $result .= '<input type="text" name="' . self::inputName('lang['.$language->tag . '].'.$name) . '" id="' . $id . '" value="' . self::data($name,$multiple,$multipleIndex) . '" '.$attributes.'><span title="' . $language[2] . '">'.$language[1].'</span>';
	}*/
	$result .= '</div></div>';
	return $result;                
        }
    
    
    
    /**
     * NgeFields::textarea()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @param string $attributes
     * @return
     */
    public static function textarea($name, $label, $help, $defaultValue='', $options=array()){
	
    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $attributes = isset($options['attributes']) ? $options['attributes'] : 'class="span12" style="height:120px"';
	
        $id = self::getId($name, $multiple, $multipleIndex);
        $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
        $label = self::getLabel($id, $label, $help);
 
     	/*return '<div class="control-group">'
                    .'<div class="control-label">'.$label.'</div>'
                    .'<div class="controls"><input type="textarea" name="' . self::inputName($name, $multiple) . '" id="' . $id . '" value="' . $value . '" '.$attributes.'></div>'
              .'</div>';*/
	return '<div class="control-group">'
                    .'<div class="control-label">'.$label.'</div>'
                    .'<div class="controls"><textarea name="' . self::inputName($name, $multiple) . '" id="' . $id . '" '.$attributes.'>' . $value . '</textarea></div>'
              .'</div>';
    }    

    /**
     * NgeFields::hidden()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @param string $attributes
     * @return
     */
    public static function hidden($name, $defaultValue=''){
        $id = self::getId($name);
        $value = self::getValue($name, $defaultValue);    
        return '<input type="hidden" name="' . self::inputName($name) . '" id="' . $id . '" value="' . $value . '">';
    }		    			    
    
    /**
     * NgeFields::radio()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @param string $attributes
     * @param mixed $radios
     * @return
     */
    //public static function radio($name, $label, $help, $defaultValue='', $multiple=false, $multipleIndex=0, $attributes='', $radios=array()){
    public static function radio($name, $label, $help, $defaultValue='', $radios=array(), $options=array()){

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $attributes = isset($options['attributes']) ? $options['attributes'].' ' : '';
	
        $id = 'field_' . str_replace('.', '_', $name). ($multiple ? '_'.$multipleIndex : '') ;
        $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
	$translatedLabel = NGE::translate($label);
	if (gettype($multiple) == 'array'){
	}
        $options = "";
    	if (sizeof($radios) != 0){
    	    foreach($radios as $option){
    		$parameters = sizeof($option) > 2 ? $option[2] : "";
    		$class = (isset($option[3])) ? $option[3] : "";
		$active = $option[0] == $value ? ' active' : '';
    		$options .= '<button type="button" ' . $attributes . 'value="' . $option[0] . '" class="btn '.$class .' '. $active . '" data-toggle="button" ' . $parameters . '>' . NGE::translate($option[1]) . '</button>';
    	    }
    	}    
    	else{
		$class_yes = $value == 1 ? 'btn btn-success active' : 'btn';
		$options .= '<button type="button" ' . $attributes . 'value="1" class="'.$class_yes.'" data-toggle="button">' . trim(NGE::translate('JYES')) . '</button>';
		$class_no = $value == 0 ? 'btn danger_active btn-danger active' : 'btn danger_active';
		$options .= '<button type="button" ' . $attributes . 'value="0" class="'.$class_no.'" data-toggle="button" data-success="false">' . trim(NGE::translate('JNO')) . '</button>';
    	}
        return 
            '<div class="control-group">'
                . '<div class="control-label">'
                    . '<label for="' . $id . '" class="ngeHelpPopover" data-content="'.NGE::translate($help).'" data-title="' . $translatedLabel . '">' . $translatedLabel . '</label>'
                . '</div>'
                . '<div class="controls">'
                    . '<div id="' . $id . '" name="btngroup' . self::inputName($name, $multiple) . '" class="btn-group fieldradio" data-toggle="buttons-radio">'
                        . $options
                    . '</div>'
                    . '<input type="hidden" name="' . self::inputName($name, $multiple) . '" value="' . self::data($name,$multiple,$multipleIndex) . '">'
                    . '<script></script>'
                . '</div>'
            . '</div>';
    }			    
			    
   
/**
    * NgeFields::radio()
    * 
    * @param mixed $name
    * @param mixed $label
    * @param mixed $help
    * @param mixed $default
    * @param string $attributes
    * @return
*/
 public static function slider($name, $label, $help, $defaultValue='', $attributes='', $options=array()){

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
     
     $id = self::getId($name, $multiple, $multipleIndex);
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);
    $attributes .= ' values="'.$value.'"';
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    . '<div class="fieldsliderpips" '.$attributes.'></div>'
                    . '<input type="hidden" id="' . $id . '"  name="' . self::inputName($name, $multiple) . '" value="' . $value . '" />'
                . '</div>'
            . '</div>';
}     
    
    /**
     * NgeFields::editor()
     * 
     * @param mixed $name
     * @param string $label
     * @param string $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @return
     */
    public static function editor($name, $label='', $help='', $defaultValue='', $options=array()){
	//Options
	$multiple = isset($options['multiple']) ? $options['multiple'] : false;
	$multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;	
	$height = isset($options['height']) && $options['height'] !== "" ? "height:".$options['height'].";" : "height:200px;";
	$style = 'style="box-sizing:border-box; width:100%;'.$height.'"';
	
        $id = self::getId($name, $multiple, $multipleIndex);
        $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
        
        if ($label != ''){
	    return '<div class="control-group">' 
		. '<div class="control-label">' . self::getLabel($id, $label, $help) . '</div>'  
		. '<div class="controls"><textarea '.$style.' id="' . $id . '" name="' . self::inputName($name, $multiple). '" class="fieldeditor ">'.htmlspecialchars($value, ENT_COMPAT, "UTF-8").'</textarea>'
		. '</div></div>';
        }else{
            return '<div class="control-group">' 
                    . '<textarea '.$style.' id="' . $id . '" name="' . self::inputName($name, $multiple). '" class="fieldeditor ">'.htmlspecialchars($value, ENT_COMPAT, "UTF-8").'</textarea>'
                    . '</div>';
        }
    }
    
/**
     * NgeFields::editor_language()
     * 
     * @param mixed $name
     * @param string $label
     * @param string $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @return
     */
    public static function editor_language($name, $label='', $help='', $defaultValue='', $multiple=false, $multipleIndex=0){
    	$id = self::getId($name, $multiple, $multipleIndex);
        $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
	
	$input = '<div class="tab-pane" id="tabcontent">
    		    <ul class="nav nav-tabs ngelanguagetabs" data-tabs="tabs">
    			<li class="active"><a href="#tabcontenttabs" data-toggle="tab">' . JText::_('COM_NGE_DEFAULT') . '</a></li>';
		foreach (self::languages() as $language){
		    $input .= '<li><a href="#' . $id.'_' . $language->tag . '" data-toggle="tab">' . $language->tag . '</a></li>';
		}
		$input .= '</ul>
    		    <div class="tab-content">
        			<div class="tab-pane active" id="'.$id.'">
			    <textarea style="box-sizing:border-box; width:100%;" id="' . $id . '" name="' . self::inputName($name, $multiple). '" class="fieldeditor cke_textarea_inline"  >'.htmlspecialchars($value, ENT_COMPAT, "UTF-8").'</textarea>
        			</div>';
		foreach (self::languages() as $language){
		    $input .= '<div class="tab-pane" id="'.$id.'_'.$language->tag.'">
			    <textarea style="box-sizing:border-box; width:100%;" id="' . $id . '_' . $language->tag . '" name="' . self::inputName($language->tag . $name, $multiple). '" class="fieldeditor cke_textarea_inline"  >'.htmlspecialchars($value, ENT_COMPAT, "UTF-8").'</textarea>
        			</div>';
		    }
        		$input .= '</div>
    		</div>';		
	
	
	
	if ($label != '')
	    return '<div class="control-group">' 
		. '<div class="control-label">' . self::getLabel($id, $label, $help) . '</div>'  
		. '<div class="controls">'.$input
		. '</div></div>';
	else
	return '<div class="control-group">' 
		. $input
		. '</div>';
    }

/**
 * NgeFields::checkbox()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @param mixed $radios
 * @return
 */
//public static function checkbox($name, $label, $help, $multiple=false, $multipleIndex=0, $radios=array()) {
    public static function checkbox($name, $label, $help, $radios=array(), $options=array()) {

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    
    $id = self::getId($name, $multiple, $multipleIndex); 
    $value = self::getValue($name, array(), $multiple, $multipleIndex);
    $label = self::getLabel($id, $label, $help);
    $options = "";

    foreach ($radios as $key => $option) {
        $class = isset($option[2]) && $option[2] != '' ? ' '.$option[2].' ': '';
        $icon = isset($option[3]) && $option[3] != '' ? '<i class="'.$option[3].'"></i>':'';
        
        if(empty($value)){
            $checked = isset($option[4]) && $option[4] != '' ? $option[4] : '';
        }else{ /*if value exist.*/
            if(in_array($option[0], $value)) {
                $checked = 'checked="checked"';
            }else{
                $checked = "";
            }
        }
	$option_attributes = isset($option[5]) && $option[5] != '' ? $option[5]: '';
        
        $options .= '<button type="button" value="'.$option[0].'" class="btn'.$class.'" '.$option_attributes.'>'.$icon.trim(NGE::translate($option[1])).'</button>';						
	$options .= '<input type="checkbox" name="' . self::inputName($name, $multiple) . '[]" value="'.$option[0].'" '.$checked.' style="display:none;"/>';
    }
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    . '<div id="'.$id.'" name="btngroup'.self::inputName($name, $multiple).'" class="btn-group fieldcheckbox" data-toggle="buttons-radio" >'
                        . $options
                    . '</div>'
                . '</div>'
            . '</div>';        
} 


/**
 * NgeFields::glyph()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
public static function glyph($name, $label, $help, $defaultValue='', $options=array()) {
    
    	//Options
	$multiple = isset($options['multiple']) ? $options['multiple'] : false;
	$multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    
    $id = 'field_' . str_replace('.', '_', $name). ($multiple ? '_'.$multipleIndex : '') ;     
    $label = self::getLabel($id, $label, $help);
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);   
    
    return '<div class="control-group">
	<div class="control-label">
	'.$label.'
	    </div><div class="controls">
	    <input type="text" id="' . $id . '" value="' . $value . '" name="' . self::inputName($name, $multiple) .'" class="fieldglyph">	    
		</div></div>';

} 


/**
 * NgeFields::color()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
public static function color($name, $label, $help, $defaultValue='', $options=array()) {

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $class = isset($options['class']) ? $options['class'] : "";
    
    $id = self::getId($name, $multiple, $multipleIndex); 
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
    $label = self::getLabel($id, $label, $help);
    
    $color = htmlspecialchars($value, ENT_COMPAT, 'UTF-8');
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    . '<input type="text" name="' . self::inputName($name, $multiple) .'" id="' . $id . '" value="' . $color . '" placeholder="#rrggbb" class="minicolors fieldcolor '.$class.'" />'
                . '</div>'
            . '</div>';                   
}

/**
 * NgeFields::colors()
 * 
 * @param string $name
 * @param string $label
 * @param string $help
 * @param string $colorsNumber
 * @param Array $defaultValue
 * @param Array $options
 * @return
 */
public static function colors($name, $label, $help, $colorsNumber, $defaultValue, $options=array()) {    
    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $class = isset($options['class']) ? $options['class'] : "";
    
    $id = self::getId($name, $multiple, $multipleIndex); 
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
    $label = self::getLabel($id, $label, $help);

    $colors_html = '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls" id="' . $id . '"><div class="ngecolorsspectrum-container">';
                for($i = 0; $i <= $colorsNumber; $i++){
                    $color = htmlspecialchars($value[$i], ENT_COMPAT, 'UTF-8');
                    $colors_html .= '<input type="text" name="' . self::inputName($name, $multiple) .'[]" value="' . $color . '" class="ngecolorsspectrum-input basic '.$class.'" />';
                }
    
    $colors_html .='</div></div>'
            . '</div>';   
    
    return $colors_html;
}


/**
 * NgeFields::colorcmyk()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param array() $options
 * @return
 */
private static function CMYKtoRGB($cyan, $magenta, $yellow, $key) {
    $result = array("r" => 0, "g" => 0, "b"=> 0);
    
    $c = $cyan / 100;
    $m = $magenta / 100;
    $y = $yellow / 100;
    $k = $key / 100;

    $result['r'] = 1 - min( 1, ($c * ( 1 - $k ) + $k) );
    $result['g'] = 1 - min( 1, ($m * ( 1 - $k ) + $k) );
    $result['b'] = 1 - min( 1, ($y * ( 1 - $k ) + $k) );

    $result['r'] = round( $result['r'] * 255 );
    $result['g'] = round( $result['g'] * 255 );
    $result['b'] = round( $result['b'] * 255 );
 
    return $result;
}
        
public static function colorcmyk($name, $label, $help, $defaultValue=array("cyan" => 0, "magenta" => 0, "yellow" => 0, "key" => 0), $options=array()) {

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $class = isset($options['class']) ? $options['class'] : "";
    
    $id = self::getId($name, $multiple, $multipleIndex); 
    if(!is_array($defaultValue)){
        $current_color = NGE::parseColor($defaultValue, array("input_type" => "hex", "output_type" => 'cmyk'));
        if($current_color === null || !is_array($current_color)){
            $current_color = array("cyan" => 0, "magenta" => 0, "yellow" => 0, "key" => 0);
        }
        $defaultValue = $current_color;
    }
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
    $label = self::getLabel($id, $label, $help);
    
    $color_cyan = (isset($value['cyan'])) ? intval($value['cyan']) : 0;
    $color_magenta = (isset($value['magenta'])) ? intval($value['magenta']) : 0;
    $color_yellow = (isset($value['yellow'])) ? intval($value['yellow']) : 0;
    $color_key = (isset($value['key'])) ? intval($value['key']) : 0;
    $background_color_rgb = self::CMYKtoRGB($color_cyan, $color_magenta, $color_yellow, $color_key);

    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls"><div class="ngecolorcmyk-container" name="' . self::inputName($name, $multiple) .'">'
                    . '<div class="ngecolorcmyk-preview" style="background-color:rgb('.$background_color_rgb["r"].','.$background_color_rgb["g"].','.$background_color_rgb["b"].');"></div>'
                    . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_C').' <input type="number" name="' . self::inputName($name, $multiple) .'[cyan]" value="'.$color_cyan.'"  min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-c '.$class.'" />%</div>'
                    . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_M').' <input type="number" name="' . self::inputName($name, $multiple) .'[magenta]" value="'.$color_magenta.'" min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-m '.$class.'" />%</div>'
                    . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_Y').' <input type="number" name="' . self::inputName($name, $multiple) .'[yellow]" value="'.$color_yellow.'" min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-y '.$class.'" />%</div>'
                    . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_K').' <input type="number" name="' . self::inputName($name, $multiple) .'[key]" value="'.$color_key.'" min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-k '.$class.'" />%</div>'
                . '</div></div>'
            . '</div>';
}

public static function colorscmyk($name, $label, $help, $colorsNumber=9, $defaultValue=array("cyan" => 0, "magenta" => 0, "yellow" => 0, "key" => 0), $options=array()) {
    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $class = isset($options['class']) ? $options['class'] : "";
    
    $id = self::getId($name, $multiple, $multipleIndex);
    
    foreach ($defaultValue as $key => $value) {
        if(!is_array($value)){
            $current_color = NGE::parseColor($value, array("input_type" => "hex", "output_type" => 'cmyk'));
            if($current_color === null || !is_array($current_color)){
                $current_color = array("cyan" => 0, "magenta" => 0, "yellow" => 0, "key" => 0);
            }
            $defaultValue[$key] = $current_color;
        }
    }

    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
    $label = self::getLabel($id, $label, $help);

    $colors_html = '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls"><div class="ngecolorscmyk-container" name="' . self::inputName($name, $multiple) .'">';
                    for($i = 0; $i <= $colorsNumber; $i++){
                        $color_cyan = (isset($value[$i]['cyan'])) ? intval($value[$i]['cyan']) : 0;
                        $color_magenta = (isset($value[$i]['magenta'])) ? intval($value[$i]['magenta']) : 0;
                        $color_yellow = (isset($value[$i]['yellow'])) ? intval($value[$i]['yellow']) : 0;
                        $color_key = (isset($value[$i]['key'])) ? intval($value[$i]['key']) : 0;
                        $background_color_rgb = self::CMYKtoRGB($color_cyan, $color_magenta, $color_yellow, $color_key);
                        
                        $colors_html .= '<div class="ngecolorcmyk-container">'
                            . '<div class="ngecolorcmyk-preview" style="background-color:rgb('.$background_color_rgb["r"].','.$background_color_rgb["g"].','.$background_color_rgb["b"].');"></div>'
                            . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_C').' <input type="number" name="' . self::inputName($name, $multiple) .'['.$i.'][cyan]" value="'.$color_cyan.'"  min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-c '.$class.'" />%</div>'
                            . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_M').' <input type="number" name="' . self::inputName($name, $multiple) .'['.$i.'][magenta]" value="'.$color_magenta.'" min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-m '.$class.'" />%</div>'
                            . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_Y').' <input type="number" name="' . self::inputName($name, $multiple) .'['.$i.'][yellow]" value="'.$color_yellow.'" min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-y '.$class.'" />%</div>'
                            . '<div>'.NGE::translate('COM_NGE_FIELD_COLORCMYK_INPUT_K').' <input type="number" name="' . self::inputName($name, $multiple) .'['.$i.'][key]" value="'.$color_key.'" min="0" max="100" step="1" placeholder="" class="ngecolorcmyk-input ngecolorcmyk-input-k '.$class.'" />%</div>'
                        . '</div>';
                    }
                $colors_html .= '</div></div>'
            . '</div>';
    
    return $colors_html;
}

/**
 * NgeFields::color()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
public static function colordouble($name, $name2, $label, $help, $defaultValue='', $defaultValue2='', $options=array()) {

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $class = isset($options['class']) ? $options['class'] : "";
    
    $id = self::getId($name, $multiple, $multipleIndex);
    $id2 = self::getId($name2, $multiple, $multipleIndex);
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
    $value2 = self::getValue($name2, $defaultValue2, $multiple, $multipleIndex);
    $label = self::getLabel($id, $label, $help);
    
    $color = htmlspecialchars($value, ENT_COMPAT, 'UTF-8');
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    . '<input type="text" name="' . self::inputName($name, $multiple) .'" id="' . $id . '" value="' . $color . '" placeholder="#rrggbb" class="minicolors fieldcolor '.$class.'" />'
	    . '&nbsp;<input type="text" name="' . self::inputName($name2, $multiple) .'" id="' . $id2 . '" value="' . $color . '" placeholder="#rrggbb" class="minicolors fieldcolor '.$class.'" />'
                . '</div>'
            . '</div>';                   
}


/**
 * NgeFields::filemanager()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @param mixed $attributes
 * @return
 */
//public static function filemanager($name, $label, $help, $defaultValue='', $multiple=false, $multipleIndex=0, $mime_type='images', $attributes='') {
public static function filemanager($name, $label, $help, $defaultValue='', $fileType='', $options=array()) {

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $attributes = isset($options['attributes']) ? $options['attributes'] : '';
    
    $id = self::getId($name, $multiple, $multipleIndex);
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);
    $mime_attr = "";
    $directory = 'data-directory="images"';

    /*$directory = 'data-directory="'.$mime_type.'"';
    switch ($mime_type) {
        case 'image':
            $mime_attr = 'data-mime="image"';
        break;
    case 'videos':
            $mime_attr = 'data-mime="video"';
        break;
        case 'documents':
            $mime_attr = 'data-mime="text/html, application/pdf"';
        break;
    }
   */ 
    
    $typeAttr = 'data-type="' . $fileType . '"';
    
    // The active file id field.
    if ($value == ""){
        $value = '';
        $input_name = NGE::translate('COM_NGE_FIELD_FILEMANAGER_SELECT_BTN');
    }else{
        $value = $value;
        $input_name = $value;
    }
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<span class="input-append">'
                        . '<input class="input-xlarge ngefield-filemanager-name" type="text" value="'.$input_name.'" disabled="disabled" size="35" />'
                        . '<div class="nge-append-button ngefilemanager-select-button" type="button" data-name="'.self::inputName($name, $multiple).'" '.$directory.' '.$typeAttr.' '.$attributes.'>'
                            . '<i class="material-icons">search</i>&nbsp;'
                        . '</div>'
                        . '<div class="nge-append-button nge-append-button-clear ngefilemanager-clear-button" type="button" data-nge-input-default="'.NGE::translate('COM_NGE_FIELD_FILEMANAGER_SELECT_BTN').'">'
		. '<i class="material-icons">clear</i>&nbsp;'	
                        . '</div>'
                    . '</span>'
                    .'<input class="ngefield-filemanager-id" type="hidden" name="' . self::inputName($name, $multiple) . '" value="' . $value . '" />'
                . '</div>'
            . '</div>';  
}

/**
 * NgeFields::getListForSelectField()
 * get a list for thi field select
 * @param string $target
 * @param string $search
 * @return Array
 */ 
public static function getListForSelectField($target = '', $search = '') {
        // no target in params, search in $_REQUEST
        if(!$target) 
            $target = JFactory::getApplication()->input->get('target');
        // no search in params, search in $_REQUEST
        if(!$search) 
            $search = JFactory::getApplication()->input->get('search');
        
        // explode target,
        // 0 indice = file 
        // 1 indice = function in file
        $targetArray = explode('.', $target);
        $fileSelectName = $targetArray[0].'select.php';
        $className      = ucfirst($targetArray[0]).'Select';
        $method         = $targetArray[1];

        // launch target function and get result
        //Search in source directory
        $sourceFilename = JPath::check(NGEPATH_CONTENTS . '/source/' . $targetArray[0] . "/select.php");

        if (file_exists($sourceFilename))
            require_once($sourceFilename);
        else //Search in common select directory (old way)
            require_once(JPath::check(NGEPATH_HELPERS.'/forms/select/'.$fileSelectName));
        $targetResult = $className::$method($search); 
        
        return $targetResult;
}

/**
 * NgeFields::select()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param Array || String $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @param Boolean $ajax
 * @param mixed $options
 * @example $options = array(
            array(
                "text" => "First OptGroup",
                "children" => array(
                    array('light','COM_NGE_SHADOW_STYLE_LIGHT'), 
                    array('blur','COM_NGE_SHADOW_STYLE_BLUR') 
                )
            ),
            array(
                "text" => "Second OptGroup",
                "children" => array(
                    array('liftedbig','COM_NGE_SHADOW_STYLE_LIFTEDBIG'), 
                    array('leftcorner','COM_NGE_SHADOW_STYLE_LEFTCORNER')
                )
            )
        ),
 * @param string $attributes
 * @example $attributes 'multiple="multiple" target="target_name"'
 * @return String
 */
public static function select($name, $label, $help, $defaultValue='', $multiple=false, $multipleIndex=0, $array_attribute=array()) {  
    $id = self::getId($name, $multiple, $multipleIndex);
    $default_value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $option_html = '';
    $attributes = "";
    $ajax = (isset($array_attribute["ajax"]) && $array_attribute["ajax"] !== null) ? $array_attribute["ajax"] : false;
    $class = (isset($array_attribute["class"]) && $array_attribute["class"] !== null) ? $array_attribute["class"] : "";
    $options = (isset($array_attribute["options"]) && $array_attribute["options"] !== null) ? $array_attribute["options"] : array();
    $target = (isset($array_attribute["target"]) && $array_attribute["target"] !== null && $array_attribute["target"] != "") ? $array_attribute["target"] : null;
    $canSelectMultipleValues = (isset($array_attribute["multiple"]) && $array_attribute["multiple"] !== null) ? $array_attribute["multiple"] : false;
    if($canSelectMultipleValues){
        $multiple = true;
    }
    $placeholder = (isset($array_attribute["placeholder"]) && $array_attribute["placeholder"] !== null) ? $array_attribute["placeholder"] : null;
    $allowclear = (isset($array_attribute["allowclear"]) && $array_attribute["allowclear"] !== null) ? $array_attribute["allowclear"] : true;
    $isConfig = (isset($array_attribute["isConfig"]) && $array_attribute["isConfig"] !== null) ? $array_attribute["isConfig"] : true;
    $lang = JFactory::getLanguage();
    $tag = explode("-", $lang->getTag());
    $tag_select2 = isset($tag[0]) ? $tag[0] : "en";
    //$fied_select_model = new NgeModelField_select();
    
    $attributes .= ' lang="'.$tag_select2.'"';
    $attributes .= ' isConfig="'.$isConfig.'"';
    
    if($target !== null){
        $attributes .= ' target="'.$target.'"';
    }
    
    if($canSelectMultipleValues){
        $attributes .= ' multiple="multiple"';
    }else{
        $option_html = '<option></option>';
    }
    
    if($placeholder !== null){
        $attributes .= ' placeholder="'.$placeholder.'"';
    }else{        
        if($canSelectMultipleValues === true){
            $attributes .= ' placeholder="'.NGE::translate("COM_NGE_FIELD_MULTISELECT_PLACEHOLDER").'"';
        }else{
            $attributes .= ' placeholder="'.NGE::translate("COM_NGE_FIELD_SELECT_PLACEHOLDER").'"';
        }
    }
    
    $allowclear = ($allowclear) ? 'true' : 'false';
    $attributes .= ' allowclear="'.$allowclear.'"';
        
    /*If we use AJAX request*/
    if(!$ajax){
        $attributes .= ' ajax="false"';
        
        foreach ($options as $key => $optionGroup) {     
            if(array_key_exists('children', $optionGroup)){
            $option_html .= '<optgroup label="'.$optionGroup['text'].'">';
                
                foreach ($optionGroup['children'] as $key => $option) {
                    $isDefaultValue = self::isSelectDefaultValue($default_value, $option[0]);
                    $option_attributes = (isset($option[2])) ? $option[2] : "";

                    if($isDefaultValue){
                        $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' selected="selected">'.NGE::translate($option[1]).'</option>';
                    }else{
                        $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' >'.NGE::translate($option[1]).'</option>';
                    }
                }
                
                $option_html .= '</optgroup>';
            }else{
                $option = $optionGroup;
                
                $isDefaultValue = self::isSelectDefaultValue($default_value, $option[0]);
                $option_attributes = (isset($option[2])) ? $option[2] : "";

                if($isDefaultValue){
                    $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' selected="selected">'.NGE::translate($option[1]).'</option>';
                }else{
                    $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' >'.NGE::translate($option[1]).'</option>';
                }
            }
        }
        
        if($target !== null){
            $select_list = self::getListForSelectField($target, "");
            
            foreach ($select_list["items"] as $key => $optionGroup) {
                if(array_key_exists('children', $optionGroup)){
                    $option_html .= '<optgroup label="'.$optionGroup['text'].'">';

                    foreach ($optionGroup['children'] as $key => $option) {
                        $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);
                        $option_attributes = (isset($option->attributes)) ? $option->attributes : "";

                        if($isDefaultValue){
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' selected="selected">'.$option->text.'</option>';
                        }else{
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' >'.$option->text.'</option>';
                        }
                    }

                    $option_html .= '</optgroup>';
                }else{
                    $option = $optionGroup;

                    $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);

                    if($isDefaultValue){
                        $option_html .= '<option value="'.$option->id.'" selected="selected">'.$option->text.'</option>';
                    }else{
                        $option_html .= '<option value="'.$option->id.'" >'.$option->text.'</option>';
                    }
                }
            }
        }
    }else{
        $attributes .= ' ajax="true"';
        $select_list = self::getListForSelectField($target, "");
            
        foreach ($select_list["items"] as $key => $optionGroup) {
            if(array_key_exists('children', $optionGroup)){
                $option_html .= '<optgroup label="'.$optionGroup['text'].'">';

                    foreach ($optionGroup['children'] as $key => $option) {
                        $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);
                        $option_attributes = (isset($option->attributes)) ? $option->attributes : "";

                        if($isDefaultValue){
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' selected="selected">'.$option->text.'</option>';
                        }else{
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' >'.$option->text.'</option>';
                        }
                    }

                    $option_html .= '</optgroup>';
            }else{
                $option = $optionGroup;

                $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);

                if($isDefaultValue){
                    $option_html .= '<option value="'.$option->id.'" selected="selected">'.$option->text.'</option>';
                }else{
                    $option_html .= '<option value="'.$option->id.'" >'.$option->text.'</option>';
                }
            }
        }
    }
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<select class="ngefield-select '.$class.'" id="'.$id.'" name="'.self::inputName($name, $multiple).'" '.$attributes.'>'.$option_html.'</select>'
                . '</div>'
            . '</div>';	
}


public static function sort($name, $label, $label2, $help, $defaultValue='', $multiple=false, $multipleIndex=0, $array_attribute=array()) {  
    $id = self::getId($name, $multiple, $multipleIndex);
    $default_value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $option_html = '';
    $attributes = "";
    $ajax = (isset($array_attribute["ajax"]) && $array_attribute["ajax"] !== null) ? $array_attribute["ajax"] : false;
    $class = (isset($array_attribute["class"]) && $array_attribute["class"] !== null) ? $array_attribute["class"] : "";
    $options = (isset($array_attribute["options"]) && $array_attribute["options"] !== null) ? $array_attribute["options"] : array();
    $target = (isset($array_attribute["target"]) && $array_attribute["target"] !== null && $array_attribute["target"] != "") ? $array_attribute["target"] : null;
    $canSelectMultipleValues = (isset($array_attribute["multiple"]) && $array_attribute["multiple"] !== null) ? $array_attribute["multiple"] : false;
    if($canSelectMultipleValues){
        $multiple = true;
    }
    $placeholder = (isset($array_attribute["placeholder"]) && $array_attribute["placeholder"] !== null) ? $array_attribute["placeholder"] : null;
    $allowclear = (isset($array_attribute["allowclear"]) && $array_attribute["allowclear"] !== null) ? $array_attribute["allowclear"] : true;
    $isConfig = (isset($array_attribute["isConfig"]) && $array_attribute["isConfig"] !== null) ? $array_attribute["isConfig"] : true;
    $lang = JFactory::getLanguage();
    $tag = explode("-", $lang->getTag());
    $tag_select2 = isset($tag[0]) ? $tag[0] : "en";
    //$fied_select_model = new NgeModelField_select();
    
    $attributes .= ' lang="'.$tag_select2.'"';
    $attributes .= ' isConfig="'.$isConfig.'"';
    
    if($target !== null){
        $attributes .= ' target="'.$target.'"';
    }
    
    if($canSelectMultipleValues){
        $attributes .= ' multiple="multiple"';
    }else{
        $option_html = '<option></option>';
    }
    
    if($placeholder !== null){
        $attributes .= ' placeholder="'.$placeholder.'"';
    }else{        
        if($canSelectMultipleValues === true){
            $attributes .= ' placeholder="'.NGE::translate("COM_NGE_FIELD_MULTISELECT_PLACEHOLDER").'"';
        }else{
            $attributes .= ' placeholder="'.NGE::translate("COM_NGE_FIELD_SELECT_PLACEHOLDER").'"';
        }
    }
    
    $allowclear = ($allowclear) ? 'true' : 'false';
    $attributes .= ' allowclear="'.$allowclear.'"';
        
    /*If we use AJAX request*/
    if(!$ajax){
        $attributes .= ' ajax="false"';
        
        foreach ($options as $key => $optionGroup) {     
            if(array_key_exists('children', $optionGroup)){
            $option_html .= '<optgroup label="'.$optionGroup['text'].'">';
                
                foreach ($optionGroup['children'] as $key => $option) {
                    $isDefaultValue = self::isSelectDefaultValue($default_value, $option[0]);
                    $option_attributes = (isset($option[2])) ? $option[2] : "";

                    if($isDefaultValue){
                        $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' selected="selected">'.NGE::translate($option[1]).'</option>';
                    }else{
                        $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' >'.NGE::translate($option[1]).'</option>';
                    }
                }
                
                $option_html .= '</optgroup>';
            }else{
                $option = $optionGroup;
                
                $isDefaultValue = self::isSelectDefaultValue($default_value, $option[0]);
                $option_attributes = (isset($option[2])) ? $option[2] : "";

                if($isDefaultValue){
                    $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' selected="selected">'.NGE::translate($option[1]).'</option>';
                }else{
                    $option_html .= '<option value="'.$option[0].'" '.$option_attributes.' >'.NGE::translate($option[1]).'</option>';
                }
            }
        }
        
        if($target !== null){
            $select_list = self::getListForSelectField($target, "");
            
            foreach ($select_list["items"] as $key => $optionGroup) {
                if(array_key_exists('children', $optionGroup)){
                    $option_html .= '<optgroup label="'.$optionGroup['text'].'">';

                    foreach ($optionGroup['children'] as $key => $option) {
                        $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);
                        $option_attributes = (isset($option->attributes)) ? $option->attributes : "";

                        if($isDefaultValue){
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' selected="selected">'.$option->text.'</option>';
                        }else{
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' >'.$option->text.'</option>';
                        }
                    }

                    $option_html .= '</optgroup>';
                }else{
                    $option = $optionGroup;

                    $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);

                    if($isDefaultValue){
                        $option_html .= '<option value="'.$option->id.'" selected="selected">'.$option->text.'</option>';
                    }else{
                        $option_html .= '<option value="'.$option->id.'" >'.$option->text.'</option>';
                    }
                }
            }
        }
    }else{
        $attributes .= ' ajax="true"';
        $select_list = self::getListForSelectField($target, "");
            
        foreach ($select_list["items"] as $key => $optionGroup) {
            if(array_key_exists('children', $optionGroup)){
                $option_html .= '<optgroup label="'.$optionGroup['text'].'">';

                    foreach ($optionGroup['children'] as $key => $option) {
                        $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);
                        $option_attributes = (isset($option->attributes)) ? $option->attributes : "";

                        if($isDefaultValue){
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' selected="selected">'.$option->text.'</option>';
                        }else{
                            $option_html .= '<option value="'.$option->id.'" '.$option_attributes.' >'.$option->text.'</option>';
                        }
                    }

                    $option_html .= '</optgroup>';
            }else{
                $option = $optionGroup;

                $isDefaultValue = self::isSelectDefaultValue($default_value, $option->id);

                if($isDefaultValue){
                    $option_html .= '<option value="'.$option->id.'" selected="selected">'.$option->text.'</option>';
                }else{
                    $option_html .= '<option value="'.$option->id.'" >'.$option->text.'</option>';
                }
            }
        }
    }
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
		.'<div class="row-fluid" style="float:left;width:320px;">
		<div data-force="30" class="span6">
			<div class="layer title">'.$label.'</div>
			<ul id="foo" class="ngesort_list">
				<li data-code="facebook">Facebook</li>
				<li data-code="twitter">Twitter</li>
				<li>Instagram</li>
				<li>Flickr</li>
				<li>Linkedin</li>
				<li>Meetup</li>
				<li>Myspace</li>
				<li>Toutube</li>
			</ul>
		</div>

		<div data-force="18" class="span6">
			<div class="layer title">'.$label2.'</div>
			<ul id="bar" class="ngesort_list">
				<li>казнить</li>
				<li>,</li>
				<li>нельзя</li>
				<li>помиловать</li>
			</ul>
		</div>
	</div>'	    
                . '</div>'
            . '</div>';	
}

/**
 * NgeFields::note()
 * text note field
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @return
 */
public static function note($name, $label, $help) {
    return '<div class="control-group">
                <div class="control-label">'.NGE::translate($label).'</div>
                <div class="controls">'.NGE::translate($help).'</div>
            </div>';
}

/**
 * NgeFields::note()
 * text note field
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @return
 */
public static function title($label) {
    return '<div class="ngefieldtitle">'.NGE::translate($label).'</div>';
}

/**
 * NgeFields::article()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
//public static function article($name, $label, $help, $multiple=false, $multipleIndex=0) {
    public static function article($name, $label, $help, $options=array()) {

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;

    $id = self::getId($name, $multiple, $multipleIndex);
    $value = self::getValue($name, 0, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $input_name = "";

    // The active font id field.
    if (0 == (int)$value){
        $value = '';
        $input_name = NGE::translate('COM_NGE_FIELD_ARTICLE_SELECT_BTN');
    }else{
        $value = (int)$value;
        $articleTable = JTable::getInstance("content");
        $isLoadarticle = $articleTable->load($value);

        $input_name = (isset($isLoadarticle) && $isLoadarticle == true) ? $articleTable->get("title") : '';
    }
                
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<span class="input-append">'
                        . '<input class="input-xlarge ngefield-article-name" type="text" id="'.$id.'_name" value="'.$input_name.'" disabled="disabled" size="35" />'
                        . '<div class="nge-append-button ngearticle-select-button" type="button">'
                      . '<i class="material-icons">search</i>&nbsp;'
                        . '</div>'
                        . '<div class="nge-append-button nge-append-button-clear ngearticle-clear-button" type="button" data-nge-input-default="'.NGE::translate('COM_NGE_FIELD_ARTICLE_SELECT_BTN').'">'
                      . '<i class="material-icons">clear</i>&nbsp;'
                        . '</div>'
                    . '</span>'
                    .'<input class="ngefield-article-id" type="hidden" id="' . $id . '_id" name="' . self::inputName($name, $multiple) . '" value="' . $value . '" />'
                . '</div>'
            . '</div>';   
}

/**
 * NgeFields::menu()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
    public static function menu($name, $label, $help, $options=array()) {

    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;

    $id = self::getId($name, $multiple, $multipleIndex);
    $value = self::getValue($name, 0, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $input_name = "";

    // The active font id field.
    if (0 == (int)$value){
        $value = '';
        $input_name = NGE::translate('COM_NGE_FIELD_MENU_SELECT_BTN');
    }else{
        $value = (int)$value;
        $articleTable = JTable::getInstance("content");
        $isLoadarticle = $articleTable->load($value);

        $input_name = (isset($isLoadarticle) && $isLoadarticle == true) ? $articleTable->get("title") : '';
    }
                
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<span class="input-append">'
                        . '<input class="input-xlarge ngefield-menu-name" type="text" id="'.$id.'_name" value="'.$input_name.'" disabled="disabled" size="35" />'
                        . '<div class="nge-append-button ngemenu-select-button" type="button">'
                      . '<i class="material-icons">search</i>&nbsp;'
                        . '</div>'
                        . '<div class="nge-append-button nge-append-button-clear ngemenu-clear-button" type="button" data-nge-input-default="'.NGE::translate('COM_NGE_FIELD_MENU_SELECT_BTN').'">'
                      . '<i class="material-icons">clear</i>&nbsp;'
                        . '</div>'
                    . '</span>'
                    .'<input class="ngefield-menu-id" type="hidden" id="' . $id . '_id" name="' . self::inputName($name, $multiple) . '" value="' . $value . '" />'
                . '</div>'
            . '</div>';   
}

/**
 * NgeFields::module()
 * module manager field
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param mixed $data
 * @return
 */
public static function module($name, $label, $help, $options=array()) {
    
    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;    
    
    $id = self::getId($name, $multiple, $multipleIndex);
    $value = self::getValue($name, 0, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $input_name = "";

    // The active font id field.
    if (0 == (int)$value){
        $value = '';
        $input_name = NGE::translate('COM_NGE_FIELD_MODULE_SELECT_BTN');
    }else{
        $value = (int)$value;
        $moduleTable = JTable::getInstance("module");
        $moduleTable->load($value);
        $input_name = $moduleTable->get("title");
    }
                
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<span class="input-append">'
                        . '<input class="input-xlarge ngefield-module-name" type="text" value="'.$input_name.'" disabled="disabled" size="35" />'
                        . '<div class="nge-append-button ngemodule-select-button" type="button">'
                      . '<i class="material-icons">search</i>&nbsp;'
                        . '</div>'
                        . '<div class="nge-append-button nge-append-button-clear ngemodule-clear-button" type="button" data-nge-input-default="'.NGE::translate('COM_NGE_FIELD_MODULE_SELECT_BTN').'">'
                      . '<i class="material-icons">clear</i>&nbsp;'
                        . '</div>'
                    . '</span>'
                    .'<input class="ngefield-module-id" type="hidden" name="' . self::inputName($name, $multiple) . '" value="' . $value . '" />'
                . '</div>'
            . '</div>'; 
}

/**
 * NgeFields::k2item()
 * k2 item manager
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param mixed $data
 * @return
 */
public static function k2item($name, $label, $help, $multiple=false, $multipleIndex=0) {
    $id = self::getId($name, $multiple, $multipleIndex);
    $value = self::getValue($name, 0, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $input_name = "";

    // The active font id field.
    if (0 == (int)$value){
        $value = '';
        $input_name = NGE::translate('COM_NGE_FIELD_K2ITEM_SELECT_BTN');
    }else{
        $value = (int)$value;	
			
        JTable::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_k2/tables');					
        $itemTable = JTable::getInstance("k2item");
        $isItemLoaded = $itemTable->load($value);

        $input_name = (isset($isItemLoaded) && $isItemLoaded == true) ? $itemTable->get("title") : '';
    }
                
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<span class="input-append">'
                        . '<input class="input-xlarge" type="text" id="'.$id.'_name" value="'.$input_name.'" disabled="disabled" size="35" />'
                        . '<div class="nge-append-button ngek2item-select-button" type="button" data-nge-input-id="'.$id.'">'
                      . '<i class="material-icons">search</i>&nbsp;'
                        . '</div>'
                        . '<div class="nge-append-button nge-append-button-clear ngek2item-clear-button" type="button" data-nge-input-id="'.$id.'" data-nge-input-default="'.NGE::translate('COM_NGE_FIELD_ITEM_SELECT_BTN').'">'
                      . '<i class="material-icons">clear</i>&nbsp;'
                        . '</div>'
                    . '</span>'
                    .'<input type="hidden" id="' . $id . '_id" name="' . self::inputName($name, $multiple) . '" value="' . $value . '" />'
                . '</div>'
            . '</div>';
}    

/**
 * NgeFields::menuItems()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
/*
public static function menuItems($name, $label, $help, $defaultValue='', $multiple=false, $multipleIndex=0, $attributes='') {
    /-*Get all the menu items*-/
    $items = MenusHelper::getMenuLinks();
    //$items = array();
    $id = self::getId($name, $multiple, $multipleIndex);
    $default_value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $option_html = "";

    foreach ($items as $key => $option) {
        /-*Get menu optgroup title*-/
        $option_html .= '<optgroup label="'.$option->title.'">';
            
            foreach ($option->links as $key => $link) {
                
                /-*Format level text*-/
                $menu_text = "";
                $menu_text_level = "";

                for ($i = 1; $i < $link->level; $i++) {
                    $menu_text_level .= "&nbsp;-";
                }
                
                $menu_text = $menu_text_level .'&nbsp;'. $link->text;
                if($link->value == $default_value){
                    $option_html .= '<option value="'.$link->value.'" selected="selected">'.$menu_text.'</option>';
                }else{
                    $option_html .= '<option value="'.$link->value.'">'.$menu_text.'</option>';
                }
            }
            
        $option_html .= '</optgroup>';
    }
    
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<select class="ngefield-menuItems" id="'.$id.'" name="'.self::inputName($name, $multiple).'" '.$attributes.'>'.$option_html.'</select>'
                . '</div>'
            . '</div>';	
}
*/
/**
 * NgeFields::url()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
public static function url($name, $label, $help, $options=array()) {
    
    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $attributes = isset($options['attributes']) ? $options['attributes'] : 0;
    
    // TODO: add a place holder?
	$id = 'field_' . str_replace('.', '_', $name). ($multiple ? '_'.$multipleIndex : '') ;  
	$label = self::getLabel($id, $label, $help);  
	return '<div class="control-group">
    		<div class="control-label">' . $label . '
    </div>
    		<div class="controls"><input type="text" name="' . self::inputName($name, $multiple) . '" id="' . $id . '" value="' . self::data($name,$multiple,$multipleIndex) . '" '.$attributes.'></div>
    </div>';    
}
/**
 * NgeFields::font()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
public static function font($name, $label, $help, $defaultValue='', $options=array()) {
    
    //Options
    $multiple = isset($options['multiple']) ? $options['multiple'] : false;
    $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
    $attributes = isset($options['attributes']) ? $options['attributes'] : '';
    
    $id = self::getId($name, $multiple, $multipleIndex);
    $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
    $label = self::getLabel($id, $label, $help);  
    $input_name = "";

    // The active font id field.
    if ($value == ""){
        $value = '';
        $input_name = NGE::translate('COM_NGE_FIELD_FONT_SELECT_BTN');
    }else{
        $value = $value;
        $input_name = $value;
    }
                
    return '<div class="control-group">'
                . '<div class="control-label">'.$label.'</div>'
                . '<div class="controls">'
                    .'<span class="input-append">'
                        . '<input class="input-medium ngefield-font-name" type="text" name="' . self::inputName($name, $multiple) . '" value="'.$value.'" size="35" />'
                        . '<div class="nge-append-button ngefont-select-button" type="button">'
                      . '<i class="material-icons">search</i>&nbsp;'
                        . '</div>'
                        . '<div class="nge-append-button nge-append-button-clear ngefont-clear-button" type="button" data-nge-input-default="">'
                      . '<i class="material-icons">clear</i>&nbsp;'
                        . '</div>'
                    . '</span>'
                . '</div>'
            . '</div>';	
}

/**
 * NgeFields::pattern()
 * 
 * @param mixed $name
 * @param mixed $label
 * @param mixed $help
 * @param string $defaultValue
 * @param bool $multiple
 * @param integer $multipleIndex
 * @return
 */
    public static function pattern($name, $label, $help, $patternType="part", $patternName="", $defaultValue='', $options=array()) {    
    require_once NGEPATH_HELPERS . '/data/nge/patterndriver.php';
    require_once NGEPATH_HELPERS . '/data/nge/patternsdriver.php';
    //Separated file to protect functionnalities / subscription formulas
    include NGEPATH_HELPERS . '/forms/fields/ngefields_patterns.php';
    return $result;
}

/**
 * NgeFields::patternToolbarOptions()
 * 
 * Field pattern toolbar for general form
 * @param String $formselector can be a div. All input elements will be saved
 * @param String $patternType
 * @param String $patternName
 * @param Int $widget_id
 * @return html
 */
public static function patternToolbar($formSelector, $patternType, $patternName) {
    $canManagePatterns = (NGE::features('config.patterns') && JFactory::getUser()->authorise('patterns.manage','com_nge'));
    $html = '<div class="ngefield-pattern-toolbar">'
        . '<div class="ngefield-pattern-toolbar-item ngefield-pattern-toolbar-reset icomoon icomoon-cancel-circle" onClick="javascript:resetToInitialForm(jQuery(this));" nge-pattern-selector="'.$formSelector.'" nge-pattern-type="'.$patternType.'" nge-pattern-name="'.$patternName.'" nge-title="' . NGE::translate( 'COM_NGE_RESET_PATTERN') . '" nge-description="' . NGE::translate( 'COM_NGE_RESET_PATTERN_TITLE') . '"></div>'
        . '<div class="ngefield-pattern-toolbar-item ngefield-pattern-toolbar-load icomoon icomoon-download" onClick="javascript:loadFormFromPattern(\'' . $formSelector . '\', \''.$patternType.'\', \''.$patternName.'\');" nge-title="' . NGE::translate( 'COM_NGE_LOAD_PATTERN') . '" nge-description="' . NGE::translate( 'COM_NGE_LOAD_PATTERN_TITLE') . '"></div>';
    if($canManagePatterns){
        $html .= '<div class="ngefield-pattern-toolbar-item ngefield-pattern-toolbar-save icomoon icomoon-upload" onClick="javascript:createPattern(\'' . $formSelector . '\', \'' . $patternType . '\', \'' . $patternName . '\');" nge-title="' . NGE::translate( 'COM_NGE_SAVEAS_PATTERN') . '" nge-description="' . NGE::translate( 'COM_NGE_SAVEAS_PATTERN_TITLE') . '"></div>';
    }
    $html .= '</div>';
    
    return $html;
}

public static function formtopattern($formSelector, $patternType, $patternName) {
        $canManagePatterns = (NGE::features('config.patterns') && JFactory::getUser()->authorise('patterns.manage','com_nge'));
    if ($canManagePatterns)    
    return '<div class="ngefield-pattern-toolbar">
        <div class="ngefield-pattern-toolbar-item ngefield-pattern-toolbar-save icomoon icomoon-upload" onClick="javascript:createPattern(\'' . $formSelector . '\', \'' . $patternType . '\', \'' . $patternName . '\');" nge-title="' . NGE::translate( 'COM_NGE_SAVEAS_PATTERN') . '" nge-description="' . NGE::translate( 'COM_NGE_SAVEAS_PATTERN_TITLE') . '"></div>
    </div>';
}



/**
 * NgeFields::patternToolbarHandsontable()
 * 
 * Field pattern toolbar for Handsontable form
 * @param String $formselector can be a div. All input elements will be saved
 * @param String $patternType
 * @param String $patternName
 * @return html
 */
public static function patternToolbarHandsontable($formSelector, $patternType, $patternName) {
    $canManagePatterns = (NGE::features('config.patterns') && JFactory::getUser()->authorise('patterns.manage','com_nge'));
    $html = '<div class="ngefield-pattern-toolbar">'
        .'<div class="ngefield-pattern-toolbar-item ngefield-pattern-toolbar-reset icomoon icomoon-cancel-circle" nge-pattern-selector="'.$formSelector.'" nge-pattern-type="'.$patternType.'" nge-pattern-name="'.$patternName.'" nge-title="' . NGE::translate( 'COM_NGE_RESET_PATTERN') . '" nge-description="' . NGE::translate( 'COM_NGE_RESET_PATTERN_TITLE') . '"></div>'
        .'<div class="ngefield-pattern-toolbar-item ngefield-pattern-toolbar-load icomoon icomoon-download" nge-pattern-selector="'.$formSelector.'" nge-pattern-type="'.$patternType.'" nge-pattern-name="'.$patternName.'" nge-title="' . NGE::translate( 'COM_NGE_LOAD_PATTERN') . '" nge-description="' . NGE::translate( 'COM_NGE_LOAD_PATTERN_TITLE') . '"></div>';
    if($canManagePatterns){    
        $html .= '<div class="ngefield-pattern-toolbar-item ngefield-pattern-toolbar-save icomoon icomoon-upload" onClick="javascript:createPattern(\'' . $formSelector . '\', \'' . $patternType . '\', \'' . $patternName . '\');" nge-title="' . NGE::translate( 'COM_NGE_SAVEAS_PATTERN') . '" nge-description="' . NGE::translate( 'COM_NGE_SAVEAS_PATTERN_TITLE') . '"></div>';
    }
    
    $html .= '</div>';
    return $html;
}

    /**
     * NgeFields::handsontable()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param bool $multiple
     * @param integer $multipleIndex
     * @return
     */
    public static function handsontable($name, $label, $help, $defaultValue='', $multiple=false, $multipleIndex=0, $array_attribute=array()) {
        $options = array();
        $id = self::getId($name, $multiple, $multipleIndex);
        $label = self::getLabel($id, $label, $help); 
 
        $default_value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);
        $class = (isset($array_attribute["class"]) && $array_attribute["class"] !== null && $array_attribute["class"] != "") ? $array_attribute["class"] : "";
        
        $options[] = (isset($array_attribute["colWidths"]) && $array_attribute["colWidths"] !== null && $array_attribute["colWidths"] != "") ? ' data-colwidths="'.htmlspecialchars(json_encode($array_attribute["colWidths"]), ENT_QUOTES, 'UTF-8').'"' : "";
        $options[] = (isset($array_attribute["readOnly"]) && $array_attribute["readOnly"] !== null && $array_attribute["readOnly"] != "") ? " data-readonly='".  json_encode($array_attribute['readOnly']) ."'" : '';
        $options[] = (isset($array_attribute["colHeaders"]) && $array_attribute["colHeaders"] === false) ? ' data-colheaders="false"' : ' data-colheaders="true"';
        $options[] = (isset($array_attribute["disabled"]) && $array_attribute["disabled"] !== null && $array_attribute["disabled"] !== "") ? " data-disabled='".  json_encode($array_attribute['disabled']) ."'" : "";
        $options[] = (isset($array_attribute["contextMenu"]) && $array_attribute["contextMenu"] !== null && $array_attribute["contextMenu"] !== "") ? " data-contextmenu='".  json_encode($array_attribute['contextMenu']) ."'" : "";
        $options[] = (isset($array_attribute["stretchH"]) && $array_attribute["stretchH"] !== null && $array_attribute["stretchH"] != "") ? ' data-stretchh="'.$array_attribute["stretchH"].'"' : '';
        $options[] = (isset($array_attribute["removeRowPlugin"]) && $array_attribute["removeRowPlugin"] === true) ? ' data-removerowplugin="true"' : ' data-removerowplugin="false"';
        $options[] = (isset($array_attribute["colHide"]) && $array_attribute["colHide"] !== null && $array_attribute["colHide"] != "") ? ' data-colhide="'.json_encode($array_attribute['colHide']).'"' : '';
        $options[] = (isset($array_attribute["formsPath"]) && $array_attribute["formsPath"] !== null && $array_attribute["formsPath"] !== "") ? " data-formspath='".  json_encode($array_attribute['formsPath']) ."'" : "";
            
        /*Default options colHeaders*/
        $default_opts_colHeaders = array(
            "defaultValue" => [], /*Default header col name.*/
            "addColName" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_OPTIONS_COLHEADERS_ADDCOLNAME') /*Default header col name when a new one is created. Column 1, Column 2 ...*/
        );
        $options[] = (isset($array_attribute["colHeadersOptions"]) && $array_attribute["colHeadersOptions"] !== null && $array_attribute["colHeadersOptions"] != "") ? " data-colheadersoptions='".  json_encode($array_attribute['colHeadersOptions']) ."'" : " data-colheadersoptions='".  json_encode($default_opts_colHeaders) ."'";
        
        /*Default lang*/
        $default_lang = array(
            "renameCol" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_RENAMECOL'), /*Default click right renamme col lang.*/
            "modalRenameColValidate" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_MODAL_RENAMECOL_VALIDATE'),
            "modalRenameColClose" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_MODAL_RENAMECOL_CLOSE'),
            "modalErrorEmptyName" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_MODAL_ERROR_EMPTYNAME'),
            "popoverHelpTitle" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_TITLE'),
            "popoverHelpContent" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT1').' :'
            . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT2')
            . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT3')
            . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT4')
            . '<br/><br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT5').'.'
            . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT6').'.',
            "insertRowBefore" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_INSERTROW_BEFORE'),
            "insertRowAfter" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_INSERTROW_AFTER'),
            "insertColLeft" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_INSERTCOL_LEFT'),
            "insertColRight" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_INSERTCOL_RIGHT'),
            "deleteRow" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_DELETEROW'),
            "deleteCol" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_DELETECOL'),
            "colProperties" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_COLPROPERTIES'),
            "rowProperties" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_ROWPROPERTIES'),
            "cellProperties" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_CELLPROPERTIES')
        );
        if(isset($array_attribute["lang"]) && $array_attribute["lang"] !== null && $array_attribute["lang"] != ""){
            $merge_lang = array_merge($default_lang, $array_attribute["lang"]);
            $options[] = " data-lang='".  json_encode($merge_lang) ."'";
        }else{
            $options[] = " data-lang='".  json_encode($default_lang) ."'";
        }
        $options[] = (isset($array_attribute["lang"]) && $array_attribute["lang"] !== null && $array_attribute["lang"] != "") ? " data-lang='".  json_encode($array_attribute['lang']) ."'" : " data-lang='".  json_encode($default_lang) ."'";
        $options[] = (isset($array_attribute["sorting"]) && $array_attribute["sorting"] !== null && $array_attribute["sorting"] !== "") ? " data-sorting='".  json_encode($array_attribute['sorting']) ."'" : "";
        
        $height = (isset($array_attribute["height"]) && $array_attribute["height"] !== null && $array_attribute["height"] != "") ? $array_attribute["height"] : '300px';

        //Widget attribute
        $options[] = (isset($array_attribute["widget_name"]) && $array_attribute["widget_name"] !== null && $array_attribute["widget_name"] != "") ? ' data-widgetname="'.$array_attribute["widget_name"].'"' : "";
        $options[] = $multiple ? ' data-widgetmultiple="true"' : ' data-widgetmultiple="false"';
        $options[] = ' data-widgetmultipleindex="'.$multipleIndex.'"';
            
        /* Work only on >= PHP5.4 
        $value = stripslashes(json_encode($default_value, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));*/

        $encoded = json_encode($default_value);
        /*$value = preg_replace_callback('/\\\u(\w{4})/', function ($matches) {*/
        /*A better pattern to use might be /(?<!\\\\)\\\\u(\w{4})/, which avoids incorrectly unescaping a JSON sequence like "\\u1234"*/
        $value = preg_replace_callback('/(?<!\\\\)\\\\u(\w{4})/', function ($matches) {
                return html_entity_decode('&#x' . $matches[1] . ';', ENT_COMPAT, 'UTF-8');
        }, $encoded);

        if($value === "" || $value === '""'){/*Use this options only when no values the first time in creation for example.*/
            $options[] = (isset($array_attribute["start_cols"]) && $array_attribute["start_cols"] !== null && $array_attribute["start_cols"] != "") ? ' data-startcols="'.$array_attribute["start_cols"].'"' : "";
            $options[] = (isset($array_attribute["start_rows"]) && $array_attribute["start_rows"] !== null && $array_attribute["start_rows"] != "") ? ' data-startrows="'.$array_attribute["start_rows"].'"' : "";
        }

	return '<div class="control-group">'
                . '<div>'
                    . '<div class="nge-handsontable nge-handsontable-container">'
                        . '<div class="handsontable-help icomoon-info"></div>'
                        . '<div style="overflow:hidden;height:'.$height.';">'
                            . '<div class="handsontable nge-handsontable-render"></div>'
                        . '</div>'
                        . '<input type="hidden" class="handsontable-input '.$class.'" '.implode($options).' name="' . self::inputName($name, $multiple) . '" value="' . "ngejson::".htmlentities($value) . '" />'
                    . '</div>'
                . '</div>'
            . '</div>';
	
	
    }
   
    /**
     * NgeFields::layout()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param string $defaultValue
     * @param bool $multiple
     * @param integer $multipleIndex
     * @param string $attributes
     * @return
     */
  //  public static function text($name, $label, $help, $defaultValue='', $multiple=false, $multipleIndex=0 , $attributes='', $place_holder='', $suffix=''){
    public static function layout($name, $label, $help, $source, $defaultValue='', $options=array()){	
	$id = 'field_' . str_replace('.', '_', $name);
	
	$sourceKeys = array_map('ucfirst', explode('.', $source));
	$contentClassName = 'Nge' . implode($sourceKeys) . 'Content';
	if (file_exists(NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $source) . '/content.php')){
	require_once NGEPATH_CONTENTS . '/source/' . str_replace('.', '/', $source) . '/content.php';
	    $fields = $contentClassName::getFields();
	}
	
	$html = array();
	$html[] = '<div id="' . $id . '" class="ngefieldlayout row-fluid">
			<div class="span9">
				<div class="ngelayout-title">' . $label . '</div>
				<div id="' . $id . '_layout" class="ngelayout">'. 
					$defaultValue
				. '</div>
			</div>
			<div class="span3">
				<div id="' . $id . '_fields" class="ngelayout-fields">';
	$fields[] = array('name'=>'title', 'label'=>'Title', 'type'=>'text');
	foreach ($fields as $field){
	    $html[] = '<div class="field field-' . $field['type'] . '" data-name="' . $field['name'] . '">' . $field['label'] . '</div>';
	}
	$html[] = '		</div>
			</div>';
	$html[] = '<textarea id="' . $id . '_name" name="' . self::inputName($name) . '">' . $defaultValue . '</textarea>';
	$html[] = '</div>';
	return implode($html);
    }
    
    /**
     * NgeFields::stockexchange()
     * Get field with a selection of stockexchange element (index, mnemo, isin)
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param mixed $defaultValue
     * @param array $array_attribute
     * @return
     */
    public static function stockexchange($name, $label, $help, $defaultValue='', $array_attribute=array()) {
        //Options
        $multiple = isset($options['multiple']) ? $options['multiple'] : false;
        $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
        $isMultiple = (isset($array_attribute["multiple"]) && $array_attribute["multiple"] != true) ? false : true;
        $type = (isset($array_attribute["type"]) && $array_attribute["type"] !== null && $array_attribute["type"] != "") ? $array_attribute["type"] : "stockexchange";
        $showLabel = isset($array_attribute['showLabel']) ? $array_attribute['showLabel'] : true;
        $options[] = (!$isMultiple) ? ' data-multiple="false"' : ' data-multiple="true"';
        $options[] = 'data-type="'.$type.'"';
	
        $id = self::getId($name, $multiple, $multipleIndex);
        $default_value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
        $label = self::getLabel($id, $label, $help);
        $input = "";

        $colHeadersOptions_defaultValue = [];
        $start_cols = 2;

        switch ($type) {
            case "commodity":
                $colHeadersOptions_defaultValue = ["Code", "Valeur", "Libelle (Manuel)"];
                $start_cols = 3;
                $buttonAddTitleLang = "Recherche de commodité";
                $buttonAddDescriptionLang = "Ajouter une commodité";
                $buttonInfoTitleLang = "Informations sur les commodités";
                $buttonInfoDescriptionLang = "Informations commplémentaires sur les commodités";
                break;
            default: /*stockexchange*/
                if(isset($array_attribute["colHeadersValue"]) && is_array($array_attribute["colHeadersValue"])){
                    array_unshift($array_attribute["colHeadersValue"], "Code");
                    $colHeadersOptions_defaultValue = $array_attribute["colHeadersValue"];
                    $start_cols = count($colHeadersOptions_defaultValue);
                }else{//Default header value
                    $colHeadersOptions_defaultValue = ["Code", "Libelle", "Libelle (Manuel)", "ISIN", "Historique", "Place", "Type"];
                    $start_cols = 7;
                }

                $buttonAddTitleLang = NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_MODAL_ADD_TITLE');
                $buttonAddDescriptionLang = NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_BUTTON_ADD_TOOLTIP');
                $buttonInfoTitleLang = NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_MODAL_INFO_TITLE');
                $buttonInfoDescriptionLang = NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_BUTTON_INFO_TOOLTIP');
                break;
        }
        
        if($isMultiple){
            /* Work only on >= PHP5.4 
            $value = stripslashes(json_encode($default_value, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));*/

            $encoded = json_encode($default_value);
            /*$value = preg_replace_callback('/\\\u(\w{4})/', function ($matches) {*/
            /*A better pattern to use might be /(?<!\\\\)\\\\u(\w{4})/, which avoids incorrectly unescaping a JSON sequence like "\\u1234"*/
            $value = "ngejson::".htmlentities(preg_replace_callback('/(?<!\\\\)\\\\u(\w{4})/', function ($matches) {
                    return html_entity_decode('&#x' . $matches[1] . ';', ENT_COMPAT, 'UTF-8');
            }, $encoded));
            
            $input = '<div class="ngestockexchange" name="' . self::inputName($name, $multiple) . '" '.implode($options).'>';
                $input .= self::handsontable($name."", 'COM_NGE_CONTENT_INPUT_TITLE', 'COM_NGE_CONTENT_INPUT_DESCRIPTION', '', 0, false, 
                    array(
                        "start_cols" => $start_cols, 
                        "start_rows" => 1,
                        "stretchH" => "all",
                        "contextMenu" => array("remove_row"),
                        "disabled" => array(
                            "beforeKeyDown" => true, //Disable beforeKeyDown Event (bottom arrow and tab add new row)
                        ),
                        "readOnly" => array(
                            "mode" => "enable",
                            "col" => array(1), //Enable read only for all except col 2 Libelle Manuel, to edit it
                        ),
                        "colHeadersOptions" => array(
                            "defaultValue" => $colHeadersOptions_defaultValue /*Default header col name.*/
                        ),
                        "sorting" => array(
                            "columns" => ["1"], //Order on column 1
                            "order" => ["ASC"] // Order column 1 ASC
                        ),
                        "colHeaders" => true,
                        "colWidths" => array(0.1, 100, 150),
                        "colHide" => array(0), //Hide cols: here hide col zero
                        "height" => "250px",
                        "class" => "ngestockexchange-input",
                        "lang" => array(
                            "popoverHelpContent" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT1').' :'
                                . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT3'),
                        )
                    )
                );
            $input .= "</div>";
        }else{
            if(is_array($default_value) || is_object($default_value) || $default_value === NULL){
                $value = "";
            }else{
                $value = $default_value;
            }
            
            $input = '<div class="ngestockexchange-container"></div>'
                . '<input class="ngestockexchange-input" type="hidden" name="' . self::inputName($name, $multiple) . '" value="' .$value. '" />';
        }
        
        $html = '<div class="control-group ngestockexchange" '.implode($options).'>';
            if($showLabel === true){
                $html .= '<div class="control-label">'.$label.'</div>'
                    . '<div class="controls">'
                    . '<span class="ngestockexchange-add icomoon-plus" modal-title="'.$buttonAddTitleLang.'" tooltip-description="'.$buttonAddDescriptionLang.'"></span>'
                    . '<span class="ngestockexchange-info icomoon-info" modal-title="'.$buttonInfoTitleLang.'" tooltip-description="'.$buttonInfoDescriptionLang.'"></span>'
                    . '<span class="ngestockexchange-loading" style="display:none;"><span class="ngestockexchange-loader-rotate icomoon-spinner2"></span><span class="ngestockexchange-loader-string">'.NGE::translate('COM_NGE_LOADING').'...</span></span>'
                    . $input
                . '</div>';
            }else{
                $html .= '<div>'
                    . '<span class="ngestockexchange-add icomoon-plus" modal-title="'.$buttonAddTitleLang.'" tooltip-description="'.$buttonAddDescriptionLang.'"></span>'
                    . '<span class="ngestockexchange-info icomoon-info" modal-title="'.$buttonInfoTitleLang.'" tooltip-description="'.$buttonInfoDescriptionLang.'"></span>'
                    . '<span class="ngestockexchange-loading" style="display:none;"><span class="ngestockexchange-loader-rotate icomoon-spinner2"></span><span class="ngestockexchange-loader-string">'.NGE::translate('COM_NGE_LOADING').'...</span></span>'
                    . $input
                . '</div>';
            }
        $html .= '</div>';
            
        return $html;
    }
    
    /**
     * NgeFields::commodities()
     * Get field with a selection of commodities
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param mixed $defaultValue
     * @param array $array_attribute
     * @return
     */
    public static function commodities($name, $label, $help, $defaultValue='', $array_attribute=array()) {
        //Options
        $multiple = isset($options['multiple']) ? $options['multiple'] : false;
        $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
        $isMultiple = (isset($array_attribute["multiple"]) && $array_attribute["multiple"] != true) ? false : true;
        $options[] = (!$isMultiple) ? ' data-multiple="false"' : ' data-multiple="true"';
	
        $id = self::getId($name, $multiple, $multipleIndex);
        $default_value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
        $label = self::getLabel($id, $label, $help);
        $input = "";

        if($isMultiple){
            /* Work only on >= PHP5.4 
            $value = stripslashes(json_encode($default_value, JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));*/

            $encoded = json_encode($default_value);
            /*$value = preg_replace_callback('/\\\u(\w{4})/', function ($matches) {*/
            /*A better pattern to use might be /(?<!\\\\)\\\\u(\w{4})/, which avoids incorrectly unescaping a JSON sequence like "\\u1234"*/
            $value = "ngejson::".htmlentities(preg_replace_callback('/(?<!\\\\)\\\\u(\w{4})/', function ($matches) {
                    return html_entity_decode('&#x' . $matches[1] . ';', ENT_COMPAT, 'UTF-8');
            }, $encoded));
            
            $input = '<div class="ngecommodities" name="' . self::inputName($name, $multiple) . '" '.implode($options).'>';
                $input .= self::handsontable($name.".values", 'COM_NGE_CONTENT_INPUT_TITLE', 'COM_NGE_CONTENT_INPUT_DESCRIPTION', '', 0, false, 
                    array(
                        "start_cols" => 7, 
                        "start_rows" => 1,
                        "stretchH" => "all",
                        "contextMenu" => array("remove_row"),
                        "readOnly" => array(
                            "mode" => "disable",
                            "col" => array(2), //Enable read only for all except col 2 Libelle Manuel, to edit it
                        ),
                        "colHeadersOptions" => array(
                            "defaultValue" => ["Code", "Libelle", "Libelle (Manuel)", "ISIN", "Historique", "Place", "Type"], /*Default header col name.*/
                        ),
                        "colHeaders" => true,
                        "colHide" => array(0), //Hide cols: here hide col zero
                        "height" => "180px",
                        "class" => "ngecommodities-input",
                        "lang" => array(
                            "popoverHelpContent" => NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT1').' :'
                                . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT2')
                                . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT3')
                                . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_CHARTS_LANG_POPOVER_HELP_CONTENT4')
                                . '<br/><br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT5').'.'
                                . '<br/>- '.NGE::translate('COM_NGE_HANDSONTABLE_DEFAULT_LANG_POPOVER_HELP_CONTENT6').'.',
                        )
                    )
                );
            $input .= "</div>";
        }else{
            if(is_array($default_value) || is_object($default_value) || $default_value === NULL){
                $value = "";
            }else{
                $value = $default_value;
            }
            
            $input = '<div class="ngecommodities-container"></div>'
                . '<input class="ngecommodities-input" type="hidden" name="' . self::inputName($name, $multiple) . '" value="' .$value. '" />';
        }
        
        return '<div class="control-group ngecommodities" '.implode($options).'>'
            .'<div class="control-label">'.$label.'</div>'
            .'<div class="controls">'
                . '<span class="ngecommodities-add icomoon-plus" modal-title="'.NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_MODAL_ADD_TITLE').'" tooltip-description="'.NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_BUTTON_ADD_TOOLTIP').'"></span>'
                . '<span class="ngecommodities-info icomoon-info" modal-title="'.NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_MODAL_INFO_TITLE').'" tooltip-description="'.NGE::translate('COM_NGE_CONTENT_STOCKEXCHANGE_BUTTON_INFO_TOOLTIP').'"></span>'
                . '<span class="ngecommodities-loading" style="display:none;"><span class="ngecommodities-loader-rotate icomoon-spinner2"></span><span class="ngecommodities-loader-string">'.NGE::translate('COM_NGE_LOADING').'...</span></span>'
                . $input
            . '</div>'
        .'</div>';
    }
    
    /**
     * NgeFields::date()
     * 
     * @param mixed $name
     * @param mixed $label
     * @param mixed $help
     * @param mixed $defaultValue
     * @param string $options
     * @return
     */
    public static function date($name, $label, $help, $defaultValue='', $options=array()) {
	//Options
        $multiple = isset($options['multiple']) ? $options['multiple'] : false;
        $multipleIndex = isset($options['multipleIndex']) ? $options['multipleIndex'] : 0;
        $attributes = isset($options['attributes']) ? $options['attributes'] : '';
	
        $id = self::getId($name, $multiple, $multipleIndex);
        $value = self::getValue($name, $defaultValue, $multiple, $multipleIndex);    
        $label = self::getLabel($id, $label, $help);
        
        return '<div class="control-group">'
            .'<div class="control-label">'.$label.'</div>'
            .'<div class="controls">'
                . '<input class="ngefield-datepicker" type="text" name="' . self::inputName($name, $multiple) . '" value="' . $value . '" '.$attributes.'>'
            . '</div>'
        .'</div>';
    }

    /**
     * NgeFields::access()
     * To display a permission page for an element
     * 
     * @return
     */    
    public static function permissions() {
	$form=array();
	JForm::addFormPath(JPATH_SITE . '/components/com_nge/models/forms');
	    $formAccess = JForm::getInstance('access', 'access');
	    $formAccess->bind(self::$_data);
		$form[] = $formAccess->getInput('rules');

	    return implode($form);
		
	}
}