/* 
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * First initialization, these settings and events will be applied to all existing forms or forms that will be loaded further in ajax
 * Initialize all scripts to make the input fields work.
 * @param {type} $selector
 * @returns {undefined}
 */
function initForms(){

    initFormsRadio();
    initFormsEditor();
    initFormsNgeSlider();
    initFormsColor();
    initFormsColors();
    initFormsColorCMYK();
    initFormsCheckbox();
    initFormsGlyph();
    initFormsFileManager();
    initFormsMenuItems();
    initFormsFont();
    initFormsArticle();
    initFormsMenu();
    initFormsModule();
    initFormsPattern();
    initFormsMultipleLayout();
    initFormsMultipleListLayout();
    initFormsLayout();
    
    //Ajax loading for subforms
    initPartSubforms();
    
    
        /* Help on labels*/
        /*$selector.find('label.ngeHelpPopover').popover({
            html:true,
            placement:'right',
            trigger:'hover',
            container:"body"
        });*/
	
	/*trigger events*/
	jQuery(document).on( "change", ":input", function() {
	    jQuery(document).trigger( "ngeConfigChange");
	});
	
	/*preview while typing*/
	var timerKeyUp;	
 	jQuery(document).on("keyup", ":input", function () {
	    clearTimeout(timerKeyUp);
	    timerKeyUp = setTimeout(function() {jQuery(document).trigger( "ngeConfigChange")}, 500);
 	});
	
}



/**
 * First initialization, after loading html content (initial form or subforms in ajax)
 * Initialize all scripts to make the input fields work.
 * @param {type} $selector
 * @returns {undefined}
 */
function initFields($selector){
    $selector = typeof $selector !== "undefined" ? $selector : jQuery("form");

    var deferredsFields = [];
    deferredsFields.push(initFieldradio($selector));
    //deferredsFields.push(initNgeEditor($selector));
    //deferredsFields.push(initNgeSlider($selector));    
    //deferredsFields.push(initNgeColor($selector));
    //deferredsFields.push(initNgeColors($selector));
    //deferredsFields.push(initNgeCheckbox($selector));
    //deferredsFields.push(initNgeGlyph($selector));
    //deferredsFields.push(initNgeFileManager($selector));
    deferredsFields.push(initNgeSelect($selector));
    //deferredsFields.push(initNgeSort($selector));    
    //deferredsFields.push(initNgeMenuItems($selector));
    deferredsFields.push(initNgeDate($selector));
    //deferredsFields.push(initNgeFont($selector));
    //deferredsFields.push(initNgeArticle($selector));
    ////deferredsFields.push(initNgeMenu($selector));
    //deferredsFields.push(initNgeModule($selector));
    /*deferredsFields.push(initNgeK2item($selector));*/
    //deferredsFields.push(initNgePattern($selector));
    //deferredsFields.push(initNgeMultipleLayout($selector));
    //deferredsFields.push(initNgeMultipleListLayout($selector));
    deferredsFields.push(initNgeHandsontable($selector));
    //deferredsFields.push(initNgeLayout($selector));
    deferredsFields.push(initNgeStockExchange($selector));
    deferredsFields.push(initNgeCommodities($selector));
    /*Launch the other fields (Feedalliance, Figaro ...)*/
    deferredsFields.push(jQuery(document).trigger( "ngeOthersFields", [{ selector : $selector }]));
    
    //var timerKeyUp;
    jQuery.when.apply(null, deferredsFields).done(function() {

        /* Help on labels*/
        $selector.find('label.ngeHelpPopover').popover({
            html:true,
            placement:'right',
            trigger:'hover',
            container:"body"
        });
	
	/*trigger events*/
	/*$selector.find(':input', '.ngecontentform, .ngeoptionsform, .ngedisplayform, .nge-hot-form').change(function () {
            jQuery(document).trigger( "ngeConfigChange");
	});*/
	
	/*preview while typing*/
 	/*$selector.find(':input', '#contentform, #optionsform, .ngedisplayform, .nge-hot-form').keyup(function () {
	    clearTimeout(timerKeyUp);
	    timerKeyUp = setTimeout(function() {jQuery(document).trigger( "ngeConfigChange")}, 500);
 	});*/
		
	//First call
	jQuery(document).trigger( "ngeConfigChange");
    });
}


/* Loading ajax subforms for best performance */
initPartSubforms = function(){

    jQuery(document).on('shown.bs.tab', 'a[data-toggle="tab"]', function (e) {
	//Find activated tab
	var contentTab = jQuery(e.target).attr("href");
	/*var $internalform = jQuery('#internalform');
	if($internalform) {
	    var str_data_internal = JSON.stringify($internalform.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal = '';*/
	var token = '&' + ngeToken + '=1';
	
	    /* If exists some tags to be loaded in ajax mode  */	
	    //jQuery(contentTab).find('.partsubform').each(function(){
	    jQuery(contentTab + ' >.partsubform').each(function(){
		var subformTag = this;
		/* If tag is empty, the form is loaded in ajax mode  */	
		//if (jQuery(this).html() == ''){	    
		    //var dataForm = jQuery(this).attr('data-form'); //Form name
		    var dataForm = jQuery(this).data('form'); //Form name
		    var formName = dataForm.name;
		    var formMode = dataForm.mode;
		    var formKey = dataForm.key;
		    jQuery.ajax({
			/*url: baseUrl + "index.php?option=com_nge&view=config&layout=subform&mode=" + formMode + "&format=raw&caller=config&" + key + "&form="+formName,*/
			url: baseUrl + "index.php?option=com_nge&task=form.load&mode=" + formMode + "&key=" + formKey + "&form="+formName + token,
			type: 'POST',
			success: function (result) { 
			    jQuery(subformTag).html(result);
			    jQuery(subformTag).removeClass('partsubform');
			    initFields(jQuery(subformTag));
			}
		    });
		//}		
	    });
    /*jQuery(document)$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
  var target = $(e.target).attr("href") // activated tab
  alert(target);
});*/
    });
}

/* Loading ajax subforms for best performance */
initPartSubformsAutoload = function($selector, callback){
    $selectorSubForm = (typeof $selector !== "undefined") ? $selector.find('.partsubform') : jQuery('.partsubform');
    
    var deferredsFields = [];
    
    loadCurrentForm = function($formSelector, formMode, formKey, formName){
	
	var dfd = jQuery.Deferred();
	/*var $internalform = jQuery('#internalform');
	if($internalform) {
	    var str_data_internal = JSON.stringify($internalform.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal = '';*/
	var token = '&' + ngeToken + '=1';
	
	jQuery.ajax({
	    url: baseUrl + "index.php?option=com_nge&task=form.load&mode=" + formMode + "&key=" + formKey + "&form="+formName + token,
	    type: 'POST',
	    success: function (result) { 
		$formSelector.html(result);
		$formSelector.removeClass('partsubform');
		initFields($formSelector);
		dfd.resolve('loadCurrentForm');
	    }
	});

	return dfd.promise();
    };

    $selectorSubForm.each(function(){
        var $subform = jQuery(this);
        var dataForm = $subform.data('form'); //Form name
        var formName = dataForm.name;
        var formMode = dataForm.mode;
        var formKey = dataForm.key;
        
        deferredsFields.push(loadCurrentForm($subform, formMode, formKey, formName));
    });
    
    /*When all deffered function ajax are done, we call the callback function*/
    jQuery.when.apply(null, deferredsFields).done(function() {
	if(typeof callback !== "undefined" && typeof callback === "function"){
            callback();
        }
    });
}

/* */
function fetchFromObject(obj, prop) {

    if(typeof obj === 'undefined') {
        return false;
    }

    var _index = prop.indexOf('.')
    if(_index > -1) {
        return fetchFromObject(obj[prop.substring(0, _index)], prop.substr(_index + 1));
    }

    return obj[prop];
}

/**
 * Update fields values from a json object
 * For example to load different default values (from patterns)
 * @param {type} $selector
 * * @param {type} $values : object containing properties of each input field to be updated, for example border.size
 * @returns {undefined}
 */
function loadValues($selector, newValues){
    $form = jQuery($selector);
    $namedFields = jQuery($selector).find("[name]");
    $namedFields.each(function(){
	var property = $namedFields.attr('name');
	var newValue = fetchFromObject(newValues, property);
	/* if jQuery(this) is input... */
	jQuery(this).val(newValue);
    });
    /* Update visual input fields*/
    updateFields($selector);
}

/**
 * Update fields display after changing content values.
 * Especially in the multiple fields
 * @param {type} $selector
 * @returns {undefined}
 */
function updateFields($selector){
    $selector = typeof $selector !== "undefined" ? $selector : jQuery("form");

    var deferredsFields = [];
    deferredsFields.push(updateFieldradio($selector));
    deferredsFields.push(updateFieldSlider($selector));    
    deferredsFields.push(updateFieldSelect($selector));
    deferredsFields.push(updateFieldCheckbox($selector));
    deferredsFields.push(updateNgeArticle($selector));
    deferredsFields.push(updateNgeMenu($selector));
    
    jQuery.when.apply(null, deferredsFields).done(function() {
	
    });
}


/*
* Hack to well render handsontable in bootstrap tab config
* Only one time per document because we just need one instance
* */
jQuery(document).on( "click", ".nav li a", function(){
    var href = jQuery(this).attr("href");
    ngeRenderHandsontable(jQuery(href));
});

/*OBJECTS*/
var NgeHandsontable = (function () {
    
    /*Constructor*/
    function NgeHandsontable (object) {
        /*
         * Default value
         */
        /*hotElement is the jquery div element where the handsontable will be instanciate*/
        this._hotElement = object.hotElement;
        /*Options used to instanciate the handsontable instance*/
        this._hotOptions = this.setDefaultHotOptions();
        /*Data used to instanciate the handsontable instance*/
        this._hotData = this.getDefaultData();
        /*Options used for widget instance if necessary, else empty*/
        this._widgetOptions = this.setDefaultWidgetOptions();
        /*Timer used to update value only when specific time is timeout.*/
        this._timerUpdateInputData = "";
        /*Attach another handsontable instance to this instance.*/
        this._bindTo = null;
        
        /*
         * Set value if exist
         */
        if(typeof object !== "undefined"){
            if(typeof object.hotOptions !== "undefined"){
                this._hotOptions = this.setDefaultHotOptions(object.hotOptions);
            }
            if(typeof object.widgetOptions !== "undefined"){
                this._widgetOptions = this.setDefaultWidgetOptions(object.widgetOptions);
            }
            /*Add name if we use colHeaders*/
            if(this._hotOptions.colHeaders !== null){
                if(typeof this._widgetOptions.colHeadersOptions.defaultValue !== "undefined"){
                    if(this._widgetOptions.colHeadersOptions.defaultValue.length > 0){
                        var arrayTmpNames = [];
                        for (var key in this._widgetOptions.colHeadersOptions.defaultValue) {
                            // skip loop if the property is from prototype
                            if (!this._widgetOptions.colHeadersOptions.defaultValue.hasOwnProperty(key)) continue;

                            arrayTmpNames.push(this._widgetOptions.colHeadersOptions.defaultValue[key]);
                        }
                        
                        this._hotData.options.names = arrayTmpNames;
                    }else{
                        this._hotData.options.names = [this._widgetOptions.colHeadersOptions.addColName+" 0", this._widgetOptions.colHeadersOptions.addColName+" 1"];
                    }
                }else{
                    this._hotData.options.names = ["Column 0", "Column 1"];
                }
            }

            if(typeof object.hotData !== "undefined" && JSON.parse(object.hotData) !== ""){
                this._hotData = formattedData(JSON.parse(object.hotData));
//                this._hotOptions.mergeCells = this.getMergeCells(); A REFAIRE FONCTIONNER EN TEMPS VOULU
            }
        }

        this._triggerUpdateDataName = null;
        this._triggerUpdateDataArgs = null;
        
        /*In case of values not initialised if not exist. For example when startCols and startRows exist*/
        if((this._hotData.values.length > this._hotData.options.rows.length) || (this._hotData.values[0].length > this._hotData.options.cols.length)
            || (this._hotData.values.length > this._hotData.options.cells.length) 
            || ((typeof this._hotData.options.cells[0] !== "undefined") && this._hotData.values[0].length > this._hotData.options.cells[0].length)){
            this._hotOptions.startRows = this._hotData.values.length;
            this._hotOptions.startCols = this._hotData.values[0].length;
        }
        
        this.formatValuesStartRowsCols();
        
        /*If file import exist*/
        this.initFileUpload();
        
        /*Catch resize event config*/
        this.initResizeEvent();
        
        /*Enabled specific element*/
        this.enabledPopoverInformation();
    }

    /*Private method*/ 
    /**
     * formatted data to be well display in handsontable instance.
     * @return {data} The object data well formatted.
     */
    function formattedData (data) {
        var highestCountValues = max(data.values).length;
        
        for (i=0; i < data.values.length; i++){
            if(data.values[i].length < highestCountValues){
                for (j=0; j < highestCountValues; j++){
                    if(typeof data.values[i][j] == "undefined"){
                        data.values[i][j] = null;
                    }
                }
            }
        }
        
        return data;
    }
    
    /*
     * Equivalent function max to php max function 
     * Retrieve the array with maximun values inside.
     */
    function max () {
        var ar
        var retVal
        var i = 0
        var n = 0
        var argv = arguments
        var argc = argv.length
        var _obj2Array = function (obj) {
          if (Object.prototype.toString.call(obj) === '[object Array]') {
            return obj
          } else {
            var ar = []
            for (var i in obj) {
              if (obj.hasOwnProperty(i)) {
                ar.push(obj[i])
              }
            }
            return ar
          }
        }
        var _compare = function (current, next) {
          var i = 0
          var n = 0
          var tmp = 0
          var nl = 0
          var cl = 0

          if (current === next) {
            return 0
          } else if (typeof current === 'object') {
            if (typeof next === 'object') {
              current = _obj2Array(current)
              next = _obj2Array(next)
              cl = current.length
              nl = next.length
              if (nl > cl) {
                return 1
              } else if (nl < cl) {
                return -1
              }
              for (i = 0, n = cl; i < n; ++i) {
                tmp = _compare(current[i], next[i])
                if (tmp === 1) {
                  return 1
                } else if (tmp === -1) {
                  return -1
                }
              }
              return 0
            }
            return -1
          } else if (typeof next === 'object') {
            return 1
          } else if (isNaN(next) && !isNaN(current)) {
            if (current === 0) {
              return 0
            }
            return (current < 0 ? 1 : -1)
          } else if (isNaN(current) && !isNaN(next)) {
            if (next === 0) {
              return 0
            }
            return (next > 0 ? 1 : -1)
          }

          if (next === current) {
            return 0
          }

          return (next > current ? 1 : -1)
        }

        if (argc === 0) {
          throw new Error('At least one value should be passed to max()')
        } else if (argc === 1) {
          if (typeof argv[0] === 'object') {
            ar = _obj2Array(argv[0])
          } else {
            throw new Error('Wrong parameter count for max()')
          }
          if (ar.length === 0) {
            throw new Error('Array must contain at least one element for max()')
          }
        } else {
          ar = argv
        }

        retVal = ar[0]
        for (i = 1, n = ar.length; i < n; ++i) {
          if (_compare(retVal, ar[i]) === 1) {
            retVal = ar[i]
          }
        }

        return retVal
    }
    
    /*Public method*/
    /**
     * Init Resize event
     */
    NgeHandsontable.prototype.initResizeEvent = function() {
        var $this = this;
        
        /*Catch resize event config*/
        if(jQuery("#nge-config-preview").length > 0){
            jQuery("#nge-config-preview").resize(function() {
                var hot = $this.getHotInstance.call($this);
                hot.render();
                /*if this._bindTo exist*/
                if($this._bindTo !== null){
                    var hotBindTo = $this._bindTo.getHotInstance.call($this._bindTo);
                    hotBindTo.render();
                }
            });
        }
    }
    /**
     * Init fileupload if exist
     */
    NgeHandsontable.prototype.initFileUpload = function() {
        var $fileImportContainer = this._hotElement.closest("div.nge-handsontable-container").find("div.nge-handsontable-fileupload-container");
        if($fileImportContainer.length > 0){
            $this = this;
            var $fileImportButton = $fileImportContainer.find("input.nge-handsontable-fileupload-input");
            var $fileImportProgress = $fileImportContainer.find("div.nge-handsontable-fileupload-progress");
            var $fileImportProgressName = $fileImportContainer.find("div.nge-handsontable-formupload-progress");
            var $fileImportProgressBar = $fileImportProgress.find("div.bar");
            
            $fileImportButton.fileupload({
                url: rootUrl+'media/com_nge/jquery-fileupload/server/php/',
                send: function (e, data) {
                    $fileImportProgress.show();
                },
                done: function (e, data) {
                    try{
                        var result = jQuery.parseJSON(data.result);
                        var file = result.files[0];
                        
                        bootbox.hideAll();
                        bootbox.prompt({
                            title: "Nombre de ligne d'entête ?",
                            message: "test",
                            backdrop: false,
                            value: 1,
                            inputType: 'number',
                            buttons: {
                                confirm: {
                                    label: "Valider",
                                    className: "btn-primary"
                                },
                                cancel: {
                                    label: "Fermer",
                                    className: "btn"
                                }
                            },
                            callback: function (result) {
                                if(result === null){
                                    jQuery.ajax({
                                        dataType: 'json',
                                        url: file.deleteUrl,
                                        type: 'DELETE'
                                    });
                                    
                                    $fileImportProgress.fadeOut(400);
                                }else{
                                    var nb_header = (result > 0) ? result : 0;
                                    $fileImportProgress.fadeOut(400, function () {
                                        $fileImportProgressName.show();
                                        var dataOptions = {};
                                        dataOptions.name = $this._widgetOptions.name;
                                        dataOptions.file_name = file.name;
                                        dataOptions.nb_header = nb_header;

                                        jQuery.ajax({
                                            url: rootUrl+"index.php?option=com_nge&task=field_handsontable.loadFile",
                                            data: {data_options:dataOptions},
                                            success : function(resultJson){
                                                try {
                                                    var result = JSON.parse(resultJson);
                                                    
                                                    jQuery.ajax({
                                                        dataType: 'json',
                                                        url: file.deleteUrl,
                                                        type: 'DELETE'
                                                    });
                                                    
                                                    $fileImportProgressName.hide();
                                                    
                                                    if(result.success === 0){
                                                        console.error(result.message);
                                                    }else{
                                                        $this.loadFileData(result.data, parseInt(result.nbHeader));
                                                    }
                                                } catch (err) {
                                                    alert("Données du fichier incorrectes !!");
                                                    console.error("Error : to load file information!<br>" + err.toString());
                                                }
                                            },
                                            error : function(){
                                                console.error("Error: to access to the load file function");   
                                            }
                                        });
                                    });
                                }
                            }
                        }).css({"z-index": "99999", "width": "280px", "margin-left": "-140px"});
                    } catch(err){
                        console.error("Error : Unable to upload the file<br>"+err.toString());  
                    }
                },
                progressall: function (e, data) {
                    var progress = parseInt(data.loaded / data.total * 100, 10);
                    $fileImportProgressBar.css(
                        'width',
                        progress + '%'
                    );
                },
                fail: function () {
                    alert("Erreur de chargement du fichier");  
                },
                start: function (e) {
                    $fileImportProgressBar.css('width', '0');
                    $fileImportProgress.fadeIn("fast");
                }
            });
        }
    }
    
    /**
     * Format value return by the plugin fileUpload
     */
    NgeHandsontable.prototype.loadFileData = function(data, nbHeader) {
        var $this = this;
        var arrayHeader = data;
        var arrayValue = data;
        var deferredsFields = [];
        
        if(nbHeader > 0){
            arrayHeader = arrayHeader.slice(0, nbHeader);
            arrayValue.splice(0, nbHeader);
        }
        
        var hot = this.getHotInstance.call(this);
        deferredsFields.push(hot.loadData(arrayValue));
        
        /*if this._bindTo exist*/
        if(this._bindTo !== null){
            var hotBindTo = this._bindTo.getHotInstance.call(this._bindTo);
            deferredsFields.push(hotBindTo.loadData(arrayHeader));
        }

        jQuery.when.apply(null, deferredsFields).done(function() {
            $this.formatHotValues.call($this); 
            /*if this._bindTo exist*/
            if($this._bindTo !== null){
                $this._bindTo.formatHotValues.call($this._bindTo);
            }
        });
    }
    
    /**
     * Launch function name if defined when data Updated
     */
    NgeHandsontable.prototype.triggerUpdateData = function() {
        if(this._triggerUpdateDataName !== null && typeof this._triggerUpdateDataName === "function"){
            if(this._triggerUpdateDataArgs !== null && this._triggerUpdateDataArgs.length > 0){
                /*Multiple args*/
                this._triggerUpdateDataName.apply(this._triggerUpdateDataArgs);
            }else{
                this._triggerUpdateDataName.call();
            }
        }
    }
    
    /**
     * Return the current handsontable instance
     * @return handsontable isntance.
     */
    NgeHandsontable.prototype.getHotInstance = function() {
        return this._hotElement.handsontable("getInstance");
    }
    
    /**
     * Sort the data with the specific options passed in parameters. Else do nothing
     * @return @void.
     */
    NgeHandsontable.prototype.dataMultiSort = function() {
        if(this._widgetOptions.sorting !== null){
            var hot = this.getHotInstance.call(this);
            var currentData = hot.getData();

            hot.view.settings.data.splice(0, hot.view.settings.data.length);
            jQuery.merge(hot.view.settings.data, ngetools.array.multisort(currentData, this._widgetOptions.sorting.columns, this._widgetOptions.sorting.orderBy))
        }
    }
    
    /**
     * Rows formatting
     * @return this.dataHot formatting
    */
    NgeHandsontable.prototype.formatHotRows = function(action, row, amount) {
        row = typeof row !== "undefined" ? row : "";
        action = typeof action !== "undefined" ? action : "";
        amount = typeof amount !== "undefined" ? amount : "";
        
        var hot = this.getHotInstance.call(this);
        var tmpDataHot = hot.getData();
        var dataRows = new Array();
        var dataHotRows = this._hotData.options.rows;
        var data;

        if(action === "remove"){
            if(row !== "" && amount !== ""){
                /*Delete rows options*/
                this._hotData.options.rows.splice(row, amount);
            }
        }else if(action === "add"){
            if(row !== ""){
                this._hotData.options.rows.splice(row, 0, null);
            }			
        }else{
            if(tmpDataHot.length >= dataHotRows.length){
                data = tmpDataHot;
            }else{
                data = dataHotRows;	
            }

            for (i = 0; i < data.length; i++) {
                if(typeof tmpDataHot[i] !== "undefined"){
                    if(typeof dataHotRows[i] !== "undefined"){
                        dataRows[i] = dataHotRows[i];
                    }else{
                        dataRows[i] = null;
                    }
                }
            }

            this._hotData.options.rows = dataRows;					
        }
    }
    
    /**
     * Columns formatting
     * @return this.dataHot formatting
     */
    NgeHandsontable.prototype.formatHotCols = function(action, col, amount) {
        col = typeof col !== "undefined" ? col : "";
        action = typeof action !== "undefined" ? action : "";
        amount = typeof amount !== "undefined" ? amount : "";
        var hot = this.getHotInstance.call(this);				
        var tmpDataHot = hot.getData();	
        var dataCols = new Array();		
        var dataHotCols = this._hotData.options.cols;			
        var data;

        if(action === "remove"){
            if(col !== "" && amount !== ""){
                /*Delete cols options*/
                this._hotData.options.cols.splice(col, amount);
                /*Delete Names colheader*/
                if(typeof this._hotData.options.names !== "undefined"){
                    this._hotData.options.names.splice(col, amount);
                }
            }
        }else if(action === "add"){
            if(col !== ""){
                this._hotData.options.cols.splice(col, 0, null);
            }			
        }else{		
            if(tmpDataHot[0].length >= dataHotCols.length){
                data = tmpDataHot[0];
            }else{
                data = dataHotCols;	
            }

            for (i = 0; i < data.length; i++) {
                if(typeof tmpDataHot[0][i] !== "undefined"){
                    if(typeof dataHotCols[i] !== "undefined"){
                        dataCols[i] = dataHotCols[i];
                    }else{
                        dataCols[i] = null;
                    }
                }
            }

            this._hotData.options.cols = dataCols;
        }
        
        /*Clean col name if col option index not exist (in old case)*/
        if(typeof this._hotData.options.names !== 'undefined'){
            for (i = 0; i < this._hotData.options.names.length; i++) {
                if(typeof this._hotData.options.cols[i] === "undefined"){
                    this._hotData.options.names.splice(i, 1);
                }
            }
        }
    }
    
    /**
     * Cells formatting
     * @return this.dataHot formatting
     */
    NgeHandsontable.prototype.formatHotCells = function(action, type, index, amount) {
        action = typeof action !== "undefined" ? action : "";
        type = typeof type !== "undefined" ? type : "";
        index = typeof index !== "undefined" ? index : "";
        amount = typeof amount !== "undefined" ? amount : "";
        var hot = this.getHotInstance.call(this);				
        var tmpDataHot = hot.getData();
        var dataHotCells = this._hotData.options.cells;
        var data;

        if(action === "remove"){
            if(type === "row"){
                if(index !== "" && amount !== ""){
                    this._hotData.options.cells.splice(index, amount);
                }
            }else{
                /*type = col*/	
                if(index !== "" && amount !== ""){
                    var count = this._hotData.options.rows.length;
                    for (i = 0; i < count; i++) {
                        if(typeof this._hotData.options.cells[i] !== "undefined"){
                            this._hotData.options.cells[i].splice(index, amount);
                        }
                    }
                }		
            }
        }else if(action === "add"){
            if(type === "row"){
                if(index !== ""){
                    this._hotData.options.cells.splice(index, 0, new Array());
                    var countCols = this._hotData.options.cols.length;

                    for (i = 0; i < countCols; i++) {
                        this._hotData.options.cells[index][i] = null;
                    }
                }
            }else{
                /*type = col*/	
                if(index !== ""){
                    var countRows = this._hotData.options.rows.length;
                    for (i = 0; i < countRows; i++) {
                        this._hotData.options.cells[i].splice(index, 0, null);
                    }
                }		
            }			
        }else{
            if(tmpDataHot.length >= dataHotCells.length && tmpDataHot[0].length >= dataHotCells[0].length){
                data = tmpDataHot;
            }else{
                data = dataHotCells;	
            }

            for (i = 0; i < data.length; i++) {
                if(typeof tmpDataHot[i] !== "undefined"){
                    for (j = 0; j < data[i].length; j++) {
                        if(typeof tmpDataHot[i][j] === "undefined"){
                            this._hotData.options.cells[i].splice(j, 1);
                        }else{
                            if(typeof dataHotCells[i] !== "undefined"){
                                if(typeof dataHotCells[i][j] !== "undefined"){
                                    this._hotData.options.cells[i][j] = dataHotCells[i][j];
                                }else{
                                    this._hotData.options.cells[i][j] = null;
                                }
                            }else{
                                this._hotData.options.cells[i] = new Array();
                                this._hotData.options.cells[i][j] = null;
                            }
                        }
                    }
                }else{
                    this._hotData.options.cells.splice(i, 1);
                }		
            }
        }
    }
    
    /**
     * Format object this.dataHot with the new value
     * @return this.dataHot formatting
     */
    NgeHandsontable.prototype.formatHotValues = function() {
        var hot = this.getHotInstance.call(this);

        this.updateValues(hot.view.settings.data);
    }
    
    /**
     * Update form object to be passed on the preview
     * @param {array} $this if exist it's an array of args
     * @return void
     */
    NgeHandsontable.prototype.updateInputData = function() {
        var $this = Array.isArray(this) ? this[0] : this;
        clearTimeout($this._timerUpdateInputData);
	$this._timerUpdateInputData = setTimeout(function(){
            if(typeof $this._hotData !== undefined){
                var str = JSON.stringify($this._hotData);
                /*Use ngejson:: parameter to the beginning of json string object -> used for decode when render or save*/
                var $input = $this._hotElement.closest(".nge-handsontable-container").find("input.handsontable-input");
                $input.val("ngejson::"+str);
                $input.trigger('change');
            }
        },  40);
    }
    
    /**
     * Set default options for the handsontable librairie.
     * @return {_hotOptions} The object _hotOptions.
     */
    NgeHandsontable.prototype.setDefaultHotOptions = function(options) {
        var hotOptions = {};
        
        /*String, function: String or rendering function*/
        hotOptions.renderer = "html";
        /*Number : Initial number of columns. Default 5*/
        hotOptions.startCols = (typeof options !== "undefined" && typeof options.startCols !== "undefined") ? options.startCols : null;
        /*Number : Initial number of rows. Default 5*/
        hotOptions.startRows = (typeof options !== "undefined" && typeof options.startRows !== "undefined") ? options.startRows : null;
        /*String : Column stretching mode. Possible values: "none", "last", "all".*/
        hotOptions.stretchH = (typeof options !== "undefined" && typeof options.stretchH !== "undefined") ? options.stretchH : 'none';
        /*Array : enabled contextmenu for specific element.*/
        hotOptions.contextMenu = (typeof options !== "undefined" && typeof options.contextMenu !== "undefined" && options.contextMenu != "true") ? JSON.parse(options.contextMenu) : ["rename_cols", "row_above", "row_below", "col_left", "col_right", "hsep1", "remove_row", "remove_col","hsep2","colProperties","rowProperties","cellProperties"];
        /*Boolean, Array, function : Setting true or false will enable or disable the default column headers (A, B, C).*/
        hotOptions.colHeaders = (typeof options !== "undefined" && typeof options.colHeaders !== "undefined" && options.colHeaders != "false") ? options.colHeaders : null;
        /*Boolean, Array, function : Setting true or false will enable or disable the default row headers (1, 2, 3).*/
        hotOptions.rowHeaders = (typeof options !== "undefined" && typeof options.rowHeaders !== "undefined") ? options.rowHeaders : null;
        /*Boolean or Array : Turn on Column sorting. https://docs.handsontable.com/pro/1.15.0/Options.html#columnSorting*/
        hotOptions.columnSorting = (typeof options !== "undefined" && typeof options.columnSorting !== "undefined") ? options.columnSorting : null;
        /*Boolean : Set whether to display the current sorting indicator (a triangle icon in the column header, specifying the sorting order).*/
        hotOptions.sortIndicator = (typeof options !== "undefined" && typeof options.sortIndicator !== "undefined") ? options.sortIndicator : false;
        /*Boolean, Array : Setting to true or array enables the mergeCells plugin, which enables the merging of the cells.*/
//        hotOptions.mergeCells = (typeof options !== "undefined" && typeof options.mergeCells !== "undefined") ? options.mergeCells : false;
        /*Boolean : Enabled remove Row plugin, default it's disabled (false).*/
        hotOptions.removeRowPlugin = (typeof options !== "undefined" && typeof options.removeRowPlugin !== "undefined") ? (options.removeRowPlugin == 'true') : false;

        return hotOptions;
    }
    
    /**
     * Set default options for the handsontable librairie.
     * @return {_hotOptions} The object _hotOptions.
     */
    NgeHandsontable.prototype.setDefaultWidgetOptions = function(options) {
        var widgetOptions = {};
        /*Number : Initial number of columns. Default 5*/
        widgetOptions.name = (typeof options !== "undefined" && typeof options.attr("data-widgetname") !== "undefined") ? options.attr("data-widgetname") : null;
        /*Number : Initial number of rows. Default 5*/
        widgetOptions.multiple = (typeof options !== "undefined" && typeof options.attr("data-widgetmultiple") !== "undefined") ? options.attr("data-widgetmultiple") : false;
        /*Boolean : Make cell read only.*/
        widgetOptions.multipleIndex = (typeof options !== "undefined" && typeof options.attr("data-widgetmultipleindex") !== "undefined") ? options.attr("data-widgetmultipleindex") : false;
        /*String : Forms path. Default empty string*/
        widgetOptions.formsPath = (typeof options !== "undefined" && typeof options.attr("data-formspath") !== "undefined" && typeof options.attr("data-formspath") !== "") ? JSON.parse(options.attr("data-formspath")) : "";
        /*Array : Setting array of element you want to disable. For example array["removeCol" => array[0, 2]] disabled removeCol for col 0 and 2*/
        widgetOptions.disabled = (typeof options !== "undefined" && typeof options.attr("data-disabled") !== "undefined" && typeof options.attr("data-disabled") !== "") ? JSON.parse(options.attr("data-disabled")) : null;
        /*Array : Get array of colHeaders options. For example : 
         *  array(
                "defaultValue" => [], //Default header col name.
                "addColName" => "Column" //Default header col name when a new one is created. Column 1, Column 2 ...
            );
        */
        var defaultColHeadersOptions = {
            defaultValue : [],
            addColName : "Column"
        };
        widgetOptions.colHeadersOptions = (typeof options !== "undefined" && typeof options.attr("data-colheadersoptions") !== "undefined" && typeof options.attr("data-colheadersoptions") !== "") ? JSON.parse(options.attr("data-colheadersoptions")) : defaultColHeadersOptions;
        /*Array : Get array of lang. For example : 
         *  array(
                "renameCol" => "Rename Column" //Default click right contextmenu renamme col lang
            );
        */
        var defaultLang = {
            renameCol : "Rename Column",
            modalRenameColValidate : "Validate",
            modalErrorEmptyName : "Column name can't be empty",
            popoverHelpTitle : "Informations",
            popoverHelpContent : 'Right click on the table allows :'
            + '<br/>- Add rows above and below'
            + '<br/>- Delete the selected row'
            + '<br/>- Rename the column name'
            + '<br/><br/>- Press the keyboard bottom arrow inside a cell to move to the next row or add a new row if it does not exist.'
            + '<br/>- Inside a cell : ALT + ENTER allows to line wrap.',
            insertRowAfter : "Insert row after",
            insertColLeft : "Insert left column",
            insertColRight : "Insert right column",
            deleteRow : "Delete row",
            deleteCol : "Delete column",
            colProperties : "Column properties",
            rowProperties : "Row properties",
            cellProperties : "Cell properties"
        };
        widgetOptions.lang = (typeof options !== "undefined" && typeof options.attr("data-lang") !== "undefined" && typeof options.attr("data-lang") !== "") ? jQuery.extend(defaultLang, JSON.parse(options.attr("data-lang"))) : defaultLang;
        /*Array, function, Number, String : Defines column widths in pixels. Array function Number String*/
        widgetOptions.colWidths = (typeof options !== "undefined" && typeof options.attr("data-colwidths") !== "undefined" && typeof options.attr("data-colwidths") !== "") ? JSON.parse(options.attr("data-colwidths")) : null;
        /*Array : Setting array of number col you want to hide. For example array[0, 1] hide col 0 and 1*/
        widgetOptions.colHide = (typeof options !== "undefined" && typeof options.attr("data-colhide") !== "undefined" && typeof options.attr("data-colhide") !== "") ? JSON.parse(options.attr("data-colhide")) : null;
        /*Boolean, Array : TRUE enabled readonly on all element, False disabled readonly on all element, ARRAY Setting array of col, cell, row you want to enable readonly option. For example array["mode"=> "enabled", "row", array(1), "col" => array(2), "cell" => array("2.2", "3.5"] enable readonly on all cell for the row 1, the col 2 and the cells at position 2.2 and 3.5*/
        widgetOptions.readOnly = (typeof options !== "undefined" && typeof options.attr("data-readonly") !== "undefined" && typeof options.attr("data-readonly") !== "") ? JSON.parse(options.attr("data-readonly")) : null;
        /*Array : Array of sorting options or NULL. For example : 
         *  array(
                "columns" => ["0", "2"], //Order on column 0 and then 2
                "order" => ["ASC", "DESC"] // Order first column ASC, next DESC
            );
        */
        widgetOptions.sorting = (typeof options !== "undefined" && typeof options.attr("data-sorting") !== "undefined" && typeof options.attr("data-sorting") !== "") ? JSON.parse(options.attr("data-sorting")) : null;

        return widgetOptions;
    }
    
    /**
     * Get merge cells stored inside _HotData.options.cells, if no merge celle return false
     * @return {_hotOptions.mergeCells} or false.
     */
//    NgeHandsontable.prototype.getMergeCells = function() {
//        var result = new Array();
//        var cells = this._hotData.options.cells;
//        
//        for (i = 0; i < cells.length; i++) {
//            if(typeof cells[i] !== "undefined"){
//            if(typeof cells[i] !== "undefined"){
//                for (j = 0; j < cells[i].length; j++) {
//                    if(typeof cells[i][j] !== "undefined" && cells[i][j] !== null && typeof cells[i][j].mergeCell !== "undefined"){
//                        result.push({
//                            row: i, 
//                            col: j, 
//                            rowspan: cells[i][j].mergeCell.rowspan, 
//                            colspan: cells[i][j].mergeCell.colspan
//                        })
//                    }
//                }
//            }
//        }
//           
//        if(result.length === 0){
//            result = this._hotOptions.mergeCells;
//        }
//        
//        return result;
//    }
    
    /**
     * Set merge cell propertie for the current cell merged.
     * @return void.
     */
//    NgeHandsontable.prototype.setMergeCell = function(options) {    
//        if(typeof options.col !== "undefined" && typeof options.colspan !== "undefined"
//            && typeof options.row !== "undefined" && typeof options.rowspan !== "undefined"){
//            if( this._hotData.options.cells[options.row][options.col] !== null
//                && typeof this._hotData.options.cells[options.row][options.col].mergeCell !== "undefined"){
//                this._hotData.options.cells[options.row][options.col].mergeCell.rowspan = options.rowspan;
//                this._hotData.options.cells[options.row][options.col].mergeCell.colspan = options.colspan;
//            }else{
//                if( this._hotData.options.cells[options.row][options.col] === null ){
//                    this._hotData.options.cells[options.row][options.col] = {};
//                }
//                
//                this._hotData.options.cells[options.row][options.col].mergeCell = {
//                    rowspan: options.rowspan, 
//                    colspan: options.colspan
//                };
//            }
//        }
//        
//        this.updateInputData.call(this);
//    }
    
    /**
     * Remove merge cell propertie for the current cell unmerged.
     * @return void.
     */
//    NgeHandsontable.prototype.removeMergeCell = function(options) { 
//        if(typeof options.start.col !== "undefined" && typeof options.start.row !== "undefined"){
//            if( this._hotData.options.cells[options.start.row][options.start.col] !== null
//                && typeof this._hotData.options.cells[options.start.row][options.start.col].mergeCell !== "undefined"){
//                delete this._hotData.options.cells[options.start.row][options.start.col].mergeCell;
//                
//                if(jQuery.isEmptyObject(this._hotData.options.cells[options.start.row][options.start.col])){ /*If no properties set to null*/
//                   this._hotData.options.cells[options.start.row][options.start.col] = null; 
//                }
//            }
//        }
//        
//        this.updateInputData.call(this);
//    }
    
    /**
     * Get default data value.
     * @return {hotData} The object dataHot.
     */
    NgeHandsontable.prototype.getDefaultData = function() {
        var hotData = {
            options: {
            	/*Cols properties*/
                cols: [null],
                /*Rows properties*/
                rows: [null],
                /*Cells properties*/
                cells: [[null]]	
            },
            values: [[null]]
        };
        
        return hotData;
    }

    /**
     * Get the custom data formatted.
     * @return {_hotData} The object dataHot.
     */
    NgeHandsontable.prototype.getData = function () {
        return this._hotData;
    }
    
    /**
     * Set hotData by the new data in paramater.
     * @return {_hotData} The object dataHot.
     */
    NgeHandsontable.prototype.setData = function (data) {
        this._hotData = data;
        /*In case of values not initialised if not exist. For example when startCols and startRows exist*/
        this.formatValuesStartRowsCols();
    }
    
    /**
     * Set other instance to bind with the current handsontable instance.
     * @return {_bindTo} The instance _bindTo.
     */
    NgeHandsontable.prototype.bindTo = function (instance) {

        this._bindTo = instance;
    }
    
    /**
     * Update values.
     * @param {values} values to change
     */
    NgeHandsontable.prototype.updateValues = function (values) {
        this._hotData.values = values;
	this.triggerUpdateData.call(this);
    }
    
    /**
     * Update option col.
     * @param {col}   current col number
     * @param {value} value to change
     */
    NgeHandsontable.prototype.updateOptionsCols = function (col, value) {
        this._hotData.options.cols[col] = value;
	this.triggerUpdateData.call(this);
    }
    
	/**
     * Set propertie of options .
     * @param {path}  path to access to the properties ex: cols.1.background.color
     * @param {value} value to change
     * @param {activeTrigger} Optionnal, to active Trigger if necessary
     * @return {Boolean} Return true if setOptions works else false if error
     */
    NgeHandsontable.prototype.setOptions = function (path, value, activeTrigger) {
        activeTrigger = (typeof activeTrigger !== "undefined") ? activeTrigger : false;

        var obj = this._hotData.options;
        var isExist = true;
        
        path = path.split('.');
    	for (i = 0; i < path.length - 1; i++){
            if(typeof obj[path[i]] !== "undefined"){
        		obj = obj[path[i]];
            }else{
            	isExist = false;
            }
        }
        
        if(isExist){
            obj[path[i]] = value;

            if(activeTrigger == true){
               /* this.triggerUpdateData.call(this);*/
            }
            
            return true;
    	}else{
        	return false;
        }
    }
        		
    /**
     * Update option row.
     * @param {row}   current row number
     * @param {value} value to change
     */
    NgeHandsontable.prototype.updateOptionsRows = function (row, value) {
        this._hotData.options.rows[row] = value;
	this.triggerUpdateData.call(this);
    }
    
    /**
     * Update option col.
     * @param {row}   current row number
     * @param {col}   current col number
     * @param {value} value to change
     */
    NgeHandsontable.prototype.updateOptionsCells = function (row, col, value) {
        this._hotData.options.cells[row][col] = value;
	this.triggerUpdateData.call(this);
    }
    
    /**
     * Format value to be well render in handsontable instance when startRows and startCols are used
     */
    NgeHandsontable.prototype.formatValuesStartRowsCols = function () {
        if(this._hotOptions.startRows !== null && this._hotOptions.startCols !== null){
            for (i=0; i < (this._hotOptions.startRows); i++){
                if(typeof this._hotData.values[i] === "undefined"){
                    this._hotData.values[i] = new Array();
                }
                
                /*Format option row*/
                if(typeof this._hotData.options.rows[i]  === "undefined"){
                    this._hotData.options.rows[i] = null;
                }

                /*Format option cell*/
                if(typeof this._hotData.options.cells[i]  === "undefined" || this._hotData.options.cells[i] === null){
                    this._hotData.options.cells[i] = new Array();
                }
                
                for (j=0; j < (this._hotOptions.startCols); j++){
                    if(this._hotOptions.colHeaders !== null){
                        if(typeof this._hotData.options.names === "undefined" && typeof this._hotData.options.names[j] === "undefined"){
                            this._hotData.options.names[j] = this._widgetOptions.colHeadersOptions.addColName+" "+j;
                        }
                    }
                    if(this._hotOptions.startCols > 0){ /*Not the first column = libelle no values*/
                        if(typeof this._hotData.values[i][j] === "undefined"){
                            this._hotData.values[i][j] = null;
                        }
                    }

                    /*Format option cell*/
                    if(typeof this._hotData.options.cells[i][j]  === "undefined"){
                        this._hotData.options.cells[i][j] = null;
                    }
                }
            }
            
            for (i=0; i < (this._hotOptions.startCols); i++){
                /*Format option cols*/
                if(typeof this._hotData.options.cols[i]  === "undefined"){
                    this._hotData.options.cols[i] = null;
                }
            }

            this.triggerUpdateData.call(this);
        }
    }
    
    /**
     * Change the name of the current col
     * @return void
     */
    NgeHandsontable.prototype.changeHotColHeaderName = function(col, name) {
        var $this = this; /*Catch the current this object*/
        
        var modalOptions = {};
        modalOptions.title = $this._widgetOptions.lang.renameCol+" :";
        modalOptions.content = '<input type="text" class="nge-hot-serie-name span12" value="'+name+'"/>';
        
        var $hotModal = $this.getModal(modalOptions);
        $hotModal.find(".nge-hot-modal-success").remove();
        $hotModal.find(".nge-hot-modal-reset").html($this._widgetOptions.lang.modalRenameColClose);
        $hotModal.find(".nge-hot-modal-reset").parent().prepend("<div class=\"nge-hot-modal-success btn\">"+$this._widgetOptions.lang.modalRenameColValidate+"</div>");
        $hotModal.modal("show");

        var updateColHeaderName = function(){
            var serieName = $hotModal.find(".nge-hot-serie-name").val();
            if(serieName !== "" && serieName !== null){
                $this.formatHotNames.call($this, "update", col, serieName);
                var hot = $this.getHotInstance.call($this);
                hot.render();
                $this.updateInputData.call($this);
                $hotModal.modal("hide");
            }else{
                alert($this._widgetOptions.lang.modalErrorEmptyName);
            }
        };
        
        $hotModal.find(".nge-hot-serie-name").keydown(function(e) {
            if(e.keyCode === 13) { /* Enter KEYCODE */
                e.preventDefault();
                e.stopPropagation();
                
                updateColHeaderName();
            }
        });
        
        $hotModal.find(".nge-hot-modal-success").click(function(){
            updateColHeaderName();
        });
    }
    
        /**
     * Save ColHeader name in the current Object dataHot
     * @return void.
     */
    NgeHandsontable.prototype.formatHotNames = function(action, col, value) {        
        col = typeof col !== "undefined" ? col : "";
        action = typeof action !== "undefined" ? action : "";
        value = typeof value !== "undefined" ? value : "";

        /*add Names colheader*/
        var col_name = value;

        if(value === ""){
            col_name = this._widgetOptions.colHeadersOptions.addColName+" "+col;
        }
                
        if(action === "add"){
            if(col !== ""){
                /*add Names colheader*/    
                this._hotData.options.names.splice(col, 0, col_name);
            }
        }else if(action === "update"){
            if(col !== ""){
                /*update Names colheader*/
                this._hotData.options.names[col] = value;
            }			
        }
    }
    
    /**
     * Update function name to be launch when update value.
     * @param {functionName} Name of the function you want to launch when update value
     */
    NgeHandsontable.prototype.setTriggerUpdateData = function (functionName, arrayArg) {
        arrayArg = typeof arrayArg !== "undefined" ? arrayArg : null;
        this._triggerUpdateDataName = functionName;
        this._triggerUpdateDataArgs = arrayArg;
    }
	
    /**
     * Edit cell HTML
     * @return void
     */
    NgeHandsontable.prototype.editCellHTML = function(row, col, html) {
        var $this = this; /*Catch the current this object*/

        var modalOptions = {};
        modalOptions.title = "Editer HTML de la cellule :";
        modalOptions.content = '<textarea id="hot_cell_editor'+row+col+'" style="box-sizing:border-box; width:500px;height:500px;" name="hot_cell_editor" class="fieldeditor cke_textarea_inline"  >'+html+'</textarea>';
        modalOptions.width = '610px';
        
        var $hotModal = $this.getModal(modalOptions);
        initFields($hotModal);
        $hotModal.find(".nge-hot-modal-success").remove();
        $hotModal.find(".nge-hot-modal-reset").parent().prepend("<div class=\"nge-hot-modal-success btn\">Valider</div>");
        $hotModal.modal("show");
        
        $hotModal.find(".nge-hot-modal-success").off("click");
        $hotModal.find(".nge-hot-modal-success").click(function(){
            var newHtml = $hotModal.find(".fieldeditor").val();
            var hot = $this.getHotInstance.call($this);
            
            if(newHtml !== html){
                var hot = $this.getHotInstance.call($this);
                hot.setDataAtCell(row, col, newHtml);
                $hotModal.modal("hide");
            }else{
                $hotModal.modal("hide");
            }
        });
    };
    
    /**
     * Change the name of the current col
     * @return void
     */
    NgeHandsontable.prototype.getModal = function(options) {
        var title = (typeof options !== "undefined" && typeof options.title !== "undefined") ? options.title : "";
        var content = (typeof options !== "undefined" && typeof options.content !== "undefined") ? options.content : "";
        var width = (typeof options !== "undefined" && typeof options.width !== "undefined") ? "width:"+options.width : "";
        
        var html = ''
            + '<div id="ngeHotModal" style="display:none;'+width+'; left: 330px;z-index:1041;border:none;border-radius:0;" class="modal in" data-backdrop="false"  aria-hidden="false">'
                + '<div class="modal-header" style="cursor:move;background-color:#555D83;border-bottom:none;">'
                    + '<h3 style="color:#fff;font-weight:normal;"></h3>'
                + '</div>'
                + '<div class="nge-hot-options-content row-fluid" style="overflow-y: auto;-moz-box-sizing: border-box;-webkit-box-sizing: border-box;box-sizing: border-box;"></div>'
                + '<div class="nge-hot-options-button" style="text-align:center; padding:10px; box-sizing:border-box;">'
                    + '<div class="nge-hot-modal-reset btn btn-primary" data-dismiss="modal">Fermer</div>'
                + '</div>'
                + '<script>'
                    + 'jQuery(function(){jQuery("#ngeHotModal").draggable({handle: ".modal-header"});});'
                + '</script>'
                + '<style>'
                    + '.modal-backdrop, .modal-backdrop.fade.in {opacity: 0;}'
                + '</style>';
            + '</div>';

        if(jQuery("#ngeHotModal").length === 0){
            jQuery(document).find("body").append(html);
        }
        
        var $modal = jQuery("#ngeHotModal");
        $modal.find(".modal-header h3").html(title);
        $modal.find(".nge-hot-options-content").html(content);
        var maxhHeight = (jQuery(document).height() - ((jQuery(document).height() * 20) / 100)) -  100;
        $modal.css({
            "height": "auto"
        });
        $modal.find(".nge-hot-options-content").css({
           "min-height": "180px",
           "max-height": maxhHeight+"px"
        });
        
        return $modal;
    }
    
    /**
     * Retrieve options for a cell, row or col and show it in a modal
     * @return void
     */
    NgeHandsontable.prototype.getModalFormOptions = function(configFileName, hotSelectNumber) {
        var $this = this; /*Catch the current this object*/
        var loarderHtml = "<div align=\"center\" class=\"nge-loading1\" style=\"zoom:1.3; padding:20px;\">"
            + "<div class=\"nge-loading1-container-general\">"
                + "<div class=\"nge-loading1-internal\"><div class=\"nge-loading1-ballcolor nge-loading1-ball_1\"> </div></div>"
                + "<div class=\"nge-loading1-internal\"><div class=\"nge-loading1-ballcolor nge-loading1-ball_2\"> </div></div>"
                + "<div class=\"nge-loading1-internal\"><div class=\"nge-loading1-ballcolor nge-loading1-ball_3\"> </div></div>"
                + "<div class=\"nge-loading1-internal\"><div class=\"nge-loading1-ballcolor nge-loading1-ball_4\"> </div></div>"
            + "</div>"
        + "</div>";
        var modalOptions = {};
        modalOptions.content = loarderHtml;
        var $hotModal = $this.getModal(modalOptions);
        var formData = this.getModalDataFormOptions.call($this, $hotModal, configFileName, hotSelectNumber);
        $hotModal.find(".nge-hot-modal-success").remove();
        $hotModal.modal("show");

        var dataOptions = {};
        dataOptions.widget_name = this._widgetOptions.name;
        dataOptions.forms_path = this.getModalDataFormPath.call($this, configFileName);
        dataOptions.hot_select_number = hotSelectNumber;
        dataOptions.form_data = formData; 
        
	var obj_data_internal = jQuery('#internalform');
	if(obj_data_internal) {
	    var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal = '';
	
        jQuery.ajax({
            url: rootUrl+"index.php?option=com_ngd&task=form.getPartForm&" + str_data_internal,
            type : "POST",
            data: {
                source: "handsontable",
                data_options: dataOptions
            },
            success: function (resultJson) {
                try {
                    var result = JSON.parse(resultJson);
                    var ngeHotOptionsContent = $hotModal.find(".nge-hot-options-content");
                    ngeHotOptionsContent.hide();
                    if(result.result == 0){
                        ngeHotOptionsContent.html(result.message).fadeIn();
                    }else{
                        ngeHotOptionsContent.hide();
                        ngeHotOptionsContent.data("nge-hot-option-type", configFileName);
                        ngeHotOptionsContent.html(result.html).fadeIn();

                        /*Active Fields*/
                        initFields(jQuery("#nge-hot-form"));

                        /*Active Events*/
                        /*Modal event*/
                        jQuery("#nge-hot-form input, #nge-hot-form select, #nge-hot-form textarea").change(function(){
                            var currentOptionType = ngeHotOptionsContent.data("nge-hot-option-type");
                            var data = jQuery("#nge-hot-form").serializeObject();
                            $this.updateModalDataFormOptions.call($this, $hotModal, currentOptionType, data);
                        });

                        /*Pattern event*/
                        $hotModal.off("click", ".ngefield-pattern-toolbar-load");
                        $hotModal.on("click", ".ngefield-pattern-toolbar-load", function(){
                           var $button = jQuery(this);
                           var $formSelector = jQuery($button.attr("nge-pattern-selector"));
                           var patternType = $button.attr("nge-pattern-type");
                           var patternName = $button.attr("nge-pattern-name");

                           $this.loadFormFromPattern($formSelector, patternType, patternName, function(){
                                var ngeHotOptionsContent = $hotModal.find(".nge-hot-options-content");
                                ngeHotOptionsContent.data("nge-hot-option-type", configFileName);

                                var $formSelector = jQuery("#nge-hot-form");
                                initFields($formSelector);

                                var data = $formSelector.serializeObject();
                                $this.updateModalDataFormOptions.call($this, $hotModal, configFileName, data);

                                /*Modal event*/
                                jQuery("#nge-hot-form input, #nge-hot-form select, #nge-hot-form textarea").change(function(){
                                    var currentOptionType = ngeHotOptionsContent.data("nge-hot-option-type");
                                    var data = jQuery("#nge-hot-form").serializeObject();
                                    $this.updateModalDataFormOptions.call($this, $hotModal, currentOptionType, data);
                                });
                           });
                        });

                        $hotModal.off("click", ".ngefield-pattern-toolbar-reset");
                        $hotModal.on("click", ".ngefield-pattern-toolbar-reset", function(){
                            var $button = jQuery(this);
                            var $formSelector = jQuery($button.attr("nge-pattern-selector"));
                            var patternType = $button.attr("nge-pattern-type");
                            var patternName = $button.attr("nge-pattern-name");
                            $button.tooltip("hide");

                            $formSelector.html('<div style="text-align:center;"><img width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /><br/>Chargement formulaire en cours</div>');
                            getAjaxFormHtml(rootUrl+"index.php?option=com_ngd&task=form.getPartForm",{
                                source: "pattern",
                                is_modal_handsontable: true,
                                patternId: "default",
                                patternType: patternType,
                                patternName: patternName
                            },function(html){
                                setTimeout(function(){
                                    var $newForm = jQuery(html);
                                    $formSelector.replaceWith($newForm).promise().done(function() {
                                        $newForm.find("input[name*='preset']").val('');

                                        var ngeHotOptionsContent = $hotModal.find(".nge-hot-options-content");
                                        ngeHotOptionsContent.data("nge-hot-option-type", configFileName);

                                        var $formSelector = jQuery("#nge-hot-form");
                                        initFields($formSelector);

                                        var data = $formSelector.serializeObject();
                                        $this.updateModalDataFormOptions.call($this, $hotModal, configFileName, data);

                                        /*Modal event*/
                                        jQuery("#nge-hot-form input, #nge-hot-form select, #nge-hot-form textarea").change(function(){
                                            var currentOptionType = ngeHotOptionsContent.data("nge-hot-option-type");
                                            var data = jQuery("#nge-hot-form").serializeObject();
                                            $this.updateModalDataFormOptions.call($this, $hotModal, currentOptionType, data);
                                        });
                                    });
                                }, 200);
                            });
                        });
                    }
                } catch (err) {
                    console.error("Error : to load form option!<br>" + err.toString());
                }
            },
            error: function () {
                console.error("Error : to load form option!");
            }
        });
    };
    
    /**
     * Retrieve form html from pattern
     * @return void
     */
    NgeHandsontable.prototype.loadFormFromPattern = function(formSelector, patternType, patternName, callbackPattern){

	var obj_data_internal = jQuery('#internalform');
	if(obj_data_internal) {
	    var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal='{}';
        ngetools.loadModal({
            url: baseUrl+"index.php?option=com_nge&view=field_ngepattern&layout=default&format=raw&name="+patternName+"&type="+patternType + '&' + str_data_internal,
            title: '<span class="icomoon-magic-wand"></span>&nbsp;Modèles',
            backgroundColor: '#F57C00',
            width:  80,
            height: 90,
            responsive: true,
            buttons : {
                cancel: {
                    label: "FERMER",
                    stopEventsPropagation: false,
                    callback: function () {
                    }
                },
                submit: {
                    label: "VALIDER",
                    stopEventsPropagation: false,
                    callback: function ($button) {
                        var $modal = $button.closest(".modal");
                        var $selectedPattern = $modal.find("div.nge-manager-list .patternitem.active");
                        var selectedPatternId = $selectedPattern.attr("data-id");

                        tooltipCancel = function(){
                           $button.tooltip("hide");
                        };
                        $button.tooltip('destroy');

                        if(typeof selectedPatternId === "undefined"){
                            $button.tooltip({
                                title: function(){
                                    return '<div style="text-align:justify;width:220px;">Pas de modèle sélectionné<br/>Merci de sélectionner un modèle pour continuer</div>'
                                    + '<div>'
                                        + '<span class="btn btn-info" style="padding: 2px 4px;font-size: 12px;font-weight: bold;" onclick="tooltipCancel();">Fermer</span>'
                                    + '</div>';
                                },
                                trigger: 'manual',
                                html: true,
                                placement: 'bottom',
                                container: 'body',
                                template: '<div class="tooltip" style="z-index:1051"><div class="tooltip-arrow"></div><div class="tooltip-inner" style="max-width:250px;"></div></div></div>'
                            });
                        }else{
                            tooltipOk = function(){
                                $button.tooltip("hide");
                                var $formContainer = jQuery(formSelector);
                                $formContainer.html('<div style="text-align:center;"><img width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /><br/>Chargement Modèle en cours</div>');
                                getAjaxFormHtml(rootUrl+"index.php?option=com_ngd&task=form.getPartForm",{
                                    source: "pattern",
                                    is_modal_handsontable: true,
                                    patternId:selectedPatternId
                                },function(html){
                                    $modal.modal("hide");

                                    setTimeout(function(){
                                        var $newForm = jQuery(html);
                                        $formContainer.replaceWith($newForm).promise().done(function() {
                                            $newForm.find("input[name*='preset']").val(selectedPatternId);
                                            callbackPattern.call();
                                        });
                                    }, 200);
                                });
                            };
                            $button.tooltip({
                                title: function(){
                                    return '<div style="text-align:justify;">Etes-vous sur de vouloir remplacer le formulaire par le modèle sélectionné ?<br/> Cette action remplacera les anciennes données par les données du modèle.</div>'
                                    + '<div>'
                                        + '<span class="btn" style="padding: 2px 4px;font-size: 12px;font-weight: bold;margin-right: 5px;" onclick="tooltipOk();">Valider</span>'
                                        + '<span class="btn btn-info" style="padding: 2px 4px;font-size: 12px;font-weight: bold;" onclick="tooltipCancel();">Fermer</span>'
                                    + '</div>';
                                },
                                trigger: 'manual',
                                html: true,
                                placement: 'bottom',
                                container: 'body',
                                template: '<div class="tooltip" style="z-index:1051"><div class="tooltip-arrow"></div><div class="tooltip-inner" style="max-width:250px;"></div></div></div>'
                            });
                        }
                        $button.tooltip('show');
                    }
                }
            }
        });
    };
    /**
     * Retrieve form data option for cols, rows or cells
     * @return data and set modal attribute
     */
    NgeHandsontable.prototype.getModalDataFormOptions = function($modal, optionType, number) {
        var $this = this; /*Catch the current this object*/
        var data = {};
        
        switch(optionType) {
            case "col":
                $modal.find(".modal-header h3").html($this._widgetOptions.lang.colProperties);
                $modal.find(".nge-hot-options-content").data("nge-hot-btn-col", number);
                if(typeof $this._hotData.options.cols[number] !== "undefined"){
                    data = $this._hotData.options.cols[number];
                }
                break;
            case "row":
                $modal.find(".modal-header h3").html($this._widgetOptions.lang.rowProperties);
                $modal.find(".nge-hot-options-content").data("nge-hot-btn-row", number);
                if(typeof $this._hotData.options.rows[number] !== "undefined"){
                    data = $this._hotData.options.rows[number];
                }
                break;
            case "cell":
                var numberCell = number.split(".");
                $modal.find(".modal-header h3").html($this._widgetOptions.lang.cellProperties);
                $modal.find(".nge-hot-options-content").data("nge-hot-btn-cell", number);
                if(typeof $this._hotData.options.cells[numberCell[0]] !== "undefined" && typeof $this._hotData.options.cells[numberCell[0]][numberCell[1]] !== "undefined"){
                    data = $this._hotData.options.cells[numberCell[0]][numberCell[1]];
                }
                break;
        }

        return data;
    }
    
    /**
     * Retrieve form data option for cols, rows or cells
     * @return data and set modal attribute
     */
    NgeHandsontable.prototype.getModalDataFormPath = function(optionType) {
        var $this = this; /*Catch the current this object*/
        var path = "";
        
        switch(optionType) {
            case "col":
                path = (typeof $this._widgetOptions.formsPath.colProperties !== "undefined") ? $this._widgetOptions.formsPath.colProperties : "";
                break;
            case "row":
                path = (typeof $this._widgetOptions.formsPath.colProperties !== "undefined") ? $this._widgetOptions.formsPath.rowProperties : "";
                break;
            case "cell":
                path = (typeof $this._widgetOptions.formsPath.colProperties !== "undefined") ? $this._widgetOptions.formsPath.cellProperties : "";
                break;
        }

        return path;
    }
    
    /**
     * Update form data option for cols, rows or cells
     * @return void
     */
    NgeHandsontable.prototype.updateModalDataFormOptions = function($modal, optionType, value) {
        var ngeHotOptionsContent = $modal.find(".nge-hot-options-content");

        switch(optionType) {
            case "col":
                var colNumber = ngeHotOptionsContent.data("nge-hot-btn-col");
                if(typeof this._hotData.options.cols[colNumber] === "undefined" 
                        || this._hotData.options.cols[colNumber] === null){
                    this._hotData.options.cols[colNumber] = {};
                }
                jQuery.extend(this._hotData.options.cols[colNumber], value);
                break;
            case "row":
                var rowNumber = ngeHotOptionsContent.data("nge-hot-btn-row");
                if(typeof this._hotData.options.rows[rowNumber] === "undefined" 
                        || this._hotData.options.rows[rowNumber] === null){
                    this._hotData.options.rows[rowNumber] = {};
                }
                jQuery.extend(this._hotData.options.rows[rowNumber], value);
                break;
            case "cell":
                var cellNumber = ngeHotOptionsContent.data("nge-hot-btn-cell");
                cellNumber = cellNumber.split(".");
                if(typeof this._hotData.options.cells[cellNumber[0]] === "undefined"){
                    this._hotData.options.cells[cellNumber[0]] = [];
                }
                if(typeof this._hotData.options.cells[cellNumber[0]][cellNumber[1]] === "undefined"
                        || this._hotData.options.cells[cellNumber[0]][cellNumber[1]] === null){
                    this._hotData.options.cells[cellNumber[0]][cellNumber[1]] = {};
                }
                jQuery.extend(this._hotData.options.cells[cellNumber[0]][cellNumber[1]], value);
                break;
        }

        this.updateInputData.call(this);
    }
    
    /**
     * Enabled the popover on icon help.
     * @return void
     */
    NgeHandsontable.prototype.enabledPopoverInformation = function () {
        var $this = this;
        var $buttonHelp = this._hotElement.closest(".nge-handsontable-container").find(".handsontable-help");

        $buttonHelp.popover({
            trigger: "hover",
            html: true,
            container: 'body',
            title: function () {
                var html = '<div style="text-transform: uppercase;text-align:center;">'+$this._widgetOptions.lang.popoverHelpTitle+"</div>";
                return html;
            },
            content: function () {
                var html = $this._widgetOptions.lang.popoverHelpContent;
                return html;
            },
            template: "<div class=\"popover\" style=\"max-width:500px;\"><div class=\"arrow\"></div><div class=\"popover-inner\"><h3 class=\"popover-title\"></h3><div class=\"popover-content\"><p></p></div></div></div>",
            placement: "right"
        });
    };
    
    /**
     * Initialize all element to show handsontable
     * @return void
     */
    NgeHandsontable.prototype.init = function () {
        /*Catch the current this object*/
        var $this = this;

        $this.setTriggerUpdateData($this.updateInputData, [$this]);
        
        var hotOptions = {};
        hotOptions.removeRowPlugin = $this._hotOptions.removeRowPlugin;
        hotOptions.cells = function (row, col, prop) {
            var cellProperties = {};
            
            if ($this._widgetOptions.readOnly !== null){
                if($this._widgetOptions.readOnly === true){
                    cellProperties.readOnly = true;
                }else{
                    if(typeof $this._widgetOptions.readOnly === "object"){
                        if(typeof $this._widgetOptions.readOnly.mode === "undefined"){/*If not declared*/
                            $this._widgetOptions.readOnly.mode = "enable";
                        }
                        
                        if($this._widgetOptions.readOnly.mode === "enable"){
                            if(
                                (typeof $this._widgetOptions.readOnly.row !== "undefined" && jQuery.isArray($this._widgetOptions.readOnly.row) && jQuery.inArray(row , $this._widgetOptions.readOnly.row) !== -1)
                                    || (typeof $this._widgetOptions.readOnly.col !== "undefined" && jQuery.isArray($this._widgetOptions.readOnly.col) && jQuery.inArray(col , $this._widgetOptions.readOnly.col) !== -1)
                                    || (typeof $this._widgetOptions.readOnly.cell !== "undefined" && jQuery.isArray($this._widgetOptions.readOnly.cell) && jQuery.inArray(row+'.'+col , $this._widgetOptions.readOnly.cell) !== -1)
                            ){
                                cellProperties.readOnly = true;
                            }else{
                                cellProperties.readOnly = false;
                            }
                        }else if($this._widgetOptions.readOnly.mode === "disable"){
                            if(
                                (typeof $this._widgetOptions.readOnly.row !== "undefined" && jQuery.isArray($this._widgetOptions.readOnly.row) && jQuery.inArray(row , $this._widgetOptions.readOnly.row) !== -1)
                                    || (typeof $this._widgetOptions.readOnly.col !== "undefined" && jQuery.isArray($this._widgetOptions.readOnly.col) && jQuery.inArray(col , $this._widgetOptions.readOnly.col) !== -1)
                                    || (typeof $this._widgetOptions.readOnly.cell !== "undefined" && jQuery.isArray($this._widgetOptions.readOnly.cell) && jQuery.inArray(row+'.'+col , $this._widgetOptions.readOnly.cell) !== -1)
                            ){
                                cellProperties.readOnly = false;
                            }else{
                                cellProperties.readOnly = true;
                            }
                        }else{
                            cellProperties.readOnly = false;
                        }
                    }else{
                        cellProperties.readOnly = false;
                    }
                }
            }else{
                cellProperties.readOnly = false;
            }

            return cellProperties;
        };
        hotOptions.colWidths = function(index) {
            if($this._widgetOptions.colHide !== null && jQuery.isArray($this._widgetOptions.colHide) && jQuery.inArray(index , $this._widgetOptions.colHide) !== -1){
                return 0.1;
            }else{
                if($this._widgetOptions.colWidths !== null && jQuery.isArray($this._widgetOptions.colWidths) && (typeof $this._widgetOptions.colWidths[index] !== "undefined")){
                    return $this._widgetOptions.colWidths[index];
                }
            }
        };

        if((jQuery.isArray($this._hotOptions.contextMenu) && $this._hotOptions.contextMenu.length > 0)){
            var items = {};
            if(jQuery.inArray("rename_cols" , $this._hotOptions.contextMenu) !== -1){
                items.rename_cols = {
                    name: function () {
                        return $this._widgetOptions.lang.renameCol;
                    },
                    disabled: function () {
                        /*if first col, disable this option*/
                        var hot = $this.getHotInstance.call($this);
                        if(typeof hot.getSelected() !== "undefined"){
                            return (($this._widgetOptions.disabled !== null && typeof $this._widgetOptions.disabled.removeRow !== "undefined" && $this._widgetOptions.disabled.renameCol.indexOf(hot.getSelected()[1]) !== -1)
                                || hot.getSelected()[1] === 0);
                        }else{
                            return true;
                        }
                    }
                };
            }
            if(jQuery.inArray("row_above" , $this._hotOptions.contextMenu) !== -1){
                items.row_above = {
                    name: function () {
                        return $this._widgetOptions.lang.insertRowBefore;
                    }
                };
            }
            if(jQuery.inArray("row_below" , $this._hotOptions.contextMenu) !== -1){
                items.row_below = {
                    name: function () {
                        return $this._widgetOptions.lang.insertRowAfter;
                    }
                };
            }
            if(jQuery.inArray("col_left" , $this._hotOptions.contextMenu) !== -1){
                items.col_left = {
                    name: function () {
                        return $this._widgetOptions.lang.insertColLeft;
                    }
                };
            }
            if(jQuery.inArray("col_right" , $this._hotOptions.contextMenu) !== -1){
                items.col_right = {
                    name: function () {
                        return $this._widgetOptions.lang.insertColRight;
                    }
                };
            }
            if(jQuery.inArray("hsep1" , $this._hotOptions.contextMenu) !== -1){
                items.hsep1 = "---------";
            }
            if(jQuery.inArray("remove_row" , $this._hotOptions.contextMenu) !== -1){
                items.remove_row = {
                    name: function () {
                        return $this._widgetOptions.lang.deleteRow;
                    },
                    disabled: function () {
                        /*if row === 1 => disable this option*/
                        var hot = $this.getHotInstance.call($this);
                        if(typeof hot.getSelected() !== "undefined"){
                            return (($this._widgetOptions.disabled !== null && typeof $this._widgetOptions.disabled.removeRow !== "undefined" && $this._widgetOptions.disabled.removeRow.indexOf(hot.getSelected()[0]) !== -1)
                                || $this._hotData.values.length <= 1);
                        }else{
                            return true;
                        }
                    }
                };
            }
            if(jQuery.inArray("remove_col" , $this._hotOptions.contextMenu) !== -1){
                items.remove_col = {
                    name: function () {
                        return $this._widgetOptions.lang.deleteCol;
                    },
                    disabled: function () {
                        /*if first col, disable this option*/
                        var hot = $this.getHotInstance.call($this);
                        if(typeof hot.getSelected() !== "undefined"){
                            return (($this._widgetOptions.disabled !== null && typeof $this._widgetOptions.disabled.removeRow !== "undefined" && $this._widgetOptions.disabled.removeCol.indexOf(hot.getSelected()[1]) !== -1)
                                || $this._hotData.values[0].length <= 1);
                        }else{
                            return true;
                        }
                    }
                };
            }
            if(jQuery.inArray("hsep2" , $this._hotOptions.contextMenu) !== -1){
                items.hsep2 = "---------";
            }
            if(jQuery.inArray("colProperties" , $this._hotOptions.contextMenu) !== -1){
                items.colProperties = {
                    name: function () {
                        return $this._widgetOptions.lang.colProperties;
                    },
                    callback: function (key, selection, event) {
                        var col = selection.start.col;
                        $this.getModalFormOptions.call($this, "col", col);
                    },
                    disabled: function () {
                        var hot = $this.getHotInstance.call($this);
                        if(typeof hot.getSelected() !== "undefined"){
                            return (($this._widgetOptions.disabled !== null && typeof $this._widgetOptions.disabled.colProperties !== "undefined" && $this._widgetOptions.disabled.colProperties.indexOf(hot.getSelected()[1]) !== -1)
                                || $this._hotData.values[0].length <= 1);
                        }else{
                            return true;
                        }
                    }
                };
            }
            if(jQuery.inArray("rowProperties" , $this._hotOptions.contextMenu) !== -1){
                items.rowProperties = {
                    name: function () {
                        return $this._widgetOptions.lang.rowProperties;
                    },
                    callback: function (key, selection, event) {
                        var row = selection.start.row;
                        $this.getModalFormOptions.call($this, "row", row);
                    },
                    disabled: function () {
                        var hot = $this.getHotInstance.call($this);
                        if(typeof hot.getSelected() !== "undefined"){
                            return (($this._widgetOptions.disabled !== null && typeof $this._widgetOptions.disabled.rowProperties !== "undefined" && $this._widgetOptions.disabled.rowProperties.indexOf(hot.getSelected()[1]) !== -1)
                                || $this._hotData.values[0].length <= 1);
                        }else{
                            return true;
                        }
                    }
                };
            }
            if(jQuery.inArray("cellProperties" , $this._hotOptions.contextMenu) !== -1){
                items.cellProperties = {
                    name: function () {
                        return $this._widgetOptions.lang.cellProperties;
                    },
                    callback: function (key, selection, event) {
                        var col = selection.start.col;
                        var row = selection.start.row;
                        var number = row+"."+col;
                        $this.getModalFormOptions.call($this, "cell", number);
                    },
                    disabled: function () {
                        var hot = $this.getHotInstance.call($this);
                        if(typeof hot.getSelected() !== "undefined"){
                            return (($this._widgetOptions.disabled !== null && typeof $this._widgetOptions.disabled.cellProperties !== "undefined" && $this._widgetOptions.disabled.cellProperties.indexOf(hot.getSelected()[1]) !== -1)
                                || $this._hotData.values[0].length <= 1);
                        }else{
                            return true;
                        }
                    }
                };
            }
            hotOptions.contextMenu = {
                callback: function (key, options) {
                    switch(key) {
                        case "rename_cols":
                            var hot = $this.getHotInstance.call($this);
                            var colHeaderName = hot.getColHeader(options.start.col);

                            $this.changeHotColHeaderName.call($this, options.start.col, colHeaderName);
                            break;
                    }
                },
                items: items
            };
        }else{
            hotOptions.contextMenu = false;
        }
        
        hotOptions.beforeRemoveRow = function (index, amount) {
            /*Never remove first row if the last one*/
            var HOT = $this.getHotInstance.call($this);
            if(index === 0 && HOT.countRows() === 1){
                return false;
            }
        };
        hotOptions.afterRemoveRow = function (index, amount) {
            $this.formatHotValues.call($this);       
        };
        hotOptions.afterRemoveCol = function (index, amount) {
            $this.formatHotCols.call($this, "remove", index, amount);
            $this.formatHotValues.call($this);	
        };
        hotOptions.afterChange = function (changes, source) {
//            if(source == "loadData"){
//                /*DO NOTHING*/
//            }else{
                $this.formatHotValues.call($this);	
//            }

            $this.updateInputData.call($this);
        };
        hotOptions.beforeRender = function (isForced) {
            $this.dataMultiSort.call($this);
        };
        hotOptions.afterColumnSort = function () {
            $this.formatHotValues.call($this);
        };
        hotOptions.afterCreateCol = function (index) {
            $this.formatHotValues.call($this);
        };
        hotOptions.afterCreateRow = function (index) {
            $this.formatHotValues.call($this);
        };
        if($this._widgetOptions.disabled !== null && typeof $this._widgetOptions.disabled.beforeKeyDown !== "undefined" && $this._widgetOptions.disabled.beforeKeyDown !== true){
            hotOptions.beforeKeyDown = function (e) {
                var HOT = $this.getHotInstance.call($this);
                var selection = HOT.getSelected();

                if (e.keyCode === 40 || e.keyCode === 46) {
                    if (selection != null && selection[2] == HOT.countRows()-1) //lastRow
                        HOT.alter ("insert_row");
                }
                else if (e.keyCode === 9) { //TAB
                    if (selection != null && selection[2] == HOT.countRows()-1 && selection[3] == HOT.countCols()-1){
                        HOT.alter ("insert_row");
                        HOT.selectCell(HOT.countRows(), 1);
                    }
                }
                lastChange = null;
            };
        }
        
        if($this._hotOptions.colHeaders !== null){
            hotOptions.colHeaders = function(index) {
                var returnColHeaderName = "";

                if($this._hotData.options.names[index] === undefined){ /*If colHeader name and not exist*/
                    if(index == 0){ /*If first colHeader rename in Category*/
                        if(typeof $this._widgetOptions.colHeadersOptions.defaultValue[0] !== "undefined"){
                            returnColHeaderName = $this._widgetOptions.colHeadersOptions.defaultValue[0];
                        }else{
                            returnColHeaderName = $this._widgetOptions.colHeadersOptions.addColName;
                        }
                    }else{
                        returnColHeaderName = $this._widgetOptions.colHeadersOptions.addColName+" "+index;
                    }

                    /*Save the new value in object*/
                    $this.formatHotNames.call($this, "update", index, returnColHeaderName);
                }else{ /*If colHeader name exist*/
                    if(index == 0 && $this._hotData.options.names[index] === ""){ /*If first colHeader and is empty*/
                        if(typeof $this._widgetOptions.colHeadersOptions.defaultValue[0] !== "undefined"){
                            returnColHeaderName = $this._widgetOptions.colHeadersOptions.defaultValue[0];
                        }else{
                            returnColHeaderName = $this._widgetOptions.colHeadersOptions.addColName;
                        }
                    }else{
                        returnColHeaderName = $this._hotData.options.names[index]; 
                    }
                }

                return returnColHeaderName;
            }
        }

        hotOptions.data =  $this._hotData.values;
        jQuery.extend($this._hotOptions, hotOptions);

        /*Remove all children if it's div clone*/
        if($this._hotElement.children().length > 0){
           $this._hotElement.children().remove(); 
        }

        $this._hotElement.handsontable($this._hotOptions);
        
        /*Hack in specific case the handosntable render before is parent is showned*/
        if($this._hotElement.find(".wtHolder").width() === 0){
            setTimeout(function(){
                var HOT = $this.getHotInstance.call($this);
                HOT.render();
            }, 300);
        }
    };
    
    return NgeHandsontable;
})();

var DataHot = (function () {
    /*Constructor*/
    function DataHot (object) {
        NgeHandsontable.call(this, object);
    }
    
    /*Child class override parent class*/
    DataHot.prototype = Object.create(NgeHandsontable.prototype);
    DataHot.prototype.constructor = DataHot;
    
    return DataHot;
})();
/*END OBJECTS*/

/* FIELDHANDSONTABLE ***********************************************************************************/
initNgeHandsontable = function(selector){
    selector.find(".nge-handsontable").each(function() {     
        var inputHidden = jQuery(this).find("input.handsontable-input");
        var hotInputValue = inputHidden.val();
        var hotInputValueDecode = hotInputValue.replace("ngejson::", "");
        var handsontable = jQuery(this).find("div.nge-handsontable-render");
    
        ngetools.loadStylesheets(
            [mediaUrl + "handsontable/jquery.handsontable.css",
            mediaUrl + "handsontable/jquery.handsontable.removeRow.css"]
        );

        ngetools.loadScripts(
            [
            {path : mediaUrl + "handsontable/jquery.handsontable.js"},
            {path : mediaUrl + "handsontable/jquery.handsontable.ngeRemoveRow.js"},
            {path : mediaUrl + "handsontable/numeral.js"},
            {path : mediaUrl + "handsontable/numeral.fr-fr.js"}
            ], function(){
                /*The Html dom table is loaded*/
                /*jQuery(document).trigger("ngeWidgetLoaded");*/

                /*If no instance already exist, build one. Else do nothing or return error*/
                if(typeof handsontable.handsontable("getInstance") === "undefined"){
                    var object = {};
                    object.hotElement = handsontable;
                    object.widgetOptions = inputHidden;
                    object.hotOptions = {};
                    object.hotOptions.startCols = inputHidden.attr("data-startcols");
                    object.hotOptions.startRows = inputHidden.attr("data-startrows");
                    object.hotOptions.colHeaders = inputHidden.attr("data-colheaders");
                    object.hotOptions.rowHeaders = true;
                    object.hotOptions.stretchH = inputHidden.attr("data-stretchh");
                    object.hotOptions.contextMenu = inputHidden.attr("data-contextmenu");
                    object.hotOptions.removeRowPlugin = inputHidden.attr("data-removerowplugin");
                    object.hotData = hotInputValueDecode;

                    var hotResult = new DataHot(object);
                        hotResult.init();
                }
            }
        );    
    });
};
/* FIELDRADIO ***********************************************************************************/
initFormsRadio = function(){

    jQuery(document).on('click', 'div.fieldradio button', function(e) {
	e.stopPropagation();
	var success = jQuery(this).attr('data-success');
						
	if(typeof success !== 'undefined' && success == 'false'){
		jQuery(this).removeClass('btn-success');
		jQuery(this).addClass('danger_active btn-danger');
	}
	updateFieldradioSelection(jQuery(this));
	updateFieldradioDatatargets(jQuery(this));
    });
    
    /*
    jQuery('div.fieldradio button.active').initialize(function() {
	updateFieldradioSelection(jQuery(this));
	updateFieldradioDatatargets(jQuery(this));
    });
    */
    
}

initFieldradio = function($selector){

    //Need update fields at the end of loading because target are outside of the tag and are loaded in the dom after
    $selector.find('div.fieldradio button.active').each(function() {
        updateFieldradioSelection(jQuery(this));
	updateFieldradioDatatargets(jQuery(this));
    });
				
    /*$selector.find('div.fieldradio button').unbind('click').click(function(e) {
	e.stopPropagation();
	var success = jQuery(this).attr('data-success');
						
	if(typeof success !== 'undefined' && success == 'false'){
		jQuery(this).removeClass('btn-success');
		jQuery(this).addClass('danger_active btn-danger');
	}
	updateFieldradioSelection(jQuery(this));
	updateFieldradioDatatargets(jQuery(this));
    });*/
}


fieldsGroupsNode = function(arrayChildObj) {
    var objectReturn = [];

    arrayChildObj.each(function(res){
        if(isNaN(res) === false){
            objectReturn.push(jQuery(this).closest('.control-group'));
        }
    });

    return objectReturn;
}

updateFieldradioSelection = function(button) {
    var buttongroup = jQuery(button).parent();
    var success = button.attr('data-success');
    var parentGroupNode = buttongroup.closest('.control-group');
    var buttongroupName = buttongroup.attr('name');
    var position = buttongroupName.indexOf('theme');

    if(position != -1){
        jQuery('button', buttongroup).each(function() {
                jQuery(this).removeClass('active');
        });

        button.addClass('active');
    }else{
        jQuery('button', buttongroup).each(function() {
            jQuery(this).removeClass('btn-success active');
            jQuery(this).removeClass('btn-danger active');
        });

        if(jQuery(button).hasClass('danger_active'))
            jQuery(button).addClass('btn-danger active');
        else
            jQuery(button).addClass('btn-success active');
        
        if(typeof success !== 'undefined' && success == 'false'){
            jQuery(button).removeClass('btn-success');
            jQuery(button).addClass('danger_active btn-danger');
	}else{
            jQuery(button).removeClass('danger_active btn-danger');
            jQuery(button).addClass('btn-success');
        }
    }

    parentGroupNode.children('.controls').children('input').val(jQuery(button).val());
    parentGroupNode.children('.controls').children('input').trigger('change');
}			
					
updateFieldradioDatatargets = function(button) {
    var buttongroup = jQuery(button).parent();
    var parentGroupNode = buttongroup.closest('.control-group');

    jQuery(button).parent().children('[data-target]').each(function() {
        /*var datatargets = jQuery(this).attr('data-target').toString();*/
        var datatargets = jQuery(this).attr('data-target');
        var targets = datatargets.split(' ');
        targets.forEach(function(target) {
            if (target.substr(0,6) == 'field:'){
                var t = target.substring(6);
                jQuery("[name$='["+t+"][]'],[name$='["+t+"]'],[name='"+t+"']", parentGroupNode.parent()).closest('.control-group').hide();
            }else if(target.substr(0,7) == 'fields:'){
                divGroup = fieldsGroupsNode(jQuery("[name^='"+target.substring(7)+"[']", parentGroupNode.parent()), 'fields');
                divGroup.each(function(divtarget) {
                    if (divtarget != null)
                        divtarget.hide();
                });
            }else if (target.substr(0,4) == 'tab:'){
                var t = target.substring(4);
                var divTarget = jQuery("[name$='["+t+"][]'],[name$='["+t+"]'],[name='"+t+"']", parentGroupNode.parent());
                divTarget.hide();
                if (divTarget.hasClass('active')){
                    jQuery(divTarget.find('a').attr('href')).removeClass('active');
                    divTarget.removeClass('active');
                    var firstTab = divTarget.parent().find('li:visible').first();
                    firstTab.addClass('active');
                    jQuery(firstTab.find('a').attr('href')).addClass('active');
                }	
            }else if(target.substr(0,6) == 'input:'){
                var currentField = jQuery("[name*='["+target.substring(6)+"]'], [name*='"+target.substring(6)+"']", parentGroupNode.parent());
                var currentFieldAttr = currentField.attr('class');
                if(currentFieldAttr == 'mce_editable'){
                    currentField = currentField.parent();
                }
                /*divtarget = fieldGroupNode(currentField, 'input');*/
                divtarget = jQuery(currentField).closest('.control-group');						
                if (divtarget != null)
                    divtarget.hide();
            }else{
                jQuery(target).hide();
            }
        });
    });
    if (jQuery(button).is('[data-target]') && jQuery(button).attr('data-target') != undefined) {
        var datatargets = jQuery(button).attr('data-target');
        var targets = datatargets.split(' ');
        targets.forEach(function(target) {
            if (target.substr(0,6) == 'field:'){
                divtarget = jQuery("[name$='["+target.substring(6)+"][]'],[name$='["+target.substring(6)+"]'],[name='"+target.substring(6)+"']", parentGroupNode.parent()).closest('.control-group');
                if (divtarget != null){
                    divtarget.show();
                    ngeRenderHandsontable(divtarget);
                }
            }else if(target.substr(0,7) == 'fields:'){
                divGroup = fieldsGroupsNode(jQuery("[name^='"+target.substring(7)+"[']", parentGroupNode.parent()), 'fields');
                divGroup.each(function(divtarget) {
                    if (divtarget != null){
                        divtarget.show();
                        ngeRenderHandsontable(divtarget);
                    }
                });
            }else if (target.substr(0,4) == 'tab:'){
                divtarget = jQuery("[name$='["+target.substring(4)+"][]'],[name$='["+target.substring(4)+"]'],[name='"+target.substring(4)+"']", parentGroupNode.parent());
                if (divtarget != null){
                    divtarget.show();
                    var firstTab = divtarget.parent().find('li:visible').first();
                    var activeTab = divtarget.parent().find('li').hasClass('active');
                    /*if (firstTab != activeTab){*/
                        jQuery(activeTab).removeClass('active');
                        jQuery(jQuery(activeTab).find('a').attr('href')).removeClass('active');
                        firstTab.addClass('active');
                        jQuery(firstTab.find('a').attr('href')).addClass('active');
                    /*}	*/
                    ngeRenderHandsontable(divtarget);
                }	
            }else if(target.substr(0,6) == 'input:'){
                var currentField = jQuery("[name*='["+target.substring(6)+"]'], [name*='"+target.substring(6)+"']", parentGroupNode.parent());
                var currentFieldAttr = currentField.attr('class');
                if(currentFieldAttr == 'mce_editable'){
                    currentField = currentField.parent();
                }
                /*divtarget = fieldGroupNode(currentField, 'input');*/
                divtarget = jQuery(currentField).closest('.control-group');
                if (divtarget != null){
                    divtarget.show();
                    ngeRenderHandsontable(divtarget);
                }
            }else{
                jQuery(target).show();
                ngeRenderHandsontable(jQuery(target));
            }
        });
    }
};						

/* Update buttons selection from hidden value */    
updateFieldradio = function($selector){    
    $selector.find('div.fieldradio').each(function() {
	var hiddenVal = jQuery(this).parent().find('input').val();
	var activeSelector = '[value='+hiddenVal+']'
	jQuery(this).find('button').removeClass('active');
	var $selectedButton = jQuery(this).find(activeSelector).addClass('active');
	updateFieldradioSelection($selectedButton);
	updateFieldradioDatatargets($selectedButton);
    });        
}

/*Hack for well render field handsontable with datatarget*/
ngeRenderHandsontable = function($selector){
    var $hots = $selector.find(".nge-handsontable-render");
    if($hots.length > 0){
        $hots.each(function() {
            var currentHot = jQuery(this);
            setTimeout(function(){
                var hot = currentHot.handsontable("getInstance");
                if(typeof hot !== "undefined"){
                    currentHot.handsontable("getInstance").render();
                }
            }, 250);
        });
    }
}

/* FIELDCOLOR ******************************************************************************************/
//initNgeColor = function($selector){
initFormsColor = function(){    
    /*If there is at least on element*/
    //if($selector.find("input.fieldcolor").length > 0){
    jQuery("input.fieldcolor").initialize(function(){
        jQuery(this).minicolors({
            control: jQuery(this).attr("data-control") || "hue",
            position: jQuery(this).attr("data-position") || "right",
            theme: "bootstrap",
            changeDelay: 200,
            change: function(value, opacity) {
                jQuery(document).trigger( "ngeConfigChange");
            }
        });
    /* The minicolor component must have a mminimum height. If not when you click on the input, the flying color picker is truncated*/
    jQuery(this).parent().parent().parent().parent().css('min-height', '180px');
    });
};

/* FIELDCOLORS ******************************************************************************************/
initFormsColors = function(){
    /*If there is at least on element*/
    //var $colorElement  = $selector.find("input.ngecolorsspectrum-input");
    //if($colorElement.length > 0){
    jQuery("input.ngecolorsspectrum-input").initialize(function(){
        jQuery(this).spectrum({
            preferredFormat: "hex",
            replacerClassName: 'ngecolorsspectruminput-container',
            showButtons: false,
            showInput: true,
            showInitial: true,
            hideAfterPaletteSelect:true,
            hide: function() {
                jQuery(document).trigger( "ngeConfigChange");
            }
        });
    });
};

/* FIELDCOLORCMYK ******************************************************************************************/
CMYKtoRGB = function (cyan, magenta, yellow, key){
    var result = {r: 0,g: 0, b:0};
 
    c = cyan / 100;
    m = magenta / 100;
    y = yellow / 100;
    k = key / 100;

    result.r = 1 - Math.min( 1, c * ( 1 - k ) + k );
    result.g = 1 - Math.min( 1, m * ( 1 - k ) + k );
    result.b = 1 - Math.min( 1, y * ( 1 - k ) + k );

    result.r = Math.round( result.r * 255 );
    result.g = Math.round( result.g * 255 );
    result.b = Math.round( result.b * 255 );

    return result;
};

initFormsColorCMYK = function(){
    jQuery(document).off('input', 'input.ngecolorcmyk-input').on('input', 'input.ngecolorcmyk-input', function(){
        var currentInput = jQuery(this);
        var currentInputsContainer = currentInput.closest(".ngecolorcmyk-container");
        var currentPreview = currentInputsContainer.find(".ngecolorcmyk-preview");
        var currentInputC = currentInputsContainer.find(".ngecolorcmyk-input-c").val();
        var currentInputM = currentInputsContainer.find(".ngecolorcmyk-input-m").val();
        var currentInputY = currentInputsContainer.find(".ngecolorcmyk-input-y").val();
        var currentInputK = currentInputsContainer.find(".ngecolorcmyk-input-k").val();
        
        var rgb = CMYKtoRGB(currentInputC, currentInputM, currentInputY, currentInputK);
        currentPreview.css("background-color", "rgb("+rgb.r+","+rgb.g+","+rgb.b+")")
    });
};

/* FIELDCHECKBOX ******************************************************************************************/
initFormsCheckbox = function(){
    jQuery('.fieldcheckbox button').initialize(function() {	
        var isChecked = jQuery(this).next().attr('checked');
        if(typeof isChecked !== 'undefined' && isChecked !== false){
            jQuery(this).addClass('btn-success active');
        }
    });
    
    jQuery(document).on("click", ".fieldcheckbox button", function(e){
        e.preventDefault();
        e.stopPropagation();
	
        $element = jQuery(e.target);
        if($element.hasClass('btn-success')){
            $element.removeClass('btn-success active');
            $element.next().prop('checked', false);
        }else{
            $element.addClass('btn-success active');
            $element.next().prop('checked', true);
        }        
        $element.trigger('change');	
    });	
    
}

updateFieldCheckbox = function($selector){ 
    $selector.find('div.fieldcheckbox').each(function() {
        var $fieldCheckbox = jQuery(this);
        var $checkboxButtons = $fieldCheckbox.find('button');
        var hiddenVal = jQuery(this).find("input[type='checkbox']").serializeArray();
        var arrayVal = [];
        
        jQuery.each(hiddenVal, function( index, val ) {
            arrayVal.push(val.value);
        });

        $checkboxButtons.each(function(e) {
            jQuery(this).removeClass('btn-success active');
            if(jQuery.inArray(jQuery(this).val(), arrayVal) !== -1){
                jQuery(this).addClass('btn-success active');	
            }
        });
    }); 
}
/* FIELDGLYPH ******************************************************************************************/

/*
 * Bootstrap 3.0 IconPicker - jQuery plugin for Icon selection
 *
 * Copyright (c) 20013 A. K. M. Rezaul Karim<titosust@gmail.com>
 *
 * Licensed under the MIT license:
 *   http://www.opensource.org/licenses/mit-license.php
 *
 * Project home:
 *   https://github.com/titosust/Bootstrap-icon-picker
 *
 * Version:  1.0.0
 *
 */

/* add this function to initialize*/
var glyphIcons = [];
var glyphIconsIsLoading = false;
initFormsGlyph = function(){
    
/*    if ((glyphIcons.length == 0) && (glyphIconsIsLoading == false)) {
	glyphIconsIsLoading = true;
	var url = rootUrl+"media/com_nge/icomoon/selection.json";
	jQuery.ajax({
	    dataType: "json",
	    url: url,
	    success: function (resultJson) {
		for(var i=0, iconlength=resultJson.icons.length;i < iconlength; i++){
		    var name = resultJson.icons[i].properties.name.split(",");
		    glyphIcons[i] = name[0];
		}
	    },
	    error: function (result) {
		console.error(result);
	    },
	    complete: function (result) {
		jQuery("input.fieldglyph").iconPicker();
		glyphIconsIsLoading = false;
	    }
	});
    }else{
	//if($selector.find("input.fieldglyph").length > 0 && typeof($selector.find("input.fieldglyph").iconPicker) === "function"){
            //$selector.find("input.fieldglyph").iconPicker();
	//jQuery("input.fieldglyph").iconPicker();
    }
   */ 
    jQuery("input.fieldglyph").initialize(function(){
	
	if ((glyphIcons.length == 0) && (glyphIconsIsLoading == false)) {
	    glyphIconsIsLoading = true;
	    jQuery.ajax({
		dataType: "json",
		url: rootUrl+"media/com_nge/icomoon/selection.json",
		success: function (resultJson) {
		    for(var i=0, iconlength=resultJson.icons.length;i < iconlength; i++){
			var name = resultJson.icons[i].properties.name.split(",");
			glyphIcons[i] = name[0];
		    }
		},
		error: function (result) {
		    console.error(result);
		},
		complete: function (result) {
		    jQuery("input.fieldglyph").iconPicker();
		    glyphIconsIsLoading = false;
		}
	    });
	}else{
	    jQuery(this).iconPicker();
	}
    });

};



jQuery.fn.iconPicker = function( options ) {
    var $popup=null;

            var glyphLenght= glyphIcons.length;
            startIndexEnd= (36 * Math.round(glyphLenght/36)) - 36;


    var settings = jQuery.extend({

    }, options);

    return this.each( function() {
            element=this;
        if(!settings.buttonOnly && jQuery(this).data("iconPicker")==undefined ){
            $this=jQuery(this).addClass("form-control");
            $parent = $this.parent();
            
            /*If always instanciate don't create icon.*/
            if(!$this.parent().hasClass("input-prepend")){
                $wraper=jQuery("<div/>",{class:"input-prepend"});
                $this.wrap($wraper);
                
                $button = jQuery("<span class=\"add-on pointer\"><i class=\" icon-picture\"></i></span>");
                $this.after($button);
            }else{
                $button = $parent.children("span");
            }
            
            (function(ele){
                    $button.unbind('click').click(function(){
                                    createUI(ele);
                                    showList(ele,glyphIcons);
                    });
                })($this);

            jQuery(this).data("iconPicker",{attached:true});
        }

            function createUI($element){
                    $popup=jQuery("<div/>",{
                            css: {
                                    "top":$element.offset().top+$element.outerHeight()+6,
                                    "left":$element.offset().left
                            },
                            class:"glyph-popup"
                    })

                    $popup.html('<div class="ip-control"> \
                                                      <ul> \
                                                        <li><a href="javascript:;" class="btn" data-dir="-1"><span class=" icon-fast-backward"></span></a></li> \
                                                        <li><input type="text" class="ip-search icon-search" placeholder="Search" /></li> \
                                                        <li><a href="javascript:;"  class="btn" data-dir="1"><span class=" icon-fast-forward"></span></a></li> \
                                                      </ul> \
                                                  </div> \
                                                 <div class="glyph-list"> </div> \
                                             ').appendTo("body");


                    $popup.addClass("dropdown-menu").show();
                            $popup.mouseenter(function() {  mouseOver=true;  }).mouseleave(function() { mouseOver=false;  });

                    var lastVal="", start_index=0,per_page=36,end_index=start_index+per_page;
                    jQuery(".ip-control .btn",$popup).click(function(e){
			console.log('CLICK');
                    e.stopPropagation();
                    var dir=jQuery(this).attr("data-dir");
		    console.log(dir);
		    console.log('---');
		    console.log(start_index);
		    
                    start_index=start_index+per_page*dir;
                    start_index=start_index<0?0:start_index;
console.log(start_index);
                    if(start_index<glyphLenght){
                      jQuery.each(jQuery(".glyph-list>ul li"),function(i){
                          if(i>=start_index && i<start_index+per_page){
                             jQuery(this).show();
                          }else{
                            jQuery(this).hide();
                          }
                      });
                    }else{
                      start_index=startIndexEnd;
                    }
                });

                    jQuery(".ip-control .ip-search",$popup).on("keyup",function(e){
                    if(lastVal!=jQuery(this).val()){
                        lastVal=jQuery(this).val();
                        if(lastVal==""){
                            showList(glyphIcons);
                        }else{
                            showList($element, jQuery(glyphIcons)
                                                            .map(function(i,v){ 
                                                                        if(v.toLowerCase().indexOf(lastVal.toLowerCase())!=-1){return v} 
                                                                    }).get());
                                            }

                    }
                });  
                    jQuery(document).mouseup(function (e){
                                if (!$popup.is(e.target) && $popup.has(e.target).length === 0) {
                                    removeInstance();
                                }
                            });

            }
            function removeInstance(){
                $popup.find(".glyph-list li a").unbind("click");
                $popup.remove();
            }
            function showList($element,arrLis){
                    $ul=jQuery("<ul>");
                    for (var i in arrLis) {
                                    if(!isNaN(i)){
                                    $ul.append("<li><a href=\"#\" title="+arrLis[i]+"><span class=\"icomoon icomoon-"+arrLis[i]+"\"></span></a></li>");
                            }
                            };

                $popup.find(".glyph-list").html($ul);
                $popup.find(".glyph-list li a").click(function(e){
                    e.preventDefault();
                    var title=jQuery(this).attr("title");
                    $element.val("icomoon-"+title);
	    jQuery(document).trigger( "ngeConfigChange");
                    removeInstance();
                });
            }

    });
};
    
/********** FIELDSLIDERPIPS **********/
initFormsNgeSlider = function(){
    jQuery("div.fieldsliderpips").initialize(function() {
    //$selector.find("div.fieldsliderpips").each(function() {
        var range = jQuery(this).attr("range");
        var min = jQuery(this).attr("min");
        var max = jQuery(this).attr("max");
        var suffix = jQuery(this).attr("suffix");
        var values = jQuery(this).attr("values");
        var step = jQuery(this).attr("step");
        var pipsStep = jQuery(this).attr("pips_step");
        var pipsRest = jQuery(this).attr("pips_rest");

        range = (typeof range !== 'undefined' && typeof(range) === "boolean") ? range : false;
        min = (typeof min !== 'undefined' && jQuery.isNumeric(min)) ? Number(min) : 0;
        max = (typeof max !== 'undefined' && jQuery.isNumeric(max)) ? Number(max) : 100;
        suffix = (typeof suffix !== 'undefined') ? suffix : "";
        values = (typeof values !== 'undefined') ? values : 0;
        step = (typeof step !== 'undefined' && jQuery.isNumeric(step)) ? Number(step) : 1;
        pipsStep = (typeof pipsStep !== 'undefined') ? pipsStep : false;
        pipsStep = (typeof(pipsStep) === "boolean") ? pipsStep : Number(pipsStep);
        pipsRest = (typeof pipsRest !== 'undefined') ? pipsRest : false;
        pipsRest = (typeof(pipsRest) === "boolean") ? pipsRest : String(pipsRest);
        
        jQuery(this)
        .slider({    
            range: range,
            min: min,
            max: max,
            values: [values],
            step: step,
            create: function(event, ui){
            },
            change: function(event, ui){
                var currentSlider = jQuery(this);
                var currentInputTooltip = currentSlider.find("input.nge-pips-slider-tooltip");

                currentInputTooltip.bind("change", function(){
                    if(!isNaN(jQuery(this).val())){
                        currentSlider.slider("values", [jQuery(this).val()]);
                    }
                });

                if(!isNaN(ui.value)){
                    jQuery(this).next().val(ui.value).trigger("change");
                }
            }
        }).slider("pips", {
            first: "label",
            last: "label",
            rest: pipsRest,
            step: pipsStep,
            labels: false,
            prefix: "",
            suffix: suffix
        }).slider("float", {
            handle: true,
            pips: false,
            labels: false,
            prefix: "",
            suffix: "",
            formatLabel: function(val){
                var stringVal = '<div style="width:100%;position:relative;"><input type="text" class="nge-pips-slider-tooltip" value="'+val+'" /></div>';
                var returnValue = this.prefix +  stringVal + this.suffix;
                return returnValue;
            }
        });
    });
};

updateFieldSlider = function($selector){
    $selector.find("div.fieldsliderpips").each(function() {
        var hiddenVal = jQuery(this).next().val();
        jQuery(this).slider("option", "values", [hiddenVal]);
    });
};
/********** FIELDFILEMANAGER **********/
var $fieldFileManager = null;
var currentDataMine, currentDirectory, currentId, currentName;
initFormsFileManager = function(){
    
    jQuery(document).on("click", "div.ngefilemanager-select-button", function(){
    //$selector.find("div.ngefilemanager-select-button").unbind('click').click(function(){
        var modalNgeFieldManager = jQuery("#ngeFieldManagerNew");
        $fieldFileManager = jQuery(this).closest(".controls");
        $inputManagerId = $fieldFileManager.find(".ngefield-filemanager-id");
        $inputManagerId.addClass("ngeselected");

        if(modalNgeFieldManager.length > 0){/*Only load elfinder and the modal the first time*/
            modalNgeFieldManager.modal("show");
        }else{ /*First time : We load the modal and elfinder*/
            currentId = jQuery(this).attr("data-id");
            currentName = jQuery(this).attr("data-name");
            currentDataMine = jQuery(this).attr("data-mime");
            currentDataType = jQuery(this).attr("data-type");
            currentDirectory = jQuery(this).attr("data-directory");
	/*var obj_data_internal = jQuery('#internalform');
	if(obj_data_internal) {
	    var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal='{}';*/
	var token = '&' + ngeToken + '=1';
            ngetools.loadModal({
                //url : baseUrl+"index.php?option=com_nge&view=field_ngefilemanager&format=raw&layout=scripts&modalId=ngeFieldManagerNew&" + str_data_internal,
	url : baseUrl+"index.php?option=com_nge&view=field_ngefilemanager&format=raw&layout=scripts&modalId=ngeFieldManagerNew&" + token,
                title: '<i class="material-icons">insert_photo</i>&nbsp;' + COM_NGE_FIELDS_MEDIAMANAGER,
                backgroundColor: '#C2185B',
	hoverColor: '#E91E63',
                width:  95,
                height: 95,
                responsive: true,
                modalId: "ngeFieldManagerNew",
                isIframe: true,
                buttons : {
                    cancel: {
                        label: "FERMER",
                        stopEventsPropagation: false,
                        callback: function ($button) {
                            $inputManagerId.removeClass("ngeselected");
                            $inputManagerId.trigger("change");
                            $button.closest('.modal').modal("hide");
                        }
                    }
                },
                callback: function () {}
            });
        }
    });
    
    //$selector.find("div.ngefilemanager-clear-button").unbind('click').click(function(){   
    jQuery(document).on("click", "div.ngefilemanager-clear-button", function(){
        $fieldFileManager = jQuery(this).closest(".controls");
        $fieldFileManager.find(".ngefield-filemanager-id")[0].value = "";
        $fieldFileManager.find(".ngefield-filemanager-name")[0].value = jQuery(this).attr("data-nge-input-default");
        $fieldFileManager.find(".ngefield-filemanager-id").trigger("change");
    });
};

/********** FIELDSELECT **********/
initNgeSelect = function($selector, isSelectElement){
    isSelectElement = typeof isSelectElement !== "undefined" ? true : false;
    var elements = $selector;
        
    if(!isSelectElement){ /*if isSelectElement is true, $selector are select elements else $selector is a container who contains select elements and we need to find them.*/
        elements = $selector.find('select.ngefield-select');
    }
    
    elements.each(function() {
        var currentSelect = jQuery(this);
        var lang = currentSelect.attr("lang");
        var useAjax = currentSelect.attr("ajax");
        var target = currentSelect.attr("target");
        var placeholder = currentSelect.attr("placeholder");
        var allowclear = (currentSelect.attr("allowclear") === "true");
        var width = currentSelect.attr("width");
        var isHidden = currentSelect.attr("ishidden");
        var isConfig = currentSelect.attr("isConfig");

        /*If current element has already initiate by old select2 but he don't have select2 event. For example with clone() jqueyr function*/
        if(currentSelect.next().hasClass("select2-container")){
            currentSelect.next().remove();
            currentSelect.removeClass("select2-hidden-accessible");
        }
        
        var options = {};
        options.width = width;
        options.language = lang;
        options.allowClear = allowclear;
        options.placeholder = placeholder;

        if(useAjax == "true"){
            options.cacheDataSource = [];
            options.query = function(query) {
                self = this;
                var key = query.term;
                var cachedData = options.cacheDataSource[key];
	var obj_data_internal = jQuery('#internalform');
	if(obj_data_internal) {
	    var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal='{}';					

                if(cachedData) {
                    query.callback({results: cachedData.items});
                    return;
                }else{
                    jQuery.ajax({
                      url: baseUrl+"index.php?option=com_nge&task=field_select.getList&target="+target + "&" + str_data_internal,
                      data: { search : query.term },
                      dataType: 'json',
                      type: 'GET',
                      success: function(data) {
                        options.cacheDataSource[key] = data;
                        query.callback({results: data.items});
                      }
                    });
                }
            };
        }
        
        currentSelect.select2(options);
        
        if(isHidden === "true"){
            currentSelect.next().hide();
        }
//        currentSelect.next().css({
//            "max-width": "200px",
//            "min-width": "100px"
//        });
        
        if(isConfig){
            updateFieldradioDatatargets(currentSelect.find('option[selected="selected"]'));

            currentSelect.on("select2:select", function (e) {
                updateFieldradioDatatargets(currentSelect.find('option[value="'+e.params.data.id+'"]'));
            }); 

            currentSelect.on("change", function (e) {
	jQuery(document).trigger( "ngeConfigChange");
            }); 
        }
    });
};

updateFieldSelect = function($selector){
    $selector.find('select.ngefield-select').each(function() {
        var currentSelect = jQuery(this);
        currentSelect.trigger("change");
    });
};

/*
initNgeSort = function($selector){

    var foo = document.getElementById("foo");
    if (foo !== null)
	Sortable.create(foo, { group: "omega" });

    var bar = document.getElementById("bar");
    if (bar !== null)
	Sortable.create(bar, { group: "omega" });
}
*/

/********** FIELDMENUITEMS **********/
initFormsMenuItems = function(){
    //$selector.find("select.ngefield-menuItems").each(function() {
    jQuery("select.ngefield-menuItems").initialize(function() {	
        var currentSelect = jQuery(this);
        
        currentSelect.select2({
           width: "90%",
        });
        
        currentSelect.next().css({
            "max-width": "300px",
            "min-width": "100px"
        });
    });
};

/********** FIELDDATE **********/
/*TODO EN CONSTRUCTION, pour l'instant en francais*/
initNgeDate = function($selector, isElement){
    isElement = typeof isElement !== "undefined" ? isElement : false;
    if(!isElement){ /*if isElement is true, $selector are the current selector don't need to find children. .ngefield_select_filter_operators*/     
        $selector = $selector.find("input.ngefield-datepicker");
    }

    $selector.each(function() {
        jQuery.datepicker.regional[ "fr" ] = {
	closeText: "Fermer",
	prevText: "Précédent",
	nextText: "Suivant",
	currentText: "Aujourd'hui",
	monthNames: [ "janvier", "février", "mars", "avril", "mai", "juin",
		"juillet", "août", "septembre", "octobre", "novembre", "décembre" ],
	monthNamesShort: [ "janv.", "févr.", "mars", "avr.", "mai", "juin",
		"juil.", "août", "sept.", "oct.", "nov.", "déc." ],
	dayNames: [ "dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi" ],
	dayNamesShort: [ "dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam." ],
	dayNamesMin: [ "D","L","M","M","J","V","S" ],
	weekHeader: "Sem.",
	dateFormat: "dd/mm/yy",
	firstDay: 1,
	isRTL: false,
	showMonthAfterYear: false,
	yearSuffix: "" };
    
        jQuery.datepicker.setDefaults( jQuery.datepicker.regional[ "fr" ] );
        jQuery(this).datepicker();
    });
};

/********** FIELDFONT **********/
var $fieldFont = null;
initFormsFont = function(){ 
    //$selector.find("div.ngefont-select-button").unbind('click').click(function(){   
    jQuery(document).on("click", "div.ngefont-select-button", function(){   
        $fieldFont = jQuery(this).closest(".controls");
        var $modalNgeFieldFont = jQuery("#ngeFontManager");

        if($modalNgeFieldFont.length > 0){/*Only load font and the modal the first time*/
            $modalNgeFieldFont.modal("show");
        }else{ /*First time : We load the modal and elfinder*/
	var token = '&' + ngeToken + '=1';
            ngetools.loadModal({
	url : rootUrl+"index.php?option=com_nge&view=field_ngefont&layout=default&format=raw&" + token,
                title: '<i class="material-icons">font_download</i>&nbsp;' + COM_NGE_FIELDS_FONTSMANAGER,
                backgroundColor: '#555D83',
	hoverColor: '#646D9C',
                width:  85,
                height: 80,
                responsive: true,
                modalId: "ngeFontManager",
                buttons : {
                    cancel: {
                        label: "FERMER",
                        stopEventsPropagation: false,
                        callback: function ($button) {
                            $button.closest('.modal').modal("hide");
                        }
                    }
                },
                callback: function () {}
            });
        }
    });
					
    //$selector.find("div.ngefont-clear-button").unbind('click').click(function(){
    jQuery(document).on("click", "div.ngefont-clear-button", function(){	
        $fieldFont = jQuery(this).closest(".controls");
        $fieldFont.find(".ngefield-font-name")[0].value = jQuery(this).attr("data-nge-input-default");
        $fieldFont.find(".ngefield-font-name").trigger("change");
    });
};

/********** FIELDEDITOR **********/
initFormsEditor = function(){
    //$selector.find('.fieldeditor').each(function() {	    
    jQuery('.fieldeditor').initialize(function() {
        var id = jQuery(this).attr('id');
        var value = jQuery(this).html();

        /*If already exist remove it*/
	
        if (CKEDITOR.instances[id]) {
	try {
	    CKEDITOR.instances[id].destroy(true);
	} catch(e) {
	    console.error('Error while destroying CKEDITOR instance :' + id);
	}
        }
    
        if (value != ""){
            loadNGECkEditor(id);
        }else{
            prepareNGECkEditor(id);
        }
    });
};

loadNGECkEditor = function(id){
    var initialValue = '';
    var editor = CKEDITOR.inline(id, {
        allowedContent: true
    });
    editor.on( "focus", function( ev) {
        if ( ev.editor.element && ev.editor.elementMode !== CKEDITOR.ELEMENT_MODE_APPENDTO ) {
            initialValue = ev.editor.getData();
            if ( this.config.htmlEncodeOutput ){
                initialValue = CKEDITOR.tools.htmlEncode( initialValue );
            }
        }
    });
    
    editor.on( "change", function( ev) {
        /-*Some editor creation mode will not have the associated element*-/
        if ( ev.editor.element && ev.editor.elementMode != CKEDITOR.ELEMENT_MODE_APPENDTO ) {
            var data = ev.editor.getData();
            if ( this.config.htmlEncodeOutput )
                data = CKEDITOR.tools.htmlEncode( data );

            document.getElementById(id).innerHTML = data;
        }
    });

    editor.on( "blur", function( ev) {
        if ( ev.editor.element && ev.editor.elementMode !== CKEDITOR.ELEMENT_MODE_APPENDTO ) {
            var value = ev.editor.getData();
            if ( this.config.htmlEncodeOutput ){
                value = CKEDITOR.tools.htmlEncode( value );
            }
            if (value !== initialValue) {
	jQuery(document).trigger( "ngeConfigChange");
            }
        }
    });
};

prepareNGECkEditor = function(id){
    var editorEvent = document.getElementById(id);
    editorEvent.addEventListener("click", function (event) {
        var initialValue = '';
        
        var editor = CKEDITOR.inline(id, {
            startupFocus: true,
            allowedContent: true
        });	
        editor.on( "focus", function( ev) {
            if ( ev.editor.element && ev.editor.elementMode !== CKEDITOR.ELEMENT_MODE_APPENDTO ) {
                initialValue = ev.editor.getData();
                if ( this.config.htmlEncodeOutput ){
                    initialValue = CKEDITOR.tools.htmlEncode( initialValue );
                }
            }
        });
        
        editor.on( "change", function( ev) {
            /-*Some editor creation mode will not have the associated element*-/
            if ( ev.editor.element && ev.editor.elementMode !== CKEDITOR.ELEMENT_MODE_APPENDTO ) {
                var data = ev.editor.getData();
                
                if ( this.config.htmlEncodeOutput )
                    data = CKEDITOR.tools.htmlEncode( data );	

                editorEvent.innerHTML = data;
            }
        });

        editor.on( "blur", function( ev) {
            if ( ev.editor.element && ev.editor.elementMode !== CKEDITOR.ELEMENT_MODE_APPENDTO ) {
                var value = ev.editor.getData();
                if ( this.config.htmlEncodeOutput ){
                    value = CKEDITOR.tools.htmlEncode( value );
                }
                if (value !== initialValue) {
                    jQuery(document).trigger( "ngeConfigChange");
                }
            }
        });      
    });
};

/********** FIELDARTICLE **********/
var $fieldArticle = null;
initFormsArticle = function(){
    //$selector.find("div.ngearticle-select-button").unbind('click').click(function(){
    jQuery(document).on("click", "div.ngearticle-select-button", function(){
        $fieldArticle = jQuery(this).closest(".controls");	        									        			
        jQuery("#ngeArticleManager").modal("show");
        getAjaxArticlesGroup();
    });

    //$selector.find("div.ngearticle-clear-button").unbind('click').click(function(){
    jQuery(document).on("click", "div.ngearticle-clear-button", function(){	
        $fieldArticle = jQuery(this).closest(".controls");
        $fieldArticle.find(".ngefield-article-id")[0].value = "";
        $fieldArticle.find(".ngefield-article-name")[0].value = jQuery(this).attr("data-nge-input-default");
        $fieldArticle.find(".ngefield-article-id").trigger("change");
    });
};

updateNgeArticle = function($selector){
    $selector.find("div.ngearticle-select-button").unbind('click').click(function(){
        $fieldArticle = jQuery(this).closest(".controls");	        									        			
        jQuery("#ngeArticleManager").modal("show");
        getAjaxArticlesGroup();
    });

    $selector.find("div.ngearticle-clear-button").unbind('click').click(function(){
        $fieldArticle = jQuery(this).closest(".controls");
        $fieldArticle.find(".ngefield-article-id")[0].value = "";
        $fieldArticle.find(".ngefield-article-name")[0].value = jQuery(this).attr("data-nge-input-default");
        $fieldArticle.find(".ngefield-article-id").trigger("change");
    });
};


getAjaxArticlesGroup = function(){
    var $articleContent = jQuery("#ngearticle-content");
    var obj_data_internal = jQuery('#internalform');
    if(obj_data_internal) {
       	var str_data_internal = JSON.stringify(obj_data_internal.serialize());
    	str_data_internal = str_data_internal.replace(/\"/g, "");
     }
    else
        str_data_internal='{}';

    if($articleContent.html() === ""){
        $articleContent.html('<img style="margin:50px auto; display:block;" width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" />');
        jQuery.ajax({
            url: baseUrl+"index.php?option=com_nge&view=field_ngearticle&layout=default&format=raw",
            type: 'POST',
            data : str_data_internal,
            success: function (result) {
                try {
                    $articleContent.html(result);
                } catch (err) {
                    console.error("Error : to load list of article!<br>" + err.toString());
                }
            },
            error: function (xhr) {
                $articleContent.html(xhr.responseText);
                console.error("Error : to load list of article!");
            },
            complete: function () {
                
            },
        });
    }
};

/********** FIELDMENU **********/
var $fieldMenu = null;
initFormsMenu = function(){
    //$selector.find("div.ngemenu-select-button").unbind('click').click(function(){
    jQuery(document).on("click", "div.ngemenu-select-button", function(){
        $fieldMenu = jQuery(this).closest(".controls");	        									        			
        jQuery("#ngeMenuManager").modal("show");
        getAjaxMenusGroup();
    });

    //$selector.find("div.ngemenu-clear-button").unbind('click').click(function(){
    jQuery(document).on("click", "div.ngemenu-clear-button", function(){	
        $fieldMenu = jQuery(this).closest(".controls");
        $fieldMenu.find(".ngefield-menu-id")[0].value = "";
        $fieldMenu.find(".ngefield-menu-name")[0].value = jQuery(this).attr("data-nge-input-default");
        $fieldMenu.find(".ngefield-menu-id").trigger("change");
    });
};

updateNgeMenu = function($selector){
    $selector.find("div.ngemenu-select-button").unbind('click').click(function(){
        $fieldMenu = jQuery(this).closest(".controls");	        									        			
        jQuery("#ngeMenuManager").modal("show");
        getAjaxMenusGroup();
    });

    $selector.find("div.ngemenu-clear-button").unbind('click').click(function(){
        $fieldMenu = jQuery(this).closest(".controls");
        $fieldMenu.find(".ngefield-menu-id")[0].value = "";
        $fieldMenu.find(".ngefield-menu-name")[0].value = jQuery(this).attr("data-nge-input-default");
        $fieldMenu.find(".ngefield-menu-id").trigger("change");
    });
};


getAjaxMenusGroup = function(){
    var $menuContent = jQuery("#ngemenu-content");
    var obj_data_internal = jQuery('#internalform');
    if(obj_data_internal) {
       	var str_data_internal = JSON.stringify(obj_data_internal.serialize());
    	str_data_internal = str_data_internal.replace(/\"/g, "");
     }
    else
        str_data_internal='{}';

    if($menuContent.html() === ""){
        $menuContent.html('<img style="margin:50px auto; display:block;" width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" />');
        jQuery.ajax({
            url: baseUrl+"index.php?option=com_nge&view=field_ngemenu&layout=default&format=raw",
            type: 'POST',
            data : str_data_internal,
            success: function (result) {
                try {
                    $menuContent.html(result);
                } catch (err) {
                    console.error("Error : to load list of menu!<br>" + err.toString());
                }
            },
            error: function (xhr) {
                $menuContent.html(xhr.responseText);
                console.error("Error : to load list of menu!");
            },
            complete: function () {
                
            },
        });
    }
};


/********** FIELDMODULE **********/
var $fieldModule = null;
initFormsModule = function(){
    //$selector.find("div.ngemodule-select-button").unbind('click').click(function(){
    jQuery(document).on("click", "div.ngemodule-select-button", function(){
        $fieldModule = jQuery(this).closest(".controls");			        									        			
        jQuery("#ngeModuleManager").modal("show");
        getAjaxModulesGroup();
    });

    //$selector.find("div.ngemodule-clear-button").unbind('click').click(function(){
    jQuery(document).on("click", "div.ngemodule-clear-button", function(){	
        $fieldModule = jQuery(this).closest(".controls");
        $fieldModule.find(".ngefield-module-id")[0].value = "";
        $fieldModule.find(".ngefield-module-name")[0].value = jQuery(this).attr("data-nge-input-default");
        $fieldModule.find(".ngefield-module-id").trigger("change");
    });
};

getAjaxModulesGroup = function(){
    var moduleContent = jQuery("#ngemodule-content");
    var obj_data_internal = jQuery('#internalform');
    if(obj_data_internal) {
       	var str_data_internal = JSON.stringify(obj_data_internal.serialize());
    	str_data_internal = str_data_internal.replace(/\"/g, "");
     }
    else
        str_data_internal='{}';
        /*Notice relative url for usage in front and back office)*/
    if(moduleContent.html() === ""){
        moduleContent.html('<img style="margin:50px auto; display:block;" width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" />');
        jQuery.ajax({
            url: baseUrl+"index.php?option=com_nge&view=field_ngemodule&layout=default&format=raw",
            type: 'POST',
            data : str_data_internal,
            success: function (result) {
                try {
                    moduleContent.html(result);
                } catch (err) {
                    console.error("Error : to load list of module!<br>" + err.toString());
                }
            },
            error: function (xhr) {
                moduleContent.html(xhr.responseText);
                console.error("Error : to load list of module!");
            },
            complete: function () {
            },
        });
    }
};

/********** FIELDK2ITEM **********/
initNgeK2item = function($selector){
    $selector.find("div.ngek2item-select-button").unbind('click').click(function(){
        var currentK2itemsInputId = jQuery(this).attr("data-nge-input-id");			        									        			
        jQuery("#ngeK2itemManager").modal("show");
        getAjaxK2itemsGroup(currentK2itemsInputId);
    });

    $selector.find("div.ngek2item-clear-button").unbind('click').click(function(){			        									        			       
        var currentK2itemsInputId = jQuery(this).attr("data-nge-input-id");			        									        			
        var currentK2itemsInputDefault = jQuery(this).attr("data-nge-input-default");			        									        			
        document.getElementById(currentK2itemsInputId+"_id").value = "";
        document.getElementById(currentK2itemsInputId+"_name").value = currentK2itemsInputDefault;
        jQuery("#"+currentK2itemsInputId+"_id").trigger("change");
    });
};

getAjaxK2itemsGroup = function(inputId){
    var K2itemContent = jQuery("#ngek2item-content");
    if(K2itemContent.html() === ""){
        K2itemContent.html('<img style="margin:50px auto; display:block;" width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" />');
        jQuery.ajax({
            url: baseUrl+"index.php?option=com_nge&view=field_ngek2&layout=default&format=raw",
            data: { id : inputId },
            success: function (result) {
                try {
                    K2itemContent.html(result);
                } catch (err) {
                    console.error("Error : to load list of k2item!<br>" + err.toString());
                }
            },
            error: function (result) {
                console.error("Error : to load list of k2item!");
            },
            complete: function (result) {
            },
        });
    }
};

/********** FIELDPATTERN **********/    
initFormsPattern = function(){
    jQuery(document).on("click", "ul.ngepatterns-list li", function(){
        var $selectButton = jQuery(this).closest('.ngepatterns-list');
	var inputId = $selectButton.attr('data-id');

        if(jQuery(this).hasClass("ngeinline-pattern-add")){	
            var patternName = $selectButton.attr('data-name');
            var patternType = $selectButton.attr('data-type');
            ngeAddPattern(inputId, patternType, patternName);
        }else{
            var patternId = jQuery(this).attr('data-id');
            var title = jQuery(this).html();
            var description = jQuery(this).attr('data-description');
            updatePatternField(inputId, patternId, title, description);
        }
    });
    
    //Display edit button
    jQuery("div.ngepattern-edit-button").initialize(function(){
	var inputId =	jQuery(this).parent().attr('data-id');
	var patternId =	jQuery('#' + inputId + '_id').val();
	if (patternId != '')
	    jQuery(this).show();
	else
	    jQuery(this).hide();
    });
    
    //Modal select mode    
    jQuery(document).on("click", "div.ngepattern-select-button", function(){
	var $selectButton = jQuery(this);
	var inputId = $selectButton.attr('data-id');
	var patternId = jQuery('#' + inputId + '_id').val();	
	var patternName = $selectButton.attr('data-name');
	var patternType = $selectButton.attr('data-type');

        //getAjaxPatternGroup(currentPatternInputId);
	selectPattern(inputId, patternId, patternType, patternName);
    });
    
    jQuery(document).on("click", "div.ngepattern-edit-button", function(){
	var $selectButton = jQuery(this);
        //jQuery("#ngePatternManager").modal("show");
        getAjaxPatternEdition($selectButton);
    });
    
    /*Event on each button of the toolbar*/
    jQuery(".ngefield-pattern-toolbar-item").initialize(function(){
        jQuery(this).tooltip({
        title: function(){
            var $currentButton = jQuery(this);
            var title = $currentButton.attr("nge-title");
            var description = $currentButton.attr("nge-description");
            
            return '<div style="font-size: 12px;font-weight: bold;text-transform: uppercase;margin-bottom: 5px;">'+title+'</div><div style="font-size: 10px;font-style: italic;text-align: justify;">'+description+'</div>'
        },
        trigger: 'hover',
        html: true,
        placement: 'bottom',
        container: 'body'
        });
    });
};

selectPattern = function(inputId, patternId, patternType, patternName){    
    jQuery("#ngePatternManager").modal("show");
    var patternContent = jQuery("#ngepattern-content");
    patternContent.html('<img style="margin:50px auto; display:block;" width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" />');
    var obj_data_internal = jQuery('#internalform');
	if(obj_data_internal) {
	    var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal='{}';
    jQuery.ajax({
        url: baseUrl+"index.php?option=com_nge&view=field_ngepattern&layout=default&format=raw&" + str_data_internal,
        data: { inputid: inputId, id: patternId, name: patternName, type: patternType},
        success: function (result) {
            try {
                patternContent.html(result);
            var patternId =	jQuery('#' + inputId + '_id').val();
            if (patternId != '')
                jQuery(this).show();
            else
                jQuery(this).hide();
            } catch (err) {
                console.error("Error : to load list of patterns!<br>" + err.toString());
            }
        },
        error: function (result) {
            console.error("Error : to load list of patterns!");
        },
        complete: function (result) {},
    });
};

ngeAddPattern = function(inputId, patternType, patternName){
    var patternType = patternType;
    var patternName = patternName;
    var formData = {};
    formData.url = baseUrl+"index.php?option=com_nge&view=inlineconfig&content=pattern&format=raw&layout=form&type=pattern&pattern_type="+patternType+"&pattern_name="+patternName;
    formData.data = {};

    ngetools.loadModal({
        url : baseUrl+"index.php?option=com_nge&view=inlineconfig&format=raw&layout=scripts",
        title: '<span class="icomoon-magic-wand"></span>Creating a new pattern',
        backgroundColor: '#FF9800',
        width:  90,
        height: 80,
        responsive: true,
        modalId: "nge-change-pattern",
        isIframe: true,
        buttons : {
            submit: {
                label: "VALIDER",
                stopEventsPropagation: true,
                callback: function ($button) {
                    var $modal = $button.closest('.modal');
                    savePattern($modal.find("iframe")[0].contentWindow.jQuery("body"), function(result){
                        updatePatternList(inputId, result.pattern.id);
                        $modal.modal("hide");
                    });
                }
            },
            cancel : function(){}
        },
        callback: function () {
            /*Function uses to check if iframe content have loadForm Function for config form*/
            var checkNgeLoadFormExist = function(iframe, params) {
                if(typeof iframe.contentWindow.loadForm !== "undefined"){
                    iframe.contentWindow.loadForm(params);
                }else{
                    setTimeout(function(){ 
                        checkNgeLoadFormExist(iframe, params); 
                    }, 100);
                }
            }
            checkNgeLoadFormExist(jQuery("#nge-change-pattern").find("iframe")[0], formData); 
        }
    });
};

function savePattern($selector, callback) {
    var $contentForm = $selector.find(".ngecontentpattern, .ngecontentform");    
    var $optionsForm = $selector.find(".ngeoptionspattern, .ngeoptionsform");
    var $patternForm = $selector.find(".ngepatternform");    
    var $internalForm = $selector.find(".ngeinternalform");
    var str_data_content = JSON.stringify($contentForm.serialize()).replace(/\"/g, "");    
    var str_data_options = JSON.stringify($optionsForm.serialize()).replace(/\"/g, "");
    var str_data_pattern = JSON.stringify($patternForm.serialize()).replace(/\"/g, "");
    var str_data_internal = JSON.stringify($internalForm.serialize()).replace(/\"/g, "");
    
    str_data_content = str_data_content.replace(/\"/g, "");
    str_data_options = str_data_options.replace(/\"/g, "");
    str_data_pattern = str_data_pattern.replace(/\"/g, "");    
    str_data_internal = str_data_internal.replace(/\"/g, "");

    jQuery.ajax({
        url: baseUrl+"index.php?option=com_nge&task=pattern.save",
        data: {
            id : $patternForm.find("[name=id]").val(),
            type : $patternForm.find("[name=type]").val(),
            name : $patternForm.find("[name=name]").val(),
            title : $patternForm.find("[name=title]").val(),
            description : $patternForm.find("[name=description]").val(),
            content: str_data_content,
            params: str_data_options,
            settings: str_data_pattern,
            ngeinternal: str_data_internal
        },
        async: false,
        type: 'POST',
        success: function (resultJson) {
            var result_obj = jQuery.parseJSON(resultJson);
            if (result_obj.result == '0') {
                alert(result_obj.message);
            }else { 
                callback.call(this, result_obj);
            }
        },
        error: function (result) {
            console.error('Error', COM_NGE_FIELDS_ERROR_SAVING_PATTERN);
        }
    });
}

resetToInitialForm = function($button){
    var $formSelector = jQuery($button.attr("nge-pattern-selector"));
    var patternType = $button.attr("nge-pattern-type");
    var patternName = $button.attr("nge-pattern-name");
    var $loader = jQuery('<div style="text-align:center;margin-top:10px;"><img width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /><br/>Chargement formulaire en cours</div>');
    $button.tooltip("hide");
    
    $formSelector.hide();
    $loader.hide();
    $formSelector.parent().prepend($loader);
    $loader.show();
    
    getAjaxFormHtml(rootUrl+"index.php?option=com_ngd&task=form.getPartForm",{
        source: "pattern",
        patternId: "default",
        patternType: patternType,
        patternName: patternName
    },function(html){
        setTimeout(function(){
            var $newForm = jQuery(html);
            $newForm.hide();
            $formSelector.replaceWith($newForm).promise().done(function() {
                $newForm.find("input[name*='preset']").val('');
                initPartSubformsAutoload($newForm, function(){
                    $loader.hide();
                    $newForm.show();
                });
            });
        }, 250);
    });
}

loadFormFromPattern = function(formSelector, patternType, patternName){
    var obj_data_internal = jQuery('#internalform');
    if(obj_data_internal) {
	var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	str_data_internal = str_data_internal.replace(/\"/g, "");
    }
    else
	str_data_internal='{}';

    ngetools.loadModal({
        url: baseUrl+"index.php?option=com_nge&view=field_ngepattern&layout=default&format=raw&name="+patternName+"&type="+patternType + "&" + str_data_internal,
        title: '<span class="icomoon-magic-wand"></span>&nbsp;Modèles',
        backgroundColor: '#F57C00',
        width:  80,
        height: 90,
        responsive: true,
        buttons : {
            cancel: {
                label: "FERMER",
                stopEventsPropagation: false,
                callback: function () {
                }
            },
            submit: {
                label: "VALIDER",
                stopEventsPropagation: false,
                callback: function ($button) {
                    var $modal = $button.closest(".modal");
                    var $selectedPattern = $modal.find("div.nge-manager-list .patternitem.active");
                    var selectedPatternId = $selectedPattern.attr("data-id");

                    tooltipCancel = function(){
                        $button.tooltip("hide");
                     };
                     $button.tooltip('destroy');

                     if(typeof selectedPatternId === "undefined"){
                         $button.tooltip({
                             title: function(){
                                 return '<div style="text-align:justify;width:220px;">Pas de modèle sélectionné<br/>Merci de sélectionner un modèle pour continuer</div>'
                                 + '<div>'
                                     + '<span class="btn btn-info" style="padding: 2px 4px;font-size: 12px;font-weight: bold;" onclick="tooltipCancel();">Fermer</span>'
                                 + '</div>';
                             },
                             trigger: 'manual',
                             html: true,
                             placement: 'bottom',
                             container: 'body',
                             template: '<div class="tooltip" style="z-index:1051"><div class="tooltip-arrow"></div><div class="tooltip-inner" style="max-width:250px;"></div></div></div>'
                         });
                     }else{
                        tooltipOk = function(){
                            $button.tooltip("hide");
                            $modal.modal("hide");
                            var $formContainer = jQuery(formSelector);
                            var $loader = jQuery('<div style="text-align:center;margin-top:10px;"><img width="30" src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /><br/>Chargement formulaire en cours</div>');
    
                            $formContainer.hide();
                            $loader.hide();
                            $formContainer.parent().prepend($loader);
                            $loader.show();
    
                            getAjaxFormHtml(rootUrl+"index.php?option=com_ngd&task=form.getPartForm",{
                                source: "pattern",
                                patternId:selectedPatternId
                            },function(html){
                                var $newForm = jQuery(html);
                                $newForm.hide();
                                $formContainer.replaceWith($newForm).promise().done(function() {
                                    $newForm.find("input[name*='preset']").val(selectedPatternId);
                                    initPartSubformsAutoload($newForm, function(){
                                        $loader.hide();
                                        $newForm.show();
                                    });
                                });
            
                            });
                        };
                        $button.tooltip({
                            title: function(){
                                return '<div style="text-align:justify;">Etes-vous sur de vouloir remplacer le formulaire par le modèle sélectionné ?<br/> Cette action remplacera les anciennes données par les données du modèle.</div>'
                                + '<div>'
                                    + '<span class="btn" style="padding: 2px 4px;font-size: 12px;font-weight: bold;margin-right: 5px;" onclick="tooltipOk();">Valider</span>'
                                    + '<span class="btn btn-info" style="padding: 2px 4px;font-size: 12px;font-weight: bold;" onclick="tooltipCancel();">Fermer</span>'
                                + '</div>';
                            },
                            trigger: 'manual',
                            html: true,
                            placement: 'bottom',
                            container: 'body',
                            template: '<div class="tooltip" style="z-index:1051"><div class="tooltip-arrow"></div><div class="tooltip-inner" style="max-width:250px;"></div></div></div>'
                        });
                     }
                     $button.tooltip('show');
                }
            }
        }
    });
};

getAjaxFormHtml = function(url, data, callback){
    callback = typeof callback !== "undefined" ? callback : function(){};
    var obj_data_internal = jQuery('#internalform');
    if(obj_data_internal) {
	var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	url = url + "&" + str_data_internal.replace(/\"/g, "");
    }
    
    jQuery.ajax({
        url: url,
        data: data,
        success: function (resultJson) {
            try {
                var data = JSON.parse(resultJson);
                if(data.result == "1"){
                    callback.call(this, data.html);
                }else{
                    console.error(data.message);
                    bootbox.alert(data.message);
                }
            } catch (err) {
                console.error("Error : to load form!<br>" + err.toString());
                bootbox.alert("Error : to load form!<br>" + err.toString());
            }
        },
        error: function () {
            bootbox.alert("Error : to load form!");
        },
        complete: function () {},
    });
};

/* Updating the current item of the input component from a direct click or the pattern Manager form*/
updatePatternField = function(inputId, patternId, patternTitle, patternDescription){
    document.getElementById(inputId + "_id").value = patternId;

    /* Case of ul/li display*/
    var $liPattern =     jQuery("#" + inputId).find('li[data-id="' + patternId + '"]');
    $liPattern.parent().children().removeClass('active');	    
    $liPattern.addClass('active');
    if ($liPattern.html() != patternTitle)
	$liPattern.html(patternTitle);
    jQuery('#' + inputId + '_description').html(patternDescription);

    /* case of select display */
    jQuery('#' + inputId + '_name').val(patternTitle);
    
    jQuery('#' + inputId + '_id').change();
}
/*Updating all the patterns list. Called from the pattternManager form */
updatePatternList = function(inputId, activePatternId){
    activePatternId = typeof activePatternId !== "undefined" ? activePatternId : "";

    if(!(activePatternId === "" && jQuery('#' + inputId + '_id').closest(".ngefield_pattern").find(".ngeinline-pattern-add").length > 0)){
        //If active Item not defined in parameter, keep current selected
        if (activePatternId === ""){
            activePatternId = jQuery('#' + inputId + '_id').val();
        }

        var $referenceTag = jQuery('#' + inputId + '_ref');	
        var patternName = $referenceTag.attr('data-name');
        var patternType = $referenceTag.attr('data-type');
	var obj_data_internal = jQuery('#internalform');
	if(obj_data_internal) {
	    var str_data_internal = JSON.stringify(obj_data_internal.serialize());
	    str_data_internal = str_data_internal.replace(/\"/g, "");
	}
	else
	    str_data_internal='{}';

        jQuery.ajax({
            url: baseUrl+"index.php?option=com_nge&view=field_ngepattern&layout=listfront&format=raw&" + str_data_internal,
            data: { id:activePatternId, name:patternName, type:patternType, inputid: inputId},
            success: function (result) {
                jQuery('#' + inputId).find('ul.ngepatterns-list').html(result);
                /*initNgePattern(jQuery("#" + inputId));*/
                $activePattern = jQuery('#' + inputId).find('li[data-id="' + activePatternId + '"]');
                $activePattern.click(); /*Update Hidden value and description*/
                jQuery(document).trigger( "ngeConfigChange");
            },
            error: function (result) {
                showMessage('Error', 'Error while loading patterns list. Please reload screen.');
            }
        });
    }
}

getAjaxPatternEdition = function($selectButton){
    var patternContent = jQuery("#ngepattern-content");

	var patternName =	$selectButton.attr('data-name');
	var patternType =	$selectButton.attr('data-type');		
	var inputId =	$selectButton.attr('data-id');
	var patternId =	jQuery('#' + inputId + '_id').val();
	
	var formUrl = "index.php?option=com_nge&view=inlineconfig&content=pattern&format=raw&layout=form&type=pattern&pattern_name="+patternName+"&pattern_type="+patternType+"&pattern_id="+patternId;
	loadInlineForm({url: formUrl,
		    element: $selectButton,
		    title: '<span class="icomoon-paint-format"></span>&nbsp;Edit pattern',
		    backgroundColor: '7B8FA1',
		    width:  900,
		    height: 700,
		    refresh : function($element, itemType, itemId){
    		    switch (itemType){
    			case 'icomoon' :
				var currentClassGlyph= $element.attr("class").split(' ').join('|');
				currentClassGlyph = currentClassGlyph+'|';
				currentClassGlyph = currentClassGlyph.match(/icomoon-([^\|]+)\|/);
				$element.removeClass("icomoon-"+currentClassGlyph[1])
				.addClass("icomoon-"+itemId);
    			    break;
			    default:	
				break;
			}
		    },
		    submit : function(element, oldItemId, currentItemId){
			if(currentItemId !== oldItemId){
			    var elementData = JSON.parse(element.attr('data-nge'));
			    var structureData = element.closest('.ngeeditablestructure').data('nge');

			    if (storeInline(structureData.id, structureData.type, elementData.source, "icomoon-"+currentItemId)){
				nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
			    }
			}
		    },
		    cancel : function(element, oldItemId, currentItemId){
			if(currentItemId !== oldItemId){
			    var currentClassGlyph= element.attr("class").split(' ').join('|');
			    currentClassGlyph = currentClassGlyph+'|';
			    currentClassGlyph = currentClassGlyph.match(/icomoon-([^\|]+)\|/);                
			    element.removeClass("icomoon-"+currentClassGlyph[1])
			    .addClass("icomoon-"+oldItemId);
			}
		    }
		});

};


/********** FIELDMULTIPLELAYOUT **********/
initFormsMultipleLayout = function($selector){  
    jQuery(document).on("click", "[id=tab_more]", function( event ) {
        event.preventDefault();
        var ngeMultipleInputId = jQuery(this).attr("data-id");
        
        var ngeMultipleInput = jQuery("#"+ngeMultipleInputId+"_id");
        var currentUL = jQuery("#"+ngeMultipleInputId+"_tabs");
        
        var tabsNumber = ngeMultipleInput.val();

        if (tabsNumber < currentUL.find(">li").length-1){
            /*display tab : removing style="display:none" attribute*/
            /*utilise removeClass hidden ou hide show*/
            currentUL.find(">li:eq("+tabsNumber+")").removeAttr("style");
            currentUL.find(">li:eq("+tabsNumber+") a").tab("show");
            /*jQuery("#tabid"+tabsNumber+" a").tab("show");						*/

            tabsNumber++;								
            ngeMultipleInput.val(tabsNumber);
            ngeMultipleInput.trigger("change");
        }else {
            alert("If you want to add more elements, please save this form and open it again.");
        }		
    });
    
    /*New tabs */
    jQuery(document).on("click", ".ngemultiple_more", function( event ) {
        event.preventDefault();
	var ngeMultipleId = jQuery(this).closest('.ngemultiple').attr('id');
	
//        var ngeMultipleInputId = jQuery(this).attr("data-id");
        
        var $ngeMultipleInput = jQuery("#"+ngeMultipleId+"_id");
        var currentUL = jQuery("#"+ngeMultipleId+"_tabs");
        
	var tabsNumber = $ngeMultipleInput.val();

        if (tabsNumber < currentUL.find(">li").length-1){
            /*display tab : removing style="display:none" attribute*/
            /*utilise removeClass hidden ou hide show*/
            currentUL.find(">li:eq("+tabsNumber+")").removeAttr("style");
            currentUL.find(">li:eq("+tabsNumber+") a").tab("show");
            /*jQuery("#tabid"+tabsNumber+" a").tab("show");						*/

            tabsNumber++;								
            $ngeMultipleInput.val(tabsNumber);
            $ngeMultipleInput.trigger("change");
        }else {
            alert("If you want to add more elements, please save this form and open it again.");
        }		
    });
        
        /*New tabs */
/*    jQuery(".ngemultipletabs_more" ).click(function( event ) {
        event.preventDefault();
        var ngeMultipleInputId = jQuery(this).closest('.ngemultiple').attr('id');
        
    var ngeMultipleInput = jQuery("#"+ngeMultipleInputId+"_id");
        var currentUL = jQuery("#"+ngeMultipleInputId+"_tabs");
        
        var tabsNumber = ngeMultipleInput.val();

        if (tabsNumber < currentUL.find(">li").length-1){
            /-*display tab : removing style="display:none" attribute*-/
            /-*utilise removeClass hidden ou hide show*-/
            currentUL.find(">li:eq("+tabsNumber+")").removeAttr("style");
            currentUL.find(">li:eq("+tabsNumber+") a").tab("show");
            /-*jQuery("#tabid"+tabsNumber+" a").tab("show");						*-/

            tabsNumber++;								
            ngeMultipleInput.val(tabsNumber);
            ngeMultipleInput.trigger("change");
        }else {
            alert("If you want to add more elements, please save this form and open it again.");
        }		
    });
*/
    
    
        /*New tabs */
    jQuery(document).on("click", ".ngemultipletabs_more", function( event ) {
	    event.preventDefault();
	var ngeMultipleId = jQuery(this).closest('.ngemultiple').attr('id');
	var $ngeMultipleInput = jQuery(this).closest('.ngemultiple');
	var namesRoot = jQuery('#'+ngeMultipleId).attr("data-root");
        
	//jQuery(this).prev().clone(true).removeClass('active').insertBefore(this);
	jQuery(this).prev().clone().insertBefore(this).removeClass('active');
	//Clone true = with events
	var $newContent = jQuery("#"+ngeMultipleId + "_content_more").clone();

	//Modify tabmore index
	var itemsCount = jQuery("#"+ngeMultipleId+" > div.tab-content").children().length;
	var oldprefix = namesRoot + '['+parseInt(itemsCount-1)+']';
	var newprefix = namesRoot + '[' + itemsCount + ']';
	var oldSelector = '[name^="' + oldprefix + '"]';
	//Names
	jQuery("#"+ngeMultipleId + "_content_more").find(oldSelector).each(function( index, value ) {
	    jQuery(this).attr('name', jQuery(this).attr('name').replace(oldprefix, newprefix));
	});
	//Ids
	jQuery("#"+ngeMultipleId + "_content_more").find("[id*=_"+parseInt(itemsCount-1)+"_]").each(function( index, value ) {
	    var oldId = jQuery(this).attr('id');
	    jQuery(this).attr('id', oldId.replace("_"+(itemsCount-1)+"_", "_"+(itemsCount)+"_"));
	});
        
        /*Change new content tabs id*/
        var $tabs = $newContent.find("ul.nav-tabs");
	$tabs.each(function() {
            var $tab_li_a = jQuery(this).find("a");
            var date = new Date();
            
            $tab_li_a.each(function() {
                var href = jQuery(this).attr('href');
                var $tabContent_div = $tabs.next().find(href);
                var newHref = href+"_"+itemsCount+"_"+date.getTime();
                var newHrefDiv = newHref.replace("#", "");
                
                jQuery(this).attr('href', newHref);
                $tabContent_div.attr("id", newHrefDiv);
            });
        });

	//Adding new cloned content and initialising javascripts events
	$newContent.insertBefore("#"+ngeMultipleId + "_content_more").attr('id', 'ngeMultipleId_tmp');
	initFields($newContent);

	var $ngeMultipleInput = jQuery("#"+ngeMultipleId+"_id");
	var tabsNumber = $ngeMultipleInput.val();
	tabsNumber++;
	$ngeMultipleInput.val(tabsNumber);

	//Reindexing all tabs
	updateMultipleTabRef(ngeMultipleId);
	
	//Instanciate tabs behavior
	jQuery(this).prev().find('a').click(function (e) {
	    e.preventDefault();
	    jQuery(this).tab('show');
	});
	jQuery(this).prev().find( ".ngemultiple-remove" ).click(function( event ) {
	    var index = jQuery(this).parent().index();
	    var ngeMultipleInputId = jQuery(this).closest('.ngemultiple').attr("id");
	    multipleTabRemove(ngeMultipleInputId, index);	
	});

	
	//Activate last tab	
	jQuery(this).prev().find('a').click();
	
	$ngeMultipleInput.trigger("change");
    });
    
    
    /* new multipleTabs*/
    /* Warning if modified see in tabs Dynamic add to add the clic bind */
    jQuery(document).on("click", ".ngemultiple-remove", function( event ) {
        event.preventDefault();
        event.stopPropagation();
        var index = jQuery(this).parent().index();
        var ngeMultipleInputId = jQuery(this).closest('.ngemultiple').attr("id");
	if (jQuery(this).closest('.ngemultiple').hasClass("ngemultipletabs"))
	    multipleTabRemove(ngeMultipleInputId, index);	
	else
	if (jQuery(this).closest('.ngemultiple').hasClass("ngemultiplelist"))
	    multipleListRemove(ngeMultipleInputId, index);	
    });


    /* Sortable tabs*/
    //Append handles to all sortable tags    
//    	jQuery(".ngemultipletabs >ul").initialize(function () {
//	//    Many bugs at that time
//	    var list = jQuery(this)[0];
//	    var editableList = Sortable.create(list, {
//	      filter: '.ngesortable-remove',
//		animation: 150,
//	    onUpdate: function (evt){
//		var el = evt.item; // the current dragged HTMLElement
//		multipleTabMove(jQuery(evt.item).closest('.ngemultiple'), evt.oldIndex, evt.newIndex);
//	    },
//	      onFilter: function (evt) {
//		var el = editableList.closest(evt.item); // get dragged item
//	      }
//	    });	    
//	});
//
///* Sortable list */
////jQuery(".ngemultiplelist >ul").children().prepend('<span class="ngesortable-handle">&#9776;</span><i class="ngesortable-remove">–</i>');
//	jQuery(".ngemultiplelist >ul").initialize(function () {
//	    var list = jQuery(this)[0];
//	    var editableList = Sortable.create(list, {
//	      filter: '.ngesortable-remove',
//		animation: 150,
//	    onUpdate: function (evt){
//		var el = evt.item; // the current dragged HTMLElement
//		multipleTabMove(jQuery(evt.item).closest('.ngemultiple'), evt.oldIndex, evt.newIndex);
//	    },
//	      onFilter: function (evt) {
//		var el = editableList.closest(evt.item); // get dragged item
//	      }
//	    });	    
//	});						


        /*New tabs */
    jQuery(document).on("click", ".ngemultiplelist_more", function( event ) {
        event.preventDefault();
        var ngeMultipleInputId = jQuery(this).closest('.ngemultiple').attr('id');
        
        var ngeMultipleInput = jQuery("#"+ngeMultipleInputId+"_id");
        var currentUL = jQuery("#"+ngeMultipleInputId+"_items");
        
        var itemsNumber = ngeMultipleInput.val();
        if (itemsNumber < currentUL.find(">li").length-1){
            /*display tab : removing style="display:none" attribute*/
            /*utilise removeClass hidden ou hide show*/
            currentUL.find(">li:eq("+itemsNumber+")").removeAttr("style");
            /*jQuery("#tabid"+tabsNumber+" a").tab("show");						*/

            itemsNumber++;								
            ngeMultipleInput.val(itemsNumber);
            ngeMultipleInput.trigger("change");
        }else {
            alert("If you want to add more elements, please save this form and open it again.");
        }		
    });

};


confirmDelete = function(ngeMultipleInputId, tabno){
    var $ngeMultipleInput = jQuery("#"+ngeMultipleInputId+"_id");
    var tabsNumber = ($ngeMultipleInput.val() - 1);
    jQuery(".tooltip").remove();
    jQuery("#"+ngeMultipleInputId+"tabcontent"+tabno).remove();
    jQuery("#"+ngeMultipleInputId+"tabid"+tabno).remove();					

    updateTabNumber(ngeMultipleInputId, tabno, tabsNumber);

    $ngeMultipleInput.val(tabsNumber);
    $ngeMultipleInput.change();
};

multipleTabRemove = function(ngeMultipleId, index){
    jQuery(".tooltip").remove();
    var namesRoot = jQuery('#'+ngeMultipleId).attr("data-root");
    var $ngeMultipleInput = jQuery("#"+ngeMultipleId+"_id");
    var itemsCount = jQuery("#"+ngeMultipleId).find('.tab-content').children().length;
    
    jQuery("#"+ngeMultipleId+"_tab_"+index).remove();					
    jQuery("#"+ngeMultipleId+"_content_"+index).remove();
    /*update names */
    for (i = index; i < itemsCount; i++) {    	
	var oldprefix = namesRoot + '['+i+']';
	var newprefix = namesRoot + '[' + parseInt(i-1) + ']';
	var tabSelector = '[name^="' + oldprefix + '"]';
	jQuery(tabSelector).each(function( index, value ) {
	    jQuery(this).attr('name', jQuery(this).attr('name').replace(oldprefix, newprefix));
	});
    }
    
    $ngeMultipleInput.val($ngeMultipleInput.val() - 1);   
    updateMultipleTabRef(ngeMultipleId);
};

multipleListRemove = function(ngeMultipleId, index){
    jQuery(".tooltip").remove();
    var namesRoot = jQuery('#'+ngeMultipleId).attr("data-root");
    var $ngeMultipleInput = jQuery("#"+ngeMultipleId+"_id");
    var itemsCount = jQuery("#"+ngeMultipleId+" >ul").children().length;
    jQuery("#"+ngeMultipleId+" >ul >li:nth-child(" + parseInt(index + 1) + ")").remove();
    /*update names */
    for (i = index; i < itemsCount; i++) {    	
	var oldprefix = namesRoot + '['+i+']';
	var newprefix = namesRoot + '[' + parseInt(i-1) + ']';
	var tabSelector = '[name^="' + oldprefix + '"]';
	jQuery(tabSelector).each(function( index, value ) {
	    jQuery(this).attr('name', jQuery(this).attr('name').replace(oldprefix, newprefix));
	});
    }
    
    $ngeMultipleInput.val($ngeMultipleInput.val() - 1);   
};

multipleTabMove = function($ngeMultiple, oldIndex, newIndex){
    //Modify all prefix names of moved tab for change at the end	
    var ngeRoot = jQuery($ngeMultiple).attr("data-root");
    var oldprefix = ngeRoot + '['+oldIndex+']';
    var newprefix = ngeRoot + '['+newIndex+']';
    var tmpprefix = ngeRoot + '[9999]';
    var oldSelector = '[name^="' + oldprefix + '"]';
    var tmpSelector = '[name^="' + tmpprefix + '"]';
    var checkboxName = "";
    
    //Interchange values
    $ngeMultiple.find(oldSelector).each(function( index, value ) {
	var name = jQuery(this).attr('name');
	var oldValue = jQuery(this).val();
	var newName = name.replace(oldprefix, newprefix);
	var $newInput = $ngeMultiple.find('[name="' + newName + '"]');
	var newValue  = $newInput.val();
        
        /*Specific to checkbox field*/
        if($newInput.attr("type") === "checkbox"){
            if($newInput.attr("name") !== checkboxName){
                /*OldValue*/
                $checkboxOldValue = jQuery(this).closest("div.fieldcheckbox");
                var hiddenValOldValue = $checkboxOldValue.find("input[type='checkbox']").serializeArray();
                var arrayValOldValue = [];

                jQuery.each(hiddenValOldValue, function( index, val ) {
                    arrayValOldValue.push(val.value);
                });

                oldValue = arrayValOldValue;
                /*NewValue*/
                $checkboxNewValue = $newInput.closest("div.fieldcheckbox");
                var hiddenValNewValue = $checkboxNewValue.find("input[type='checkbox']").serializeArray();
                var arrayValNewValue = [];

                jQuery.each(hiddenValNewValue, function( index, val ) {
                    arrayValNewValue.push(val.value);
                });

                newValue = arrayValNewValue;

                checkboxName = $newInput.attr("name");

                $ngeMultiple.find('[name="' + name + '"]').val(newValue);
                $newInput.val(oldValue);
            }
        }else //Field filemanager
        if($newInput.hasClass("ngefield-filemanager-id")){
	    jQuery(this).val(newValue);
	    $newInput.val(oldValue);   	    
	$oldFilemanagerText = jQuery(this).parent().find(".ngefield-filemanager-name");
	$newFilemanagerText = $newInput.parent().find(".ngefield-filemanager-name");
	oldTextValue = $oldFilemanagerText.val();
	newTextValue = $newFilemanagerText.val();
	$oldFilemanagerText.val(newTextValue);
	$newFilemanagerText.val(oldTextValue);
        }else //Field article
        if($newInput.hasClass("ngefield-article-id")){
	    jQuery(this).val(newValue);
	    $newInput.val(oldValue);   	    
	$oldArticleText = jQuery(this).parent().find(".ngefield-article-name");
	$newArticleText = $newInput.parent().find(".ngefield-article-name");
	oldTextValue = $oldArticleText.val();
	newTextValue = $newArticleText.val();
	$oldArticleText.val(newTextValue);
	$newArticleText.val(oldTextValue);
        }else //Field module
        if($newInput.hasClass("ngefield-module-id")){
	    jQuery(this).val(newValue);
	    $newInput.val(oldValue);   	    
	$oldModuleText = jQuery(this).parent().find(".ngefield-module-name");
	$newModuleText = $newInput.parent().find(".ngefield-module-name");
	oldTextValue = $oldModuleText.val();
	newTextValue = $newModuleText.val();
	$oldModuleText.val(newTextValue);
	$newModuleText.val(oldTextValue);
        }else //Editor
        if($newInput.hasClass("fieldeditor")){
	    jQuery(this).val(newValue);
	    $newInput.val(oldValue);   	    
	$oldEditorText = jQuery(this).parent().find(".cke_editable");
	$newEditorText = $newInput.parent().find(".cke_editable");
	oldEditorValue = $oldEditorText.html();
	newEditorValue = $newEditorText.html();
	$oldEditorText.html(newEditorValue);
	$newEditorText.html(oldEditorValue);
        }		
        else{
            /*For other case*/
            jQuery(this).val(newValue);
            $newInput.val(oldValue);   
        }
    });
    var ngeMultipleId = jQuery($ngeMultiple).attr("id");
    updateMultipleTabRef(ngeMultipleId);
    
    var selectorContentOldindex = jQuery($ngeMultiple).find("ul li:eq("+oldIndex+") a").attr("href");
    var selectorContentNewindex = jQuery($ngeMultiple).find("ul li:eq("+newIndex+") a").attr("href");
    updateFields(jQuery(selectorContentOldindex).add(jQuery(selectorContentNewindex)));
}

multipleTabMoveOld = function($ngeMultiple, oldIndex, newIndex){
    //Modify all prefix names of moved tab for change at the end	
    var ngeRoot = jQuery($ngeMultiple).attr("data-root");
    var oldprefix = ngeRoot + '['+oldIndex+']';
    var tmpprefix = ngeRoot + '[9999]';
    var oldSelector = '[name^="' + oldprefix + '"]';
    var tmpSelector = '[name^="' + tmpprefix + '"]';
    $ngeMultiple.find(oldSelector).each(function( index, value ) {
	jQuery(this).attr('name', jQuery(this).attr('name').replace(oldprefix, tmpprefix));
    });

    // moving from left ro right
    if(oldIndex<=newIndex) {
	//Moving Detail content into new position. Adding 1 more (index changes while moving)
	var ngeMultiple = $ngeMultiple.attr('id');
    
	jQuery('#' + ngeMultiple + '>ul>div.tab-content >div:nth-child('+parseInt(oldIndex+1)+')').insertBefore(jQuery('#' + ngeMultiple + '>ul>div.tab-content >div:nth-child('+parseInt(newIndex+2)+')'));	
        var IndexToMove = oldIndex+1;
        while (IndexToMove <= newIndex) {
            var IndexDest   = IndexToMove-1;
            var prefixStart = ngeRoot + '['+ IndexToMove +']';
            var prefixDest  = ngeRoot + '['+ IndexDest +']';
            var selectorToMove = '[name^="' + prefixStart + '"]';
            //$ngeMultiple.find('[name^="' + prefixStart + '"][label]').val(prefixDest);
            $ngeMultiple.find(selectorToMove).each(function( index, value ) {
        	    jQuery(this).attr('name', jQuery(this).attr('name').replace(prefixStart, prefixDest));
        	});            
            IndexToMove++;
        }
    }else {
	//Moving Detail content into new position
	 jQuery('#' + ngeMultiple + '>ul>div.tab-content >div:nth-child('+parseInt(oldIndex+1)+')').insertBefore(jQuery('#' + ngeMultiple + '>ul>div.tab-content >div:nth-child('+parseInt(newIndex+1)+')'));
        var IndexToMove = oldIndex-1;
        while (IndexToMove >= newIndex) {
            var IndexDest   = IndexToMove+1;
            var prefixStart = ngeRoot + '['+ IndexToMove +']';
            var prefixDest  = ngeRoot + '['+ IndexDest +']';
            var selectorToMove = '[name^="' + prefixStart + '"]';
            jQuery('[name^="' + prefixStart + '"][label]').val(prefixDest);
            $ngeMultiple.find(selectorToMove).each(function( index, value ) {
        	    jQuery(this).attr('name', jQuery(this).attr('name').replace(prefixStart, prefixDest));
        	});
            
            IndexToMove--;
        }
    }

    // moved tab has temporary names. Setting new index
    	var newprefix = ngeRoot + '[' + newIndex + ']';
	$ngeMultiple.find(tmpSelector).each(function( index, value ) {
	    jQuery(this).attr('name', jQuery(this).attr('name').replace(tmpprefix, newprefix));
	});
    
    var ngeMultipleId = jQuery($ngeMultiple).attr("id");
    updateMultipleTabRef(ngeMultipleId);
}

updateTabNumber = function(ngeMultipleInputId, deleteTabNumber, tabsNumber){
    var currentUL = jQuery("#"+ngeMultipleInputId+"_tabs");
     
    var tabsObject = currentUL.children();
    if(deleteTabNumber < tabsNumber){	
        tabsObject.each(function(){

            currentTabId = jQuery(this).attr("id");		
            currentTabNumber = currentTabId.replace(ngeMultipleInputId+"tabid", "");

            if(!isNaN(currentTabNumber) && (parseInt(currentTabNumber) > parseInt(deleteTabNumber))){
                jQuery(this).attr("id", ngeMultipleInputId+"tabid"+(currentTabNumber-1));
                jQuery(this).children().attr("href", "#"+ngeMultipleInputId+"tabcontent"+(currentTabNumber-1));
                jQuery(this).children().html(currentTabNumber);
                jQuery("#"+ngeMultipleInputId+"tabcontent"+currentTabNumber).find("div div.tabdelete").attr("data-number", (currentTabNumber-1));
                jQuery("#"+ngeMultipleInputId+"tabcontent"+currentTabNumber).attr("id", ngeMultipleInputId+"tabcontent"+(currentTabNumber-1));
            }
        });	
    }
    if (deleteTabNumber <= tabsNumber){
        if(deleteTabNumber == tabsNumber){
            jQuery("#"+ngeMultipleInputId+"tabid"+parseInt(deleteTabNumber-1)).addClass( "active" );
            jQuery("#"+ngeMultipleInputId+"tabcontent"+parseInt(deleteTabNumber-1)).addClass( "active" );
        }else{
            jQuery("#"+ngeMultipleInputId+"tabid"+parseInt(deleteTabNumber)).addClass( "active" );
            jQuery("#"+ngeMultipleInputId+"tabcontent"+parseInt(deleteTabNumber)).addClass( "active" );
        }
    }
};

updateMultipleTabRef = function(ngeMultipleId){
    
    var $ngeMultipleInput = jQuery("#"+ngeMultipleId+"_id");
    
    var itemsCount = jQuery("#"+ngeMultipleId+" >ul>li").length-1;
    
    for (i = 0; i < itemsCount; i++) {    	
	var $tab = jQuery("#"+ngeMultipleId+" >ul>li:nth-child("+parseInt(i+1)+")");
	$tab.attr('id', ngeMultipleId+"_tab_"+i); 
	$tab.find('a').attr('href', '#'+ngeMultipleId+"_content_"+i).html(parseInt(i+1));
	
        jQuery("#"+ngeMultipleId+" >div.tab-content>div:nth-child("+parseInt(i+1)+")")
        .addClass("nge-tab-content")
        .attr({
            'id' : ngeMultipleId+"_content_"+i, 
            'nge-tab-index' : i,
            'nge-tab-multiple' : 1
        });
    }
     $ngeMultipleInput.change();
};


/********** FIELDMULTIPLELISTLAYOUT **********/
initFormsMultipleListLayout = function(){ 
  
    jQuery(document).on("click", "[id=item_more]", function(event) {
	        event.preventDefault();
	        var ngeMultipleInputId = jQuery(this).attr("data-id");
	        
	        var ngeMultipleInput = jQuery("#"+ngeMultipleInputId+"_id");
	        var currentUL = jQuery("#"+ngeMultipleInputId+"_items");
	        
	        var itemsNumber = ngeMultipleInput.val();

	        if (itemsNumber < currentUL.find(">li").length-1){
	            /*display tab : removing style="display:none" attribute*/
	            /*utilise removeClass hidden ou hide show*/
	            currentUL.find(">li:eq("+itemsNumber+")").removeAttr("style");
	            /*jQuery("#tabid"+tabsNumber+" a").tab("show");						*/

	            itemsNumber++;								
	            ngeMultipleInput.val(itemsNumber);
	            ngeMultipleInput.trigger("change");
	        }else {
	            alert("If you want to add more elements, please save this form and open it again.");
	        }
    });
    jQuery(document).on("click", ".itemdelete", function( event ) {
        event.preventDefault();
        event.stopPropagation();
        
        var ngeMultipleInputId = jQuery( "#item_more" ).attr("data-id");
        var currentTabNumber = jQuery(this).data("number");
        
        confirmItemDelete(ngeMultipleInputId, currentTabNumber);	
    });
    
};

confirmItemDelete = function(ngeMultipleInputId, tabno){
    var ngeMultipleInput = jQuery("#"+ngeMultipleInputId+"_id");
    var itemsNumber = (ngeMultipleInput.val() - 1);
    jQuery(".tooltip").remove();
    jQuery("#itemcontent"+tabno).remove();
    
    updateItemNumber(ngeMultipleInputId, tabno, itemsNumber);

    ngeMultipleInput.val(itemsNumber);
    ngeMultipleInput.change();
};

updateItemNumber = function(ngeMultipleInputId, deleteTabNumber, itemsNumber){
    var currentUL = jQuery("#"+ngeMultipleInputId+"_tabs");
     
    var tabsObject = currentUL.children();
    if(deleteTabNumber < itemsNumber){	
        tabsObject.each(function(){

            currentTabId = jQuery(this).attr("id");		
            currentTabNumber = currentTabId.replace("tabid", "");

            if(!isNaN(currentTabNumber) && (parseInt(currentTabNumber) > parseInt(deleteTabNumber))){
                jQuery(this).attr("id", "tabid"+(currentTabNumber-1));
                jQuery(this).children().attr("href", "#tabcontent"+(currentTabNumber-1));
                jQuery(this).children().html(currentTabNumber);
                jQuery("#tabcontent"+currentTabNumber).find("div div.tabdelete").attr("data-number", (currentTabNumber-1));
                jQuery("#tabcontent"+currentTabNumber).attr("id", "tabcontent"+(currentTabNumber-1));
            }
        });	
    }
    if (deleteTabNumber <= itemsNumber){
        if(deleteTabNumber == itemsNumber){
            jQuery("#tabid"+parseInt(deleteTabNumber-1)).addClass( "active" );
            jQuery("#tabcontent"+parseInt(deleteTabNumber-1)).addClass( "active" );
        }else{
            jQuery("#tabid"+parseInt(deleteTabNumber)).addClass( "active" );
            jQuery("#tabcontent"+parseInt(deleteTabNumber)).addClass( "active" );
        }
    }
};

/************************* layout *************************************/

initFormsLayout = function(){
// Advanced groups

	jQuery('div.ngefieldlayout').initialize(function(){
	    var id = jQuery(this).attr('id');    
	    Sortable.create(document.getElementById(id+'_layout'), { group: id, sort:true, animation:150, pull:true, put:true, 
		onUpdate: function (evt/**Event*/){
		    document.getElementById(id+'_name').innerHTML(document.getElementById(id+'_layout').innerHTML);
		}
	    });
	    Sortable.create(document.getElementById(id+'_fields'), { group: id, sort:false, animation:150, pull:'clone', put:false });
	    	    
	});
/*
	[{
		class: 'ngelayout',
		pull: true,
		put: true
	},
	{
		class: 'advanced-fields',
		pull: 'clone',
		put: false
	}].forEach(function (groupOpts, i) {
		Sortable.create(document.getElementsByClassName('advanced-' + (i + 1)), {
			sort: (i != 1),
			group: groupOpts,
			animation: 150
		});
	});*/
};

/************************* Stock Exchange *************************************/

initNgeStockExchange = function($selector){
    var $stockExchange = $selector.find(".ngestockexchange");
    
    /*Remove modal if it's a new instance*/
    jQuery("#ngestockexchange").remove();
    jQuery("#ngecommoditie").remove();

    if(typeof $stockExchange !== "undefined" && $stockExchange.length > 0){
        var $inputStockExchange = $selector.find("input.ngestockexchange-input");
        var $buttonAddStock = $selector.find("span.ngestockexchange-add");
        var $stockContainer = $buttonAddStock.parent().find(".ngestockexchange-container");
        var $buttonInfoStockexchange = $selector.find("span.ngestockexchange-info");
        var $buttonLoadingStockexchange = $selector.find("span.ngestockexchange-loading");
        var tooltipAddDescription = $buttonAddStock.attr("tooltip-description");
        var tooltipInfoDescription = $buttonInfoStockexchange.attr("tooltip-description");
        var modalTitle = $buttonAddStock.attr("modal-title");
        var modalInfoTitle = $buttonInfoStockexchange.attr("modal-title");
        var isMultiple = (typeof $stockExchange.attr("data-multiple") !== "undefined" && $stockExchange.attr("data-multiple") === "true") ? true : false;
        var type = (typeof $stockExchange.attr("data-type") !== "undefined" && $stockExchange.attr("data-type") !== "") ? $stockExchange.attr("data-type") : "stockexchange";
        
        var field = "field_nge"+type;
        var modalName = "nge"+type;
        var instrumentType = "bourse";
        
        switch(type) {
            case "stockexchange":
                instrumentType = "bourse";
                break;
            case "commoditie":
                instrumentType = "commodite";
                break;
        }
        /*Destroy tooltip already initialized*/
        $buttonAddStock.tooltip('destroy');
        $buttonInfoStockexchange.tooltip('destroy');

        /*Initialize button add tooltip*/
        $buttonAddStock.tooltip({
            title: tooltipAddDescription,
            trigger: 'hover',
            placement: 'bottom',
            template: '<div class="tooltip" style="z-index:1051"><div class="tooltip-arrow"></div><div class="tooltip-inner" style="max-width:150px;"></div></div></div>'
        });
	
        $buttonInfoStockexchange.tooltip({
            title: tooltipInfoDescription,
            trigger: 'hover',
            placement: 'bottom',
            template: '<div class="tooltip" style="z-index:1051"><div class="tooltip-arrow"></div><div class="tooltip-inner" style="max-width:150px;"></div></div></div>'
        });

        /*Info button event*/
        $buttonInfoStockexchange.unbind('click').click(function(){    
            /*Load stock exchange modal*/
            var data = {};

            ngetools.loadModal({
                url : rootUrl+"index.php?option=com_nge&view="+field+"&layout=information&format=raw",
                title: '<span style="margin-right:5px;" class="icomoon icomoon-coin-dollar"></span>&nbsp;'+modalInfoTitle,
                backgroundColor: '#555D83',
                width: 70,
                height: 75,
                responsive: true,
                modalId: modalName+"Info",
                buttons : {
                    cancel: {
                        label: "",
                        stopEventsPropagation: false,
                        callback: function ($button) {
                            $button.closest('.modal').modal("hide");
                        }
                    }
                },
                callback: function (result) {
                    result.css({"overflow": "auto"});
                }
            });
        });

        /*Add button event*/
        $buttonAddStock.unbind('click').click(function(){
            /*Load stock exchange modal*/
            var $modalNgeFieldStockExchange = jQuery("#"+modalName);
            if($modalNgeFieldStockExchange.length > 0){/*Only load stock exchange modal the first time*/
                $modalNgeFieldStockExchange.data("jsonStockExchange", {});
                $modalNgeFieldStockExchange.modal("show");
            }else{ /*First time : We load the modal*/
                var data = {};
                
                ngetools.loadModal({
                    url : rootUrl+"index.php?option=com_nge&view="+field+"&layout=search&format=raw&isMultiple="+isMultiple,
                    title: '<span style="margin-right:5px;" class="icomoon icomoon-coin-dollar"></span>&nbsp;'+modalTitle,
                    backgroundColor: '#7B8FA1',
                    width:  70,
                    height: 65,
                    responsive: true,
                    modalId: modalName,
                    buttons : {
                        cancel: {
                            label: "",
                            stopEventsPropagation: false,
                            callback: function ($button) {
                                $button.closest('.modal').modal("hide");
                            }
                        },
                        submit: {
                            label: "",
                            stopEventsPropagation: false,
                            callback: function ($button) {
                                var $modal = $button.closest('.modal');
                                var value = $modal.data("jsonStockExchange");
                                var instrument = "";
                                    
                                switch(type) {
                                    case "stockexchange":
                                        instrument = instrumentType+":"+value[7]+":"+value[0];
                                        break;
                                    case "commoditie":
                                        if(typeof value.exchange !== "undefined"){
                                            instrument = instrumentType+":"+value.exchange+":"+value.symbol;
                                        }
                                        if(typeof value.idmatiere !== "undefined"){
                                            instrument = "bourse:future:"+value.idmatiere+":"+value.echeance;
                                        }
                                        break;
                                }
                                
                                if(!isMultiple){/*If single value is expected*/
                                    var $inputHiddenValue = $stockContainer.parent().find("input");
                                    
                                    if(instrument !== ""){
                                        $inputHiddenValue.val(instrument);
                                        $inputHiddenValue.trigger('change');

                                        $buttonLoadingStockexchange.fadeIn("fast");

                                        jQuery.ajax({
                                            url: rootUrl+"index.php?option=com_nge&view="+field+"&layout=instrument_information&format=raw&instrument="+instrument,
                                            success : function(resultHtml){
                                                try {
                                                    $stockContainer.fadeOut("fast", function(){
                                                        $stockContainer.html(resultHtml).fadeIn("fast");
                                                        $buttonLoadingStockexchange.fadeOut("fast");
                                                    });
                                                } catch (err) {
                                                    console.error("Error : to load stock information!<br>" + err.toString());
                                                }
                                            },
                                            error : function(){
                                                console.error("Error: to access to stock information");   
                                            }
                                        });
                                    }
                                }else{/*If one or more values ​​are expected*/
                                    var $handsontable = $buttonAddStock.parent().find("div.nge-handsontable-render");
                                    var handsontable = $handsontable.handsontable("getInstance");
                                    /*If no instance already exist, build one. Else do nothing or return error*/
                                    if(typeof handsontable !== "undefined"){
                                        var currentData = handsontable.getData();
                                        
                                        $buttonLoadingStockexchange.fadeIn("fast");
                                        
                                        if(type === "stockexchange"){ /*stockexchange*/
                                            jQuery.ajax({
                                                url: rootUrl+"index.php?option=com_nge&view="+field+"&layout=instrument_json&format=raw&instrument="+instrument,
                                                success : function(resultJson){
                                                    try {
                                                        var result = JSON.parse(resultJson);

                                                        if(currentData.length === 1 && (currentData[0][0] === null || currentData[0][0] === "")){
                                                            var newRow = [instrument, result.libelle];
                                                            jQuery.extend( true, currentData[0], newRow);
                                                        }else{
                                                            var newRow = Array(currentData[0].length).fill(null);
                                                            newRow[0] = instrument;
                                                            newRow[1] = result.libelle;
                                                            currentData.push(newRow);
                                                        }

                                                        handsontable.loadData(currentData);

                                                        $buttonLoadingStockexchange.fadeOut("fast");
                                                    } catch (err) {
                                                        console.error("Error : to load stock information!<br>" + err.toString());
                                                    }
                                                },
                                                error : function(){
                                                    console.error("Error: to access to stock information");   
                                                }
                                            });
                                        }else{ /*commodities intraday*/
                                            var newRow = [];
                                            
                                            if(typeof value.exchange !== "undefined"){
                                                newRow = [instrument, value.longname, null];
                                            }else if (typeof value.idmatiere !== "undefined"){
                                                newRow = [instrument, value.libelle, null];
                                            }
                                            
                                            if(newRow.length > 0){
                                                if(currentData.length === 1 && (currentData[0][0] === null || currentData[0][0] === "")){
                                                    currentData[0] = newRow;
                                                }else{
                                                    currentData.push(newRow);
                                                }

                                                handsontable.loadData(currentData);
                                            }
                                            
                                            $buttonLoadingStockexchange.fadeOut("fast");
                                        }
                                    }
                                }

                                $modal.modal("hide");
                            }
                        }
                    },
                    callback: function (result) {}
                });
            }
        });

        /*Add current value inside the table*/
        if(!isMultiple){/*If single value is expected*/
            /*Only when no multiple value because there are save in the data base and not when multiple is false*/
            var inputValue = $inputStockExchange.val();
            var inputValueSplit = inputValue.split(":");

            if(instrumentType === inputValueSplit[0]){                       
                $buttonLoadingStockexchange.fadeIn("fast");

                jQuery.ajax({
                    url: rootUrl+"index.php?option=com_nge&view="+field+"&layout=instrument_information&format=raw&instrument="+instrumentType+":"+inputValueSplit[1]+":"+inputValueSplit[2],
                    success : function(resultHtml){
                        try {
                            $stockContainer.fadeOut("fast", function(){
                                $stockContainer.html(resultHtml).fadeIn("fast");
                                $buttonLoadingStockexchange.fadeOut("fast");
                            });
                        } catch (err) {
                            console.error("Error : to load stock information!<br>" + err.toString());
                        }
                    },
                    error : function(){
                        console.error("Error: to access to stock information");   
                    }
                });
            }
        }
    }
};

/************************* Commodities *************************************/

initNgeCommodities = function($selector){
};

/*External librairies*/
/**
 * jQuery serializeObject, serializeJson
 * @copyright 2014, macek <paulmacek@gmail.com>
 * @link https://github.com/macek/jquery-serialize-object
 * @license BSD
 * @version 2.5.0
 */
!function(e,i){if("function"==typeof define&&define.amd)define(["exports","jquery"],function(e,r){return i(e,r)});else if("undefined"!=typeof exports){var r=require("jquery");i(exports,r)}else i(e,e.jQuery||e.Zepto||e.ender||e.$)}(this,function(e,i){function r(e,r){function n(e,i,r){return e[i]=r,e}function a(e,i){for(var r,a=e.match(t.key);void 0!==(r=a.pop());)if(t.push.test(r)){var u=s(e.replace(/\[\]$/,""));i=n([],u,i)}else t.fixed.test(r)?i=n([],r,i):t.named.test(r)&&(i=n({},r,i));return i}function s(e){return void 0===h[e]&&(h[e]=0),h[e]++}function u(e){switch(i('[name="'+e.name+'"]',r).attr("type")){case"checkbox":return"on"===e.value?!0:e.value;default:return e.value}}function f(i){if(!t.validate.test(i.name))return this;var r=a(i.name,u(i));return l=e.extend(!0,l,r),this}function d(i){if(!e.isArray(i))throw new Error("formSerializer.addPairs expects an Array");for(var r=0,t=i.length;t>r;r++)this.addPair(i[r]);return this}function o(){return l}function c(){return JSON.stringify(o())}var l={},h={};this.addPair=f,this.addPairs=d,this.serialize=o,this.serializeJSON=c}var t={validate:/^[a-z_][a-z0-9_]*(?:\[(?:\d*|[a-z0-9_]+)\])*$/i,key:/[a-z0-9_]+|(?=\[\])/gi,push:/^$/,fixed:/^\d+$/,named:/^[a-z0-9_]+$/i};return r.patterns=t,r.serializeObject=function(){return new r(i,this).addPairs(this.serializeArray()).serialize()},r.serializeJSON=function(){return new r(i,this).addPairs(this.serializeArray()).serializeJSON()},"undefined"!=typeof i.fn&&(i.fn.serializeObject=r.serializeObject,i.fn.serializeJSON=r.serializeJSON),e.FormSerializer=r,r});


/*!
 * jQuery initialize - v1.1.0 - 06/02/2017
 * https://github.com/adampietrasiak/jquery.initialize
 *
 * Copyright (c) 2015-2016 Adam Pietrasiak
 * Released under the MIT license
 * https://github.com/timpler/jquery.initialize/blob/master/LICENSE
 */
(function($){"use strict";var combinators=[" ",">","+","~"];var fraternisers=["+","~"];var complexTypes=["ATTR","PSEUDO","ID","CLASS"];function grok(msobserver){if(!$.find.tokenize){msobserver.isCombinatorial=true;msobserver.isFraternal=true;msobserver.isComplex=true;return}msobserver.isCombinatorial=false;msobserver.isFraternal=false;msobserver.isComplex=false;var token=$.find.tokenize(msobserver.selector);for(var i=0;i<token.length;i++){for(var j=0;j<token[i].length;j++){if(combinators.indexOf(token[i][j].type)!=-1)msobserver.isCombinatorial=true;if(fraternisers.indexOf(token[i][j].type)!=-1)msobserver.isFraternal=true;if(complexTypes.indexOf(token[i][j].type)!=-1)msobserver.isComplex=true}}}var MutationSelectorObserver=function(selector,callback,options){this.selector=selector.trim();this.callback=callback;this.options=options;grok(this)};var msobservers=[];msobservers.initialize=function(selector,callback,options){var seen=[];var callbackOnce=function(){if(seen.indexOf(this)==-1){seen.push(this);$(this).each(callback)}};$(options.target).find(selector).each(callbackOnce);var msobserver=new MutationSelectorObserver(selector,callbackOnce,options);this.push(msobserver);var observer=new MutationObserver(function(mutations){var matches=[];function push(match){matches.push(match)}for(var m=0;m<mutations.length;m++){if(mutations[m].type=="attributes"){if(mutations[m].target.matches(msobserver.selector))matches.push(mutations[m].target);if(msobserver.isFraternal)mutations[m].target.parentElement.querySelectorAll(msobserver.selector).forEach(push);else mutations[m].target.querySelectorAll(msobserver.selector).forEach(push)}if(mutations[m].type=="childList"){for(var n=0;n<mutations[m].addedNodes.length;n++){if(!(mutations[m].addedNodes[n]instanceof Element))continue;if(mutations[m].addedNodes[n].matches(msobserver.selector))matches.push(mutations[m].addedNodes[n]);if(msobserver.isFraternal)mutations[m].addedNodes[n].parentElement.querySelectorAll(msobserver.selector).forEach(push);else mutations[m].addedNodes[n].querySelectorAll(msobserver.selector).forEach(push)}}}matches.forEach(function(match){$(match).each(msobserver.callback)})});var defaultObeserverOpts={childList:true,subtree:true,attributes:msobserver.isComplex};observer.observe(options.target,options.observer||defaultObeserverOpts)};$.fn.initialize=function(callback,options){msobservers.initialize(this.selector,callback,$.extend({},$.initialize.defaults,options))};$.initialize=function(selector,callback,options){msobservers.initialize(selector,callback,$.extend({},$.initialize.defaults,options))};$.initialize.defaults={target:document.documentElement,observer:null}})(jQuery);

initForms();