<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

require_once (NGEPATH_HELPERS.'/data/joomla/articledriver.php');
$article = NgeJoomlaArticleDriver::loadTable($id);
$created_by = JFactory::getUser($article->created_by)->name;
$updated_by = JFactory::getUser($article->modified_by)->name;
?>
<style>
    .nge-inline-elements-article-information{
        padding: 10px 20px;
    }  
    .article-information-item-title{
        font-weight: bold;
        text-align: center;
        background-color: rgba(6, 162, 220, 0.1);
        padding: 5px;
        font-size: 16px;
    }
    .article-information-item-content{
        padding: 5px;
        text-align: center;
        font-style: italic;
    }
    .article-information-item-inline{
         display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-flex-wrap: nowrap;
        -ms-flex-wrap: nowrap;
        flex-wrap: nowrap;
        -webkit-justify-content: flex-start;
        -ms-flex-pack: start;
        justify-content: flex-start;
        -webkit-align-content: flex-start;
        -ms-flex-line-pack: start;
        align-content: flex-start;
        -webkit-align-items: stretch;
        -ms-flex-align: stretch;
        align-items: stretch;
    }
    
    .article-information-item-inline > .article-information-item{
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 1 1 auto;
        -ms-flex: 1 1 auto;
        flex: 1 1 auto;
        -webkit-align-self: auto;
        -ms-flex-item-align: auto;
        align-self: auto;
    }
</style>    
<script>
    close = function(){    
}
</script>
<div class="nge-inline-elements-article-information">
    <div class="article-information-item">
        <div class="article-information-item-title">Title</div>
        <div class="article-information-item-content"><?= $article->title ?></div>
    </div>
    <div class="article-information-item">
        <div class="article-information-item-title">Alias</div>
        <div class="article-information-item-content"><?= $article->alias ?></div>
    </div>
    <div class="article-information-item">
        <div class="article-information-item-title">Hits</div>
        <div class="article-information-item-content"><span class="badge badge-success"><?= $article->hits ?></span></div>
    </div>
    <div class="article-information-item">
        <div class="article-information-item-title">Id</div>
        <div class="article-information-item-content"><span class="badge"><?= $article->id ?></span></div>
    </div>
    <div class="article-information-item-inline">
        <div class="article-information-item">
            <div class="article-information-item-title">Created</div>
            <div class="article-information-item-content">
                <?= $article->created ?>
                <br>
                <span style="font-weight:bold">by <?= $created_by ?></span>
            </div>
        </div>
        <div class="article-information-item">
            <div class="article-information-item-title">Modified</div>
            <div class="article-information-item-content">
                <?= $article->modified ?>
                <br>
                <span style="font-weight:bold">by <?= $updated_by ?></span>
            </div>
        </div>
        <div class="article-information-item">
            <div class="article-information-item-title">Published</div>
            <div class="article-information-item-content"><?= $article->publish_up ?></div>
        </div>
    </div>
</div>
