/*  
 * Prototype NgeToolbar
 * @version: 1.1
 */ 
var NgeToolbar = (function () {
    NgeToolbar._plugins = new Object;
    
    /*Constructor*/
    function NgeToolbar (toolbarName) {
        this._toolbarName = toolbarName;
        NgeToolbar._plugins[this._toolbarName] = new Array();
    }
    
    /*Method override*/
    /**
     * Create and store plugin for the current toolbar inside NgeToolbar._plugins variable. 
     * @return void
     */
    NgeToolbar.prototype.addPlugin = function(elementname, pluginname, label, icon, description, width, height, jsfunction) {
        var $this = this;
        var pluginInfo = {
            name:pluginname,
            label:label,
            icon:icon,
            description:description,
            width:width,
            height:height,
            jsfunction:jsfunction
        };
        
        /*Can have one element in string or multiple element in array*/
        if (typeof elementname == 'string' || elementname instanceof String){
            elementname = [elementname];
        }
        
        /*Create current element object*/
        if(Array.isArray(elementname)){
            if(typeof NgeToolbar._plugins[$this._toolbarName] !== "undefined"){
                elementname.forEach(function(element) {
                    if(typeof NgeToolbar._plugins[$this._toolbarName][element] === "undefined"){
                        NgeToolbar._plugins[$this._toolbarName][element] = new Array();
                    }

                    var buttonHtml = "";
                    buttonHtml += '<span id="nge'+$this._toolbarName+'tlb-'+pluginname+'"';
                    buttonHtml += ' class="ngetoolbarplugin ngetoolbar-icon '+icon+'"';
                    buttonHtml += ' data-toggle="tooltip"';
                    //buttonHtml += ' data-nge=\'{"element": elementname, "plugin": pluginname, "description": description, "width": width, "height": height}\'';
                    buttonHtml += ' data-element="'+element+'"';
                    buttonHtml += ' data-plugin="'+pluginname+'"';		    
                    buttonHtml += ' data-width="'+width+'"';		    
                    buttonHtml += ' data-height="'+height+'"';		    
                    buttonHtml += ' data-jsfunction='+jsfunction;		    
                    buttonHtml += ' data-original-title="'+description+'">';
                    buttonHtml += '</span>';

                    pluginInfo.html = buttonHtml;
                    NgeToolbar._plugins[$this._toolbarName][element][pluginname] = pluginInfo;
                });
            }
        }
    };
    
    /**
     * show plugins available for the current widget.
     * @return void
     */
    NgeToolbar.prototype.show = function() {
        var widgetId = jQuery("#part-toolbar").attr("data-part");
        var widgetType = jQuery("#part-"+widgetId).attr("data-part");
        jQuery("#nge"+this._toolbarName+"-toolbar-plugins").empty();
        if(typeof NgeToolbar._plugins[this._toolbarName][widgetType] !== "undefined"){
            var widgetPluginInfo = NgeToolbar._plugins[this._toolbarName][widgetType];
            for (var key in widgetPluginInfo) {
                if (widgetPluginInfo.hasOwnProperty(key)) {
                    /*Add and show current plugin*/
                    var $plugin = jQuery("#nge"+this._toolbarName+"tlb-"+widgetPluginInfo[key].name);
                    if ($plugin.length > 0) {
                        $plugin.replaceWith(widgetPluginInfo[key].html);
                    }else{
                        jQuery("#nge"+this._toolbarName+"-toolbar-plugins").append(widgetPluginInfo[key].html);
                    }
                    
                    /*Enable current plugin event*/
                    var $plugin = jQuery("#nge"+this._toolbarName+"tlb-"+widgetPluginInfo[key].name);
                    $plugin.off("mouseenter mouseleave click");
                    $plugin.mouseenter(function(){
                        var iconTitle = jQuery(this).data("original-title");

                        if(iconTitle !== ""){
                            jQuery(this).closest(".ngetoolbar").find(".ngetoolbar-status").html(iconTitle).show();
                        }
                    }).mouseleave(function(){
                        jQuery(this).closest(".ngetoolbar").find(".ngetoolbar-status").html("").hide();
                    }).click(function(e){
                        if (!jQuery(e.target).hasClass('ngeloading')){
                            var jsFunction = jQuery(e.target).attr("data-jsfunction");
                            if (typeof jsFunction !== "undefined") {
                                jQuery("#part-toolbar-status").html('').hide();
                                jQuery('#part-toolbar').fadeOut(200);
                                //jQuery(".ngetlb-move").hide();
		    jQuery('#ngemove-toolbar').hide();
                                window[jsFunction](e.target);		
                            }
                        }
                    });
                }
            }
        }
    };
    
    /**
     * hide plugins available for the current widget.
     * @return void
     */
    NgeToolbar.prototype.hide = function() {
        var widgetId = jQuery("#part-toolbar").attr("data-part");
        var widgetType = jQuery("#part-"+widgetId).attr("data-part");
        if(typeof NgeToolbar._plugins[this._toolbarName][widgetType] !== "undefined"){
            var widgetPluginInfo = Array.from(NgeToolbar._plugins[this._toolbarName][widgetType]);
            for (var key in widgetPluginInfo) {
                if (widgetPluginInfo.hasOwnProperty(key)) {
                    var $plugin = jQuery("#nge"+this._toolbarName+"tlb-"+widgetPluginInfo[key].name);
                    if ($plugin.length > 0) {
                        $plugin.off("mouseenter mouseleave click");
                        /*Remove plugin after 300 ms. Because the parttoolbar hide after 300ms too.*/
                        setTimeout(function () {
                            $plugin.remove();
                        }, 300);
                    }
                }
            }
        }
    };
    
    return NgeToolbar;
})();

/**
 * Generic config form call
 * @param {type} params
 * 
 * params is  json object
 * known properties : 
 * title: displayed text in the modal header
 * buttons : 
 *  -> OLD way displayed button in the header bar : submit, cancel, close. For example ['close'], default ['submit', 'cancel']
 *  -> NEW way used object buttons to show and override events : 
 *              buttons : {
 *                   cancel: {
 *                       label: "FERMER"
 *                   },
 *                   stopEventsPropagation: false,
 *                   callback: function () {}
 *               }
 * backgroundColor: background color of the modal header
 * width: width in pixels of the modal window
 * height: height in pixels of the modal window
 * OLD way submit : function that will be called by the submit button (if displayed). Arguments are free
 * OLD way cancel : function that will be called by the cancel button (if displayed). Arguments are free
 * OLD way close : function that will be called by the close button (if displayed). Arguments are free
 * 
 * @returns {undefined}
 */
function loadInlineForm(params){
    var responsive = typeof params.responsive !== "undefined" ? params.responsive : false;  
    var iframeId = typeof params.iframeId !== "undefined" ? params.iframeId : null;
    var $inlineModal = jQuery("#inlineConfigForm");
    
    if(iframeId !== null){
        var $inlineModalClone = $inlineModal.clone();
        $inlineModalClone.attr("id", iframeId).insertAfter($inlineModal);
        $inlineModal = $inlineModalClone;
        
        $inlineModal.draggable({
	    handle: ".modal-header",
	    scroll: false,
	    drag : function(e,ui){            
		//Do not permit to go outside the window      
		if(ui.position.top < 0){   
		    ui.position.top = 0;
		}
		if(ui.position.left > jQuery(window).width() - jQuery(this).width()){   
		    ui.position.left = jQuery(window).width() - jQuery(this).width();
		}
		if(ui.position.left < 0){   
		    ui.position.left = 0;
		}
		if(ui.position.top >(jQuery(window).height() - jQuery(this).height())){   
		    ui.position.top = jQuery(window).height() - jQuery(this).height();
		}
	    }
	});
    }

    var $inlineModalHeader = $inlineModal.find(".modal-header");
    
    if(!responsive){ /*In px*/
        $inlineModal.width(params.width).height(params.height);
        /*Center modal*/
	var windowHeight = jQuery(window).height();
	var windowWidth = jQuery(window).width();
	var boxHeight = $inlineModal.height();
	var boxWidth = $inlineModal.width();
	$inlineModal.css({
            'left' : ((windowWidth - boxWidth)/2), 
            'top' : ((windowHeight - boxHeight)/2),
            "transform": "initial"
        });
	$inlineModalHeader.css('cursor' , "move");
        $inlineModal.draggable( "enable" );
    }else{ /*Responsive in %*/
        $inlineModal.css({
            "width": params.width+"%",
            "height": params.height+"%",
            "top": ((100-params.height)/2)+"%",
            "left": ((100-params.width)/2)+"%"
        });
        $inlineModalHeader.css('cursor' , "initial");
        if($inlineModal.is('.ui-draggable')){
            $inlineModal.draggable( "disable" );
        }
    }
    
    $inlineModal.find(".inlineconfig_icon").html(params.icon);
    $inlineModal.find(".inlineconfig_title").html(params.title);

        //Submit buttons
        if (typeof params.buttons === "undefined"){
            //Default buttons
            $inlineModal.find('#button-inlineConfigForm-submit').css( "display", "inline-block");
            $inlineModal.find('#button-inlineConfigForm-cancel').css( "display", "inline-block");
            $inlineModal.find('#button-inlineConfigForm-close').hide();
        }else{
            $inlineModal.find('.modal-custom-footer').children().hide();
            if(Array.isArray(params.buttons)){/*Old way: used array*/
                params.buttons.forEach(function(button) {
                    $inlineModal.find('.button-inlineConfigForm-'+button).css( "display", "inline-block");
                });
            }else{ /*New way: used object*/
                for (var button in params.buttons) {
                    var $button = $inlineModal.find('.button-inlineConfigForm-'+button);
                    var stopEventsPropagation = typeof params.buttons[button].stopEventsPropagation !== "undefined" ? params.buttons[button].stopEventsPropagation : false;
                    
                    $button.css( "display", "inline-block");
                    
                    if(typeof params.buttons[button].callback !== "undefined"){
                        $button.data("buttonName", button);
                        $button.off("click", $button).on( "click", $button, function(evt) {
                            var currentButton = jQuery(this).data("buttonName");

                            if(stopEventsPropagation){
                                evt.preventDefault();
                                evt.stopPropagation();
                            }

                            params.buttons[currentButton].callback($button);
                        });
                    }
                }
            }
        }

    $inlineModal.modal("show");
    /*Wait before set height*/
    setTimeout(function(){
        /*Here not before else outerHeight is not well calculate*/
        var $inlineModalHeader = $inlineModal.find(".modal-header");
        $inlineModalHeader.css('background-color', params.backgroundColor);
        if (typeof params.hoverColor !== "undefined")
	$inlineModal.find("#button-inlineConfigForm-submit, #button-inlineConfigForm-cancel").hover(function(e) {
	    jQuery(this).css("background-color", e.type === "mouseenter"?params.hoverColor:"transparent")
	});	
        $inlineModal.find(".nge-modal-body").height($inlineModal.outerHeight() - $inlineModalHeader.outerHeight());
        checkLoadFormExist($inlineModal.find(".inlineconfig_iframe")[0], params);
    }, 250);
}

/*Same as above, but this time it loads the url in the iframe all the time. So it reloads the scripts every time*/
function loadModal(params){
    var responsive = typeof params.responsive !== "undefined" ? params.responsive : false;  
    var iframeId = typeof params.iframeId !== "undefined" ? params.iframeId : null;
    var $inlineModal = jQuery("#modalInlineEditing");
    
    if(iframeId !== null){
        var $inlineModalClone = $inlineModal.clone();
        $inlineModalClone.attr("id", iframeId).insertAfter($inlineModal);
        $inlineModal = $inlineModalClone;
    }

    if(!$inlineModal.is('.ui-draggable')){
        $inlineModal.draggable({
	    handle: ".modal-header",
	    scroll: false,
	    drag : function(e,ui){            
		//Do not permit to go outside the window      
		if(ui.position.top < 0){   
		    ui.position.top = 0;
		}
		if(ui.position.left > jQuery(window).width() - jQuery(this).width()){   
		    ui.position.left = jQuery(window).width() - jQuery(this).width();
		}
		if(ui.position.left < 0){   
		    ui.position.left = 0;
		}
		if(ui.position.top >(jQuery(window).height() - jQuery(this).height())){   
		    ui.position.top = jQuery(window).height() - jQuery(this).height();
		}
	    }
	});
    }

    var $inlineModalHeader = $inlineModal.find(".modal-header");
    
    if(!responsive){ /*In px*/
        $inlineModal.width(params.width).height(params.height);
        /*Center modal*/
	var windowHeight = jQuery(window).height();
	var windowWidth = jQuery(window).width();
	var boxHeight = $inlineModal.height();
	var boxWidth = $inlineModal.width();
	$inlineModal.css({
            'left' : ((windowWidth - boxWidth)/2), 
            'top' : ((windowHeight - boxHeight)/2),
            "transform": "initial"
        });
	$inlineModalHeader.css('cursor' , "move");
        $inlineModal.draggable( "enable" );
    }else{ /*Responsive in %*/
        $inlineModal.css({
            "width": params.width+"%",
            "height": params.height+"%",
            "top": ((100-params.height)/2)+"%",
            "left": ((100-params.width)/2)+"%"
        });
        $inlineModalHeader.css('cursor' , "initial");
        if($inlineModal.is('.ui-draggable')){
            $inlineModal.draggable( "disable" );
        }
    }
    
    $inlineModal.find(".inlineconfig_title").html(params.title);		    
        //Submit buttons
        if (typeof params.buttons === "undefined"){
            //Default buttons
            $inlineModal.find('.button-modalInlineEditing-submit').css( "display", "inline-block");
            $inlineModal.find('.button-modalInlineEditing-cancel').css( "display", "inline-block");
            $inlineModal.find('.button-modalInlineEditing-close').hide();
        }else{
            $inlineModal.find('.modal-custom-footer').children().hide();

            for (var button in params.buttons) {
                var $button = $inlineModal.find('.button-modalInlineEditing-'+button);
                var stopEventsPropagation = typeof params.buttons[button].stopEventsPropagation !== "undefined" ? params.buttons[button].stopEventsPropagation : false;

                $button.css( "display", "inline-block");
                $button.attr("title", params.buttons[button].label);
                
                if(typeof params.buttons[button].callback !== "undefined"){
                    $button.data("buttonName", button);
                    $button.off("click").on( "click", function(evt) {
                        var currentButton = jQuery(this).data("buttonName");
                        if(stopEventsPropagation){
                            evt.preventDefault();
                            evt.stopPropagation();
                        }

                        params.buttons[currentButton].callback($button);
                    });
                }
            }
        }
        $inlineModal.find(".nge-loading-inlinecontent").fadeIn();
        $inlineModal.modal("show");
    
    /*Here not before else outerHeight is not well calculate*/
    var $inlineModalHeader = $inlineModal.find(".modal-header");
    $inlineModalHeader.css('background-color', params.backgroundColor);	
    $inlineModal.find(".nge-modal-body").height($inlineModal.outerHeight() - $inlineModalHeader.outerHeight());
    
    var $inlineModalIframe = $inlineModal.find(".modalinlineediting_iframe");
    if($inlineModalIframe.length > 0){
        $inlineModalIframe.css("visibility", "hidden");
        $inlineModalIframe.attr("src", params.url);
        $inlineModalIframe.off("load");
        $inlineModalIframe.load(function() {
            $inlineModal.find(".nge-loading-inlinecontent").hide();
            $inlineModalIframe.css("visibility", "visible");
            
            /*Set focus inside for specific take effect like keypress...*/
            $inlineModalIframe[0].contentWindow.focus();
        });
    }
}

function checkLoadFormExist(iframe, params) {
    if(typeof iframe.contentWindow.loadForm !== "undefined"){
        iframe.contentWindow.loadForm(params);
    }else{
        setTimeout(function(){ 
            checkLoadFormExist(iframe, params); 
        }, 100);
    }
}  
  
    /*Enabling toolbar*/
enableNgetoolbars = function (selector) {
    /*Show toolbars */    
    var selectorStructures = jQuery('div.ngeeditablestructure');
    selectorStructures.addClass('ngeeditable');
    jQuery(document).off("mouseenter mouseleave", "div.ngeeditablestructure").on("mouseenter", "div.ngeeditablestructure", function (e) {
        jQuery(this).find('div.ngetoolbar').css('display', 'inline-block');        
    }).on("mouseleave", "div.ngeeditablestructure", function (e) {
        jQuery(this).find('div.ngetoolbar').css('display', 'none');        
    });
    
    jQuery("span.ngetoolbar-icon").mouseenter(function(){
        var iconTitle = jQuery(this).data("original-title");

        if(iconTitle !== ""){
            jQuery(this).closest(".ngetoolbar").find(".ngetoolbar-status").html(iconTitle).show();
        }
    }).mouseleave(function(){
        jQuery(this).closest(".ngetoolbar").find(".ngetoolbar-status").html("").hide();
    }).click(function(e){
        if (!jQuery(e.target).hasClass('ngeloading')){
            var jsFunction = jQuery(e.target).attr("data-jsfunction");
            if (typeof jsFunction !== "undefined") {
                window[jsFunction](e.target);		
            }
        }
    });
};

/*Disabling toolbar*/
disableNgetoolbars = function () {
    /*Hide toolbars */    
    jQuery('div.ngeeditablestructure').removeClass('ngeeditable');
    jQuery("span.ngetoolbar-icon").off("mouseenter mouseleave click");
};

/*Triggering edition functions when unlock page editing*/
jQuery(document).on( "ngeStartEdition", function() {
    enableNgetoolbars();
});

jQuery(document).on( "ngeDisableEdition", function() {
    disableNgetoolbars();
});
