/*Global variable. Use it to add new button (plugin) to the parttoolbar.*/
var partToolbarPlugins = new NgeToolbar("part");
var currentPopoverToolbarAdd; 
var currentPopoverToolbarRemove;        

/* Create popover on remove button*/ 
jQuery("#ngeparttlb-remove").popover({
    trigger: 'manual',
    html: true,
    content: function () {
        var html = jQuery(this).closest("#part-toolbar").children(".toolbarpopover-remove-content").html();
        return html;
    },
    placement: "bottom",
    container: "#part-toolbar"
 });
 
this.removeTemporaryThumb = function () {
    currentThumbTemporary = jQuery("#part-thumb-temporary");
    currentThumbTemporary.remove();
};

/*Nge Part Toolbar subconfig pluginst*/
ngeDisplayPartInlineconfig = function(plugin, width, height, description){
    var pk = jQuery("#part-toolbar").attr('data-part');
    var formUrl = "index.php?option=com_nge&view=inlineconfig&layout=form&layout=form&format=raw&form=" + plugin + "&id=" + pk;
    var formParams = "type=part&id=" + pk;		
    //loadInlineForm(formUrl, formParams, ngeDisplayPartInlineconfigCallback, description, '#A5B5C3', width, height);

    loadInlineForm({url: formUrl,
        element: formParams,
        title: description,
        backgroundColor: '#A5B5C3',
        width:  width,
        height: height,
        submit : ngeDisplayPartInlineconfigCallback,
        });



    isPartHover = false;
    jQuery("#part-" + pk).trigger("mouseleave");
};
ngeDisplayPartInlineconfigCallback = function(){};

/*Nge Part Toolbar function Edit*/
ngePartToolbarEdit = function(){
            var pk = jQuery("#part-toolbar").attr('data-part');
            var part = jQuery('#part-' + pk);

            //jQuery("#partconfig_iframe").contents().find("html").html('<div style="margin-left:50%;margin-top:100px;"><img src="'+assetsUrl+'images/spinner.gif" /></div>');
            jQuery("#partConfigForm").modal("show");

            jQuery("div.ngelayout-workshop").data;

            /*Finding parent layout type : parent is content and parent().parent layout*/
            if (part.closest(".ngelayout").length){
                var layoutNode = jQuery("#part-" + pk).closest(".ngelayout"); 
                var caller = '&caller=layout.' + layoutNode.data('ngelayout');
                var viewmode = '&viewmode=' + layoutNode.data('ngeviewmode');
            }
            else{
                caller = '&caller=front';
                viewmode = '';
            }    
            //jQuery("#partconfig_iframe").attr("src", viewsUrl + "&view=config" + caller + viewmode + "&mode=edit&format=raw&pk=" + pk);
            document.getElementById("partconfig_iframe").contentWindow.loadContent(viewsUrl + "&view=config&layout=form" + caller + viewmode + "&mode=edit&format=raw&pk=" + pk);

            isPartHover = false;
            previewIsLoading = false;
            jQuery("#part-" + pk).trigger("mouseleave");
};

/*Nge Part Toolbar function Duplicate*/
ngePartDuplicate = function(){
    var currentToolbar = jQuery("#part-toolbar");
    var pk = currentToolbar.attr('data-part');
    var part = jQuery('#part-' + pk);
    var isWireFrame = part.hasClass("wireframe");

    if (isWireFrame) {
        duplicatePart(pk, "wireframe");
    } else {
        var currentLayout = part.closest(".ngelayout");
        if (currentLayout.hasClass('ngelayout-page')){
            duplicatePagePart(pk);
        }else if (currentLayout.hasClass('ngelayout-grid')){
                /*duplicatePart(pk, content);*/
        }else if (currentLayout.hasClass('ngelayout-wall')){
                /*duplicatePart(pk, content);*/
        }else if (currentLayout.hasClass('ngelayout-workshop')){
                duplicateWorkshopPart(pk);		
        }else if (currentLayout.hasClass('ngelayout-position')){
                duplicateCurrentModule(part.closest(".ngemodule-part"));
        }else if (currentLayout.hasClass('ngelayout-article')){
                duplicateArticlePart(pk);
        }else if (currentLayout.hasClass('ngelayout-part')){
                duplicatePartPart(pk);
        }else if (currentLayout.hasClass('ngelayout-module')){
                duplicateModulePart(pk);
        }
    }
};	

/*Nge Part Toolbar function Add part*/
ngePartToolbarAdd = function(){
    jQuery("#ngeparttlb-add").popover({
        trigger: 'manual',
        html: true,
        content: function () {
                var html = jQuery(this).closest("#part-toolbar").children(".toolbarpopover-add-content").html();
                return html;
        },
        placement: "right",
        container: "#part-toolbar"
    }).click(function (e) {
        if (!e) var e = window.event;
        e.cancelBubble = true;
        if (e.stopPropagation) e.stopPropagation();

        if(typeof currentPopoverToolbarRemove !== 'undefined')
            currentPopoverToolbarRemove.popover("hide");

        currentPopoverToolbarAdd = jQuery(this);
        currentPopoverToolbarAdd.popover('show');
    }); 

    jQuery("#ngeparttlb-add").popover("toggle");
}

/*Nge Part Toolbar function Remove*/
ngePartRemove = function(){
            /*Nge Part Toolbar Event Remove Popover*/
/*jQuery("#ngeparttlb-remove").popover({
                    trigger: 'manual',
                    html: true,
                    content: function () {
                            var html = jQuery(this).closest("#part-toolbar").children(".toolbarpopover-remove-content").html();
                            return html;
                    },
                    placement: "right",
                    container: "#part-toolbar"
 }).click(function (e) {
                    if (!e) var e = window.event;
                        e.cancelBubble = true;
                        if (e.stopPropagation) e.stopPropagation();

                        if(typeof currentPopoverToolbarAdd !== 'undefined')
                            currentPopoverToolbarAdd.popover("hide");

            //jQuery("#ngeparttlb-remove").popover('show')

            //currentPopoverToolbarRemove = jQuery(this);
                        //currentPopoverToolbarRemove.popover('show');
                });
*/
                jQuery("#ngeparttlb-remove").popover("show");
}

ngePartFormTheme = function(){	
	var pk = jQuery("#part-toolbar").attr('data-part');
	var oldHtml = jQuery('#part-' + pk).html();
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=part&form=theme&pk=" + pk,
		    icon: '<span class="icomoon-paint-format">',
		    title: COM_NGE_EDITOR_TOOLBAR_THEME_TITLE,		    
		    backgroundColor: '204389',
		    width:  450,
		    height: 600,
		    refresh : function(html){
			console.log('REFRESH');
			/* Update only content without editing features*/
			jQuery('#part-' + pk).replaceWith(html);
		    },
		    submit : function(result_obj){
			/* Update content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    },
		    cancel : function(element, oldItemId, currentItemId){
			jQuery('#part-' + pk).replaceWith(oldHtml);
			//$part.replaceWith(oldHtml);
			var result_obj = {html:oldHtml};
			/* Updating old content and editing features in Javascript*/
			//document.afterLayoutPartUpdate(result_obj);
		    }
		});        
};

ngePartFormAnimate = function(){
	var pk = jQuery("#part-toolbar").attr('data-part');
	var oldHtml = jQuery('#part-' + result.pk).html();
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=part&form=animate&pk=" + pk,
		    icon: '<span class="icomoon-power">',
		    title: COM_NGE_EDITOR_TOOLBAR_ANIMATE_TITLE,
		    backgroundColor: '204389',
		    width:  500,
		    height: 600,
		    refresh : function(html){
			/* Update only content without editing features*/
			jQuery('#part-' + result.pk).replaceWith(html);
		    },
		    submit : function(result_obj){
			/* Update content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    },
		    cancel : function(element, oldItemId, currentItemId){
			var result_obj = {html:oldHtml};
			/* Updating old content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    }
		});        
};

ngePartFormDisplay = function(){
	var pk = jQuery("#part-toolbar").attr('data-part');
	var oldHtml = jQuery('#part-' + result.pk).html();
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=part&form=display&pk=" + pk,
		    icon: '<span class="icomoon-display"></span>',
		    title: COM_NGE_EDITOR_TOOLBAR_DISPLAY_TITLE,
		    width:  450,
		    height: 600,
		    refresh : function(html){
			console.log('REFRESH');
			/* Update only content without editing features*/
			jQuery('#part-' + pk).replaceWith(html);
		    },
		    submit : function(result_obj){
			/* Update content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    },
		    cancel : function(element, oldItemId, currentItemId){
			var result_obj = {html:oldHtml};
			/* Updating old content and editing features in Javascript*/
			//document.afterLayoutPartUpdate(result_obj);
		    }
		});		
};

ngePartFormConditions = function(){
	var pk = jQuery("#part-toolbar").attr('data-part');
	var oldHtml = jQuery('#part-' + result.pk).html();
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=part&form=conditions&pk=" + pk,
		    icon: '<span class="icomoon-display"></span>',
		    title: COM_NGE_EDITOR_TOOLBAR_CONDITIONS_TITLE,
		    width:  600,
		    height: 600,
		    refresh : function(html){
			console.log('REFRESH');
			/* Update only content without editing features*/
			jQuery('#part-' + pk).replaceWith(html);
		    },
		    submit : function(result_obj){
			/* Update content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    },
		    cancel : function(element, oldItemId, currentItemId){
			var result_obj = {html:oldHtml};
			/* Updating old content and editing features in Javascript*/
			//document.afterLayoutPartUpdate(result_obj);
		    }
		});		
};

ngePartFormTransform = function(){
	var pk = jQuery("#part-toolbar").attr('data-part');
	var oldHtml = jQuery('#part-' + result.pk).html();
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=part&form=transform&pk=" + pk,
		    icon: '<span class="icomoon-display"></span>',
		    title: COM_NGE_EDITOR_TOOLBAR_TRANSFORM_TITLE,
		    width:  800,
		    height: 600,
		    refresh : function(html){
			console.log('REFRESH');
			/* Update only content without editing features*/
			//jQuery('#part-' + pk).replaceWith(html);
		    },
		    submit : function(result_obj){
			console.log('SUBMITeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee');
			/* Update content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    },
		    cancel : function(element){
			console.log('CLOSEeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee');
			var result_obj = {html:oldHtml};
			/* Updating old content and editing features in Javascript*/
			//document.afterLayoutPartUpdate(result_obj);
		    }
		});		
};

ngePartFormInformation = function(){
	var pk = jQuery("#part-toolbar").attr('data-part');
	var oldHtml = jQuery('#part-' + result.pk).html();
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=part&form=information&pk=" + pk,
		    icon: '<span class="icomoon-display"></span>',
		    title: COM_NGE_EDITOR_TOOLBAR_INFO_TITLE,
		    width:  450,
		    height: 500,
		    refresh : function(html){
			console.log('REFRESH');
			/* Update only content without editing features*/
			jQuery('#part-' + pk).replaceWith(html);
		    },
		    submit : function(result_obj){
			/* Update content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    },
		    cancel : function(element, oldItemId, currentItemId){
			var result_obj = {html:oldHtml};
			/* Updating old content and editing features in Javascript*/
			//document.afterLayoutPartUpdate(result_obj);
		    }
		});		
};


/**
 * @name removePositionModulePart
 * @description removes a part included in a module position
 * @returns void
 */
removePositionModulePart = function (module) {
    /*Searching part id and closest parent layout (columns or position layout)    	*/
    var m_id = module.attr('data-module-id');   
    var result = false;
    if (typeof m_id != "undefined") {
	var url = 'index.php?option=com_nge&task=module.delete';
	var token = jQuery('#tokenform').find('input').attr('name');
	var data = {};
	data['m_id'] = m_id;
	data[token] = token;

	jQuery.ajax({
	    url: url,
	    data: data,
	    type: 'POST',
	    success: function (resultJson) {
		result = jQuery.parseJSON(resultJson);
		if (result.result == '1') {
		    /*Moving toolbar at the starting of the document, to avoid being removed with the part*/
		    jQuery('#part-toolbar').hide();

		    jQuery('#module-' + m_id).remove();
		} else
		    bootbox.alert(COM_NGE_JS_EDITING_ERROR + result.message);
	    },
	    error: function (result) {
		bootbox.alert(COM_NGE_JS_EDITING_WRONG_URL + result);
	    }
	});
    }
};

/**
 * @name duplicateCurrentModule
 * @description duplicate current module in same position
 * @returns void
 */
duplicateCurrentModule = function ($module) {
    //var module = jQuery("#module-ngetoolbar-duplicate").closest(".ngemodule-joomla");
    /*Searching part id and closest parent layout (columns or position layout)    	*/
    var m_id = $module.attr('data-module-id');

    if (typeof m_id != "undefined") {
    	var url = 'index.php?option=com_nge&task=module.duplicate';
    	var token = jQuery('#tokenform').find('input').attr('name');
    	var data = {};    	
    	data['m_id'] = m_id;
    	data[token] = 1;
	var moduleHeight = $module.height();
	var moduleWidth = $module.width();
	$module.after('<div id="ngetmpmodule" style="height:'+moduleHeight+';width:'+moduleWidth+';padding-left:50%;padding-top:'+moduleHeight/2+'px;"><img src="' + rootUrl + 'components/com_nge/assets/images/spinner.gif" /></div>');

		jQuery.ajax({
		    url: url,
		    data: data,
		    type: 'POST',
		    success: function (resultJson) {
		    	ajaxResult = jQuery.parseJSON(resultJson);
				if (ajaxResult.result == '1') {
				    //var createParentDivModule = '<div id="module-' + ajaxResult.m_id + '" class="ngemodule ngemodule-joomla" data-module-label="' + ajaxResult.title + '" data-module-id="' + ajaxResult.m_id + '">';
				    //createParentDivModule += ajaxResult.html;
				    //createParentDivModule += '</div>';
		
				    /*Add edit attributes and events for this new part*/
				    //module.after(createParentDivModule);
				    jQuery("#ngetmpmodule").remove();
				    $module.after(ajaxResult.html);
				    var partElement = $module.find(".part");
		
				    if (partElement.length == 1){					
					enableNgePartToolbar('#module-' + ajaxResult.m_id + ' .part'); /*will enable parts inside the new module*/
					enableNgeInlineEditing('#module-' + ajaxResult.m_id + ' .part');
					enableNgeItemsSortable('#module-' + ajaxResult.m_id + ' .part');
					
					activeSortableLayout(jQuery('#module-' + ajaxResult.m_id + ' .part'));					
				    }
				    else{
				    	enableNgeModuleOldToolbar('#module-' + ajaxResult.m_id);
				    }
				} else {
				    bootbox.alert(COM_NGE_JS_EDITING_ERROR + ajaxResult.message);
				}
		    },
		    error: function (result) {
		    	console.error(result);
		    }
		});
    }
};	
	
    /*Add widget after or before the current widget*/
    ngePartToolbarAddWidget = function(action, partId){
        var tempDroppedPart = '<div id="part-temp-dropped" class="part" style="display:block; padding:10px; background:yellow;"></div>';
        var $currentPart = jQuery("#part-"+partId);
        
        if(action === "before"){
            $currentPart.before(tempDroppedPart);
        }else{
            $currentPart.after(tempDroppedPart);
        }
        
        jQuery("#partconfig_iframe").contents().find("html").html('<div style="margin-left:50%;margin-top:100px;"><img src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /></div>');
	jQuery("#partConfigForm").modal("show");
	jQuery("#partconfig_iframe").attr("src", "index.php?option=com_nge&view=librarygallery&format=raw&caller=layout.page");			 
    };
    
    /*Enabling toolbar*/
    enableNgePartToolbar = function (selector, isParent, activeMarge, activeResize) {
    	isParent = typeof isParent !== 'undefined' ? isParent : false;
    	selector = typeof selector !== 'undefined' ? selector : ".part";
    	activeMarge = typeof activeMarge !== 'undefined' ? activeMarge : true;
    	activeResize = typeof activeResize !== 'undefined' ? activeResize : true;
    	
    	var elementsPart = jQuery(selector);
	var partToolbar = jQuery('#part-toolbar');

    	if(isParent){
		elementsPart = elementsPart.find(".part");
    	}
	//partToolbarPlugins = new NgeToolbar('');
        
        /*In case of old parttoolbar that did not hide*/
        /*TODO don't use normally we can active toolbar for specific selector without hide toolbar of another one*/
        /*partToolbar.hide();*/
        
	/* Create structureeditable attributes, for generic inlineediting and toolbar*/
	/* TODO inside parts in php before*/
	elementsPart.each(function () {
	    var pk = jQuery(this).attr("id").split("-");
	    var partId = libraryTitle = jQuery(this).data("part-label");
	    jQuery(this).addClass('ngeeditablestructure ngeeditablestructurepart').data("nge", {type: "part", id: pk[1]});	
	});

    	var lastPartId = "";
    	elementsPart.addClass('ngeeditable');

    	var timerHidePartToolbar; 
    	elementsPart.unbind("mouseenter mouseleave");
		
		elementsPart.bind("mouseenter", function (e) {
			var $currentPart = jQuery(this);
			var $currentPartId = jQuery(this).attr("id");
			
			/*For imbricated parts*/
			if($currentPart.parents(".part").length > 0){
				/*It's a child part*/
				isPartHover = false;
			}
			
			/*For imbricated parts in module*/
			if($currentPart.parents(".ngelayout-module").length > 0){
				/*It's a child part*/
				isPartHover = false;
			}
			
                        /*If parts in workshop layout*/
			if($currentPart.parents(".ngelayout-workshop").length > 0){
			    activeMarge = false;
			    activeResize = false;
			}

			if(isPartHover == false && isPartSortable == false){
				clearTimeout(timerHidePartToolbar);
				
				/*Disable hover edit in all part*/
				disableResizePart();
				disableMarginPart();
				
				/*Enable Rezisable for current Part*/
				/* If part is a menu in fixed-top position : don't resize : the position witch was fixed becomes relative and the navbar flies away when mouse over */
				if((typeof $currentPart.data("ngelayout") == "undefined") && (!$currentPart.hasClass('navbar-fixed-top')) && (!$currentPart.hasClass('navbar-fixed-bottom')))
					enableResizePart($currentPart, activeResize);
				
				/*Enable Margin for current Part*/
				enableMarginPart($currentPart, activeMarge);

			    partToolbar.find("div.popover").remove();
			    
			    var dataSizeWidthBackground = $currentPart.data("size-width-background");
			    var partToolbarTop = Math.abs(($currentPart.offset().top - partToolbar.outerHeight() + 2));
			    /*if ($currentPart.offset().left > 0)
				partToolbarLeft = $currentPart.offset().left;
			    else
				partToolbarLeft = 0;
			    */
			    if (parseInt(jQuery($currentPart).css('margin-left')) < 0)
				var partToolbarLeft = $currentPart.offset().left - parseInt(jQuery($currentPart).css('margin-left'));
			    else				    
				var partToolbarLeft = $currentPart.offset().left;

                            /*When widget are inside container with specific structure with scroll active (not body element)*/
                            var scrollContainerObject = null;
                            $currentPart.parents('div').each(function(){
		    //Test if scrollbar, heights with bottom margin
		    if((jQuery(this).get(0).scrollHeight - jQuery(this).find(".nge-margin-s").height() - partToolbar.outerHeight()/2) > jQuery(this).innerHeight()){
                                    scrollContainerObject = {
                                        scrollTop: jQuery(this).scrollTop(),
                                        offsetTop: jQuery(this).offset().top
                                    };
                                    return false;
                                }
                            });
                            
                            if(scrollContainerObject !== null){
                                if(partToolbarTop <= scrollContainerObject.offsetTop){
                                    partToolbarTop = scrollContainerObject.offsetTop + 2;
                                }
                            }      
			/* Check if content is rotated */
			    var el = document.getElementById($currentPartId);
			    var st = window.getComputedStyle(el, null);
			    var tr = st.getPropertyValue("-webkit-transform") ||
			             st.getPropertyValue("-moz-transform") ||
			             st.getPropertyValue("-ms-transform") ||
			             st.getPropertyValue("-o-transform") ||
			             st.getPropertyValue("transform") ||
			             "FAIL";
			    
			    if(tr != "FAIL" && tr != "none"){
			    	var values = tr.split('(')[1].split(')')[0].split(',');
			    	
				    var a = values[0];
				    var b = values[1];
				    var c = values[2];
				    var d = values[3];

				    var scale = Math.sqrt(a*a + b*b);
				    var angle = Math.abs(Math.round(Math.atan2(b, a) * (180/Math.PI)));
				    
				    if(angle >= 180)
				    	angle = 360 - angle;
				   
				    if(angle > 0){
					    var widthTranslate, heightTranslate;
					    var angleRadians = angle * (Math.PI / 180);
					    var hypotenuse = $currentPart.outerWidth()/2;
					    
					    if(angle == 90){
					    	widthTranslate = 0;
					    	heightTranslate = hypotenuse/2;
					    }else{
					    	widthTranslate = Math.abs(Math.cos(angleRadians) * hypotenuse);
					    	heightTranslate =  Math.abs(Math.sin(angleRadians) * hypotenuse);
					    }

					    if(scale !== 1){
					    	widthTranslate = widthTranslate*scale;
					    	heightTranslate = heightTranslate*scale;
					    }
					    
				    	partToolbarTop = $currentPart.offset().top + heightTranslate;
					    partToolbarLeft = $currentPart.offset().left + widthTranslate - (partToolbar.outerWidth()/2);
				    }
			    }
			    
			    partToolbar.css({
			        "position": "absolute",
			        "top": partToolbarTop + "px",
			        "left": partToolbarLeft + "px"
			    });
			    
					var pk = jQuery(this).attr("id").split("-");
					var libraryTitle = jQuery(this).data("part-label");
                                        if(typeof libraryTitle !== "undefined"){
                                            if(libraryTitle.length > 25){
                                                libraryTitle = libraryTitle.substring(0,21)+" ...";
                                            }
                                        }else{
                                            libraryTitle = "";
                                        }
					jQuery('#part-toolbar-title').html(libraryTitle);
					partToolbar.attr('data-part', pk[1]);
					
                                        /* Enabled plugins for current widget */
                                        partToolbarPlugins.show();
					
					/*Show move button for sortable element*/
					var toolbarMoveSelector = jQuery("#nge-editing-bar").find(".ngetlb-move");	
					jQuery(".ngetlb-move").not(toolbarMoveSelector).remove();
					var currentMoveSelector = toolbarMoveSelector.clone(true, true);
					$currentPart.append(currentMoveSelector);
					
					/*For the moment only show icon move widget in article and widget layout*/
					var closestLayout = $currentPart.parent().closest(".ngelayout");
					if(closestLayout.hasClass("ngelayout-article") || closestLayout.hasClass("ngelayout-part") ||
						closestLayout.hasClass("ngelayout-position") || closestLayout.hasClass("ngelayout-workshop") || closestLayout.hasClass("ngelayout-page")){
						currentMoveSelector.show();
					}
			
					/*If part is in a NGE Layout, more capabilities*/
					if (jQuery(this).closest('div.ngelayout').length != 0) {
						jQuery("#ngeparttlb-duplicate").show();
						jQuery("#ngeparttlb-remove").show();
					} else {
						jQuery("#ngeparttlb-generate").hide();
						jQuery("#ngeparttlb-duplicate").hide();
						jQuery("#ngeparttlb-remove").hide();
					}
                                        
					/* update plugins */
					/* Displays plugins buttons affected to this part */
					var partType = $currentPart.data('part');
					partToolbar.find('.partplugin').hide();
					partToolbar.find('span[data-part="'+partType+'"]').show();
			
                                        /*Button access right*/
                                        displayButtonsAccess = jQuery.parseJSON($currentPart.attr("data-toolbar"));
                                        if(displayButtonsAccess !== null && typeof displayButtonsAccess.displayButtons !== "undefined"){
                                            partToolbar.find('span.ngetoolbar-icon').hide();
                                            displayButtonsAccess.displayButtons.forEach(function(button) {
                                                jQuery("#ngeparttlb-"+button).show();
                                            });
                                        }
					/*Show Toolbar*/
					jQuery("#part-toolbar-info").css({"margin-left": (partToolbar.outerWidth() +2) + "px"});
					partToolbar.fadeIn();
					
					$currentPart.trigger("activepartmouseleave");
					isPartHover = true;
			}
		});
		
		elementsPart.on("activepartmouseleave", function(){
			var currentElement = jQuery(this);

			currentElement.unbind("mouseleave");
			currentElement.bind("mouseleave", function (e) {
				if (!e) var e = window.event;
                                e.cancelBubble = true;
				var element = e.toElement || e.relatedTarget;
				var elementId = jQuery(element).attr('id');
				var $currentPartLeave = jQuery(this);
                                /*We are hover the widget toolbar*/
                                if(jQuery(element).closest(".ngetoolbar").length > 0){
                                    elementId = "part-toolbar";
                                }
                               
				if($currentPartLeave.hasClass("nge-part-resize-process")
						|| $currentPartLeave.hasClass("nge-part-margin-process")
							|| isLayoutColumnResize){
					isPartHover = true;
				}else{
					/*If we are on hover the part toolbar don't hide it*/
					if (typeof elementId === "undefined" || elementId !== "part-toolbar"){
						var parentPart = $currentPartLeave.parent().closest(".part");
						var parentModule = $currentPartLeave.parent().closest(".ngemodule");

						if(parentPart.length > 0 
								&& $currentPartLeave.attr("id") != parentPart.attr("id")){
							/*He have a parent and it's not a layout*/
							isPartHover = false;
							parentPart.trigger("mouseenter");
						}else{
							timerHidePartToolbar = setTimeout(function () {
								if(isPartHover == false){
								    disableResizePart();
								    disableMarginPart();



								    jQuery("#part-toolbar-status").html('').hide();
								    jQuery('#part-toolbar').fadeOut();
								    jQuery(".ngetlb-move").fadeOut();
								}
							}, 200);
								
							/* Enabled plugins for current widget */
							jQuery(partToolbarPlugins).hide();
							isPartHover = false;
						}
					}
				}
			});
		});
		
                jQuery("#part-toolbar").off("mouseenter mouseleave");
		jQuery("#part-toolbar").bind("mouseenter", function (e) {
                    if (!e) var e = window.event;
		    e.cancelBubble = true;
		    
                    clearTimeout(timerHidePartToolbar);
                    var $currentPart = jQuery("#part-"+jQuery(this).attr("data-part"));

                    if($currentPart.hasClass("nge-part-resize-process")
                        || $currentPart.hasClass("nge-part-margin-process")
                        || isLayoutColumnResize){
                        isPartHover = true;
                    }
		});
		
		jQuery("#part-toolbar").bind("mouseleave", function (e) {
                    if (!e) var e = window.event;
		    e.cancelBubble = true;

                    var $currentPartId = jQuery(this).attr("data-part");
                    var $currentPart = jQuery("#part-"+$currentPartId);

                    if($currentPart.hasClass("nge-part-resize-process")
                        || $currentPart.hasClass("nge-part-margin-process")
                        || isLayoutColumnResize){
                        isPartHover = true;
                    }else{
                        /* Enabled plugins for current widget */
                        partToolbarPlugins.hide();
                        var element = e.toElement || e.relatedTarget;
                        var elementId = jQuery(element).closest(".part").attr('id');
                        /*If we are on hover the part toolbar don't hide it*/
                        if (typeof elementId === "undefined"){
                            $currentPart.trigger("mouseleave");
                        }else if($currentPartId != elementId){
                            isPartHover = false;
                        }
                    }
		});
    };
    
    /*Disabling toolbar*/
    disableNgePartToolbar = function (selector) {
    	selector = typeof selector !== 'undefined' ? selector : ".part";
    	jQuery(selector).removeClass('ngeeditable').unbind("mouseenter mouseleave");
    };


/******* Resize ********************/
/*jQuery(document).ready(function () {*/
	var resizePartSelector = "";
	
	var resizePartSelectorPartTextLabel = jQuery('.ngelayout .part[data-part="text.label"]');
	var resizePartSelectorPartTextDropcap = jQuery('.ngelayout .part[data-part="text.dropcap"]');
	var resizePartSelectorAlignNone = jQuery('.ngelayout .part[data-size-align="none"]:not(.ngelayout)');
	var resizePartSelectorAlignAvailable = jQuery('.ngelayout .part[data-size-align="available"]:not(.ngelayout)');
	var resizePartSelectorWidthModeContent = jQuery('.ngelayout .part[data-size-width-mode="content"]:not(.ngelayout)');
	var resizePartSelectorLayoutPage = jQuery('.ngelayout-page');
	var resizePartSelectorLayoutColumn = jQuery('.ngelayout-column');
	
    enableResizePart = function (selector, activeResize) {
    	/*Get the selector for the rezisable*/
    	selector = typeof selector !== 'undefined' ? selector : "";
    	activeResize = typeof activeResize !== 'undefined' ? activeResize : true;
        
        if(activeResize === true){
            if(selector == "")
                    resizePartSelector = jQuery(".ngelayout .part:not(.ngelayout)");
            else 
                    resizePartSelector = jQuery(selector);

            resizePartSelector = resizePartSelector.not(resizePartSelectorAlignNone).not(resizePartSelectorAlignAvailable).not(resizePartSelectorWidthModeContent).not(resizePartSelectorPartTextLabel).not(resizePartSelectorPartTextDropcap).not(resizePartSelectorLayoutPage).not(resizePartSelectorLayoutColumn);

            /*Get the good Handles option depending on the display paramaters*/
            var parentWidth, partWidth, childWidth, diffPartChildWidth, storePartWidthIfLowerThanChildWidth, maxWidth;
            var padLeft, padRight, padTop, padBottom, padHorizontalTotal, padVerticalTotal;
            var borderLeft, borderRight, borderTop, borderBottom, borderHorizontalTotal, borderVerticalTotal;
            var margLeft, margRight, margTop, margBottom, margHorizontalTotal, margVerticalTotal;
            var handleTarget;
            var currentWidth = 50;
            var currentHeight = 30;
            var toolbarStatus;
            
            resizePartSelector.each(function( index ) {
                    var currentPartResize = jQuery(this);
                    var dataSizeDisplay = currentPartResize.data("size-display");
                    var dataSizeAlign = currentPartResize.data("size-align");
                    var dataSizeWidthMode = currentPartResize.data("size-width-mode");    		
                    var dataSizeHeightMode = currentPartResize.data("size-height-mode");    		
                    var handlesString = getHandlesString(dataSizeAlign);

                    currentPartResize.resizable({
                            handles: handlesString,
                        start: function (event, ui) {
                            toolbarStatus = jQuery("#part-toolbar-status");				    
                            handleTarget = jQuery(event.originalEvent.target).closest(".ui-resizable-handle");
                            parentWidth = ui.element.parent().width();
                            partWidth   = ui.element.outerWidth();
                            childWidth  = ui.element.children().outerWidth();
                            storePartWidthIfLowerThanChildWidth = null;
                            diffPartChildWidth  = partWidth - childWidth;
                            padLeft = jQuery(this).css('padding-left').replace('px','');
                            padRight = jQuery(this).css('padding-right').replace('px','');
                            padTop = jQuery(this).css('padding-top').replace('px','');
                            padBottom = jQuery(this).css('padding-bottom').replace('px','');
                            borderLeft = jQuery(this).css('border-left-width').replace('px','');
                            borderRight = jQuery(this).css('border-right-width').replace('px','');
                            borderTop = jQuery(this).css('border-top-width').replace('px','');
                            borderBottom = jQuery(this).css('border-bottom-width').replace('px','');
                            padHorizontalTotal = parseFloat(padLeft) + parseFloat(padRight);
                            borderHorizontalTotal = parseFloat(borderLeft) + parseFloat(borderRight);
                            padVerticalTotal = parseFloat(padTop) + parseFloat(padBottom);
                            borderVerticalTotal = parseFloat(borderTop) + parseFloat(borderBottom);


                            /*Marges*/
                            margLeft = jQuery(this).css('margin-left').replace('px','');
                            margRight = jQuery(this).css('margin-right').replace('px','');
                            margTop = jQuery(this).css('margin-top').replace('px','');
                            margBottom = jQuery(this).css('margin-bottom').replace('px','');

                            if(dataSizeAlign === "center"){
                                margHorizontalTotal = 0;
                            }else{
                                if (handleTarget.hasClass('ui-resizable-e') || handleTarget.hasClass('ui-resizable-se')){
                                    margHorizontalTotal = parseFloat(margLeft);
                                }else if(handleTarget.hasClass('ui-resizable-w') || handleTarget.hasClass('ui-resizable-sw')){
                                    margHorizontalTotal = parseFloat(margRight);
                                }
                            }
                            
                            maxWidth = ui.element.outerWidth(true) - margHorizontalTotal - padHorizontalTotal - borderHorizontalTotal;

                            jQuery(this).resizable( "option", "maxWidth", maxWidth);
                            jQuery(this).addClass("nge-part-resize-process");
                        },
                        resize: function (event, ui) {
                            var unitWidth = (dataSizeWidthMode === "flexible") ? "%" : "px";
                            var unitHeight = "px"; /*Height always in px*/
                            partWidth = ui.element.outerWidth();
                            childWidth = ui.element.children().width();

                            if (handleTarget.hasClass('ui-resizable-e') || handleTarget.hasClass('ui-resizable-w')){
                                /* Rezise horizontaly */
                                ui.size.width = ui.size.width + padHorizontalTotal + borderHorizontalTotal;

                                if(ui.size.width <= 50){
                                    currentWidth = 50;
                                }else if(ui.size.width <= parentWidth - margHorizontalTotal){ /*In most current case*/
                                    currentWidth = ui.size.width;
                                }else{ /*If size width bigger than parent width*/
                                    currentWidth = parentWidth - margHorizontalTotal;
                                }
                                
                                toolbarStatus.html(COM_NGE_WIDTH+' : ' + getCurrentResizeWidth(unitWidth, currentWidth, ui.element.outerWidth(true))).show();
                            }else if (handleTarget.hasClass('ui-resizable-s')){
                                /*Resize Vertical*/
                                ui.size.height = ui.size.height + padVerticalTotal + borderVerticalTotal; 

                                if(ui.size.height <= 30){
                                    currentHeight = 30;
                                }else{
                                    currentHeight = ui.size.height;
                                }

                                ui.element.outerHeight(currentHeight);
                                toolbarStatus.html(COM_NGE_HEIGHT+' : ' + currentHeight + unitHeight).show();
                            }else if (handleTarget.hasClass('ui-resizable-se') || handleTarget.hasClass('ui-resizable-sw')){
                                /*Resize Horizontal*/
                                ui.size.width = ui.size.width + padHorizontalTotal + borderHorizontalTotal;

                                if(ui.size.width <= 50){
                                    currentWidth = 50;
                                }else if(ui.size.width <= parentWidth - margHorizontalTotal){ /*In most current case*/
                                    currentWidth = ui.size.width;
                                }else{ /*If size width bigger than parent width*/
                                    currentWidth = parentWidth - margHorizontalTotal;
                                }
                                
                                /*Resize Vertical*/
                                ui.size.height = ui.size.height + padVerticalTotal + borderVerticalTotal; 

                                if(ui.size.height <= 30){
                                    currentHeight = 30;
                                }else{
                                    currentHeight = ui.size.height;
                                }
                                
                                toolbarStatus.html(COM_NGE_WIDTH+' : ' + getCurrentResizeWidth(unitWidth, currentWidth, ui.element.outerWidth(true)) +' , '+COM_NGE_HEIGHT+' : ' + currentHeight + unitHeight).show();			    
                            }
                            
                            ui.element.css({
                                "left": "0",
                                "right": "0"
                            });
                        },
                        stop: function (event, ui) {
                            ui.element.css({
                                "left": "0",
                                "right": "0"
                            });
                            
                            jQuery(this).removeClass("nge-part-resize-process");
                            /*Part ID : part id is "part-nnn"*/
                            var divid = jQuery(ui.element).attr('id');
                            var pkArray = divid.split("-");
                            var pk = pkArray[1];

                            if (handleTarget.hasClass('ui-resizable-e') || handleTarget.hasClass('ui-resizable-w')){
                                /*Saved Resize Horizontal*/
                                saveResizePartWidth(pk, ui.element.outerWidth(true), currentWidth, dataSizeWidthMode);
                            }else if (handleTarget.hasClass('ui-resizable-se') || handleTarget.hasClass('ui-resizable-sw')){
                                saveResizePartWidth(pk, ui.element.outerWidth(true), currentWidth, dataSizeWidthMode);
                                saveResizePartHeight(pk, currentHeight, dataSizeHeightMode);
                            }else if(handleTarget.hasClass('ui-resizable-s')){
                                saveResizePartHeight(pk, currentHeight, dataSizeHeightMode);
                            }

                            toolbarStatus.html("").hide();	
                        }
                    }).find("div.ui-resizable-se").removeClass("ui-icon").removeClass("ui-icon-gripsmall-diagonal-se");

                    /*disableMarginPart because rezise doesn't work when draggable add position:absolue*/
                    currentPartResize.find(".ui-resizable-handle").mousedown(function(event){
                            disableMarginPart(currentPartResize);
                    }).mouseup(function(){
                            enableMarginPart(currentPartResize);
                    });

                    currentPartResize.find(".ui-resizable-handle").mouseenter(function(){
                                jQuery("#part-toolbar-status").html(COM_NGE_JS_EDITING_RESIZE_CHANGE).show();
                            }).mouseleave(function(){
                                    jQuery("#part-toolbar-status").hide().html("");
                            });
            });
        }
    };
    
    getCurrentResizeWidth = function(unitWidth, currentWidth, parentWidth){
        var result = currentWidth;
        
        if(unitWidth === "%"){
            result = Math.round((currentWidth*100)/parentWidth)+unitWidth;
        }else{
            result = currentWidth+unitWidth;
        }
        
        return result;
    };
    
    getHandlesString = function (dataSizeAlign, dataSizeWidthMode){
    	var handlesString = 'e, se, s';
    	
    	if (typeof dataSizeAlign !== "undefined") {
            switch (dataSizeAlign) {
                case "left":
                    handlesString = 'e, se, s';
                    break;
                case "right":
                    handlesString = 'w, sw, s';
                    break;
                case "center":
                    handlesString = 'e, w, se, sw, s';
                    break;
            }
    	}
        
    	return handlesString;
    };
    
    saveResizePartWidth = function(pk, parentWidth, currentWidth, dataSizeWidthMode){
        var params = {};
	params["size"] = {};
        params["size"]["width"] = {};
        
    	switch (dataSizeWidthMode) {
            case "flexible":
                var currentWidthPourcent = Math.round((currentWidth*100)/parentWidth);
                params["size"]["width"]["flexible_value"] = currentWidthPourcent;
                storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                break;

            case "fixed":
                params["size"]["width"]["fixed_value"] = currentWidth;
                storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                break;
        }
    };
    
    saveResizePartHeight = function(pk, currentHeight, dataSizeHeightMode){
	var params = {};
	params["size"] = {};
	params["size"]["height"] = {};
        
    	switch (dataSizeHeightMode) {
            case "custom":
                params["size"]["height"]["value"] = currentHeight;
                storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                break;

            default: /*Auto*/
                params["size"]["height"]["value"] = currentHeight;
                params["size"]["height"]["mode"] = 'custom';
                storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                break;
    	}
    };
    
    disableResizePart = function (selector) {
		selector = typeof selector !== 'undefined' ? selector : "";

		resizePartSelector = jQuery(".part:not(.ngelayout)");

		resizePartSelector = resizePartSelector.not(resizePartSelectorAlignNone).not(resizePartSelectorAlignAvailable).not(resizePartSelectorPartTextLabel).not(resizePartSelectorPartTextDropcap).not(resizePartSelectorLayoutPage).not(resizePartSelectorLayoutColumn);

		resizePartSelector.each(function( index ) {
			var currentSelector = jQuery(this);

			if (typeof currentSelector !== "undefined" && currentSelector.hasClass("ui-resizable") && (typeof currentSelector.data("ngelayout") == "undefined"))
				currentSelector.resizable("destroy");
			
			/*Delete class ui-state-disabled because the disable resizable add this class and we don't need it.
			resizeParts.removeClass('ui-state-disabled');*/
		});
    };

/*});*/

/******* Margins *******************/

    enableMarginPart = function (selector, activeMarge) {
    	/*Get the selector for the rezisable*/
    	selector = typeof selector !== 'undefined' ? selector : "";
    	activeMarge = typeof activeMarge !== 'undefined' ? activeMarge : true;
        
        if(activeMarge === true){
            if(selector === "")
                var marginPartSelector = jQuery("div.ngelayout .part");
            else 
                var marginPartSelector = jQuery(selector);

            var parentWidth, startPartWidth, partWidth, childWidth, diffPartChildWidth, storePartWidthIfLowerThanChildWidth;
            var margLeft, margRight, margTop, margBottom;
            var padLeft, padRight, padTop, padBottom, padHorizontalTotal, padVerticalTotal;
            var borderLeft, borderRight, borderTop, borderBottom;
            var margeSize, newPartSize;
    	
            marginPartSelector.each(function( index ) {
                    var currentPartMargin = jQuery(this);
                    var dataSizeDisplay = currentPartMargin.data("size-display");
                    var dataSizeAlign = currentPartMargin.data("size-align");
                    var dataSizeWidthMode = currentPartMargin.data("size-width-mode");    		
                    var dataSizeHeightMode = currentPartMargin.data("size-height-mode");
                    var currentPrevElement = currentPartMargin.prev();
                    
                    var currentPrevElementMarginBottom = 0;
                    if(currentPrevElement.length != 0){ /*If prev element exist else 0*/
                        currentPrevElementMarginBottom = Math.round(parseFloat(currentPrevElement.css('margin-bottom').replace('px','')));
                    }
                    var partToolbarTop;
                    /*Add the div handle at the end of the current element*/
                    addPartMarginHandles(currentPartMargin, dataSizeAlign);

                    currentPartMargin.draggable({
                        handle: currentPartMargin.find(".nge-margin-handle"),
                        start: function(event, ui){
                            handleTarget = jQuery(event.originalEvent.target).closest(".nge-margin-handle");
                            newPartSize 	= null;
                            parentWidth 	= Math.round(parseFloat(jQuery(this).parent().width()));
                            startPartWidth 	= Math.round(parseFloat(jQuery(this).outerWidth()));
                            partWidth 		= Math.round(parseFloat(jQuery(this).outerWidth()));
                            childWidth          = Math.round(parseFloat(jQuery(this).children().outerWidth()));
                            storePartWidthIfLowerThanChildWidth = null;
                            diffPartChildWidth  = partWidth - childWidth;
                            margLeft 		= Math.round(parseFloat(jQuery(this).css('margin-left').replace('px','')));
                            margRight 		= Math.round(parseFloat(jQuery(this).css('margin-right').replace('px','')));
                            margTop 		= Math.round(parseFloat(jQuery(this).css('margin-top').replace('px','')));
                            margBottom 		= Math.round(parseFloat(jQuery(this).css('margin-bottom').replace('px','')));
                            borderLeft	 	= Math.round(parseFloat(jQuery(this).css('border-left-width').replace('px','')));
                            borderRight 	= Math.round(parseFloat(jQuery(this).css('border-right-width').replace('px','')));
                            borderTop 		= Math.round(parseFloat(jQuery(this).css('border-top-width').replace('px','')));
                            borderBottom 	= Math.round(parseFloat(jQuery(this).css('border-bottom-width').replace('px','')));
                            padLeft 		= Math.round(parseFloat(jQuery(this).css('padding-left').replace('px','')));
                            padRight 		= Math.round(parseFloat(jQuery(this).css('padding-right').replace('px','')));
                            padTop 			= Math.round(parseFloat(jQuery(this).css('padding-top').replace('px','')));
                            padBottom 		= Math.round(parseFloat(jQuery(this).css('padding-bottom').replace('px','')));
                            padHorizontalTotal = padLeft + padRight;
                            padVerticalTotal = padTop + padBottom;
                            partToolbarTop = jQuery("#part-toolbar").css('top').replace('px','');
                            
                            if (handleTarget.hasClass('nge-margin-w') || handleTarget.hasClass('nge-margin-e')){
                                    currentPartMargin.draggable( "option", "axis", "x" );
                            }else{
                                    currentPartMargin.draggable( "option", "axis", "y" );
                            }

                            jQuery(this).addClass("nge-part-margin-process");
                        },
                        drag: function(event, ui){
                                    /*var unit = (dataSizeWidthMode === "flexible" || dataSizeAlign === "available") ? "%" : "px";
                                     * FOR THE MOMENT MARGIN ARE ALWAYS IN PX*/
                                    var unit = "px";
                                    ui.position.left = Math.round(parseFloat(ui.position.left));
                                    ui.position.top = Math.round(parseFloat(ui.position.top));
                                    partWidth = Math.round(parseFloat(jQuery(this).outerWidth()));
                                    childWidth = Math.round(parseFloat(jQuery(this).children().outerWidth()));
                                        
                                    if (handleTarget.hasClass('nge-margin-e')){
                                        var marginMoveSize = margRight - ui.position.left;

                                        if(dataSizeAlign === "available"){
                                            if(marginMoveSize < 0){
                                                margeSize = 0;
                                                jQuery(this).css({"margin-right": margeSize+"px"});
                                            }else if(partWidth < (childWidth + diffPartChildWidth)){
                                                if(storePartWidthIfLowerThanChildWidth === null){
                                                    storePartWidthIfLowerThanChildWidth = childWidth + diffPartChildWidth;
                                                }

                                                margeSize = parentWidth - storePartWidthIfLowerThanChildWidth - margLeft;
                                                jQuery(this).css({"margin-right": margeSize+"px"});
                                                return false;
                                            }else if(marginMoveSize > parentWidth - (margLeft + 100)){
                                                margeSize = parentWidth - (margLeft + 100);
                                                jQuery(this).css({"margin-right": margeSize+"px"});
                                            }else{
                                                margeSize = marginMoveSize;
                                                jQuery(this).css({"margin-right": margeSize+"px"});
                                            }
                                        }else{
                                            if(marginMoveSize < 0){
                                                margeSize = 0;
                                                jQuery(this).css({"margin-right": margeSize+"px"});
                                            }else if((marginMoveSize + partWidth) < parentWidth){
                                                margeSize = marginMoveSize;

                                                jQuery(this).css({"margin-right": margeSize+"px"});
                                            }else{
                                                if(dataSizeWidthMode === "content"){
                                                    if(partWidth < startPartWidth){
                                                        margeSize = parentWidth - startPartWidth;
                                                        jQuery(this).css({"margin-left": margeSize+"px"});
                                                        return false;
                                                    }
                                                }else{
                                                    if(partWidth > 50){
                                                            margeSize = marginMoveSize;
                                                            newPartSize = parentWidth - margeSize;
                                                    }else{
                                                            margeSize = parentWidth - 50;
                                                            newPartSize = 50;
                                                    }

                                                    jQuery(this).css({"margin-right": margeSize+"px"});
                                                    jQuery(this).css({"width": newPartSize+"px"});
                                                }
                                            }
                                        }

                                        handleTarget.css({
                                            "right": -(margeSize + borderRight)+"px",
                                            "width": margeSize+"px"
                                        });

                                        jQuery("#part-toolbar-status").html(COM_NGE_JS_EDITING_MARGIN_RIGHT_CHANGE+' : ' + getCurrentMargeWidth(unit, margeSize, parentWidth)).show();
                                        ui.position.left = 0;
                                    }else if(handleTarget.hasClass('nge-margin-w')){
                                        var marginMoveSize = margLeft + ui.position.left;

                                        if(dataSizeAlign === "available"){
                                            if(marginMoveSize < 0){
                                                margeSize = 0;
                                                jQuery(this).css({"margin-left": margeSize+"px"});   
                                            }else if(partWidth < (childWidth + diffPartChildWidth)){
                                                if(storePartWidthIfLowerThanChildWidth === null){
                                                    storePartWidthIfLowerThanChildWidth = childWidth + diffPartChildWidth;
                                                }

                                                margeSize = parentWidth - storePartWidthIfLowerThanChildWidth - margRight;
                                                jQuery(this).css({"margin-left": margeSize+"px"});
                                                return false;
                                            }else if(marginMoveSize > parentWidth - (margRight + 100)){
                                                margeSize = parentWidth - (margRight + 100);
                                                jQuery(this).css({"margin-left": margeSize+"px"});
                                            }else{
                                                margeSize = marginMoveSize;
                                                jQuery(this).css({"margin-left": margeSize+"px"});
                                            }
                                        }else{
                                            if(marginMoveSize < 0){
                                                margeSize = 0;
                                                jQuery(this).css({"margin-left": margeSize+"px"});
                                            }else if((marginMoveSize + partWidth) < parentWidth){
                                                margeSize = marginMoveSize;

                                                jQuery(this).css({"margin-left": margeSize+"px"});
                                            }else{
                                                if(dataSizeWidthMode === "content"){
                                                    if(partWidth < startPartWidth){
                                                        margeSize = parentWidth - startPartWidth;
                                                        jQuery(this).css({"margin-left": margeSize+"px"});
                                                        return false;
                                                    }
                                                }else{
                                                    if(partWidth > 50){
                                                        margeSize = marginMoveSize;
                                                        newPartSize = parentWidth - margeSize;
                                                    }else{
                                                        margeSize = parentWidth - 50;
                                                        newPartSize = 50;
                                                    }

                                                    jQuery(this).css({"margin-left": margeSize+"px"});
                                                    jQuery(this).css({"width": newPartSize+"px"});
                                                }
                                            }
                                        }

                                        handleTarget.css({
                                            "left": -(margeSize + borderLeft)+"px",
                                            "width": margeSize+"px"
                                        }).children("div").css({
                                            "left": margeSize+"px"
                                        });

                                        jQuery("#part-toolbar-status").html(COM_NGE_JS_EDITING_MARGIN_LEFT_CHANGE+' : ' + getCurrentMargeWidth(unit, margeSize, parentWidth)).show();
                                        ui.position.left = 0;
                                    }else if(handleTarget.hasClass('nge-margin-n')){     
                                        var partToolbarTopFinal = parseFloat(partToolbarTop) + parseFloat(ui.position.top);
                                        
                                        if(margTop > currentPrevElementMarginBottom){
                                            /*To manage marge fusion on navigator*/
                                            /*IF current part marge top bigger than prev element marge bottom*/
                                            var marginMoveSize = margTop + ui.position.top;
                                            
                                            if(marginMoveSize < currentPrevElementMarginBottom){
                                                    margeSize = 0;
                                                    jQuery(this).css({"margin-top": margeSize+"px"});
                                            }else{
                                                margeSize = marginMoveSize;
                                                jQuery(this).css({"margin-top": margeSize+"px"});
                                                jQuery("#part-toolbar").css({"top": partToolbarTopFinal+"px"});
                                            }
                                        }else{
                                            /*ELSE IF current part marge top lower than prev element marge bottom*/
                                            var marginMoveSize = currentPrevElementMarginBottom + ui.position.top;
                                            
                                            if(marginMoveSize < currentPrevElementMarginBottom){
                                                    margeSize = 0;
                                                    jQuery(this).css({"margin-top": margeSize+"px"});
                                            }else{
                                                margeSize = marginMoveSize;
                                                jQuery(this).css({"margin-top": margeSize+"px"});
                                                jQuery("#part-toolbar").css({"top": partToolbarTopFinal+"px"});
                                            }
                                        }
                                          
                                            handleTarget.css({
                                                    "height": margeSize+"px",
                                                    "top": -(margeSize + borderTop)+"px",
                                            }).children("div").css({
                                                    "top": (margeSize)+"px"
                                            });

                                            jQuery("#part-toolbar-status").html(COM_NGE_JS_EDITING_MARGIN_TOP).show();
                                            ui.position.top = 0;
                                    }else if(handleTarget.hasClass('nge-margin-s')){
                                            var marginMoveSize = margBottom + ui.position.top;

                                            if(marginMoveSize < 0){
                                                    margeSize = 0;
                                                    jQuery(this).css({"margin-bottom": margeSize+"px"});
                                            }else{
                                                    margeSize = marginMoveSize;
                                                    jQuery(this).css({"margin-bottom": margeSize+"px"});
                                            }

                                            handleTarget.css({
                                                    "height": margeSize+"px",
                                                    "bottom": -(margeSize + borderBottom)+"px",
                                            }).children("div").css({
                                                    "top": (margeSize)+"px"
                                            });

                                            jQuery("#part-toolbar-status").html(COM_NGE_JS_EDITING_MARGIN_BOTTOM_CHANGE+' : ' + getCurrentMargeWidth(unit, margeSize, parentWidth)).show();
                                            ui.position.top = 0;
                                    }

                            },
                            stop: function(event, ui){
                                    /*Part ID : part id is "part-nnn"*/
                                    var divid = jQuery(this).attr('id');
                                    var pkArray = divid.split("-");
                                    var pk = pkArray[1];
                                    var params = {};
                                    params["size"] = {};
                                    params["size"]["margin"] = {};
                                    
                                    /*FOR THE MOMENT MARGIN ARE ALWAYS IN PX
                                    if (typeof dataSizeAlign !== "undefined" && dataSizeAlign === "available"){
                                        margeSize = Math.round((margeSize*100)/parentWidth);
                                    }else{
                                        if (typeof dataSizeWidthMode !== "undefined" && dataSizeWidthMode === "flexible"){
                                            margeSize = Math.round((margeSize*100)/parentWidth);
                                            
                                            if(newPartSize !== null){
                                                newPartSize = Math.round((newPartSize*100)/parentWidth);
                                            }
                                        }
                                    }*/
                                
                                    jQuery(this).removeClass("nge-part-margin-process");
                                    
                                    if (handleTarget.hasClass('nge-margin-e')){
                                            params["size"]["margin"]["right"] = margeSize;
                                            if(newPartSize != null){
                                                params["size"]["width"] = {};
                                                if(dataSizeWidthMode === "flexible"){
                                                    params["size"]["width"]["flexible_value"] = newPartSize;
                                                }else if(dataSizeWidthMode === "fixed"){
                                                    params["size"]["width"]["fixed_value"] = newPartSize;
                                                }
                                            }
                                            storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                                    }else if(handleTarget.hasClass('nge-margin-w')){
                                            params["size"]["margin"]["left"] = margeSize;

                                            if(newPartSize != null){
                                                params["size"]["width"] = {};
                                                if(dataSizeWidthMode === "flexible"){
                                                    params["size"]["width"]["flexible_value"] = newPartSize;
                                                }else if(dataSizeWidthMode === "fixed"){
                                                    params["size"]["width"]["fixed_value"] = newPartSize;
                                                }
                                            }
                                            
                                            storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                                    }else if(handleTarget.hasClass('nge-margin-n')){
                                            params["size"]["margin"]["top"] = margeSize;
                                            storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                                    }else if(handleTarget.hasClass('nge-margin-s')){
                                            params["size"]["margin"]["bottom"] = margeSize;
                                            storePartParams(pk, params, true, jQuery("#part-toolbar-save"));
                                    }
                            }
                });
            });
        }
    };
    
    addPartMarginHandles = function (currentPartMargin, dataSizeAlign){
    	if (typeof dataSizeAlign !== "undefined") {
    		borderLeft 		= Math.round(parseFloat(currentPartMargin.css('border-left-width').replace('px','')));
	    	borderRight 	= Math.round(parseFloat(currentPartMargin.css('border-right-width').replace('px','')));
	    	borderTop 		= Math.round(parseFloat(currentPartMargin.css('border-top-width').replace('px','')));
	    	borderBottom 	= Math.round(parseFloat(currentPartMargin.css('border-bottom-width').replace('px','')));
	    	margLeft 		= Math.round(parseFloat(currentPartMargin.css('margin-left').replace('px','')));
	    	margRight 		= Math.round(parseFloat(currentPartMargin.css('margin-right').replace('px','')));
	    	margTop 		= Math.round(parseFloat(currentPartMargin.css('margin-top').replace('px','')));
	    	margBottom 		= Math.round(parseFloat(currentPartMargin.css('margin-bottom').replace('px','')));
	    	
			switch (dataSizeAlign) {
				case "left":
					currentPartMargin.append('<div class="nge-margin-handle nge-margin-w ngenosave" style="z-index: 9998;"><div></div></div>');
					currentPartMargin.find(".nge-margin-w").css({
						"left": -(margLeft+borderLeft)+"px",
						"width": margLeft+"px"
					}).children("div").css({
						"left": margLeft+"px"
					});
					break;
				case "right":
					currentPartMargin.append('<div class="nge-margin-handle nge-margin-e ngenosave" style="z-index: 9998;"><div></div></div>');
					currentPartMargin.find(".nge-margin-e").css({
						"right": -(margRight+borderRight)+"px",
						"width": margRight+"px"
					});
					break;
				case "available":
					currentPartMargin.append('<div class="nge-margin-handle nge-margin-w ngenosave" style="z-index: 9998;"><div></div></div>');
					currentPartMargin.find(".nge-margin-w").css({
						"left": -(margLeft+borderLeft)+"px",
						"width": margLeft+"px"
					}).children("div").css({
						"left": margLeft+"px"
					});
					
					currentPartMargin.append('<div class="nge-margin-handle nge-margin-e ngenosave" style="z-index: 9998;"><div></div></div>');
					currentPartMargin.find(".nge-margin-e").css({
						"right": -(margRight+borderRight)+"px",
						"width": margRight+"px"
					});
					break;
			}
			
			currentPartMargin.append('<div class="nge-margin-handle nge-margin-n ngenosave" style="z-index: 9998;"><div class="ngebtn-widget-move-vertical" data-toggle="tooltip" data-original-title="Déplacer verticalement"><div></div></div></div>');
			currentPartMargin.append('<div class="nge-margin-handle nge-margin-s ngenosave" style="z-index: 9998;"><div></div></div>');
			
			currentPartMargin.find(".nge-margin-s").css({
				"height": margBottom+"px",
				"bottom": -(margBottom+borderBottom)+"px"
			}).children("div").css({
				"top": margBottom+"px"
			});
                        
			currentPartMargin.find(".nge-margin-handle > div").mouseenter(function(){
                            var currentHandle = jQuery(this).parent();
                            
                            if(currentHandle.hasClass("nge-margin-n")){
                                currentHandle.css({"z-index": 10000});
                                jQuery("#part-toolbar-status").html(COM_NGE_JS_EDITING_MARGIN_TOP).show(); 
                            }else{
                                jQuery("#part-toolbar-status").html(COM_NGE_JS_EDITING_MARGIN_CHANGE).show(); 
                            }
			}).mouseleave(function(){
                            var currentHandle = jQuery(this).parent();
                            
                            if(currentHandle.hasClass("nge-margin-n")){
                                currentHandle.css({"z-index": 9998});
                            }
                            
                            jQuery("#part-toolbar-status").hide().html("");
			});
    	}
    };
    
    getCurrentMargeWidth = function(unit, margeWidth, parentWidth){
        var result = margeWidth;
        
        if(unit === "%"){
            result = Math.round((margeWidth*100)/parentWidth)+unit;
        }else{
            result = margeWidth+unit;
        }
        
        return result;
    };
    
    disableMarginPart = function (selector) {
		selector = typeof selector !== 'undefined' ? selector : "";
    
    	if(selector == "")
    		var marginPartSelector = jQuery(".part");
    	else 
    		var marginPartSelector = jQuery(selector);
    	
    	marginPartSelector.each(function( index ) {
			var currentSelector = jQuery(this);

			if (typeof currentSelector !== "undefined" && currentSelector.hasClass("ui-draggable"))
				currentSelector.draggable("destroy");
			
			currentSelector.find(".nge-margin-handle").remove();
		});
    };
   





    /*Referencing functions.
    Adding to editing functions pool */
    //ngeEnableEditFunctions.push(enableNgePartToolbar);
    //ngeDisableEditFunctions.push(disableNgePartToolbar);

jQuery(document).on( "ngeEnableEdition", function() {
  enableNgePartToolbar();    
});

jQuery(document).on( "ngeDisableEdition", function() {
  disableNgePartToolbar();
});

