<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

$user = NGE::user();
$userName = $user->name;
//User can see other workshops
$canSeeWorkshops = (in_array(FIGARODB_LEVEL_ATELIERREDACTION_SECTEUR, $user->getAuthorisedViewLevels()));


//$this->item contient les informations du workshop courant.
//Affichage du nom de l'atelier si ce n'est pas celui de son utiliateur propriétaire
$displayedWorkshopname = ($this->item->created_by != $user->id) ? '<span>&nbsp;' . $this->item->title . '</span>' : '';
?>
<style> 
#ngemainbar-add.ngeloading::before{
    content:url(<?php echo JUri::root() ?>components/com_nge/assets/images/spinner_svg_white.svg);
}
/*for Figaro finger to clic on the workshop*/
#containergallery li.thumb > div {
    cursor:pointer;    
}

#view-mode-group i{
    color:#D6E3F4;
}

#view-mode-group button{
    background-color: transparent;
    background-image:none;
    padding-top:8px;
    border:transparent;
    -webkit-box-shadow: none;
    -moz-box-shadow: none;
    box-shadow: none;
    -webkit-border-top-left-radius: 0px;
    -moz-border-radius-topleft: 0px;
    border-top-left-radius: 0px;
    -webkit-border-bottom-left-radius: 0px;
    -moz-border-radius-bottomleft: 0px;
    border-bottom-left-radius: 0px;
    -webkit-border-top-right-radius: 0px;
    -moz-border-radius-topright: 0px;
    border-top-right-radius: 0px;
    -webkit-border-bottom-right-radius: 0px;
    -moz-border-radius-bottomright: 0px;
    border-bottom-right-radius: 0px;
}

#view-mode-group button.active, #view-mode-group button:hover{
background-color: #8B92B3;
}
#view-mode-group button.active i, #view-mode-group button:hover i{
color:#fff;
}

span.username{
    font-size : 16px;
    color: #fff;
    vertical-align:middle;
    padding-right:10px;
    margin-left:60px;
}
#nge-editing-bar{
    position: relative;
    display: block;
    background-color: #646D9C;
    z-index: 999 !important;
    top: 0;
    left: 0;
    -moz-box-sizing: border-box;
    -webkit-box-sizing: border-box;
    box-sizing: border-box;
}

#nge-editing-bar div{
    -moz-box-sizing: border-box;
    -webkit-box-sizing: border-box;
    box-sizing: border-box;
}
#nge-editing-bar .figaro-mainbar-container {    
    display: -ms-flexbox;
    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: row;
    -ms-flex-direction: row;
    flex-direction: row;
    -webkit-flex-wrap: wrap;
    -ms-flex-wrap: wrap;
    flex-wrap: wrap;
    -webkit-justify-content: flex-start;
    -ms-flex-pack: start;
    justify-content: flex-start;
    -webkit-align-content: stretch;
    -ms-flex-line-pack: stretch;
    align-content: stretch;
    -webkit-align-items: flex-start;
    -ms-flex-align: start;
    align-items: flex-start;
}

#nge-editing-bar .figaro-mainbar-item{
  color:#FFFFFF;
  font-size:24px;
  padding:10px;
  height: 100%;
  box-sizing: border-box;
}

#nge-editing-bar .figaro-mainbar-item-title{
    padding:12px;
    font-size:18px;
    font-weight:bold;
    white-space: nowrap;
}

#nge-editing-bar .figaro-mainbar-item-link{
  cursor:pointer;
}

#nge-editing-bar .figaro-mainbar-item-link.active, #nge-editing-bar .figaro-mainbar-item-link:hover{
  background-color: #8B92B3;
}

#nge-editing-bar .figaro-mainbar-group-first{
    -webkit-order: 0;
    -ms-flex-order: 0;
    order: 0;
    -webkit-flex: 0 1 340px;
    -ms-flex: 0 1 340px;
    flex: 0 1 340px;
    -webkit-align-self: stretch;
    -ms-flex-item-align: stretch;
    align-self: stretch;
    display: -ms-flexbox;
    display: -webkit-flex;
    display: flex;
}

#nge-editing-bar .figaro-mainbar-group{
  -webkit-order: 0;
    -ms-flex-order: 0;
    order: 0;
    -webkit-flex: 0 1 auto;
    -ms-flex: 0 1 auto;
    flex: 0 1 auto;
    -webkit-align-self: stretch;
    -ms-flex-item-align: stretch;
    align-self: stretch;
    display: -ms-flexbox;
    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: row;
    -ms-flex-direction: row;
    flex-direction: row;
    -webkit-flex-wrap: nowrap;
    -ms-flex-wrap: nowrap;
    flex-wrap: nowrap;
}

#nge-editing-bar .figaro-mainbar-group-last{
   -webkit-order: 0;
    -ms-flex-order: 0;
    order: 0;
    -webkit-flex: 1 1 auto;
    -ms-flex: 1 1 auto;
    flex: 1 1 auto;
    -webkit-align-self: stretch;
    -ms-flex-item-align: stretch;
    align-self: stretch;
}

#nge-editing-bar .figaro-mainbar-group-right{
  display: -ms-flexbox;
    display: -webkit-flex;
    display: flex;
    -webkit-flex-direction: row;
    -ms-flex-direction: row;
    flex-direction: row;
    -webkit-flex-wrap: nowrap;
    -ms-flex-wrap: nowrap;
    flex-wrap: nowrap;
    -webkit-justify-content: flex-end;
    -ms-flex-pack: end;
    justify-content: flex-end;
    -webkit-align-content: stretch;
    -ms-flex-line-pack: stretch;
    align-content: stretch;
    -webkit-align-items: flex-start;
    -ms-flex-align: start;
    align-items: flex-start;
    height: 100%;
    box-sizing: border-box;
}

#nge-editing-bar .figaro-mainbar-item-logout{
    font-size: 18px;
    padding: 11px;
}
#nge-editing-bar .figaro-mainbar-item-logout:hover{
    background-color:#e74c3c;
}
#ngemainbar-search{
    display:none;
}
</style>
<div id="nge-editing-bar" data-nge-mainbar-theme="horizontal">
    <div class="figaro-mainbar-container">
        <div class="figaro-mainbar-group-first">
            <div class="figaro-mainbar-item figaro-mainbar-item-title">
                LE&nbsp;FIGARO
                <a style="text-decoration:none;color:#646D9C;background-color:#ffffff;-webkit-border-radius: 6px;-moz-border-radius: 6px;border-radius: 6px;padding: 2px 6px;font-size: 17px;margin-left: 10px;" target="_blank" href="http://www.lefigaro.fr/assets/infographie/print/siteRedacteurs/aide-pour-teatis.html">
                    AIDE
                </a>
            </div>
        </div>
        <div class="figaro-mainbar-group">
            <div style="display: inline-block;margin-right: -4px;vertical-align: top;display:none;">
                <div id="ngemainbar-button" data-toggle="tooltip"
                     data-original-title="<?php echo NGE::translate('COM_NGE_HELP_MAINBAR_EDITING'); ?>">
                    <span id="ngemainbar-button-icon" class="icomoon-lock"></span>
                    <div align="center" class="nge-loading1" style="display:none;">
                        <div class="nge-loading1-container-general">
                            <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_1"> </div></div>
                            <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_2"> </div></div>
                            <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_3"> </div></div>
                            <div class="nge-loading1-internal"><div class="nge-loading1-ballcolor nge-loading1-ball_4"> </div></div>
                        </div>
                    </div>
                </div>
            </div>
            <div id="ngemainbar-add" class="figaro-mainbar-item figaro-mainbar-item-link icomoon ngeloading" data-content="parts" title="Ajouter une nouvelle infographie"></div>
            <div id="ngemainbar-body" class="nge-menu" style="float:left;position:absolute;"></div>
            <div id="ngemainbarsearch-btn" class="figaro-mainbar-item figaro-mainbar-item-link icomoon icomoon-search" style="display:none;" title="Rechercher une infographie existante"></div>
            <div id="ngemainbar-search" class="figaro-mainbar-item figaro-mainbar-item-link icomoon icomoon-search" style="display:none;" title="Rechercher une infographie existante"></div>
            <?php if ($canSeeWorkshops): ?>
                <div id="ngemainbar-users" class="figaro-mainbar-item figaro-mainbar-item-link icomoon icomoon-users" style="display:none;" title="Ateliers des rédacteurs"></div>
                <div class="figaro-mainbar-item" style="white-space: nowrap;padding:12px;font-size:18px;font-style:italic;"><?php echo $displayedWorkshopname;?></div>
            <?php endif; ?>
        </div>
        <div class="figaro-mainbar-group-last">
            <div class="figaro-mainbar-group-right" id="view-mode-group">
                <input id="view-mode" type="hidden" value="fastview" />
                <div id="view-mode-group" name="btngroup-view-mode" class="btn-group figaro-mainbar-item" data-toggle-name="view-mode" data-toggle="buttons-radio" style="padding:0px;">
		    <button type="button" value="fastview" class="btn figaro-mainbar-item" data-toggle="button" title="Aperçu rapide"><i class="icomoon-image"></i></button>
		    <button type="button" value="preview" class="btn figaro-mainbar-item" data-toggle="button" title="Aperçu réel"><i class="icomoon-play"></i></button>
		    <button type="button" value="edit" class="btn figaro-mainbar-item" data-toggle="button" title="Edition directe"><i class="icomoon-pencil"></i></button>		    
		    <?php /*<button type="button" value="grid" class="btn figaro-mainbar-item" data-toggle="button" title="Galerie"><i class="icomoon-th-large"></i></button>
		     <button type="button" value="list" class="btn figaro-mainbar-item" data-toggle="button" title="Liste"><i class="icomoon-th-list"></i></button>
		     <button type="button" value="thumbnails" class="btn figaro-mainbar-item" data-toggle="button" title="Thumbnails"><i class="icomoon-th-small"></i></button>*/ ?>
		</div>
                <?php
                $url_logout= JUri::root()."index.php?option=com_users&task=user.logout&" . NGE::token() . "=1";
                ?>
                <div class="figaro-mainbar-item" style="white-space: nowrap;margin-left:30px;padding:12px;font-size:16px;padding-right:0px;"><?php echo $userName; ?></div>
                <div class="figaro-mainbar-item figaro-mainbar-item-link figaro-mainbar-item-logout" style="font-size: 18px;padding: 11px;" title="Déconnexion">
                    <a style="text-decoration:none;" href="<?php echo $url_logout; ?>"><i class="icomoon icomoon-switch" style="color:#fff;"></i></a>
                </div>
            </div>
        </div>
    </div>
    <span id="ngemove-toolbar" style="display: none;"
	    class="ngetlb-move ngenosave icomoon-move"
	    title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_MOVE_TITLE'); ?>">
    </span>
    <span style="display: none;"
	    class="ngetlb-module-move"
	    title="<?php echo NGE::translate('COM_NGE_EDITOR_TOOLBAR_MOVE_TITLE'); ?>">
        &#9776;
    </span>
</div>

<div id="nge-message-box">
    <div class="nge-message-box-first nge-message-box-clone">
	<span class="icomoon"></span>
	<span class="nge-message">Test</span>
    </div>
</div>
<input type="hidden" id="nge-token" value="<?= NGE::token(); ?>">
<div id="nge-bootstrap-missing" style="display:none;">
    <div class="title"><div class="nge-bootstrap-missing-title"><?php echo NGE::translate('COM_NGE_HELP_MAINBAR_BOOTSTRAP_MISSING') ?></div></div>
    <div class="content"><div class="nge-bootstrap-missing-content"><?php echo NGE::translate('COM_NGE_HELP_MAINBAR_BOOTSTRAP_MISSING_DESC') ?></div></div>
    <div class="button"><div class="nge-bootstrap-missing-button"><?php echo NGE::translate('COM_NGE_HELP_MAINBAR_BOOTSTRAP_MISSING_LOAD_BUTTON') ?></div></div>
</div>
<form id="tokenform">
    <?php echo NGE::tokenInput(); ?>
</form>
<script>  
    jQuery(function() {
        /*Events*/
        jQuery('#view-mode-group button').each(function() {
            var button = jQuery(this);
            var $viewMode = jQuery("#view-mode");
            button.click(function(e) {
                e.stopPropagation();
                jQuery('#view-mode-group button').removeClass('active');
                jQuery(this).addClass('active');
                var viewMode = jQuery(this).val();
                /*Changing viewmode class*/
                jQuery("div.ngelayout-workshop .content").removeClass("nge-workshop-"+$viewMode.val());
                jQuery("div.ngelayout-workshop .content").addClass("nge-workshop-"+viewMode);
                $viewMode.val(viewMode);

                /* for being used by the config screen */
                jQuery("div.ngelayout-workshop").data("ngeviewmode", viewMode);

                loadCategoryContent(getCurrentCategory());
            });

            if (button.val() == $viewMode.val()) {
                button.addClass('active');
            }   
        });	

        /*Init*/
        var currentView = jQuery("#view-mode-group").find("button.active").val();
        jQuery("div.ngelayout-workshop").data("ngeviewmode", currentView);
    });
</script>