<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;
?>
@charset "utf-8";
@media print {
    #nge-editing-bar, #part-toolbar, #ngemove-toolbar{
        display:none;
    }
}

#nge-backdrop-loading{
    position: fixed;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    z-index: 9999;
}

#nge-editing-bar .ngemainbar-icon{
    display: table;
    cursor: pointer;
    padding: 12px;
    background: #204389;
    color: #FFFFFF;
    border-top: 1px solid #ffffff;
    -webkit-transition: border .2s ease-in-out;
    -moz-transition: border .2s ease-in-out;
    -o-transition: border .2s ease-in-out;
    transition: border .2s ease-in-out;
}

#nge-editing-bar .ngemainbar-icon:hover{
    background: rgba(32,67,137,0.8);
}

.part.ngeeditable:hover {
	outline: 1px dashed #646D9C;
}

div.nge-modal{
	-moz-border-radius: 0px !important;
	border-radius: 0px !important;
	-webkit-box-shadow: 0 3px 7px rgba(0,0,0,0.3) !important;
    -moz-box-shadow: 0 3px 7px rgba(0,0,0,0.3) !important;
    box-shadow: 0 3px 7px rgba(0,0,0,0.3) !important;
}

.ngelayout.ngeeditable:not(.ngelayout-part) > div.content, .ngelayout-part.ngeeditable{
    min-height:80px;
}

#nge-message-box{
	position: fixed;
	left: 0;
    top: 0;
    z-index: 15001;
}

#nge-message-box .nge-message-box-first{
	display:none;
}

#nge-message-box .nge-message-box-clone{
	position:relative;
	padding:10px;
	color:#ffffff;
	margin-bottom:2px;
}

#nge-message-box .nge-message-box-success{background:#81CE66;}
#nge-message-box .nge-message-box-warning{background:#F09721;}
#nge-message-box .nge-message-box-error{background:#E43D26;}

#ngemainbar-button{
    background-color: #8B92B3 !important;
    cursor: pointer !important;	
    height:40px;
    width:47px;
    display:table-cell;
    text-align: center;
    vertical-align:middle;
    line-height: 17px;
    font-size:17px !important;
}

#ngemainbar-button span{
    display:none;
    margin-left:4px;
    color:#ffffff;
}

#ngemainbar-button img{
    margin: 0 auto;
    width: 33px !important;
}

/***** NGEMAINBAR Toolbar tabs bootstrap forced *****/
#ngemainbar-toolbar{
    background-color:#FFFFFF !important;
    width: 47px;
}

#ngemainbar-toolbar .nav {
	margin-left: 0;
	margin-bottom: 18px;
	list-style: none !important;
}

#ngemainbar-toolbar .nav > li > a:hover,
#ngemainbar-toolbar .nav > li > a:focus {
	text-decoration: none;
}

#ngemainbar-toolbar.nav > li > a > img {
	max-width: none;
}

#ngemainbar-toolbar.nav > .pull-right {
	float: right;
}

#ngemainbar-toolbar.nav-tabs{
	*zoom: 1;
}

#ngemainbar-toolbar .nav-tabs:before,
#ngemainbar-toolbar .nav-tabs:after{
	display: table;
	content: "";
	line-height: 0;
}

#ngemainbar-toolbar .nav-tabs:after{
	clear: both;
}

#ngemainbar-toolbar .nav-tabs a span, #ngemainbar-toolbar .tab h3{
	position: inherit !important;
	left: inherit !important;
}

#ngemainbar-toolbar .nav-tabs{
    margin:0 !important;
    padding:0 !important;
}

#ngemainbar-toolbar .nav-tabs > li {
	margin-bottom: 0px !important;
	cursor: pointer !important;	
	list-style: none !important;
	padding: 0px !important;
	padding-left: 0px !important;
	background-color:#8B92B3 !important;
	width: 47px;
}
#ngemainbar-toolbar .nav-tabs{
	border: none !important;
}

#ngemainbar-toolbar .nav > li > a{
	display: block;
	text-decoration:none; 
	margin:0 !important;
}

#ngemainbar-toolbar li > a{
	line-height: 14px !important;
	font-size:22px !important;
	background-color:#8B92B3;
	padding:12px;
	border-color: transparent;
   	-webkit-border-radius: 0;
  	-moz-border-radius: 0;
  	border-radius: 0;
  	color:#FFFFFF;
}

#ngemainbar-toolbar .nav-tabs > .active > a,
#ngemainbar-toolbar .nav-tabs > .active > a:hover,
#ngemainbar-toolbar .nav-tabs > .active > a:focus {
	border: 0px solid transparent;
	background-color: #646D9C;
	border-color: transparent;
	cursor: pointer;
}
/***** END NGEMAINBAR Toolbar tabs bootstrap forced *****/

#ngemainbar-body{
    background-color: #FFFFFF;    
    -moz-box-shadow: 0px 5px 10px 0px #9b9b9b;
  -webkit-box-shadow: 0px 5px 10px 0px #9b9b9b;
  -o-box-shadow: 0px 5px 10px 0px #9b9b9b;
  box-shadow: 0px 5px 10px 0px #9b9b9b;
  filter: progid:DXImageTransform.Microsoft.Shadow(color=#9b9b9b, Direction=135, Strength=5);
}

#ngemainbar-body-parts{
    margin-top : 4px;
    margin-left : 0;
    margin-right : 4px;
    margin-bottom : 4px;
}
#ngemainbar-body-parts-title{
    color: #FFFFFF;
    font-size: 14px;
    text-align:center;
    padding: 8px 12px;
    font-weight: bold;
    line-height: 14px;
    margin-left: 2px;
    margin-right: 2px;
    margin-bottom: 4px;
}

#ngethumbnails {
    margin:0px;
    padding: 0px;
}    
#ngethumbnails li{
display: block;
padding: 0px;
line-height: 20px;
-webkit-transition: all .2s ease-in-out;
-moz-transition: all .2s ease-in-out;
-o-transition: all .2s ease-in-out;
transition: all .2s ease-in-out;
width:80px;
height:80px;
border : 1px solid #dddddd;
margin:2px;
float:left;
    font-size: 11px;
    position: relative;
}

#ngethumbnails img{
    width: 50px;
    margin: 15px;
    margin-top: 10px;
}

/*#ngemainbar-content ul >li{
    background-color: #8B92B3 !important;
    margin-right:2px;
    border:none;
}
#ngemainbar-content ul >li >a{
    color:#FFFFFF !important;
}
#ngemainbar-content ul >li:hover a, 
#ngemainbar-content ul >li.active a{
    background-color: #646D9C !important;    
    border: none;
}
*/
.thumbs_hover:hover .thumbs_btn_group{	
	display:block;
}

.thumbnails img{
width:40px;
height:40px;
}

#ngeLayoutToolbarContent ul.thumbnails > li{
	width:64px;
	height:64px;
	margin-left : 10px !important;
	cursor: move;
}

#ngeLayoutToolbarContent ul.thumbnails{
	margin-left : 0px !important;
	margin-top:10px;
}

#ngethumbnails .legend {
  position: absolute;
  text-align: center;
  left: 0px;
  bottom: 0px;
  width: 100%;

}

#ngeMainbarView span{
	cursor:pointer;
}

/***** Bootstrap Missing *****/
div.modal.nge-bootbox-size{
	width:30%;
	margin-left:-15%;
	-webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    border-radius: 0px;
}

div.modal.nge-bootbox-size .nge-bootstrap-missing-content{
	padding: 20px;
    font-size: 18px;
    text-align: center;
    line-height: 20px;
    color: #646D9C;
	font-family: Arial, sans-serif;
}

div.modal.nge-bootbox-size .modal-footer{
	text-align:center;
}

div.modal.nge-bootbox-size .modal-footer .btn-success{
	border:none;
}

div.modal.nge-bootbox-size .modal-footer .btn{
	-webkit-border-radius: 0px;
    -moz-border-radius: 0px;
    border-radius: 0px;
    padding: 10px 30px;
}
/***** END Bootstrap Missing *****/


/****** Move button for part or module sortable *****/

/* When NGE included in the page, the modules are reloaded with unpublished ones. Hiding them in normal preview. When un locking, they will be displayed */
.ngeunpublished {
    display:none;
}

.ngetlb-move, .ngetlb-module-move{
	position: absolute;
	right:0;
	top:0;
	z-index:9998;	
	display: inline-block;
    color: #ffffff;
    padding: 2px 4px;
    font-size: 12px;
    -webkit-transition: background .2s ease-in-out;
	-moz-transition: background .2s ease-in-out;
	-o-transition: background .2s ease-in-out;
	transition: background .2s ease-in-out;
	cursor:move;
}

.ngetlb-move{
    background: #8B92B3;
}
.ngetlb-module-move{
    background: #F77;
}

.ngetlb-move:hover{
    background: ##646D9C;
}
.ngetlb-module-move:hover{
    background: #d55;
}

/***** END Move button *****/

.ngedraggable-mainbar{
	cursor: move;	
}

.ngelayout-popover{
	display:none;	
}

.bootbox.nge-bootbox-packinformation {
	width: 60% !important;
  	margin: 0 auto !important;
  	top:0;
  	right:0;
  	left:0;
}

.bootbox.nge-bootbox-packinformation .modal-body{
	max-height:100% !important;
}

#ngeLayoutToolbar{
	font-family: Arial;
	z-index:999;
	/*left : 0;*/
	position: relative;
 	font-size: 14px;
/* 	top : 50%;
 	margin-top: -300px; */
/* up from the half-height of the div to center */
} 	

#ngemainbarParts{
	float: left; 
	
}

#ngemainbarParts ul.nav > li > a{
	color:#fff !important;
	text-decoration: none !important;
	text-shadow: none !important;
	cursor: pointer;
}


#nge-editing-bar-lock, #nge-editing-bar-print{
	background : #646D9C;
    color: #FFFFFF;
    border-radius: 0px;
}

#nge-editing-bar{
	position:fixed;
	left:0;
	top: 20%;
	z-index: 100000;
	/* Gantry menus 10001*/
	box-shadow: 5px 5px 20px #ccc;
}

.jepnavbar {
	min-height: 40px;
	padding-left: 20px;
	padding-right: 20px;
	background-color: #646D9C;
	border: 1px solid #d4d4d4;
	-webkit-border-radius: 4px;
	-moz-border-radius: 4px;
	border-radius: 4px;
	-webkit-box-shadow: 0 1px 4px rgba(0,0,0,0.065);
	-moz-box-shadow: 0 1px 4px rgba(0,0,0,0.065);
	box-shadow: 0 1px 4px rgba(0,0,0,0.065);
}

#nge-editing-bar .navbar .brand{
    color:#ffffff;
    text-shadow : none;
}
#nge-editing-bar .navbar .nav >li >a {
    color:#ffffff;
    text-shadow : none;
}

#nge-editing-bar .dropdown-menu > li > a:hover,
#nge-editing-bar .dropdown-menu > li > a:focus,
#nge-editing-bar .dropdown-submenu:hover > a,
#nge-editing-bar .dropdown-submenu:focus > a 
{
    background-color: #646D9C;
    
}

#ngemainbar-content{
    background-color: #FFFFFF;    
    -moz-box-shadow: 0px 5px 10px 0px #9b9b9b;
  -webkit-box-shadow: 0px 5px 10px 0px #9b9b9b;
  -o-box-shadow: 0px 5px 10px 0px #9b9b9b;
  box-shadow: 0px 5px 10px 0px #9b9b9b;
  filter: progid:DXImageTransform.Microsoft.Shadow(color=#9b9b9b, Direction=135, Strength=5);
}

#nge-sortable-helper{
	position:absolute;
	padding:10px; 
	background:#646D9C;
	font-weight:bold;
	cursor:move !important;
	font-size:14px; 
	line-height:14px;
	display:inline !important;
	box-sizing: border-box !important;
	color:#FFFFFF;
	text-align:center;
	z-index:1000;
	width: auto !important;
	height: auto !important;
}

.ngelayout-sortable, .ngelayout-sortable-thumbnails{
	display:inline-block;
	list-style-type:none;
	border: 1px dashed #49AFCD;
	padding: 10px;
	box-sizing: border-box;
	text-align:center;
	overflow:hidden;
        width:100%;
}

.ngelayout-sortable:after {
	display: inline-block;
  	content: "<?php echo NGE::translate('COM_NGE_MAINBAR_DROPHERE_FULL');?>";
  	color: #49AFCD;
  	font-size: 15px;
}

.ngelayout-sortable-article{
	display:inline-block;
	list-style-type:none;
	border: 1px dashed #49AFCD;
	padding: 10px;
	box-sizing: border-box;
	text-align:center;
	overflow:hidden;
        width:100%;
}
.ngelayout-sortable-article:after {
	display: inline-block;
  	content: "<?php echo NGE::translate('COM_NGE_MAINBAR_DROPARTICLE');?>";
  	color: #49AFCD;
  	font-size: 15px;
}

.ngelayout-sortable-position{
	display:inline-block;
	list-style-type:none;
	border: 1px dashed #F77;
	padding: 10px;
	box-sizing: border-box;
	text-align:center;
	overflow:hidden;
        width:100%;
}
.ngelayout-sortable-position:after {
	display: inline-block;
  	content: "<?php echo NGE::translate('COM_NGE_MAINBAR_DROPPOSITION');?>";
  	color: #F77;
  	font-size: 15px;
}

.ngelayout-sortable-part{
	display:inline-block;
	list-style-type:none;
	border: 1px dashed #8B92B3;
	padding: 10px;
	box-sizing: border-box;
	text-align:center;
	overflow:hidden;
        width:100%;
}
.ngelayout-sortable-part:after {
	display: inline-block;
  	content: "<?php echo NGE::translate('COM_NGE_MAINBAR_DROPPART');?>";
  	color: #8B92B3;
  	font-size: 15px;
}

.ngelayout-sortable-module{
	display:inline-block;
	list-style-type:none;
	border: 1px dashed #F9BEA9;
	padding: 10px;
	box-sizing: border-box;
	text-align:center;
	overflow:hidden;
        width:100%;
}
.ngelayout-sortable-module:after {
	display: inline-block;
  	content: "<?php echo NGE::translate('COM_NGE_MAINBAR_DROPMODULE');?>";
  	color: #F9BEA9;
  	font-size: 15px;
}


.ngelayout-sortable-thumbnails:after {
	display: inline-block;
  	content: "<?php echo NGE::translate('COM_NGE_MAINBAR_DROPHERE_CONDENSED');?>";
  	color: #49AFCD;
  	font-size: 15px;
}
 
.nge-btnhelp {
    border : none;
    color:#FFF;
    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    font-size:13px;
    background : #87A5D3;
    padding:5px 15px 5px 15px;
    font-weight: normal;
  line-height: 18px;
  text-align: center;
  vertical-align: middle;
  cursor: pointer;    
}
.nge-btnhelp:hover {
    background : #6089C6;
}

#accordionCategories{
	background-color:#FFFFFF;
	margin:0;
	padding:4px;
}

#accordionCategories .accordion-group{
	-webkit-border-radius: 0px;
  	-moz-border-radius: 0px;
  	border-radius: 0px;
  	border:none;
}

#accordionCategories .nav-header{
	background-color:#646D9C;
	font-size:14px;
	color:#ffffff;
	text-shadow: none; 	
	padding: 0px;
	line-height: 18px;
}
#accordionCategories .nav-header>a{
	color:#FFFFFF;
	font-size:14px;
	text-decoration: none;
}
#accordionCategories .accordion-inner{
	padding:0px;
	margin:0px;
}
#accordionCategories .accordion-inner ul{
	padding:0px;
	margin:0px;
}
#accordionCategories li{
	cursor: pointer;	
	list-style: none;
	padding: 3px;
	padding-left: 30px;
	line-height: 18px;
}

#ngemainbar-title {
    font-family: "Helvetica Neue", Helvetica, Arial, sans-serif;
    font-size:14px;
    color:#fff;        
}

.ngedropping{
	background: #fff;
    min-height:80px;
    padding: 8px;
}

.ngedragging{
	background-color: rgba(173, 185, 196, 0.8) !important;
}

.document.ngelayout > .content{
	min-height: 180px;
	padding-bottom:20px;
}

/***** Drag and drop, sortable element in layout *****/
.ui-state-highlight { 
	border: 1px dashed #646D9C;
	height: 2.5em; 
	line-height: 1.2em; 
}
.dropzone {
	border: dashed 1px transparent;
	border-radius: 1px;
}
.drop-active {
	border-color: #666;
}
.drag-drop.can-drop { background-color: #4e4; }

.ngelayout-page > .content, .ngelayout-wall > .content{	
	overflow-x:visible !important; 
	overflow-y:visible !important; 
	padding: 0 !important;
}

/**** Wireframe in the layout ****/
.thumbnails>li {
float: left;
margin-bottom: 20px;
margin-left: 20px;
}

.thumbnail {
background-color: #FFF;
/* width: 80px; */
height: 80px;
text-align: center; 
position: relative;
}

.thumbnail {
display: block;
padding: 4px;
line-height: 20px;
border: 1px solid #ddd;
-webkit-border-radius: 4px;
-moz-border-radius: 4px;
border-radius: 4px;
-webkit-box-shadow: 0 1px 3px rgba(0,0,0,0.055);
-moz-box-shadow: 0 1px 3px rgba(0,0,0,0.055);
box-shadow: 0 1px 3px rgba(0,0,0,0.055);
-webkit-transition: all .2s ease-in-out;
-moz-transition: all .2s ease-in-out;
-o-transition: all .2s ease-in-out;
transition: all .2s ease-in-out;
}


/* Warning and information messages */
    div.ngePreviewWarning{

        padding: 10px 10px 10px 10px;
        font-size: 12px;
        color : #fff;
        background: #D44A26;
        margin-bottom: 5px;
    }
    
    div.ngePreviewWarning h4    {
	font-size : 26px;
	font-weight : normal;
	margin:0px 0px 10px 0px;
    }
    div.ngePreviewWarning .close, div.ngePreviewInformation .close {
	position: relative;
	top: -2px;
	line-height: 18px;
	float: right;
	font-size: 20px;
	font-weight: bold;
	line-height: 18px;
	color: #fff;
	text-shadow: 0 1px 0 #ffffff;
	opacity: 0.7;
	filter: alpha(opacity=20);
	cursor:pointer;
	border:transparent;
}

<?php /* hidden editable parts. Due to display conditions, in edit rendering mode they are present and gidden to be visible and editable when page is unlocked */?>
    .visiblewhenunlocked{
    	display:none;
    }

    <?php /* Information edition panels will be displayed when the mainbar edition is unlocked */?>
    .visiblewhenunlocked{
    	display:none;
    }

    div.ngePreviewInformation{
	padding: 10px 10px 10px 10px;
	font-size: 12px;
	color : #fff;
	background: #4F73DB;
	margin-bottom: 5px;
	border-left:4px solid #4F73DB;
    }
    div.ngePreviewInformation h4    {
	font-size : 26px;
	font-weight : normal;
	margin:0px 0px 10px 0px;
    }


    <?php /*Styles for inline ckeditor */ ?>
#system-readmore {
    border: dotted 2px #D44A26;
    color: #D44A26;
}
    

/*Spinner css 1*/
.nge-loading1{
	position:relative;
	margin: auto;
}

.nge-loading1-container-general
{
	animation:nge-loading1-animball_two 1.6s infinite;
		-o-animation:nge-loading1-animball_two 1.6s infinite;
		-ms-animation:nge-loading1-animball_two 1.6s infinite;
		-webkit-animation:nge-loading1-animball_two 1.6s infinite;
		-moz-animation:nge-loading1-animball_two 1.6s infinite;
	width:31px; height:31px;
}
.nge-loading1-internal
{
	width:31px; height:31px; position:absolute;
}
.nge-loading1-ballcolor
{
	width: 14px;
	height: 14px;
	border-radius: 50%;
}
.nge-loading1-ball_1, .nge-loading1-ball_2, .nge-loading1-ball_3, .nge-loading1-ball_4
{
	position: absolute;
	animation:nge-loading1-animball_one 1.6s infinite ease;
		-o-animation:nge-loading1-animball_one 1.6s infinite ease;
		-ms-animation:nge-loading1-animball_one 1.6s infinite ease;
		-webkit-animation:nge-loading1-animball_one 1.6s infinite ease;
		-moz-animation:nge-loading1-animball_one 1.6s infinite ease;
}
.nge-loading1-ball_1
{
	background-color:rgb(255,119,109);
	top:0; left:0;
}
.nge-loading1-ball_2
{
	background-color:rgb(255,204,0);
	top:0; left:17px;
}
.nge-loading1-ball_3
{
	background-color:rgb(73,174,205);
	top:17px; left:0;
}
.nge-loading1-ball_4
{
	background-color:rgba(117,205,73,0.98);
	top:17px; left:17px;
}





@keyframes nge-loading1-animball_one
{
	0%{ position: absolute;}
	50%{top:8px; left:8px; position: absolute;opacity:0.5;}
	100%{ position: absolute;}
}

@-o-keyframes nge-loading1-animball_one
{
	0%{ position: absolute;}
	50%{top:8px; left:8px; position: absolute;opacity:0.5;}
	100%{ position: absolute;}
}

@-ms-keyframes nge-loading1-animball_one
{
	0%{ position: absolute;}
	50%{top:8px; left:8px; position: absolute;opacity:0.5;}
	100%{ position: absolute;}
}

@-webkit-keyframes nge-loading1-animball_one
{
	0%{ position: absolute;}
	50%{top:8px; left:8px; position: absolute;opacity:0.5;}
	100%{ position: absolute;}
}

@-moz-keyframes nge-loading1-animball_one
{
	0%{ position: absolute;}
	50%{top:8px; left:8px; position: absolute;opacity:0.5;}
	100%{ position: absolute;}
}

@keyframes nge-loading1-animball_two
{
	0%{transform:rotate(0deg) scale(1);}
	50%{transform:rotate(360deg) scale(1.3);}
	100%{transform:rotate(720deg) scale(1);}
}

@-o-keyframes nge-loading1-animball_two
{
	0%{-o-transform:rotate(0deg) scale(1);}
	50%{-o-transform:rotate(360deg) scale(1.3);}
	100%{-o-transform:rotate(720deg) scale(1);}
}

@-ms-keyframes nge-loading1-animball_two
{
	0%{-ms-transform:rotate(0deg) scale(1);}
	50%{-ms-transform:rotate(360deg) scale(1.3);}
	100%{-ms-transform:rotate(720deg) scale(1);}
}

@-webkit-keyframes nge-loading1-animball_two
{
	0%{-webkit-transform:rotate(0deg) scale(1);}
	50%{-webkit-transform:rotate(360deg) scale(1.3);}
	100%{-webkit-transform:rotate(720deg) scale(1);}
}

@-moz-keyframes nge-loading1-animball_two
{
	0%{-moz-transform:rotate(0deg) scale(1);}
	50%{-moz-transform:rotate(360deg) scale(1.3);}
	100%{-moz-transform:rotate(720deg) scale(1);}
}