<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;
defined('JPATH_BASE') or die;

JFormHelper::loadFieldClass('list');

/**
 * Form Field class for the Joomla Framework.
 *
 * @package     Joomla.Administrator
 * @subpackage  com_Partslibraryselect
 * @since       1.6
 */
class JFormFieldPartslibraryselect extends JFormFieldList
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since   1.6
	 */
	protected $type = 'Partslibraryselect';

	/**
	 * Method to get the field options.
	 *
	 * @return  array  The field option objects.
	 * @since   1.6
	 */
	protected function getOptions()
	{
		$options = array();

		//User access
		$user = NGE::user();
		$levels = implode(',', $user->getAuthorisedViewLevels());
		$db	= JFactory::getDbo();
		$query	= $db->getQuery(true)
			->select('id As value, name As text')
			->from('#__Partslibraryselect AS a')
			->order('a.name');

		// Get the options.
		//TODO Afficher les libraryparts en arbre, comme le field category
		$db->setQuery("select 0 as value, '<Toutes infographies>' as text
		UNION
		(SELECT l.part as value, l.title as text FROM #__nge_parts_library l
			LEFT JOIN #__nge_categories c ON l.catid = c.id
			LEFT JOIN #__nge_plugins p ON c.plugin = p.name
			WHERE l.state=1
			AND c.published=1
			AND l.access IN (" . $levels . ") 
			AND c.access IN (" . $levels . ") 
			ORDER BY catid, ordering, title)");
	//	(SELECT part as value, title as text FROM #__nge_parts_library WHERE catid=17 ORDER BY catid, ordering, title)");
		try
		{
			$options = $db->loadObjectList();
		}
		catch (RuntimeException $e)
		{
			NGE::message($db->getMessage() , 'error');
		}

		// Merge any additional options in the XML definition.
		$options = array_merge(parent::getOptions(), $options);

		return $options;
	}
}

