<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */
defined('_JEXEC') or die;

//Joomla! modules submenu
$user = JFactory::getUser();

if ($user->authorise('core.create', 'com_modules')) {
    JLoader::import( 'select', JPATH_ADMINISTRATOR .'/components/com_modules/models' );
    $mymodel = JModelLegacy::getInstance('Select', 'ModulesModel');
    $items = $mymodel->getItems();
    
    $list = array();
    $list['mod_articles_archive'] =	array('articles', 'stack');
    $list['mod_articles_latest'] =		array('articles', 'history');
    $list['mod_articles_popular'] =	array('articles', 'trophy');
    $list['mod_banners'] =		array('system', 'file-text');
    $list['mod_breadcrumbs'] =		array('system', 'file-text');
    $list['mod_custom'] =		array('content', 'file-text');
    $list['mod_feed'] =			array('system', 'box-add');
    $list['mod_footer'] =		array('system', 'file-text');
    $list['mod_login'] =		array('users', 'unlocked');
    $list['mod_menu'] =		array('content', 'menu');
    $list['mod_articles_news'] =		array('articles', 'newspaper');
    $list['mod_random_image'] =		array('content', 'images');
    $list['mod_related_items'] =		array('articles', 'copy');
    $list['mod_search'] =		array('system', 'search');
    $list['mod_stats'] =		array('system', 'stats-dots');
    $list['mod_syndicate'] =		array('system', 'box-add');
    $list['mod_users_latest'] =		array('users', 'address-book');
    $list['mod_weblinks'] =		array('content', 'link');
    $list['mod_whosonline'] =		array('users', 'user-check');
    $list['mod_wrapper'] =		array('content', 'profile');
    $list['mod_articles_category'] =	array('articles', 'list');
    $list['mod_articles_categories'] =	array('articles', 'list');
    $list['mod_languages'] =		array('system', 'flag');
    $list['mod_finder'] =		array('system', 'search');
    $list['mod_tags_popular'] =		array('articles', 'trophy');
    $list['mod_tags_similar'] =		array('articles', 'copy');
    $list['mod_k2_comments'] =		array('k2', 'bubble2');
    $list['mod_k2_content'] =		array('k2', 'file-text');
    $list['mod_k2_tools'] =		array('k2', 'wrench');
    $list['mod_k2_users'] =		array('k2', 'users');
    $list['mod_k2_user'] =		array('k2', 'user');
    
    $lists = array();
    foreach ($items as $item){
	if (isset($list[$item->module])){
	    $item->glyph = $list[$item->module][1];
	    $lists[$list[$item->module][0]][] = $item;
	}
	else{
	    $item->glyph = 'file-text';
	    $lists['others'][] = $item;
	}
    }
    
function getModulesList($items){
	$html = array();
	$html[] = '<div class="ngemainbarmodulelist">';
        foreach ($items as &$item){
	    $name    = htmlspecialchars($item->name);
	    $desc    = Jhtml::_('string.truncate', (htmlspecialchars($item->desc)), 200);
	    $short_desc    = Jhtml::_('string.truncate', (htmlspecialchars($item->desc)), 90);
	    $html[] = '<div id="thumbs_module_'.$item->extension_id.'" class="ngemodule ngedraggable-mainbar" data-ngedraggable-dest="article position" data-ngedraggable-type="module" data-ngedraggable-ref="'.$item->extension_id.'" data-ngedraggable-title="'.$name.'" data-ngedraggable-module="'.$item->module.'" title="'.$name.'" data-content="'.$desc.'" data-glyph="'.$item->glyph.'"><div><span class="icomoon icomoon-' . $item->glyph . '"></span>'.$name.'</div></div>';
    }
    $html[] = '</div>';
    return implode($html);
}    
    
    
?>
<style>
    
    
    
    #ngemainbar-content{
	min-height:500px;
    }
    
    #ngemainbar-content-modules{
	background-color:#F5F5F5;
    }
    
    #ngemainbar-content-modules .span3{
	background-color:#FFF;
    }
    
    .ngemainbarmodulelist{
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-flex-wrap: wrap;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        /*-webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;*/
        -webkit-align-content: flex-start;
        -ms-flex-line-pack: start;
        align-content: flex-start;
        -webkit-align-items: flex-start;
        -ms-flex-align: start;
        align-items: flex-start;
    }
    
    .ngemainbarmodulelist > div{
        height: 106px;
        -webkit-order: 0;
        -ms-flex-order: 0;
        order: 0;
        -webkit-flex: 0 1 106px;
        -ms-flex: 0 1 106px;
        flex: 0 1 106px;
        -webkit-align-self: auto;
        -ms-flex-item-align: auto;
        align-self: auto;
        /*border : 1px solid #F9BEA9;*/
	/*color:#F9BEA9;*/
	color:#888;
	background-color:#fff;
	
		box-shadow: 0 4px 4px 0 rgba(0,0,0,.3);
	
        cursor: move;
        -webkit-transition: all .2s ease-in-out;
        -moz-transition: all .2s ease-in-out;
        -o-transition: all .2s ease-in-out;
        transition: all .2s ease-in-out;
        overflow: hidden;
        margin:2px;
        
        padding:10px;
        box-sizing: border-box;
        
        display: -ms-flexbox;
        display: -webkit-flex;
        display: flex;
        -webkit-flex-direction: row;
        -ms-flex-direction: row;
        flex-direction: row;
        -webkit-flex-wrap: wrap;
        -ms-flex-wrap: wrap;
        flex-wrap: wrap;
        -webkit-justify-content: center;
        -ms-flex-pack: center;
        justify-content: center;
        -webkit-align-content: flex-start;
        -ms-flex-line-pack: start;
        align-content: flex-start;
        -webkit-align-items: center;
        -ms-flex-align: center;
        align-items: center;
    }
    
    .ngemainbarmodulelist > div > div{
        text-align:center;
        font-size: 14px;
    }
    
    .ngemainbarmodulelist > div:hover{
        background-color: #F77;
        color: #FFFFFF;
    }
    
    .ngemainbarmodulelist span{
	font-size:36px;
	display:block;
	margin-bottom:10px;
    }
    
    #moduletabs li {
	color:#fff;
	background-color: #F9BEA9 !important;
	margin-right:1px;
    }
    #moduletabs li.active, #moduletabs li:hover {
	background-color: #F77 !important;
    }
    
    #moduletabs >li a{
    color:#FFFFFF !important;
}
#moduletabs li:hover a, 
#moduletabs li.active a{
    background-color: #F77 !important;    
    border: none;
}
    
    
    
    #moduletitle{
	color:#888;
	margin-top:20px;
	margin-bottom:15px;
    }
    
    #moduleglyph{
	font-size:36px;
	color:#888;
    }
    
</style>

  <div class="row-fluid">
      <div class="span3" style="text-align:right"><h3><?php echo NGE::translate('COM_NGE_FIELD_MODULE_LEGEND_TITLE'); ?></h3><?php echo NGE::translate('COM_NGE_FIELD_MODULE_LEGEND'); ?><br/><br/><br/><br/><i><a href="<?php echo NGEURL_ROOT; ?>administrator/index.php?option=com_modules" target="blank"><?php echo NGE::translate('COM_NGE_FIELD_MODULE_LEGEND_LINK'); ?></a></i></div>
    <div class="span9 manager_body" style="border-left: 1px solid #ddd;">
	
    <ul id="moduletabs" class="nav nav-tabs" data-tabs="tabs">
	<li class="active"><a href="#tabmodulescontent" data-toggle="tab">CONTENT</a></li>
	<li><a href="#tabmodulesarticles" data-toggle="tab">ARTICLES</a></li>
	<li><a href="#tabmodulesusers" data-toggle="tab">USERS</a></li>
	<li><a href="#tabmodulessystem" data-toggle="tab">SYSTEM</a></li>
	<li><a href="#tabmodulesk2" data-toggle="tab">K2</a></li>
	<li><a href="#tabmodulesothers" data-toggle="tab">OTHERS</a></li>
    </ul>
    <div class="tab-content">
	<div class="tab-pane active" id="tabmodulescontent">
	    <?php echo getModulesList($lists['content']); ?>
	</div>						
	<div class="tab-pane" id="tabmodulesarticles">
	      <?php echo getModulesList($lists['articles']); ?>
	</div>						
	<div class="tab-pane" id="tabmodulesusers">
	    <?php echo getModulesList($lists['users']); ?>
	</div>
	<div class="tab-pane" id="tabmodulessystem">
	    <?php echo getModulesList($lists['system']); ?>
	</div>
	<div class="tab-pane" id="tabmodulesk2">
	    <?php echo getModulesList($lists['k2']); ?>
	</div>
	<div class="tab-pane" id="tabmodulesothers">
	    <?php echo getModulesList($lists['others']); ?>
	</div>
	  <div style="max-width:600px;margin-left:65px;margin-right:30px;">
	    	<h3 id="moduletitle"></h3>
			<div style="position:relative; overflow:hidden;">
				<div id="moduleglyph" style="margin-right:20px;float:left;">				    
				</div>
				<div id="moduledescription">			    

				</div>
			</div> 
	  </div>
    </div>	

</div>
      </div>
<script>
//jQuery(".ngemodule").popover({trigger:"hover", placement:"bottom", container:"#ngemainbar-content"});
 jQuery(".ngemodule").click(function(){
	//var dataPopover = jQuery(this).data('popover');
	//dataPopover.tip().find('.popover-content').html("<?php echo JText::_('COM_NGE_HELP_TOOLBAR_DRAG'); ?><button id='nge-editing-bar-lock-help' class='btn btn-primary pull-right' style='margin:10px;' onclick='showHelp();'><?php echo JText::_('COM_NGE_HELP'); ?></button>");
});
jQuery(".ngemodule").hover(function(){
	jQuery("#moduletitle").html(jQuery(this).attr('title'));
	   jQuery("#moduledescription").html(jQuery(this).attr('data-content'));
	   jQuery("#moduleglyph").html('<span class="icomoon icomoon-' + jQuery(this).data('glyph') + '"></span>');
});



</script>
<?php
}