<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

//To flush browser cache when NGE version changes
$ngeVersion = '?'. NGE::version();

$user = JFactory::getUser();


	/**
     * Method to change if it's a Parent , the category_id and category_name by the first subcategory id and name 
     *
     * @param	int		$currentCategory
     * @return void
     */
	function setCategoryDisplay($current_category){
		$isCatParent = isCategoryParent($current_category);

		if($isCatParent == true){
			//Get array of all categories
			$categories_array = $getCategories();
			
			//Get array of parent category
			$category_id = (int)$categories_array[$current_category][0]->id;
			$category_name = $categories_array[$current_category][0]->title;
		}
	}
	
	/**
	 * Method to know if a category id is a parent
	 *
	 * @param	int		$category_id
	 * @return 	true if it's a parent category else false
	 */
	function isCategoryParent($category_id){
		//Get array of all categories
		$categories_array = getCategories();
		
		//Get array of parent categories
		if (count($categories_array)>1)
			$categories_parent_array = $categories_array[1];
		else
			$categories_parent_array = array();
		
		//Return if category is parent
		$i = 0;
		$isParent = false;
		while($isParent == false && $i < count($categories_parent_array)){
			if((int)$categories_parent_array[$i]->id == (int)$category_id){
				$isParent = true;
			}else{
				$isParent = false;
			}
			$i++;
		}
		
		return $isParent;
	}
	
    function getCategories() {
        //$categoriesModel = JModelList::getInstance("categories","ngeModel");
    	/*require_once(JPATH_SITE.'/components/com_nge/models/categories.php');
    	$categoriesModel = new NgeModelCategories();
	$categories = $categoriesModel->getItems();*/
		require_once(JPATH_SITE.'/components/com_nge/models/librarygallery.php');
		$libraryGalleryModel = new NgeModelLibraryGallery();
		$categories = $libraryGalleryModel->getCategories();

	    // create category list with sublevels
	    $categoriesList = array();
	    foreach($categories as $item) {            
		$categoriesList[$item->parent_id][] = $item ;            
	    }        
 		
        ksort($categoriesList, SORT_NUMERIC);

        return $categoriesList;
    }
    
    
    function setPart($index = 0)
    {
    	if (isset($parts[$index]))
    	{
    		$_tmp_part = &$parts[$index];
    	}
    	else
    	{
    		$_tmp_part = new JObject;
    	}
    }
    /*
    function loadpart($name, $title='', $style = 'view')
    {
    	require_once JPATH_LIBRARIES . '/nge/ngecontenthelper.php';
    	require_once JPATH_COMPONENT_SITE . '/helpers/ngeparthelper.php';
    
    	$part		= NgePartsHelper::getPart($name, $title);
    	//$params = array('style' => $style);
	$params = new stdClass();
	$params->style = $style;
    	ob_start();
    	echo NgePartHelper::render($part, $params);
    	$result = ob_get_clean();
    
    	return $result;
    }	 
	 */
  
		//Load language file for all installed packs
		require_once(JPATH_SITE.'/components/com_nge/models/librarygallery.php');
		$libraryGalleryModel = new NgeModelLibraryGallery();
		$libraryGalleryModel->loadPacksLanguage();

		$config = JComponentHelper::getParams('com_nge');
		
		$jinput = JFactory::getApplication()->input;
		//If a medium exists the choosend part will be added to the medimum
		$caller = $jinput->get('caller', '', 'string');
		$medium = $jinput->get('medium', '', 'string');
		$medium_id = $jinput->get('medium_id', '', 'int');
		$category_id = $jinput->get('category_id', null,'int');
		$category_name = $jinput->get('category_name', null,'string');
		//Change the category display if the category_id is a parent category
		setCategoryDisplay($category_id);

		//View mode : default in component configuration
		jimport('joomla.application.component.helper');
		$defaultViewmode = JComponentHelper::getParams('com_nge')->get('viewmode_default');
		if ($defaultViewmode == '')
			$defaultViewmode = 'thumbs';
		$viewmode = $jinput->get('viewmode', $defaultViewmode, 'string');
		
		//Main screen : top navigation and left categories
//		if (getLayout() == 'default'){
        	// categories list
        	$categories = getCategories();
  //      	$assignRef( 'categories', $categories );
	//	}
	/*	else //Body div
		if ($getLayout() == 'body'){
			$parts = $get('parts', 'librarygallery');
			if ($viewmode == 'preview')			
				for ($i=0;$i<count($parts);$i++){
					$parts[$i]->preview = $loadpart($parts[$i]->part);
				}			
			$parts = &$parts;
			$setLayout($viewmode);				
		}
	*/	

//Import Elfinder script depending on Joomla language
$lang = JFactory::getLanguage();
$tag = $lang->getTag();
$nge_elfinder_lang = substr($tag, 0, 2);
?>
<link rel="stylesheet" type="text/css" href="<?php echo Juri::root(); ?>media/com_nge/jquery-ui/themes/smoothness/jquery-ui.css" />
<link rel="stylesheet" type="text/css" href="<?php echo Juri::root(); ?>media/com_nge/elfinder/css/elfinder.min.css" />
<link rel="stylesheet" type="text/css" href="<?php echo Juri::root(); ?>media/com_nge/elfinder/css/nge-override-elfinder.css" />
<script src="<?php echo Juri::root(); ?>media/com_nge/elfinder/js/elfinder.full.js" ></script>
<?php
if($nge_elfinder_lang != "en")
	echo '<script src="'.Juri::root().'media/com_nge/elfinder/js/i18n/elfinder.'.$nge_elfinder_lang.'.js" ></script>';
?>	
<script src="<?php echo NGEURL_MEDIA; ?>list/list.min.js<?php echo $ngeVersion; ?>"></script>
<script src="<?php echo NGEURL_MEDIA; ?>list/list.pagination.min.js<?php echo $ngeVersion; ?>"></script>
<script>
// 	jQuery('#ngemainbar-content').css('width', '400px');
// jQuery( ".hoverExpand" ).mouseenter(
//     function() {
//         if (!jQuery(this).find('a').hasClass('collapsed')) {
//                 jQuery( this ).find('a').click();
//         }
//     }
// );
</script>
<div class="tab-pane" id="ngemainbar-content" style="width:804px;">
    <ul class="nav nav-tabs" data-tabs="tabs" style="display:table;">
	    <li class="active" style="display:table-cell;background-color:#7AC143;"><a href="#ngemainbar-content-layouts" data-toggle="tab">Mises en page</a></li>
	    <?php if ($user->authorise('core.create', 'com_modules')) 
		echo '<li><a href="#ngemainbar-content-modules" data-toggle="tab">'.JText::_('COM_NGE_FIELD_MODULE_LEGEND_TITLE').'</a></li>';
	    ?>
<!--	    <li style="display:table-cell;"><a href="#ngemainbar-content-articles" data-toggle="tab">Articles</a></li>						
	    <li style="display:table-cell;background-color:#2383C6;" id="#ngemainbar-content-images-tab"><a href="#ngemainbar-content-images" data-toggle="tab">Images</a></li>-->
    </ul>
    <div class="tab-content">
	    <div class="tab-pane active" id="ngemainbar-content-layouts">
		    <?php  include('parts/mainbar.content.parts.php'); ?>
	    </div>
	    <?php if ($user->authorise('core.create', 'com_modules')) { ?> 
	    <div class="tab-pane active" id="ngemainbar-content-modules">
		    <?php include('modules/mainbar.content.modules.php'); ?>
	    </div>					
	       <?php } ?>
<!--	    <div class="tab-pane" id="ngemainbar-content-articles">
		    <?php // include('articles/mainbar.content.articles.php'); ?>
	    </div>-->
<!--	    <div class="tab-pane" id="ngemainbar-content-images">
		    <?php // include('images/mainbar.content.images.php'); ?>
	    </div>-->
    </div>
</div>	