
    enableEditablePositionLayout = function () {		
	jQuery("div.ngelayout-position").addClass('ngeeditable');
    };

    disableEditablePositionLayout = function () {
    	jQuery("div.ngelayout-position").removeClass('ngeeditable');
    };

    /**
     * @name saveModulePosition
     * @description save the new module position
     * @param endPosition, m_id, m_before_id
     * @returns void
     */
    saveModulePosition = function (endPosition, m_id, m_before_id) {
    	var url = "index.php?option=com_nge&task=module.move";
    	var token = jQuery('#tokenform').find('input').attr('name');
    	var data = {};
    	data['end_position'] = endPosition;
    	data['m_id'] = m_id;
    	data['m_before_id'] = m_before_id;
    	data[token] = 1;    	
    	jQuery.ajax({
    	    url: url,
    	    data: data,
	    type: 'POST',
    	    success: function (resultJson) {
	    		try {
	    		    result = jQuery.parseJSON(resultJson);
	    		} catch (err) {
	    		    bootbox.alert(COM_NGE_JS_EDITING_ARTICLE_UNABLE_MOVE_MODULE + "<br>" + err.toString());
	    		}
    	    },
    	    error: function (result) {
    	    	bootbox.alert(COM_NGE_JS_EDITING_ARTICLE_UNABLE_MOVE_MODULE);
    	    }
    	});
    };

    /**
     * @name afterPositionLayoutPartCreate
     * @description Called by config screen when new part has been created
     * @returns void
     */
    afterPositionLayoutPartCreate = function (result) {
    	var createParentDivModule = '<div id="module-'+result.m_id+'" class="ngemodule ngemodule-part" data-module-label="'+result.title+'" data-module-id="'+result.m_id+'">';
    	createParentDivModule += result.html;
    	createParentDivModule += '</div>';
    	
    	/*Finding current dropped part with the part-temp-dropped class*/
		currentThumbTemporary = jQuery("#part-temp-dropped");
		currentThumbTemporary.after(createParentDivModule);
		currentThumbTemporary.remove();
	
		/*Add edit attributes and events for this new part*/
		enableNgePartToolbar('#part-' + result.pk);
		enableNgeInlineEditing('#part-' + result.pk);
		enableNgeItemsSortable('#part-'+result.pk);
		
		activeSortableLayout(jQuery('#part-'+result.pk));
    };

    /**
     * @name afterPositionLayoutModuleCreate
     * @description Called by config screen when new part has been created
     * @returns void
     */
    afterPositionLayoutModuleCreate = function (result) {
    	
    	var createParentDivModule = '<div id="module-'+result.m_id+'" class="ngemodule ngemodule-joomla" data-module-label="'+result.title+'" data-module-id="'+result.m_id+'">';
    	createParentDivModule += result.html;
    	createParentDivModule += '</div>';
    	
    	/*Finding current dropped module with the part-temp-dropped class*/
		currentThumbTemporary = jQuery("#part-temp-dropped");
		currentThumbTemporary.after(createParentDivModule);
		currentThumbTemporary.remove();
	
		/*Add edit attributes and events for this new module content*/
		updateNgeModuleEditable('#module-' + result.m_id);
    };

    /**
     * @name afterPositionLayoutModuleUpdate
     * @description Called by config screen when a module has been updated
     * @returns void
     */
    afterPositionLayoutModuleUpdate = function (result) {
    	
		jQuery('#module-' + result.m_id).html(result.html);
    };

/*************** SORTABLE *****************/
	var sortablePositionSelector;
	/*var currentPopover = "";*/
	
    /*Activate sortable element in Layout    */
    enablePositionSortableLayout = function () {
		var startPosition = "";
		var endPosition = "";
		sortablePositionSelector = jQuery("div.ngelayout-position").children("div.content");

		sortablePositionSelector.sortable({
		    placeholder: "ngelayout-sortable-position",
		    /*handle: ".ngetlb-module-move, .ngetlb-move",*/
		    handle: ".ngetlb-module-move, #ngemove-toolbar",
                    /* SORTABLE IN ALL LAYOUT This version is used to connect with other sortable layout
                    * connectWith: ".ngelayout-module .custom, .ngelayout-article .content, .ngelayout-page .content, .ngelayout-position .content, .ngelayout-part",*/
		    cursorAt: {top: 35, left: 35},
		    start: function (e, ui) {
		    	/*Set part sortable active to not trigger mouseover on other part when dragging a part*/
            	isPartSortable = true;
            	jQuery('#part-toolbar').hide();
            	
            	if (!ui.item.hasClass('ngedraggable-mainbar')) {/*Come from another sortable content*/
                    /* SORTABLE IN ALL LAYOUT This version is used to connect with other sortable layout
                     * enableSortableDragDropZone(["article", "position", "part"]);*/
                    /* SORTABLE ONLY FOR REORDER This version only accept sortable inside the current element*/
                    enableSortableDragDropCurrentZone(jQuery(this));
            	}
            	
				startPosition = ui.item.closest("div.ngelayout-position").data("position");
		    },
		    helper: function (event, ui) {
				var name = "";
				var widget = jQuery(ui).clone(true);
                                if(!widget.hasClass("ngemodule")){
                                    widget = widget.find(".ngemodule");
                                }
                                    
                                if(widget.hasClass("ngemodule-part")){ /*Module NGE widget*/
                                    name = widget.find(".part").attr("data-part-label");
                                }else{/*Module Joomla*/
                                    name = widget.attr("data-module-label");
                                }
				/*Get ajax default part html and return the html code*/
				var target = '<div id="nge-sortable-helper" style="background: #F77;">' + name + '</div>';
				return target;
		    },
		    receive: function (e, ui) {
	            
	            var partType 	= ui.item.data('part');
	            var endPosition = ui.item.closest("div.ngelayout-position").data("position");
				var m_id 		= ui.item.data('module-id');
				var m_before = ui.item.prev();
				
				if(m_before.hasClass("ngemodule")){
					var m_before_id = m_before.data("module-id");
				}else{
					var m_before_id = m_before.find(".ngemodule").data("module-id");
				}
				
	            if (!ui.item.hasClass('ngedraggable-mainbar')) {
	            	/*Come from another sortable content*/
	    		    if (typeof m_id !== "undefined") {
	    		    	/*It's a module*/
	    		 /*   	saveModulePosition(endPosition, m_id, m_before_id);*/
				    	var data = {
				    			"element": "module",
				    			"destination": "position",
					    	    "m_id": m_id,
					    	    "end_position": endPosition,
					    	    "m_before_id": m_before_id
					    };
				    	
	    		    	updateDraggableElement(ui.item, data);
	    		    }else if(typeof partType !== "undefined"){
	    		    	/*It's a part*/
	    		    	var partId = jQuery(ui.item).attr('id');
	    		    	var partIdSplit = partId.split("-");
/*	    		    	var objectCreated = savePartInModulePosition(endPosition, partIdSplit[1], m_before_id);*/
				    	var data = {
				    			"element": "part",
				    			"destination": "position",
					    	    "part_id": partIdSplit[1],
					    	    "part_type": partType,
					    	    "end_position": endPosition,
					    	    "m_before_id": m_before_id
					    };
				    	
	    		    	updateDraggableElement(ui.item, data);
	    		    	/*var createParentDivModule = '<div id="module-'+objectCreated.m_id+'" class="ngemodule ngemodule-part" data-module-label="'+objectCreated.title+'" data-module-id="'+objectCreated.m_id+'">';
	    		    	createParentDivModule += objectCreated.html;
	    		    	createParentDivModule += '</div>';
	    		    	*/
	    		    	/*Replace part by module*/
	    			/*	ui.item.replaceWith(createParentDivModule);*/
	    				
	    				/*Add edit attributes and events for this new part*/
	    				/*enableNgePartToolbar('#part-' + objectCreated.pk);
	    				enableNgeInlineEditing('#part-' + objectCreated.pk);*/
	    		    }
	            }
		    },
		    update: function (e, ui) {
				if (ui.item.hasClass('ngedraggable-mainbar')) { 
					/*To determine if it comes from drag & drop or from sorting*/
					var dragType = ui.item.data('ngedraggable-type');
					var dragRef = ui.item.data('ngedraggable-ref');          
					var dragTitle = ui.item.data('ngedraggable-title');
					var endPosition = ui.item.closest("div.ngelayout-position").data("position");
					var m_before = ui.item.prev();

					if(m_before.hasClass("ngemodule")){
						var m_before_id = m_before.attr("data-module-id");
					}else{
						var m_before_id = m_before.find(".ngemodule").attr("data-module-id");
					}

					/*In case of old ones   */
				    jQuery("#part-temp-dropped").remove();
		
				    /*temporary part will be found after config screen by the "part-temp-dropped" class*/
				    var tempDroppedPart = '<div id="part-temp-dropped" class="part" style="display:block; padding:10px"></div>';
				    ui.item.hide();
				    ui.item.after(tempDroppedPart);

				    if (dragType == 'part') {
				    	showPartConfigForm(dragType, startPosition, endPosition, dragRef, m_before_id);
				    }else if (dragType == 'module') {
				    	var moduleElement = jQuery(ui.item).data('ngedraggable-module');
				    	showModuleConfigForm(moduleElement, startPosition, endPosition, dragRef, m_before_id);
				    }else{
				    	var data = {
				    		"startPosition": startPosition,
				    	    "endPosition": endPosition,
				    	    "m_before_id": m_before_id,
				    	};
				    	showLayoutWizardPopover(dragType, dragRef, 'position', dragTitle, data);
				    }
				    
				    ui.item.remove();
				}else{
					var endPosition = ui.item.closest("div.ngelayout-position").data("position");
			    	if(startPosition == endPosition){
			    		/*Update only if we are in the current sortable and not from another sortable
				    	only module can be update in the layout position*/
						var m_id = ui.item.data('module-id');
                                                if(typeof m_id === "undefined"){
                                                    m_id = ui.item.find(".ngemodule ").data('module-id');
                                                }
						var m_before = ui.item.prev();
						
						if(m_before.hasClass("ngemodule")){
							var m_before_id = m_before.data("module-id");
						}else{
							var m_before_id = m_before.find(".ngemodule").data("module-id");
						}
					 /*   if (typeof m_id !== "undefined")
					    	saveModulePosition(endPosition, m_id, m_before_id);*/	
                                    if (typeof m_id !== "undefined"){
                                        var data = {
                                            "element": "module",
                                            "destination": "position",
                                            "m_id": m_id,
                                            "end_position": endPosition,
                                            "m_before_id": m_before_id
                                        };
                                        updateDraggableElement(ui.item, data);
                                    }
			    	}
				}
		    },
		    stop: function (e, ui) {
				
				isPartSortable = false;
				disableSortableDragDropZone();
		    }
		});
    };

    disablePositionSortableLayout = function () {
    	if (typeof sortablePositionSelector !== "undefined" && sortablePositionSelector.hasClass("ui-sortable"))
    		sortablePositionSelector.sortable("destroy");
    };
    
    showPartConfigForm = function(partType, startPosition, endPosition, dragRef, m_before_id){	
		var partIframe = jQuery("#partconfig_iframe");
		//partIframe.contents().find("html").html('<div style="margin-left:50%;margin-top:100px;"><img src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /></div>');
		jQuery("#partConfigForm").modal("show");
		//partIframe.attr("src", "index.php?option=com_nge&view=config&layout=default&caller=layout.position&mode=create&format=raw&plname=" + dragRef + "&start_position=" + startPosition + "&end_position=" + endPosition + "&m_before_id=" + m_before_id);    
		document.getElementById("partconfig_iframe").contentWindow.loadContent("index.php?option=com_nge&view=config&layout=form&caller=layout.position&mode=create&format=raw&plname=" + dragRef + "&start_position=" + startPosition + "&end_position=" + endPosition + "&m_before_id=" + m_before_id);						
    };
    
    showModuleConfigForm = function(moduleElement, startPosition, endPosition, m_id, m_before_id){
    	var moduleIframe = jQuery("#moduleconfig_iframe");
    	moduleIframe.contents().find("html").html('<div style="margin-left:50%;margin-top:100px;"><img src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /></div>');
    	jQuery("#moduleConfigForm").modal("show");
    	moduleIframe.attr("src", "index.php?option=com_nge&view=module&layout=edit&caller=layout.position&mode=create&tmpl=component&ngetemplate=admin&element=" + moduleElement + "&start_position=" + startPosition + "&end_position=" + endPosition + "&m_id=" + m_id + "&m_before_id=" + m_before_id);
    };


ngePositionFormAddmodule = function(){
	var pk = jQuery("#part-toolbar").attr('data-part');
	var oldHtml = jQuery('#part-' + result.pk).html();
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=joomla.position&form=addmodule&pk=" + pk,
		    icon: '<span class="icomoon-display"></span>',
		    title: COM_NGE_EDITOR_TOOLBAR_ADD_TITLE,
		    width:  800,
		    height: 600,
		    refresh : function(html){
			/* Update only content without editing features*/
			jQuery('#part-' + pk).replaceWith(html);
		    },
		    submit : function(result_obj){
			/* Update content and editing features in Javascript*/
			document.afterLayoutPartUpdate(result_obj);
		    },
		    cancel : function(element, oldItemId, currentItemId){
			var result_obj = {html:oldHtml};
			/* Updating old content and editing features in Javascript*/
			//document.afterLayoutPartUpdate(result_obj);
		    }
		});		
};


    /*Triggering functions.*/
    jQuery(document).on( "ngeEnableEdition", function() {
	enableEditablePositionLayout();	
	enablePositionSortableLayout();
    });

    jQuery(document).on( "ngeDisableEdition", function() {
	disableEditablePositionLayout();
	disablePositionSortableLayout();
    });
