/**
 * @name removePartPart
 * @description remove part and save layout part content
 * @param pk - id of the part
 * @returns void
 */
removePartPart = function (part) {
    var parentPartLayout = part.closest(".ngelayout-part");

    /*Moving toolbar at the starting of the document, to avoid being removed with the part*/
    jQuery('#part-toolbar').hide();
    
    /*Removing part and saving closest parent Layout (columns or page layout)    	*/
    part.remove();
    
    savePartContent(parentPartLayout);
};

/**
 * @name duplicatePartPart
 * @description duplicate part on the layout page content
 * @param pk - id of the part
 * @returns void
 */
duplicatePartPart = function (pk, returnmode) {
    returnmode = returnmode || "preview";
    var token = jQuery('#tokenform').find('input').attr('name');
    var url = "index.php?option=com_nge&task=part.duplicate";
    url += '&pk=' + pk;
    url += '&return=' + returnmode;
    url += '&media=layout';
    url += '&' + token + '=1';
    
    jQuery.ajax({
        url: url,
        success: function (resultJson) {
            try {
                result = jQuery.parseJSON(resultJson);

                var currentPart = jQuery("#part-" + pk);
                currentPart.after(result.html);

                /*Finding closest parent Layout (columns or page layout)*/
                var parentPartLayout = jQuery('#part-' + result.pk).closest(".ngelayout-part");

    	    	enableNgePartToolbar('#part-'+result.pk);
    		enableNgeInlineEditing('#part-'+result.pk);
		enableNgeItemsSortable('#part-'+result.pk);
			
    		activeSortableLayout(jQuery('#part-'+result.pk));

		savePartContent(parentPartLayout);
            } catch (err) {
                bootbox.alert(COM_NGE_JS_EDITING_UNABLE_DUPLICATE_PART + "<br>" + err.toString());
            }
        },
        error: function (result) {
            bootbox.alert(COM_NGE_JS_EDITING_UNABLE_DUPLICATE_PART);
        }
    });
};

/**
 * @name afterPartLayoutPartCreate
 * @description Called by config screen when new part has been created
 * @returns void
 */
afterPartLayoutPartCreate = function (result) {
    /*Finding current dropped part with the part-temp-dropped class*/
    currentThumbTemporary = jQuery("#part-temp-dropped");
    currentThumbTemporary.after(result.html);
    currentThumbTemporary.remove();

	/*Add dit attributes and events for this new part*/
	enableNgePartToolbar('#part-'+result.pk);
	enableNgeInlineEditing('#part-'+result.pk);
	enableNgeItemsSortable('#part-'+result.pk);
		
	enablePartSortableLayout('#part-'+result.pk);
	
    var parentPartLayout = jQuery('#part-' + result.pk).closest(".ngelayout-part");
    savePartContent(parentPartLayout);
};
    
/**
 * @name savePartContent
 * @description saving layout part content
 * @returns void
 */
savePartContent = function (parentPartLayout) {
    var value = cleanEditingInEditorContent(jQuery(parentPartLayout).clone(true));

    /*Part ID : finding closest parent part. part id is "part-nnn"*/
    var divid = jQuery(parentPartLayout).closest(".part").attr('id');
    var pkArray = divid.split("-");
    var pk = pkArray[1];

    /*Part property*/
    var property = jQuery(parentPartLayout).data('nge').source;
    property = property.split(":")[1];

    storePartProperty(pk, 'content', property, value);

    disableSortableDragDropZone();
};

/*************** SORTABLE *********************/
	var sortableParts;
    
    /*Activate sortable element in parts
    enablePartSortableLayout = function (sortablePartSelector) {*/
    enablePartSortableLayout = function (sortablePartSelector) {
	
    	sortableParts = typeof sortablePartSelector !== 'undefined' ? jQuery(sortablePartSelector) : jQuery("div.part");
    	sortableParts = sortableParts.find(".ngeinlineeditable");
    	/*	
    	var currentActiveSortablePart = sortablePartSelector.find(".ngecontenteditableinline[data-type=ngeeditor]");
    	currentActiveSortablePart.addClass("ngelayout ngelayout-part");
	currentActiveSortablePart.attr("data-ngelayout", "part");
    	
    	var partContent = sortablePartSelector.find(".ngelayout-part");
    	var selectPart = partContent.find(".part");
    	var selectPartChild = partContent.find(".part *");
    	var selectorInsideContent = partContent.find("div, form, body, fieldset, h1, h2, h3, h4, h5, h6, pre, li, span,th , td").not(selectPartChild).not(selectPart);
    	var sortablePartSelector = partContent.add(selectorInsideContent);

    	selectorInsideContent.addClass("ngelayout-editablecontent");
*/
	
    	/*All parts that have rich content becomes sortable (connectable with all other layouts)*/
    	sortableParts.addClass("ngelayout ngelayout-part").attr("data-ngelayout", "part");
    	
    	/*Make sortable all child elements in the editable parts, except other parts (already selected)*/
    	/*In editable parts content, enable Adding all editable content inside except parts*/
    	var sortableContent = sortableParts.find("div, form, body, fieldset, h1, h2, h3, h4, h5, h6, pre, li, span,th , td").not("div.part").not("div.part *");
    	sortableContent.addClass("ngelayout-editablecontent");
    	
    	/*All sortable elements : editable parts and their inside content*/
    	var sortableElements = sortableParts.add(sortableContent);
		
    	/*var startLayout 	= "";*/
    	var startLayout;
    	/*var currentlayout 	= "";*/

    	/*sortablePartSelector.sortable({*/
    	sortableElements.sortable({
            placeholder: "ngelayout-sortable-part",
            /*handle: ".ngetlb-move",*/
	    handle: "#ngemove-toolbar",
            /* SORTABLE IN ALL LAYOUT This version is used to connect with other sortable layout
             * connectWith: ".ngelayout-article .content, .ngelayout-module .custom, .ngelayout-position .content, .ngelayout-page .content, .ngelayout-part, .ngelayout-editablecontent",*/
            /* SORTABLE ONLY FOR REODER This version only accept sortable inside the current element*/
            connectWith: ".ngelayout-editablecontent",
            cursorAt: {top: 35, left: 35},
            start: function (e, ui) {
            	/*Set part sortable active to not trigger mouseover on other part when dragging a part*/
            	isPartSortable = true;
            	jQuery('#part-toolbar').hide();
            	
            	if (!ui.item.hasClass('ngedraggable-mainbar')) {/*Come from another sortable content*/
                    /* SORTABLE IN ALL LAYOUT This version is used to connect with other sortable layout
                     * enableSortableDragDropZone(["module", "article", "position", "page", "part"]);*/
                    /* SORTABLE ONLY FOR REORDER This version only accept sortable inside the current element*/
                    enableSortableDragDropCurrentZone(jQuery(this));
            	}
            	
            	startLayout = ui.item.closest(".ngelayout");
            },
            helper: function (event, ui) {
            	var name = "";
            	var clone = jQuery(ui).clone(true);
            	
            	var name = clone.data("part-label");

			    /*Get ajax default part html and return the html code*/
			    var target = '<div id="nge-sortable-helper">'+name+'</div>';
			    return target;
			},
            receive: function (e, ui) {
                
                var partType 	= ui.item.data('part');
                var m_id		= ui.item.data('module-id');

                if (!ui.item.hasClass('ngedraggable-mainbar')) {
                	/*Come from another sortable content (module or part)*/
        		    if (typeof m_id !== "undefined") {
        		    	/*It's a module*/
        		    	if (ui.item.hasClass("ngemodule-part")) {
        		    		/*It's a part module*/
        		    		/*Remove div Module and keep only the div part*/
        		    		var partElement = ui.item.find(".part");
        		    		ui.item.replaceWith(partElement);
        		    		/*Trash the module*/
        		    		removeModuleFromPosition(m_id);
        		    		
        		    		currentlayout = ui.item.closest(".ngelayout-module");
            		    	saveModule(currentlayout.children(".custom"));
        		    	}else{
        		    		/*Other module*/
        		    		var articleId = ui.item.closest(".nge-article-content").data('nge-id');
        		    		
        		    		var data = {
				    			"element": "module",
				    			"destination": "article",
					    	    "m_id": m_id,
					    	    "articleId": articleId,
						    };
					    	
		    		    	updateDraggableElement(ui.item, data);
        		    		/*Save the artcle with the new part*/
        		    		/*Auto save with update function*/
        		    	}
        		    }else if(typeof partType !== "undefined"){
        				/*It's a part*/
        		    	currentlayout = ui.item.closest(".ngelayout");
        		    	if(startLayout.hasClass("ngelayout-part") && currentlayout.hasClass("ngelayout-part")){
        		    		savePartContent(currentlayout);
        		    	}
        		    }
               }
            },
            update: function( event, ui ) {
            	
            	if (ui.item.hasClass('ngedraggable-mainbar')) {
                	/*Active the creation of part if come from drag&drop*/
                	addPartToLayout(ui);
                }else{
                	/*Update start layout if defined*/
                	if (typeof startLayout !== 'undefined'){
                		if(startLayout.hasClass("ngelayout-part")){
                			savePartContent(startLayout);
                		}
    	            }
                }
            },
            stop: function (e, ui) {
            	
				disableSortableDragDropZone();
				isPartSortable = false;
            }
        });
    };

    disablePartSortableLayout = function () {
		/*Content*/
		jQuery("div.part").find(".ngelayout-editablecontent").removeClass("ngelayout-editablecontent");	
		/*Parts*/
		jQuery("div.part").find(".ngelayout, .ngelayout-part").removeClass("ngelayout").removeClass("ngelayout-part");
		/*All sortable elements*/
		jQuery("div.part").find(".ui-sortable").sortable("destroy");
    };
    
    /*Triggering functions.*/
    jQuery(document).on( "ngeEnableEdition", function() {
	enablePartSortableLayout();
    });

    jQuery(document).on( "ngeDisableEdition", function() {
	disablePartSortableLayout();
    });
    
