/**
 * @name removeModulePart
 * @description remove part in module layout and save layout module content
 * @returns void
 */
removeModulePart = function (part) {
    var parentPartLayout = part.closest(".ngelayout-module");
    var parentModuleContent = parentPartLayout.children(".custom");
    
    /*Moving toolbar at the starting of the document, to avoid being removed with the part*/
    jQuery('#part-toolbar').hide();
    
    /*Removing part and saving closest parent Layout (columns or page layout)    	*/
    part.remove();
    
    saveModule(parentModuleContent);
};

/**
 * @name duplicateModulePart
 * @description duplicate part on the layout module
 * @param pk - id of the part
 * @returns void
 */
duplicateModulePart = function (pk, returnmode) {
    returnmode = returnmode || "preview";
    var token = jQuery('#tokenform').find('input').attr('name');
    var url = "index.php?option=com_nge&task=part.duplicate";
    url += '&pk=' + pk;
    url += '&return=' + returnmode;
    url += '&media=layout';
    url += '&' + token + '=1';    

    jQuery.ajax({
        url: url,
        success: function (resultJson) {
            try {
                result = jQuery.parseJSON(resultJson);

                var currentPart = jQuery("#part-" + pk);
                currentPart.after(result.html);
                
    	    	enableNgePartToolbar('#part-'+result.pk);
    		enableNgeInlineEditing('#part-'+result.pk);
		enableNgeItemsSortable('#part-'+result.pk);
		
    		activeSortableLayout(jQuery('#part-'+result.pk));
		
    		var parentModuleContent = jQuery('#part-' + result.pk).closest(".ngelayout-module").children(".custom");
    		saveModule(parentModuleContent);
            } catch (err) {
                bootbox.alert(COM_NGE_JS_EDITING_UNABLE_DUPLICATE_PART + "<br>" + err.toString());
            }
        },
        error: function (result) {
            bootbox.alert(COM_NGE_JS_EDITING_UNABLE_DUPLICATE_PART);
        }
    });
};

/**
 * @name afterModuleLayoutPartCreate
 * @description Called by config screen when new part has been created
 * @returns void
 */
afterModuleLayoutPartCreate = function (result) {
    /*Finding current dropped part with the part-temp-dropped class*/
    currentThumbTemporary = jQuery("#part-temp-dropped");
    currentThumbTemporary.after(result.html);
    currentThumbTemporary.remove();

	/*Add dit attributes and events for this new part*/
	enableNgePartToolbar('#part-'+result.pk);
	enableNgeInlineEditing('#part-'+result.pk);
	enableNgeItemsSortable('#part-'+result.pk);
	
	enablePartSortableLayout('#part-'+result.pk);
	
    var parentModuleContent = jQuery('#part-' + result.pk).closest(".ngelayout-module").children(".custom");
    saveModule(parentModuleContent);
};

/**
 * @name saveModule
 * @description saving layout module content
 * @returns void
 */
saveModule = function(moduleContent){
	var module = moduleContent.closest(".ngelayout-module");
	var moduleId = module.data('module-id');
	var ckEditor = CKEDITOR.instances['ngelayout-module-content-'+moduleId];
	var contentHtml = moduleContent.clone(true);
	var token = jQuery("#nge-token").val();

	/*removing part preview and restore original part tags*/
	contentHtml.find('.part').each(function(){
	    var divid = jQuery(this).attr('id');
	    var pkArray = divid.split("-");
	    var pk 	= pkArray[1];
	    
	    var partlibrary = jQuery(this).attr('data-part');
	    jQuery(this).after('<part data-class="'+partlibrary+'" data-part="'+pk+'">&nbsp;</part>');
	    jQuery(this).remove();
	});

	/*Removing sortable, partToolbar stuff*/
	contentHtml.find('.nge-margin-handle').remove();
	contentHtml.find('.nge-part-margin-process').remove();
	contentHtml.find('.nge-part-resize-process').remove();
	contentHtml.find('.ui-draggable').removeClass('ui-draggable');
	contentHtml.find('.ui-resizable').removeClass('ui-resizable');
	contentHtml.find('.ui-sortable').removeClass('ui-sortable');
	contentHtml.find('.ngelayout-article-connected-sortable').removeClass('ngelayout-article-connected-sortable');
	
	var html = contentHtml.html();
	html = html.replace(/<!--{cke_protected}.*?-->/g, '');

	var url = 'index.php?option=com_nge&task=module.save';
	var dataPost = {'pk': moduleId, 'content': html};
	dataPost[token] = 1;
	
	jQuery.ajax({
		url: url,
		data: dataPost,
		type: 'POST',
		success: function (resultJson) {
                    contentHtml.remove();
                    try {
                        data = jQuery.parseJSON(resultJson);

                        if(data.result == 1){
                            nge.showNotification( data.message, 'success', 3000);
                        }else{
                            nge.showNotification( data.message, 'warning', 3000);
                        }
                    } catch (err) {
                        console.error("Error : to save module" + err.toString());
                    }
		},
		error: function (result) {
			console.error("Error : Article Wrong url, may be 500 Internal Servor Error =>" + result);
		}
	});       
};
/*
enableModuleEditContent = function(){
	var modules = jQuery(".ngelayout-module");
	modules.addClass("ngeeditable");
	
	jQuery.each(modules, function(index, val){
		var currentModule = jQuery(this);
		var currentModuleId = currentModule.data("module-id");
		
		currentModule.children(".custom").addClass("ngemoduleeditableinline")
		.attr("data-type", "ngeeditor").attr("data-property", "content").attr("id", "ngelayout-module-content-"+currentModuleId);
	});
	
	enableCkEditorModules();
};

disableModuleEditContent = function(){
	var modules = jQuery(".ngelayout-module");
	modules.removeClass("ngeeditable");
	modules.children(".custom").removeClass("ngemoduleeditableinline").removeAttr("data-type").removeAttr("data-property").removeAttr("id");
	
	disableCkEditorModules();
};


    jQuery(document).on( "ngeEnableEdition", function() {
	enableModuleEditContent();
    });

    jQuery(document).on( "ngeDisableEdition", function() {
	disableModuleEditContent();
    });
    */
   
/***************** Module sortable *************************/
	var sortableModules, sortableModuleElements;
    
    /*Activate sortable element in module*/
    enableModuleSortableLayout = function (sortableModuleSelector) {
    	sortableModules = typeof sortableModuleSelector !== 'undefined' ? jQuery(sortableModuleSelector) : jQuery(".ngelayout-module").children(".custom");
    	
    	/*In editable parts content, enable Adding all editable content inside except parts*/
    	var sortableContent = sortableModules.find("div, form, body, fieldset, h1, h2, h3, h4, h5, h6, pre, li, span,th , td").not("div.part").not("div.part *");
    	sortableContent.addClass("ngelayout-editablecontent");
    	
    	/*All sortable elements : editable parts and their inside content*/
    	sortableModuleElements = sortableModules.add(sortableContent);
		
    	var startLayout, currentlayout;

    	/*sortableModuleselector.sortable({*/
    	sortableModuleElements.sortable({
            placeholder: "ngelayout-sortable-module",
            /*handle: ".ngetlb-move",*/
	handle: "#ngemove-toolbar",
            connectWith: ".ngelayout-module .custom, .ngelayout-article .content, .ngelayout-position .content, .ngelayout-page .content, .ngelayout-part, .ngelayout-editablecontent",
            cursorAt: {top: 35, left: 35},
            start: function (e, ui) {
            	/*Set part sortable active to not trigger mouseover on other part when dragging a part*/
            	isPartSortable = true;     	
            	jQuery('#part-toolbar').hide();
            	
            	if (!ui.item.hasClass('ngedraggable-mainbar')) {/*Come from another sortable content*/
            		enableSortableDragDropZone(["module", "article", "position", "page", "part"]);
            	}
            	
            	startLayout = ui.item.closest(".ngelayout-module");
            },
            helper: function (event, ui) {
            	var name = "";
            	var clone = jQuery(ui).clone(true);
            	
            	var name = clone.data("part-label");

			    /*Get ajax default part html and return the html code*/
			    var target = '<div id="nge-sortable-helper">'+name+'</div>';
			    return target;
			},
            receive: function (e, ui) {

                var partType 	= ui.item.data('part');
                var m_id		= ui.item.data('module-id');

                if (!ui.item.hasClass('ngedraggable-mainbar')) {
                	/*Come from another sortable content (module or part)*/
        		    if (typeof m_id !== "undefined") {
        		    	/*It's a module*/
        		    	if (ui.item.hasClass("ngemodule-part")) {
        		    		/*It's a part module*/
        		    		/*Remove div Module and keep only the div part*/
        		    		var partElement = ui.item.find(".part");
        		    		ui.item.replaceWith(partElement);
        		    		/*Trash the module*/
        		    		removeModuleFromPosition(m_id);
        		    		
        		    		currentlayout = ui.item.closest(".ngelayout-module");
            		    	saveModule(currentlayout.children(".custom"));
        		    	}else{
        		    		/*Other module*/
        		    		var articleId = ui.item.closest(".nge-article-content").data('nge-id');
        		    		
        		    		var data = {
				    			"element": "module",
				    			"destination": "article",
					    	    "m_id": m_id,
					    	    "articleId": articleId,
						    };
					    	
		    		    	updateDraggableElement(ui.item, data);
        		    		/*Save the artcle with the new part*/
        		    		/*Auto save with update function*/
        		    	}
        		    }else if(typeof partType !== "undefined"){
        				/*It's a part*/
        		    	currentlayout = ui.item.closest(".ngelayout-module");
        		    	saveModule(currentlayout.children(".custom"));
        		    }
               }
            },
            update: function( event, ui ) {
                
                if (ui.item.hasClass('ngedraggable-mainbar')) {
                	/*Active the creation of part if come from drag&drop*/
                	addPartToLayout(ui);
                }else{
                	/*Update start layout if defined*/
                	if (typeof startLayout !== 'undefined'){
                		saveModule(startLayout.children(".custom"));
    	            }
                }
            },
            stop: function (e, ui) {
            	
            	disableSortableDragDropZone();
            	isPartSortable = false;
            }
        });
    };

    disableModuleSortableLayout = function () {
    	if (typeof sortableModuleElements !== "undefined" && sortableModuleElements.hasClass("ui-sortable"))
    		sortableModuleElements.sortable("destroy");
		
    	/*Content*/
    	if (typeof sortableModules !== "undefined")
        	sortableModules.find(".ngelayout-editablecontent").removeClass("ngelayout-editablecontent");
    };
    
    /*Referencing functions.
    Adding to editing functions pool */
    /*ngeEnableEditFunctions.push(enableModuleSortableLayout);
    ngeDisableEditFunctions.push(disableModuleSortableLayout);*/