<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

/**
 *GLOBAL FUNCTION USED FOR SORTABLE LAYOUT
*/
/*Elements for building popover forms*/
/*	var wizardforms = [];
	wizardforms['article'] = [];
	wizardforms['article_new'] = [];
	wizardforms['module'] = [];
	wizardforms['image'] = [];
	wizardforms['document'] = [];

	var wizardelements = [];
	wizardelements['input'] = [];
	wizardelements['selector'] = [];
*/
	

include_once(NGEPATH_HELPERS . '/editor/wizard/elements/wizard.elements.buttons.php');
include_once(NGEPATH_HELPERS . '/editor/wizard/elements/wizard.elements.inputs.php');
include_once(NGEPATH_HELPERS . '/editor/wizard/elements/wizard.elements.selectors.php');
?>

jQuery(document).ready(function() {

	jQuery.fn.extend({
    popoverClosable: function (options) {
        var defaults = {
            template:
                '<div class="popover" style="min-width:'+options.width+';">\
<div class="arrow"></div>\
<div class="popover-header">\
<button type="button" class="close" data-dismiss="popover" aria-hidden="true">&times;</button>\
<h3 class="popover-title"></h3>\
</div>\
<div class="popover-content" style="max-height:'+options.height+'; overflow:auto;"></div>\
</div>'
        };
        options = jQuery.extend({}, defaults, options);
        var $popover_togglers = this;
        $popover_togglers.popover(options);
        $popover_togglers.on('click', function (e) {
            e.preventDefault();
            $popover_togglers.not(this).popover('hide');
        });
        jQuery('html').on('click', '[data-dismiss="popover"]', function (e) {
            $popover_togglers.popover('hide');
            jQuery("#part-temp-dropped").remove();
        });
    }
});
	showLayoutWizardPopover = function(dragType, dragRef, dragDest, titleRef, data){
		jQuery(".popover").popover("hide");
		data = typeof data !== 'undefined' ? data : new Object();
		var tempDropped = jQuery("#part-temp-dropped");
		var popovercontent = '';
		var element;
		var formpopover = JSON.parse(wizardforms[dragType][dragDest]);
		var popoverTitle = formpopover.title;	
		if (titleRef != undefined)
			popoverTitle = popoverTitle + ' ' + titleRef;
		
		popoverContent = '<form id="ngelayout-popover">';
		popoverContent += '<input type="hidden" name="element" value="'+dragType+'" />';
		popoverContent += '<input type="hidden" name="ref" value="'+dragRef+'" />';
		popoverContent += '<input type="hidden" name="destination" value="'+dragDest+'" />';	
		
		jQuery.each(data, function(key, value) {
			popoverContent += '<input type="hidden" name="'+key+'" value="'+value+'" />';	
		});

		jQuery.each(formpopover.items, function(index, item) {
			switch(item[0]) {
				case 'input':
				case 'buttons':
					popoverContent += wizardelements[item[0]][item[1]];
				break;
				case 'selector':
					popoverContent += '<ul id=\"ngelayout-popover-select\">';
					jQuery.each(item[1], function(indexSelector, valueSelector) {
						element = wizardelements['selector'][valueSelector[0]][valueSelector[1]];
						popoverContent += '<li data-value="'+element[1]+'">'+element[0]+'</li>';
					});
					popoverContent += '</ul>';
					popoverContent += '<input type="hidden" name="part_type" value="" />';
					<?php /*
					popovercontent += '<'+'script>jQuery("#ngelayout-popover-select li").click(function() {';
					popovercontent += 'alert( "XXX" );';
					popovercontent += '});<\/script>';
*/
					?>

				break;	
			default :
				break;
			}
		});
		popoverContent += '</form>';
						
		/*Return popover content depending on the Layout, type on select, and if the ref element exist or not*/
		tempDropped.popoverClosable({
			html: true,
			width: formpopover.width,
			height: formpopover.height,
			animation: true,
			placement: "bottom",
			container: "#part-temp-dropped",
			trigger: "manual",
			title: popoverTitle,
			content: popoverContent
		});
		tempDropped.popover('show');				
			jQuery("#ngelayout-popover-select li").click(function() {
					jQuery("#ngelayout-popover input[name='part_type']").val(jQuery(this).data("value"));

					var postFunction = popoverPostFunctions[dragDest];
					if (typeof postFunction == "function") {
						postFunction.call();				    
					}    
			});

			jQuery("#ngelayout-popover").find(".ngelayout-popover-buttons-create").click(function(){
				var postFunction = popoverPostFunctions[dragDest];
					if (typeof postFunction == "function") {
						postFunction.call();				    
					}    		    	
			});
			/*
			jQuery("div.ngelayout-popover-buttons-cancel").click(function(){
				jQuery(this).parents(".popover").hide();
				jQuery("#part-temp-dropped").remove();
			});
			*/
	};
});