    /**
     * @name saveModuleToArticle
     * @description save module in article like {loadposition xxx-nnn}
     * @param moduleId, articleId
     * @returns object or false
     */
    saveModuleToArticle = function (moduleId, articleId) {
    	var res = false;
    	
    	var url = "index.php?option=com_nge&task=module.moduletoarticle ";
    	var token = jQuery('#tokenform').find('input').attr('name');
    	var data = {};
    	data['m_id'] = moduleId;
    	data['a_id'] = articleId;
    	data[token] = 1;    	
    	jQuery.ajax({
    	    url: url,
    	    data: data,
    	    async: false,
	    type: 'POST',
    	    success: function (resultJson) {
		try {
		    result = jQuery.parseJSON(resultJson);
		    res = result;
		} catch (err) {
		    bootbox.alert(COM_NGE_JS_EDITING_ARTICLE_UNABLE_MOVE_PART_TO_POSITION + err.toString());
		}
    	    },
    	    error: function (result) {
    	    	bootbox.alert(COM_NGE_JS_EDITING_ARTICLE_UNABLE_MOVE_PART_TO_MODULE);
    	    }
    	});
    	
    	return res;
    }
    
    /**
	 * @name savePartModuleToPartArticle
	 * @description Remove module div and saveArticle() with only div part content
	 * @param m_id
	 * @returns void
	 */
    savePartModuleToPartArticle = function(m_id) {
    	var partId = part.attr('id');
    	
    	/*Removing part and saving closest parent Layout (columns or page layout)    	*/
    	jQuery('#'+partId).remove();
    	
		var articleContent = jQuery('#'+partId).closest(".nge-article-content");
		saveArticle(articleContent);
    };
    
    /**
	 * @name removeArticlePart
	 * @description remove part in article and save the article
	 * @param part element
	 * @returns void
	 */
    removeArticlePart = function(part) {
	    //var articleContent = part.closest(".nge-article-content");
	    var $articleContent = jQuery(part).closest(".ngeinlineeditor");
	    var oldHtml = $articleContent.html();
	    /*Moving toolbar at the starting of the document, to avoid being removed with the part*/
	    jQuery('#part-toolbar').hide();
	    /*Removing part and saving closest parent Layout (columns or page layout)    	*/
	    part.remove();
	    saveInlineEditorContent($articleContent);
    };
    
    /**
	 * @name duplicateArticlePart
	 * @description duplicate part on the layout article and save the article
	 * @param pk, returnMode
	 * @returns void
	 */
    duplicateArticlePart = function(pk, returnMode) {
    	returnMode = returnMode || "preview";
	var token = jQuery('#tokenform').find('input').attr('name');
	var url="index.php?option=com_nge&task=part.duplicate";
    	url += '&pk='+pk;
    	url += '&return='+returnMode;	
    	url += '&media=layout';
	url += '&' + token + '=1';
    	
        jQuery.ajax({
    	    url:url,
    	    success:function(resultJson){
		try {
		    var result = jQuery.parseJSON(resultJson);
		    try{
			result = jQuery.parseJSON(resultJson);
			if (result.result == 1){
			    var currentPart = jQuery("#part-" + pk);
			    currentPart.after(result.html);

			    var duplicatePart = jQuery('#part-' + result.pk);
			    duplicatePart.addClass('ngeeditable');
			    enableNgePartToolbar('#part-' + result.pk);
			    enableNgeInlineEditing('#part-' + result.pk);
			    enableNgeItemsSortable('#part-' + result.pk);

			    activeSortableLayout(jQuery('#part-' + result.pk));

			    var $articleContent = jQuery("#part-" + result.pk).closest(".ngeinlineeditor");
			    saveInlineEditorContent($articleContent);
			}
			else {
			    console.error(result.message);
			}
		    } catch(err){
			    console.error("Error : Unable to duplicate part<br>"+err.toString());  
		    }		    
		}
		catch(error){ 
		    console.log(error);
		    console.log(resultJson);
		}
    	    },
    	    error:function(result){
    	    	console.error("Error : Unable to duplicate part");   
    	    }
    	});
    };

    /**
	 * @name afterPageLayoutPartCreate
	 * @description Called by config screen when new part has been created
	 * @returns void
	 */    
    afterArticleLayoutPartCreate = function(result){
         /*Finding current dropped part with the part-temp-dropped class*/
 		currentThumbTemporary = jQuery("#part-temp-dropped");
 		currentThumbTemporary.after(result.html);
 		currentThumbTemporary.remove();

		/*Add edit attributes and events for this new part*/
		enableNgePartToolbar('#part-'+result.pk);
		enableNgeInlineEditing('#part-'+result.pk);
		enableNgeItemsSortable('#part-'+result.pk);
		
		activeSortableLayout(jQuery('#part-'+result.pk));
		
		//var articleContent = jQuery("#part-"+result.pk).closest(".nge-article-content");
		//saveArticle(articleContent);
				
		var $inlineEditorContent = jQuery("#part-"+result.pk).closest(".ngeinlineeditor");
		saveInlineEditorContent($inlineEditorContent);
 	};

/*
	 * @name afterArticleLayoutModuleCreate
	 * @description Called by config screen when new module has been created
	 * @returns void
	 */    
    afterArticleLayoutModuleCreate = function(pk, content){

         /*Finding current dropped part with the part-temp-dropped class*/
 		currentThumbTemporary = jQuery("#part-temp-dropped");
 		currentThumbTemporary.after(content);
 		currentThumbTemporary.remove();
 	};

saveArticle = function(articleContent){
	var articleId = articleContent.closest(".ngeeditablestructurearticle").data('nge').id;
	var ckEditor = CKEDITOR.instances['ngelayout-article-content-'+articleId];
	var contentHtml = articleContent.clone(true);
	
	/*removing part preview and restore original part tags*/
	contentHtml.find('.part').each(function(){
	    var divid = jQuery(this).attr('id');
	    var pkArray = divid.split("-");
	    var pk 	= pkArray[1];
	    
	    var partlibrary = jQuery(this).attr('data-part');
	    jQuery(this).after('<part data-class="'+partlibrary+'" data-part="'+pk+'">&nbsp;</part>');
	    jQuery(this).remove();
	});

	/*Removing sortable, partToolbar stuff*/
	contentHtml.find('.nge-margin-handle').remove();
	contentHtml.find('.nge-part-margin-process').remove();
	contentHtml.find('.nge-part-resize-process').remove();
	contentHtml.find('.ui-draggable').removeClass('ui-draggable');
	contentHtml.find('.ui-resizable').removeClass('ui-resizable');
	contentHtml.find('.ui-sortable').removeClass('ui-sortable');
	contentHtml.find('.ngelayout-article-connected-sortable').removeClass('ngelayout-article-connected-sortable');
	
	var html = contentHtml.html();
	html = html.replace(/<!--{cke_protected}.*?-->/g, '');

	var url = 'index.php?option=com_nge&task=article.save';

	jQuery.ajax({
		url: url,
		data: {'a_id': articleId, 'articletext': html},
		type: 'POST',
		success: function (resultJson) {
			contentHtml.remove();
			try {
    		    result = jQuery.parseJSON(resultJson);

    		    if(result.success == 1){
        		    if(typeof ckEditor !== 'undefined')
        		    	nge.showNotification( result.message, 'success', 3000);
    		    }else{
    		    	if(typeof ckEditor !== 'undefined')
    		    		nge.showNotification( result.message, 'warning', 3000);
        		}
        		
    		} catch (err) {
    		    console.error("Error : to save article" + err.toString());
    		}
		},
		error: function (result) {
			console.error("Error : Article Wrong url, may be 500 Internal Servor Error =>" + result);
		}
	});       
};


/************ Article editable *****************/
/*Activate editable content in layout*/
enableEditableArticleLayout = function () {
    var selector_articles = jQuery('.ngelayout-article');
	selector_articles.addClass('ngeeditable');
        selector_articles.find('div.ngelayout-toolbar').css('display', 'inline-block');
        
};

disableEditableArticleLayout = function () {
    var selector_articles = jQuery('.ngelayout-article');
        selector_articles.removeClass('ngeeditable');
        selector_articles.find("div.ngelayout-toolbar").css('display', 'none');
};

	loadEditableArticle = function(editor){
    	var editableElements = jQuery( "div.ngelayout-article" );
    	var nbEditableElements = editableElements.length;
    	var nbEditableElementsLoaded = 0;
    	
    	editableElements.fadeOut();
    	editableElements.html('<div style="text-align:center;margin-top:50px;"><img src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /></div>');
    	editableElements.fadeIn();

    	editableElements.each(function( index ) {
	    	var currentElement = jQuery(this);
	    	var elementId = currentElement.data('nge-id');

		    var url = 'index.php?option=com_nge&view=editor&tmpl=component&layout=nge&format=raw&source=article&id='+elementId;
	    	jQuery.ajax({
	    	    url:url,
	    	    async:true,
	    	    success:function(result){
	    	    	try{		    
	    	    		/*Update the article with new content article*/
	    	    		currentElement.html(result);
	    	    		nbEditableElementsLoaded++;
	    	    		
	    	    		/*Enable all function for the edition*/
	    	    		if(nbEditableElementsLoaded == nbEditableElements){
	    	    			ngeBeginEdition('article');
	    	    			enableEditableArticleLayout();
	    	    		}
	    	    	} catch(err){
	    	    		console.error("Error : Unable to load editable content<br>"+err.toString());  
	    	    	}		
	    	    },
	    	    error:function(result){
	    	    	console.error("Error : Unable to load editable content");   
	    	    }
	    	});    
	    });
    };


/******************* Article sortable **************************/
	/*Activate sortable element in Layout    */
    enableArticleSortableLayout = function () {
    	var startLayout, currentlayout;
    	/*Current article becomes sortable (connectable with all other layouts)*/
    	var sortableArticle = jQuery("div.ngelayout-article").children(".content");
    	
    	/*Make sortable all child elements in the article, except other parts (selected further as editable parts)*/
    	/*In article content, enable Adding all editable content inside except parts*/
    	var sortableContent = sortableArticle.find("div, form, body, fieldset, h1, h2, h3, h4, h5, h6, pre, li, span,th , td").not(".part").not(".part *");
    	sortableContent.addClass("ngelayout-editablecontent");
    	
		/*All sortable elements : editable parts and their inside content*/
		var sortableElements = sortableArticle.add(sortableContent);
			
    	/*selectorArticleSortable.sortable({*/
        sortableElements.sortable({
            placeholder: "ngelayout-sortable-article ngenosave",
            /*handle: ".ngetlb-move",*/
	handle: "#ngemove-toolbar",
            /* SORTABLE IN ALL LAYOUT This version is used to connect with other sortable layout
             * connectWith: ".ngelayout-article .content, .ngelayout-module .custom, .ngelayout-page .content, .ngelayout-part, .ngelayout-editablecontent",*/
            /* SORTABLE ONLY FOR REODER This version only accept sortable inside the current element*/
            connectWith: ".ngelayout-editablecontent",
            cursorAt: {top: 35, left: 35},
            start: function (e, ui) {
            	/*Set part sortable active to not trigger mouseover on other part when dragging a part*/
            	isPartSortable = true;
            	jQuery('#part-toolbar').hide();
            	if (!ui.item.hasClass('ngedraggable-mainbar')) {/*Comes from another sortable content*/
                    /* SORTABLE IN ALL LAYOUT This version is used to connect with other sortable layout
                     * enableSortableDragDropZone(["article", "part", "module"]);*/
                    /* SORTABLE ONLY FOR REORDER This version only accept sortable inside the current element*/
                    enableSortableDragDropCurrentZone(jQuery(this));
            	}
            	
            	startLayout = ui.item.closest(".nge-article-content");
            },
            helper: function (event, ui) {
            	var name = "";
            	var clone = jQuery(ui).clone(true);
            	
            	var name = clone.data("part-label");
            	
			    /*Get ajax default part html and return the html code*/
			    var target = '<div id="nge-sortable-helper">'+name+'</div>';
			    return target;
			},
            receive: function (e, ui) {      
                var partType = ui.item.data('part');
                var m_id	= ui.item.data('module-id');
                if (!ui.item.hasClass('ngedraggable-mainbar')) {
                	/*Come from another sortable content*/
        		    if (typeof m_id !== "undefined") {
        		    	if (ui.item.hasClass("ngemodule-part")) {/*It's a part module*/
        		    		/*Remove div Module and keep only the div part*/
        		    		var partElement = ui.item.find(".part");
        		    		ui.item.replaceWith(partElement);
        		    		/*Trash the module*/
        		    		removeModuleFromPosition(m_id);
        		    		/*Save the article with the new part*/
        		    		/*Auto save with update function*/
        		    	}else{/*Other module*/
        		    		var articleId = ui.item.closest(".nge-article-content").data('nge-id');
/*        		    		var objectCreated = saveModuleToArticle(m_id, articleId);*/
        		    		
        		    		/*Replace module by loadposition code*/
/*        		    		ui.item.replaceWith(objectCreated.html);*/
        		    		
        		    		var data = {
								"element": "module",
								"destination": "article",
								"m_id": m_id,
								"articleId": articleId,
							};
					    	
		    		    	updateDraggableElement(ui.item, data);
        		    		/*Save the article with the new part*/
        		    		/*Auto save with update function*/
        		    	}
        		    }else if(typeof partType !== "undefined"){
        				/*It's a part*/
        		    	currentlayout = ui.item.closest(".nge-article-content");
        		    	saveArticle(currentlayout);
        		    }
                }
            },
            update: function( event, ui ) {
                
            	if (ui.item.hasClass('ngedraggable-mainbar')) {
                	/*Active the creation of part if come from drag&drop*/
                        /*Test if we are in a nested article sortable if yes we don't update because it's always done by the parent article*/
                        if(!jQuery(this).hasClass("ngelayout-editablecontent")){
                            addPartToLayout(ui);
                        }
                }else{
                	/*Update start layout if defined*/
                	if (typeof startLayout !== 'undefined'){
                		saveArticle(startLayout);
    	            }
                }
            },
            stop: function (e, ui) {
            	
            	disableSortableDragDropZone();
            	isPartSortable = false;
            }
        });
    };

    disableArticleSortableLayout = function () {	
    	jQuery(".ngelayout-article").find(".ngelayout-editablecontent").removeClass("ngelayout-editablecontent");
		jQuery(".ngelayout-article").find(".content.ui-sortable").sortable("destroy");
    };
    
    
    
    /*Triggering functions.*/
jQuery(document).on( "ngeEnableEdition", function() {
  enableEditableArticleLayout();
  enableArticleSortableLayout();
});

jQuery(document).on( "ngeDisableEdition", function() {
  disableEditableArticleLayout();
  disableArticleSortableLayout();
});    