var currentCkeditorCleanValue;

/* enableNgeInlineEditing 
 * enable inlineediting in all tags ready for that.
 * */
enableNgeInlineEditing = function (selector) {
    var $selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);

    /*Text without formatting*/
    enableInlineEditableText($selector);
    /*Rich text*/
    enableInlineEditableEditor($selector);
    /*Disable links for all inlineeditable texts in links (menu labels, ...)*/
    disableEditableLinks($selector);
    /* Show nge messages inside page (information panels) */
    jQuery('.visiblewhenunlocked').show();
};
	
disableNgeInlineEditing = function (selector) {
    var $selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);

    disableInlineEditableTexts($selector);		
    /*Enable links for all inlineeditable texts in links (menu labels, ...)*/
    enableEditableLinks($selector);	    
    /* Hide nge messages inside page (information panels) */
    jQuery('.visiblewhenunlocked').hide();
};

/*
 * Disable bind event on editable links : the text in the link will be inline editable clicking in it
 * @param {type} selector
 * @returns {undefined}
 */		
disableEditableLinks = function($selector){
    $selector.find('.inlineeditablelink').bind('click', false);
    /*disableEditableLinks
    jQuery('.inlineeditablelink').each(function(){
        jQuery(this).attr('ngehref', jQuery(this).attr('href'));
        jQuery(this).attr('href', '#');
    });
    */
}
	
/*
 * Setting again bind event on editable links after editing mode
 * @param {type} selector
 * @returns {undefined}
 */
enableEditableLinks = function($selector){
    $selector.find('.inlineeditablelink').unbind('click', false);
    /*
    jQuery('.inlineeditablelink').each(function(){
        jQuery(this).attr('href', jQuery(this).attr('ngehref'));
    });
    */
}


enableInlineEditableParts = function (selector, isInArticle) {
    var $elementsPart = jQuery(selector);
    isInArticle = typeof isInArticle !== 'undefined' ? isInArticle : false;

    $elementsPart.find('.ngecontenteditableinline').each(function () {
        if (jQuery(this).data('type') == 'inline') {
            var currentPartZoneEditable = jQuery(this);

            / *Mouse enter* /
            currentPartZoneEditable.mouseenter(function () {
                jQuery(this).attr("contenteditable", "true");
                toolbarStatus = document.getElementById("part-toolbar-status");
                toolbarStatus.innerHTML = COM_NGE_JS_EDITING_INLINE_EDIT;
                toolbarStatus.style.display = 'block';				    
                currentInlineEditingValue = jQuery(this).text().trim();
            });

            / *Mouse clic* /
            currentPartZoneEditable.click(function () {
                toolbarStatus = document.getElementById("part-toolbar-status");
                toolbarStatus.innerHTML = COM_NGE_EDITING;
                toolbarStatus.style.display = 'block';
            });		

            / *MouseOut* /
            currentPartZoneEditable.mouseleave(function () {
                var value = jQuery(this).text().trim();
                if (value != currentInlineEditingValue) {

                            / *Part ID : finding closest parent part. part id is "part-nnn"* /
                            var divid = jQuery(this).closest(".part").attr('id');
                            var pkArray = divid.split("-");
                            var pk = pkArray[1];
                            / *Property* /
                            var property = jQuery(this).attr('data-property');
                            if (storePartProperty(pk, 'content', property, value)){
                                    nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
                            }
                            currentInlineEditingValue = value;
                }else{
                        toolbarStatus = document.getElementById("part-toolbar-status");
                        toolbarStatus.style.display = "none";  					    
                        toolbarStatus.innerHTML = '';
                }

                jQuery(this).attr("contenteditable", "false");
            });
        }
    });
};
    
disableInlineEditableParts = function (selector) {
    selector = typeof selector !== 'undefined' ? selector : '.part';
    jQuery(selector).find('.ngecontenteditableinline[data-type="inline"]').unbind();	
};

/*
 * disableInlineEditableTexts()
 * Disable all instance of inline text and inline editor (ckeditor)
 * @param {type} $selector
 * @returns void
 */
disableInlineEditableTexts = function($selector){
    for(name in CKEDITOR.instances){
        if(CKEDITOR.instances[name]){
            CKEDITOR.instances[name].destroy();
        }
    }
    
    jQuery( "*[contenteditable=true]" ).attr("contenteditable", "false");
    $selector.find(".ngeinlinetext").unbind("mouseenter click blur");
    $selector.find( ".ngeinlineeditor" ).unbind("mouseenter click blur");
};

/*
 * Enable inlineEditable for all simple texts 
 * simple texts have the "ngeinlinetext" class
 * @returns {undefined}
 */
enableInlineEditableText = function($selector){
    var initialValue = '';
    //$selector.find('.ngeinlinetext').mouseenter(function () {
    jQuery($selector).find('.ngeinlinetext').mouseenter(function () {
        initialValue = jQuery(this).text();
        jQuery(this).attr("contenteditable", "true");
        /*Editable edition and Toolbars status */
        var $structureElement = jQuery(this).closest('.ngeeditablestructure');
	//$structureElement.find(".ngetoolbar-status").html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
        if ($structureElement.hasClass('ngeeditablestructurepart')){		    
            jQuery('#part-toolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();			
        }
         jQuery('#ngeinline-toolbar').find(".ngetoolbar-status").html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
    }).mouseleave(function () {
            var $structureElement = jQuery(this).closest('.ngeeditablestructure');
	   // $structureElement.find(".ngetoolbar-status").html('').hide();
            if ($structureElement.hasClass('ngeeditablestructurepart')){			
                jQuery('#part-toolbar-status').html('').hide();			
            }		    
    }).click(function () {
        /*Toolbars status */		    
        jQuery("#ngeinline_toolbar-status").html(COM_NGE_EDITING).show();
/*	    var inputWidth = jQuery(this).width();
        var initialInputDisplay = jQuery(this).css('display');
        jQuery(this).html("").css('display', 'block').width(inputWidth);*/
    }).blur(function () {
        /*Saving new text*/
        var value = jQuery(this).text();
        if (value != initialValue) {	
            var elementData = jQuery(this).data('nge');
            var structureData = jQuery(this).closest('.ngeeditablestructure').data('nge');
            if (storeInline(structureData.id, structureData.type, elementData.source, value)){
                nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
            }			    
        }				    
        /* End editable and hide toolbar status */
        jQuery(this).attr("contenteditable", "false");
        /*jQuery(this).css('display', 'inline');*/
        jQuery("#ngeinline_toolbar-status").html("").hide();				    				    
    });	
};

/*
 * Enable inlineEditable for all rich texts 
 * rich texts have the "ngeinlineeditor" class
 * @returns {undefined}
 */
enableInlineEditableEditor = function($selector, callback){
    var changeValueCallback = (typeof callback === "function") ? callback : null;
    /* Loading all contents */
    var $editableElements = $selector.find( ".ngeinlineeditor" );
    var nbEditableElements = $editableElements.length;
    var nbEditableElementsLoaded = 0;

    if(nbEditableElements === 0){ /*No element to load, it means loading is finished*/
        jQuery(document).trigger('ngeInlineEditableReady');
    }else{
        $editableElements.each(function( ) {
            var $currentElement = jQuery(this);
            var elementData = $currentElement.data('nge');
            var structureData = $currentElement.closest('.ngeeditablestructure').data('nge');
            var token = jQuery('#tokenform').find('input').attr('name');
	    
	    /*Preloading content to get initial content without content plugins applied.
	    If options preload false : no preloading. For example table cells with riche content*/
            if ((typeof structureData !== "undefined") && !((typeof elementData.options !== 'undefined') && (typeof elementData.options.preload !== 'undefined') && (elementData.options.preload == false))){
                $currentElement.html('<div style="text-align:center;margin-top:50px;"><img src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /></div>');
                var url = 'index.php?option=com_nge&task=inline.load&rendering=editor&type=' + structureData.type + '&source=' + elementData.source + '&id=' +structureData.id + '&' + token + '=1';
                jQuery.ajax({
                    url:url,
                    async:true,
                    success:function(resultJson){
                        try{		  
                            /*Update the article with new content article*/
                            result = jQuery.parseJSON(resultJson);				    
                            if (result.result == '1'){
                                $currentElement.html(result.value).attr("contenteditable", "true");
                            }
                            nbEditableElementsLoaded++;
                            /*Enable all function for the edition*/
                            if(nbEditableElementsLoaded === nbEditableElements){
                                addEditingInEditorContent($editableElements);
                                /*Creating ckEditor instances */
                                loadInlineEditors($editableElements, changeValueCallback);
                            }
                        } catch(err){
                            console.error("Error : Unable to load editable content<br>"+err.toString());
                        }		
                    },
                    error:function(result){
                        console.error("Error : Unable to load editable content");   
                    }
                });
            }else{ /* Missing informations. Content is not editable*/
                nbEditableElements--;
            }
        });
        
	if (nbEditableElements === 0){ /*for example table cells, no content preload. We load the editor new*/
	    loadInlineEditors($editableElements, changeValueCallback);
        }
    }
};
        
loadInlineEditors = function($editableElements, callback){
    var changeValueCallback = (typeof callback === "function") ? callback : null;
    
    $editableElements.mouseenter(function () {
        /*Editable edition and Toolbars status */
        /*var $structureElement = jQuery(this).closest('.ngeeditablestructure');
        if ($structureElement.hasClass('ngeeditablestructurepart')){		    
            jQuery('#part-toolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();			
        }*/
	
	/* If has Element toolbar, use it, if not use structure toolbar */
	var $elementToolbar = jQuery(this).find('.ngetoolbar');
	if ($elementToolbar.length > 0){
	    $elementToolbar.find('.ngetoolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
	}
	else {
	    var $structureElement = jQuery(this).closest('.ngeeditablestructure');
	    var $structureToolbar = $structureElement.find('.ngetoolbar');
	    if ($structureToolbar.length > 0){
		$structureToolbar.find('.ngetoolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
	    }
	    /*if ($structureElement.hasClass('ngeeditablestructurepart')){		    
		$partToolbarStatus.html(COM_NGE_JS_EDITING_INLINE_EDIT).show();			
	    }*/
	}	    
		
	
    }).mouseleave(function () {
        /*Editable edition and Toolbars status */
        var $structureElement = jQuery(this).closest('.ngeeditablestructure');
        if ($structureElement.hasClass('ngeeditablestructurepart')){		    
            jQuery('#part-toolbar-status').html('').hide();			
        }
    })
            
    jQuery(document).off("mousedown", ".ngeinlineeditor").on("mousedown", ".ngeinlineeditor", function(evt) {
        /*Toolbars status */
        jQuery("#ngeinline_toolbar-status").html(COM_NGE_EDITING).show();
        
        /*Creating each inline editor instance. One instance by element */
        var $currentEditableContent = jQuery(this);
        var currentEditableContentId = jQuery(this).attr('id');
        var currentEditableContentCkeditorName = jQuery(this).data('ckEditorName');
        var ckInstanceElement = null;
        
        if(typeof currentEditableContentId !== "undefined" && currentEditableContentId !== "" && currentEditableContentId !== null){
            /*Ckeditor instance with ID is the fastest way*/
            ckInstanceElement = currentEditableContentId;
        }else if(typeof currentEditableContentCkeditorName !== "undefined" && currentEditableContentCkeditorName !== "" && currentEditableContentCkeditorName !== null){
            /*Ckeditor instance with Dom element else*/
            ckInstanceElement = currentEditableContentCkeditorName;
        }else{ /*No id and no dom name created*/ 
            /*Ckeditor instance only works with javascript dom element*/
            ckInstanceElement = $currentEditableContent.get(0);
        }
        
        jQuery('.ngeinlineeditor[contenteditable="true"]').attr("contenteditable", "false");
        $currentEditableContent.attr("contenteditable", "true");

        /*Check if we are clicking on part element who is different off current instance of ckeditor*/
        if (!e) var e = window.event;
        var element = e.toElement || e.relatedTarget;
        var elementId = jQuery(element).closest(".part").attr('id');
        var currentEditablePartId = $currentEditableContent.closest(".part").attr('id');
        
        /*Check if we are Part element or not remove focus of the current ckeditor inline instance*/
        if(elementId === currentEditablePartId){
            /*Necessary, when there are nested widgets*/
            evt.stopPropagation();
            
            /*Create ckeditor inline isntance if not exist yet*/
            if ( typeof ckInstanceElement !== "undefined" && ckInstanceElement !== null && !CKEDITOR.instances[ckInstanceElement] ) {
                var ckInlineEditor = CKEDITOR.inline(ckInstanceElement, {
                    startupFocus: true,
                    allowedContent: true
                });
                
                /*Save instance name as data attribute*/
                $currentEditableContent.data("ckEditorName", ckInlineEditor.name)

                ckInlineEditor.on( 'focus', function( evt ) {
                    /*Get current value before change*/
                    currentCkeditorCleanValue = cleanEditingInEditorContent($currentEditableContent.clone(true));

                    /*If there are widgets with inlineEditor inside this one. Activate listeners beacause ckeditor destroy them*/
                    addEditingInEditorContent($currentEditableContent);
                });

                ckInlineEditor.on( 'blur', function( evt ) {
                    /*Saving new text if changed*/
                    saveInlineEditorContent($currentEditableContent, changeValueCallback);
                });
            }else{
                /*Ckeditor instance exist so just active it*/
                CKEDITOR.instances[ckInstanceElement].focus();
                CKEDITOR.instances[ckInstanceElement].focusManager.focus();
            }
        }else{
            /*Remove focus*/
            if (CKEDITOR.instances[ckInstanceElement]){
                CKEDITOR.instances[ckInstanceElement].focusManager.blur();
            }
            $currentEditableContent.attr("contenteditable", "false");
        }							
    });	
};	

/*Removing all editing stuff in an editable content before saving*/
addEditingInEditorContent = function($elements){
    var partsInside = $elements.find(".part" );
    var partsInsideEditable = $elements.find('.ngecontenteditableinline');
    
    /*Well render for ckeditor : destroy instance of parts inside the current element, if always exist. Else wrong render*/
    $elements.find(".ngeinlineeditor" ).each(function(){
        var divid = jQuery(this).attr('id');
        if(CKEDITOR.instances[divid]){
            CKEDITOR.instances[divid].destroy();
        }
    });

    /*Disable conteneditable for part inside the current element*/
    partsInside.attr("contenteditable", "false");
    partsInsideEditable.attr("contenteditable", "false");

    enableInlineEditableParts(partsInside);

    enableNgePartToolbar(partsInside);	
    enableNgeInlineEditing(partsInside);
    enablePartSortableLayout(partsInside);
    //enableNgeItemsSortable(partsInside);    
};

/*Removing all editing stuff in an editable content before saving*/
cleanEditingInEditorContent = function(element){
    /*removing part preview and restore original part tags*/
    element.find('.part').each(function(){
        var divid = jQuery(this).attr('id');
        var pkArray = divid.split("-");
        var pk 	= pkArray[1];

        var partlibrary = jQuery(this).attr('data-part');
        jQuery(this).after('<part data-class="'+partlibrary+'" data-part="'+pk+'">&nbsp;</part>');
        jQuery(this).remove();
    });

    /*Find class not useful for backup*/
    //element.find('#ngeinline-toolbar').remove();
    jQuery('body').prepend(element.find("#ngeinline-toolbar"));
    element.find('.ngenosave').remove(); //Embeded script and link tags
    //element.find(".ngetlb-move").remove();
    //element.find('.nge-margin-handle').remove();
    //!!C'est sur la part lui-mêmeelement.find('.nge-part-margin-process').remove();
    //element.find('.nge-part-resize-process').remove();
    element.find('.ui-draggable').removeClass('ui-draggable');
    element.find('.ui-resizable').removeClass('ui-resizable');
    element.find('.ui-sortable').removeClass('ui-sortable');
    element.find('.ngelayout-editablecontent').removeClass('ngelayout-editablecontent');
    element.find('.ngelayout-article-connected-sortable').removeClass('ngelayout-article-connected-sortable');

    var html = element.html();
    html = html.replace(/<!--{cke_protected}.*?-->/g, '');

    return html;
};
	
saveInlineEditorContent = function($editableContent, callback){
   var $clonedEditableContent = $editableContent.clone();

    /*Moving inline toolbar not to be included in the save content */
    var $inlineToolbar = jQuery("#ngeinline-toolbar");
    $inlineToolbar.css('display', 'none');        
    jQuery('body').prepend($inlineToolbar);	    

    /*Removing all editing stuff*/
    var value = cleanEditingInEditorContent($clonedEditableContent)
    
    /*get informations for saving*/
    var elementData = $editableContent.data('nge');
    var structureData = $editableContent.closest('.ngeeditablestructure').data('nge');

    /*Save article only if the content changed and saved function work*/
    if (value !== currentCkeditorCleanValue){
        var changeValueCallback = (typeof callback === "function") ? callback($editableContent, value) : null;
        if (storeInline(structureData.id, structureData.type, elementData.source, value, changeValueCallback)){
            nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
        }
    else
	nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVINGERROR , 'warning', 3000);
    }
    /*Deleting cloned content */
    $clonedEditableContent.remove();

    /* Restoring inlinetoolbar */
    $editableContent.prepend($inlineToolbar);
};	
    
storeInline = function (id, type, source, value, callback) {
    var isStored = false;
    var token = jQuery('#tokenform').find('input').attr('name');
    var data = {};
    data['id'] = id;	
    data['type'] = type;
    data['source'] = source;        
    data['value'] = value;
    /* If needed, type of value for content callback article/module/url/image */
    data['callback'] = callback;
    /* Security check */
    data[token] = 1;
    
    var data_str = JSON.stringify(data);
    var url = "index.php?option=com_nge&task=inline.store";
    
    jQuery.ajax({
        url: url,
        data: data,
        type: 'POST',
        async: false,
        success: function (result) {
	try{
	    resultobj = JSON.parse(result);
	    isStored = resultobj.result;
	    if(typeof callback !== "undefined" && callback !== null && typeof callback === "function"){
		callback.call();
	    }
	}
	    catch (e) {
	    console.error("Error while storing inline value : " + e.message)
	}
        }
    });

    return isStored;
};

/*Triggering functions.*/
jQuery(document).on( "ngeStartEdition", function() {
    enableNgeInlineEditing();
});

jQuery(document).on( "ngeDisableEdition", function() {
    disableNgeInlineEditing();
});