var currentCkeditorCleanValue;

/* enableNgeInlineEditing 
 * enable inlineediting in all tags ready for that.
 * */
enableNgeInlineSvgEditing = function (selector) {
    var $selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);

    /*Text without formatting*/
    enableInlineEditableSvgText($selector);
    /*Rich text*/
    //enableInlineEditableEditor($selector);

};
	
disableNgeInlineSvgEditing = function (selector) {
    var $selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);

    disableInlineEditableTexts($selector);		
    /*Enable links for all inlineeditable texts in links (menu labels, ...)*/
    enableEditableLinks($selector);		
};


/*
 * disableInlineEditableTexts()
 * Disable all instance of inline text and inline editor (ckeditor)
 * @param {type} $selector
 * @returns void
 */
disableInlineEditableSvgTexts = function($selector){
    for(name in CKEDITOR.instances){
        if(CKEDITOR.instances[name]){
            CKEDITOR.instances[name].destroy();
        }
    }
    
    jQuery( "*[contenteditable=true]" ).attr("contenteditable", "false");
    $selector.find(".ngeinlinetext").unbind("mouseenter click blur");
    $selector.find( ".ngeinlineeditor" ).unbind("mouseenter click blur");
};

/*
 * Enable inlineEditable for all simple texts 
 * simple texts have the "ngeinlinetext" class
 * @returns {undefined}
 */
enableInlineEditableSvgText = function($selector){
    
    
    var focused = null;
    jQuery($selector).find("svg")
	.on("keydown",keydown)
	.on("keypress",keypress)
	.on("click", function() {
		if (focused) {
			focused.stroke = d3.rgb(240,240,240);
			focused = null;
		}
	});

/*var $svg = jQuery($selector).find("svg");
t = new Textbox($svg);
*/
    
    var initialValue = '';
    //$selector.find('.ngeinlinetext').mouseenter(function () {
	jQuery($selector).find('.ngeinlinesvgtext').mouseenter(function () {
        initialValue = jQuery(this).text();
        //jQuery(this).attr("contenteditable", "true");
	
	
        /*Editable edition and Toolbars status */
        var $structureElement = jQuery(this).closest('.ngeeditablestructure');
        if ($structureElement.hasClass('ngeeditablestructurepart')){		    
            jQuery('#part-toolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();			
        }
         jQuery('#ngeinline-toolbar').find(".ngetoolbar-status").html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
    }).mouseleave(function () {
            var $structureElement = jQuery(this).closest('.ngeeditablestructure');
            if ($structureElement.hasClass('ngeeditablestructurepart')){			
                jQuery('#part-toolbar-status').html('').hide();			
            }		    
    }).click(function () {		
        /*Toolbars status */		    
        jQuery("#ngeinline_toolbar-status").html(COM_NGE_EDITING).show();
	
	
/*	    var inputWidth = jQuery(this).width();
        var initialInputDisplay = jQuery(this).css('display');
        jQuery(this).html("").css('display', 'block').width(inputWidth);*/
    }).blur(function () {
        /*Saving new text*/
        var value = jQuery(this).text();
        if (value != initialValue) {	
            var elementData = jQuery(this).data('nge');
            var structureData = jQuery(this).closest('.ngeeditablestructure').data('nge');
            if (storeInline(structureData.id, structureData.type, elementData.source, value)){
                nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
            }			    
        }				    
        /* End editable and hide toolbar status */
        jQuery(this).attr("contenteditable", "false");
        /*jQuery(this).css('display', 'inline');*/
        jQuery("#ngeinline_toolbar-status").html("").hide();				    				    
    });	
};


/* Textbox FROM Eric Forgy 
  https://groups.google.com/forum/#!topic/d3-js/3jTaajInaJs 
  http://jsfiddle.net/eforgy/ppoakf0k/
http://stackoverflow.com/questions/9308938/inline-text-editing-in-svg
 http://jsfiddle.net/brx3xm59/*/

    var keydown = function() {
	if (!focused) return;
	var text = focused.text;
	/*var code = d3.event.keyCode;
	if (code == 8) { // Backspace
		d3.event.preventDefault();
		text = text.substring(0,text.length-1);
	};
	if (code == 13) { // Enter
		focused.stroke = d3.rgb(240,240,240);
		focused.callback();
	};*/
	focused.text = text;
}

var keypress = function() {
	if (!focused) return;
	/*var text = focused.text;
	var code = d3.event.keyCode;
	text = text+String.fromCharCode(code);*/
	focused.text = text;
}

 function Textbox(parent) {
	var text = "text",
		fontsize = 12,
		x = 10,
		y = 30,
		width = 100,
		height = 20,
		stroke = d3.rgb(240,240,240),
		fill = d3.rgb(255,255,255);
	var textgroup = parent.append("g")
		.attr("transform", "translate(" + x + "," + y + ")");
	var rct = textgroup.append("rect")
		.attr("width", width)
		.attr("height", height)
		.style("fill",fill)
		.style("stroke-width","1px")
		.style("stroke",stroke)
		.style("opacity", 1);
	var txt = textgroup.append("text")
		.text(text)
		.style("fill","black")
		.style("font", fontsize+"px 'Helvetica Neue'");
	var cover = textgroup.append("rect") // Transparent cover to hide cursor when mousing over text
		.attr("width", width)
		.attr("height", height)
		.style("opacity", 0);
		
	var txt_width = txt.node().getComputedTextLength();
	txt.attr("x",.5*(width-txt_width));
	txt.attr("y",.5*(height+fontsize)-2);
		
	var callback = function() {
	}
			
	var aligntext = function() {
		txt.attr("x",.5*(width-txt_width));
		txt.attr("y",.5*(height+fontsize)-2);				
	};
		
	function textbox() {
  	}
		
	Object.defineProperty(textbox,"text",{
		get: function() {return text;},
		set: function(_) {
			text = _;
			txt.text(_);
			txt_width = txt.node().getComputedTextLength();
			aligntext();
		},
		enumerable: true,
		cofigurable: true
	});

	Object.defineProperty(textbox,"x",{
		get: function() {return x;},
		set: function(_) {
			x = _;
			textgroup.attr("transform", "translate(" + x + "," + y + ")");
		},
		enumerable: true,
		cofigurable: true
	});
		Object.defineProperty(textbox,"y",{
		get: function() {return y;},
		set: function(_) {
			y = _;
			textgroup.attr("transform", "translate(" + x + "," + y + ")");
		},
		enumerable: true,
		cofigurable: true
	});
		
	Object.defineProperty(textbox,"width",{
		get: function() {return width;},
		set: function(_) {
			width = _;
				rct.attr("width",_);
				cover.attr("width",_);
				aligntext();
			},
			enumerable: true,
			cofigurable: true
	});

	Object.defineProperty(textbox,"height",{
		get: function() {return height;},
		set: function(_) {
			height = _;
			rct.attr("height",_);
			cover.attr("height",_);
			aligntext();
		},
		enumerable: true,
		cofigurable: true
	});

    Object.defineProperty(textbox,"position",{
		get: function() {return [x, y, width, height];},
		set: function(_) {
			textbox.x = _[0]; 
			textbox.y = _[1];
			textbox.width = _[2];
			textbox.height = _[3];
		},
		enumerable: true,
		cofigurable: true
	})
				
	Object.defineProperty(textbox,"stroke",{
		get: function() {return stroke;},
		set: function(_) {
			stroke = _;
			rct.style("stroke",stroke);
		},
		enumerable: true,
		cofigurable: true
	});
		
	Object.defineProperty(textbox,"cover",{
		get: function() {return cover;},
		enumerable: true,
		cofigurable: true
	});
		
	Object.defineProperty(textbox,"callback",{
		get: function() {return callback;},
		set: function(_) {
			callback = _;
		},
		enumerable: true,
		cofigurable: true
	});

	cover.on("click", function() {
		focused = textbox;
		rct.style("stroke","#347bbe");
		d3.event.stopPropagation();
	});
    
	return textbox;
}
    
   
    
storeInlineSvg = function (id, type, source, value, callback) {
    var token = jQuery('#tokenform').find('input').attr('name');
    var data = {};
    data['id'] = id;	
    data['type'] = type;
    data['source'] = source;        
    data['value'] = value;
    /* If needed, type of value for content callback article/module/url/image */
    data['callback'] = callback;
    /* Security check */
    data[token] = 1;

    var data_str = JSON.stringify(data);
    var url = "index.php?option=com_nge&task=inline.store";
    jQuery.ajax({
        url: url,
        data: data,
        type: 'POST',
        async: false,
        success: function (result) {
            resultobj = JSON.parse(result);
    isStored = resultobj.result;
        }
    });

    return isStored;
};

/*Triggering functions.*/
jQuery(document).on( "ngeStartEdition", function() {
    enableNgeInlineSvgEditing();
});

jQuery(document).on( "ngeDisableEdition", function() {
    disableNgeInlineSvgEditing();
});