/*  
 * Prototype NgeInline
 * @version 1.0
 * @author Teatis
 */

var NgeInline = (function () {
    /*Constructor*/
    function NgeInline(selector) {
        this._selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);
        this._editing = {};
        this._editing.texts = new NgeInlineEditingTexts(this._selector);
    }
    
    /**
     * Store data at the specific place and return callback if exist.
     * @return void
     */
    NgeInline.prototype.store = function (options) {
        var token = jQuery('#tokenform').find('input').attr('name');
        var data = {};
        data['id'] = options.id;	
        data['type'] = options.type;
        data['source'] = options.source;        
        data['value'] = options.value;
        /* If needed, type of value for content callback article/module/url/image */
        data['callback'] = options.callback;
        /* Security check */
        data[token] = 1;

        var url = "index.php?option=com_nge&task=inline.store";
        jQuery.ajax({
            url: url,
            data: data,
            type: 'POST',
            async: false,
            success: function (result) {
                resultobj = JSON.parse(result);
                isStored = resultobj.result;
                
                if(isStored == true || parseInt(isStored) === 1){ /*If store success*/
                    if(typeof options.storeEventCallback !== "undefined" && options.storeEventCallback !== null && typeof options.storeEventCallback === "function"){
                        options.storeEventCallback.call();
                    }
                    if(typeof options.storeMessageCallback !== "undefined" && options.storeMessageCallback !== null && typeof options.storeMessageCallback === "function"){
                        options.storeMessageCallback.call();
                    }
                }else{
                    nge.showNotification('Warning: Error while storing inline value' , 'error', 3000); 
                    console.error("Warning: Error while storing inline value");
                }
            }
        });
    };
    
    return NgeInline;
})();

var NgeInlineEditingTexts = (function () {
    /*Constructor*/
    function NgeInlineEditingTexts (selector) {
        this._selector = selector;
        this._currentCkeditorCleanValue = null;
        this._storeEventCallback = null;
    }
    
    /*Child class override parent class*/
    NgeInlineEditingTexts.prototype = Object.create(NgeInline.prototype);
    NgeInlineEditingTexts.prototype.constructor = NgeInlineEditingTexts;
    
    /*Method/
    /**
     * Enable all editing texts event & fucntion
     * @return void
     */
    NgeInlineEditingTexts.prototype.enable = function () {
        this.enableText();
        this.enableEditor();
        this.disableLinks();
    };
    /**
     * Disable all editing texts event & fucntion
     * @return void
     */
    NgeInlineEditingTexts.prototype.disable = function () {
        this.disableTexts();		
        this.disableEditors();		
        this.enableLinks();
    };
    /**
     * Enable inlineEditable for all simple texts 
     * simple texts have the "ngeinlinetext" class
     * @return void
     */
    NgeInlineEditingTexts.prototype.enableText = function () {
        var $this = this;
        var initialValue = '';
        var $partToolbarStatus = jQuery('#part-toolbar-status');

        this._selector.find('.ngeinlinetext').mouseenter(function () {
            initialValue = jQuery(this).text();
            jQuery(this).attr("contenteditable", "true");
            /*Editable edition and Toolbars status */
	    /* If has Element toolbar, use it, if not use structure toolbar */
	    var $elementToolbar = jQuery(this).find('.ngetoolbar');
	    if ($elementToolbar.length > 0){
		$elementToolbar.find('.ngetoolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
	    }
	    else {
		var $structureElement = jQuery(this).closest('.ngeeditablestructure');
		var $structureToolbar = $structureElement.find('.ngetoolbar');
		if ($structureToolbar.length > 0){
		    $structureToolbar.find('.ngetoolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
		}
		/*if ($structureElement.hasClass('ngeeditablestructurepart')){		    
		    $partToolbarStatus.html(COM_NGE_JS_EDITING_INLINE_EDIT).show();			
		}*/
	    }
            jQuery("#ngeinline-toolbar").find(".ngetoolbar-status").html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
        }).mouseleave(function () {
            var $structureElement = jQuery(this).closest('.ngeeditablestructure');
            if ($structureElement.hasClass('ngeeditablestructurepart')){			
                $partToolbarStatus.html('').hide();			
            }		    
        }).click(function () {		
            /*Toolbars status */		    
            jQuery("#ngeinline_toolbar-status").html(COM_NGE_EDITING).show();
        }).blur(function () {
            /*Saving new text*/
            var value = jQuery(this).text();
            if (value !== initialValue) {	
                var elementData = jQuery(this).data('nge');
                var structureData = jQuery(this).closest('.ngeeditablestructure').data('nge');
                
                var storeInlineData = {
                    id : structureData.id,
                    type : structureData.type,
                    source : elementData.source,
                    value : value,
                    callback : null,
                    storeMessageCallback : function(){
                        nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000); 
                    }
                }
                $this.store(storeInlineData);			    
            }				    
            /* End editable and hide toolbar status */
            jQuery(this).attr("contenteditable", "false");
            /*jQuery(this).css('display', 'inline');*/
            jQuery("#ngeinline_toolbar-status").html("").hide();				    				    
        });
    };
    /**
     * Enable inlineEditable for all rich texts 
     * rich texts have the "ngeinlineeditor" class
     * @return void
     */
    NgeInlineEditingTexts.prototype.enableEditor = function () {
        /* Loading all contents */
        var $this = this;
        var $editableElements = $this._selector.find( ".ngeinlineeditor" );
        var nbEditableElements = $editableElements.length;
        var nbEditableElementsLoaded = 0;

        if(nbEditableElements === 0){ /*No element to load, it means loading is finished*/
            jQuery(document).trigger('ngeInlineEditableReady');
        }else{
            $editableElements.each(function( ) {
                var $currentElement = jQuery(this);
                var elementData = $currentElement.data('nge');
                var structureData = $currentElement.closest('.ngeeditablestructure').data('nge');
	var token = jQuery('#tokenform').find('input').attr('name');

                /*Preloading content to get initial content without content plugins applied.
                If options preload false : no preloading. For example table cells with riche content*/
                if ((typeof structureData !== "undefined") && !((typeof elementData.options !== 'undefined') && (typeof elementData.options.preload !== 'undefined') && (elementData.options.preload == false))){
                    $currentElement.fadeOut().html('<div style="text-align:center;margin-top:50px;"><img src="'+rootUrl+'components/com_nge/assets/images/spinner.gif" /></div>').fadeIn();
                    var url = 'index.php?option=com_nge&task=inline.load&rendering=editor&type=' + structureData.type + '&source=' + elementData.source + '&id=' +structureData.id + '&' + token + '=1';
                    jQuery.ajax({
                        url:url,
                        async:true,
                        success:function(resultJson){
                            try{		  
                                /*Update the article with new content article*/
                                result = jQuery.parseJSON(resultJson);				    
                                if (result.result == '1'){
                                    $currentElement.html(result.value).attr("contenteditable", "true");
				    console.log("CONTENTEDITABLE TRUE");
                                }
                                nbEditableElementsLoaded++;
                                /*Enable all function for the edition*/
                                if(nbEditableElementsLoaded === nbEditableElements){
                                    $this.activeEditingInsideEditor($editableElements);
                                    /*Creating ckEditor instances */
                                    $this.loadInlineEditors($editableElements);
                                }
                            } catch(err){
                                console.error("Error : Unable to load editable content<br>"+err.toString());  
                            }		
                        },
                        error:function(){
                            console.error("Error : Unable to load editable content");   
                        }
                    });
                }else{ /* Missing informations. Content is not editable*/
                    nbEditableElements--;
                }
            });

            if (nbEditableElements === 0){ /*for example table cells, no content preload. We load the editor new*/
                $this.loadInlineEditors($editableElements);
            }
        }
    };
    /**
     * Active editing for all element who can be edit.
     * @return void
     */
    NgeInlineEditingTexts.prototype.activeEditingInsideEditor = function($elements){
        var partsInside = $elements.find(".part" );
        var partsInsideEditable = $elements.find('.ngecontenteditableinline');

        /*Disable contenteditable for part inside the current element*/
        partsInside.attr("contenteditable", "false");
        partsInsideEditable.attr("contenteditable", "false");
        
        /*Enable partToolbar if exist.*/
        if(typeof enableNgePartToolbar !== "undefined"){ 
            enableNgePartToolbar(partsInside);
        }
        var enableChildEditing = new NgeInline(partsInside);
        enableChildEditing._editing.texts.enable();
    };
    /**
     * Load ckeditor for each rich element.
     * @return void
     */
    NgeInlineEditingTexts.prototype.loadInlineEditors = function($editableElements){
        var $this = this;
        $editableElements.mouseenter(function () {
            /*Editable edition and Toolbars status */
            /*var $structureElement = jQuery(this).closest('.ngeeditablestructure');
            if ($structureElement.hasClass('ngeeditablestructurepart')){		    
                jQuery('#part-toolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();			
            }*/
	    /* If has Element toolbar, use it, if not use structure toolbar */
	    var $elementToolbar = jQuery(this).find('.ngetoolbar');
	    if ($elementToolbar.length > 0){
		$elementToolbar.find('.ngetoolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
	    }
	    else {
		var $structureElement = jQuery(this).closest('.ngeeditablestructure');
		var $structureToolbar = $structureElement.find('.ngetoolbar');
		if ($structureToolbar.length > 0){
		    $structureToolbar.find('.ngetoolbar-status').html(COM_NGE_JS_EDITING_INLINE_EDIT).show();
		}
		/*if ($structureElement.hasClass('ngeeditablestructurepart')){		    
		    $partToolbarStatus.html(COM_NGE_JS_EDITING_INLINE_EDIT).show();			
		}*/
	    }	    
	    
	    
        }).mouseleave(function () {
            /*Editable edition and Toolbars status */
            var $structureElement = jQuery(this).closest('.ngeeditablestructure');
            if ($structureElement.hasClass('ngeeditablestructurepart')){		    
                jQuery('#part-toolbar-status').html('').hide();			
            }
        }).click(function (e) {
            /*Toolbars status */
            jQuery("#ngeinline_toolbar-status").html(COM_NGE_EDITING).show();

            /*Creating each inline editor instance. One instance by element */
            var $currentEditableContent = jQuery(this);
            var currentEditableContentId = jQuery(this).attr('id');
            var currentEditableContentCkeditorName = jQuery(this).data('ckEditorName');
            var ckInstanceElement = null;

            if($currentEditableContent.hasClass("nge-ckeditor-disabled")){
                $currentEditableContent.attr("contenteditable", "false");
            }else{
                /*Necessary, when there are nested widgets*/
                e.stopPropagation();
                
                if(typeof currentEditableContentId !== "undefined" && currentEditableContentId !== "" && currentEditableContentId !== null){
                    /*Ckeditor instance with ID is the fastest way*/
                    ckInstanceElement = currentEditableContentId;
                }else if(typeof currentEditableContentCkeditorName !== "undefined" && currentEditableContentCkeditorName !== "" && currentEditableContentCkeditorName !== null){  
                /*Ckeditor instance with Dom element else*/
                    ckInstanceElement = currentEditableContentCkeditorName;
                }else{ /*No id and no dom name created*/ 
                    /*Ckeditor instance only works with javascript dom element*/
                    ckInstanceElement = $currentEditableContent.get(0);
                }

                $currentEditableContent.attr("contenteditable", "true");

                /*Test if editor is already loaded*/
                if ( typeof ckInstanceElement !== "undefined" && ckInstanceElement !== null && !CKEDITOR.instances[ckInstanceElement] ) {
                     if(CKEDITOR.instances[ckInstanceElement]){
                        CKEDITOR.instances[ckInstanceElement].destroy();
                    }
                    /*Create and Instanciate ckeditor for current element*/
                    var ckInlineEditor = CKEDITOR.inline(ckInstanceElement, {
                        startupFocus: true,
                        allowedContent: true
                    });

                    /*Save instance name as data attribute*/
                    $currentEditableContent.data("ckEditorName", ckInlineEditor.name);

                    ckInlineEditor.on( 'focus', function( evt ) {
                        /*Get current value before change*/
                        $this._currentCkeditorCleanValue = $this.cleanEditingInEditorContent($currentEditableContent.clone(true));

                        /*If there are widgets with inlineEditor inside this one. Activate listeners beacause ckeditor destroy them*/
                        $this.activeEditingInsideEditor($currentEditableContent);
                    });

                    ckInlineEditor.on( 'blur', function( evt ) {
                        /*Saving new text if changed*/
                        $this.saveInlineEditorContent($currentEditableContent);
                        $currentEditableContent.attr("contenteditable", "false");
                    });
                }
            }
        });	
    };
    /**
     * Removing all editing stuff in an editable content before saving
     * @return void
     */
    NgeInlineEditingTexts.prototype.cleanEditingInEditorContent = function(element){
        /*removing part preview and restore original part tags*/
        element.find('.part').each(function(){
            var divid = jQuery(this).attr('id');
            var pkArray = divid.split("-");
            var pk 	= pkArray[1];

            var partlibrary = jQuery(this).attr('data-part');
            jQuery(this).after('<part data-class="'+partlibrary+'" data-part="'+pk+'">&nbsp;</part>');
            jQuery(this).remove();
        });

        /*Find class not useful for backup*/
        element.find(".ngetlb-move").remove();
        element.find('.nge-margin-handle').remove();
        element.find('.nge-part-margin-process').remove();
        element.find('.nge-part-resize-process').remove();
        element.find('.ui-draggable').removeClass('ui-draggable');
        element.find('.ui-resizable').removeClass('ui-resizable');
        element.find('.ui-sortable').removeClass('ui-sortable');
        element.find('.ngelayout-editablecontent').removeClass('ngelayout-editablecontent');
        element.find('.ngelayout-article-connected-sortable').removeClass('ngelayout-article-connected-sortable');

        var html = element.html();
        html = html.replace(/<!--{cke_protected}.*?-->/g, '');

        return html;
    };
    /**
     * Save ckeditor value
     * @return void
     */
    NgeInlineEditingTexts.prototype.saveInlineEditorContent = function($editableContent){
        var $this= this;
        var $clonedEditableContent = $editableContent.clone();

         /*Moving inline toolbar not to be included in the save content */
         //var $inlineToolbar = jQuery("#ngeinline-toolbar");
         //$inlineToolbar.css('display', 'none');        	    

         /*Removing all editing stuff*/
         var value = this.cleanEditingInEditorContent($clonedEditableContent)

         /*get informations for saving*/
         var elementData = $editableContent.data('nge');
         var structureData = $editableContent.closest('.ngeeditablestructure').data('nge');

         /*Save article only if the content change and saved function work*/
         if (value !== this._currentCkeditorCleanValue){
            var storeInlineData = {
                id : structureData.id,
                type : structureData.type,
                source : elementData.source,
                value : value,
                callback : null,
                storeEventCallback : function(){
                    if(typeof $this._storeEventCallback !== "undefined" && $this._storeEventCallback !== null && typeof $this._storeEventCallback === "function"){
                        $this._storeEventCallback.call(this, $editableContent, value);
                    }else{
                        /*Widget table specific event if it's a table widget and if datatable is enabled.*/
                        if($editableContent.closest(".part").attr("data-part") === "tables.table" 
                                && $editableContent.closest(".dataTables_wrapper").length > 0){
                            var $dataTableWrapper = $editableContent.closest(".dataTables_wrapper");
                            var $dataTableScrollBody = $dataTableWrapper.find(".dataTables_scrollBody");
                            var $table = ($dataTableScrollBody.length > 0) ? $dataTableScrollBody.find("table.dataTable") : $dataTableWrapper.find("table.dataTable");
                            var $dataTable = $table.DataTable();
                            var tableTd = $editableContent.parent();
                            var tableTdList = $editableContent.closest("tr").children();
                            var cellCol = tableTdList.index(tableTd);

                            $dataTable.settings()[0].aoColumns[cellCol].sTitle = value;
                            $dataTable.columns.adjust().responsive.recalc().draw("full-hold");
                        }
                    }
                },
                storeMessageCallback : function(){
                    nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000); 
                }
            }
            this.store(storeInlineData);
         }
         /*Deleting cloned content */
         $clonedEditableContent.remove();
    };
    /**
     * Disable contenteditable text
     * @return void
     */
    NgeInlineEditingTexts.prototype.disableTexts = function () {
        jQuery( "*[contenteditable=true]" ).attr("contenteditable", "false");
        this._selector.find(".ngeinlinetext").unbind("mouseenter click blur");
    };
    /**
     * Disable ckeditor instance
     * @return void
     */
    NgeInlineEditingTexts.prototype.disableEditors = function () {
        for(name in CKEDITOR.instances){
            if(CKEDITOR.instances[name]){
                CKEDITOR.instances[name].destroy();
            }
        }
        
        CKEDITOR.currentInstance = null;
        
        this._selector.find( ".ngeinlineeditor" ).each(function() {
            var $editor = jQuery(this);
            $editor.removeData("ckEditorName");
            $editor.unbind("mouseenter mouseleave click blur focus");
        });

        jQuery( "*[contenteditable=true]" ).attr("contenteditable", "false");
    };
    /**
     * Enable links for all inlineeditable texts in links (menu labels, ...)
     * @return void
     */
    NgeInlineEditingTexts.prototype.enableLinks = function () {
        this._selector.find('.inlineeditablelink').unbind('click', false);
    };
    /**
     * Disable links for all inlineeditable texts in links (menu labels, ...)
     * @return void
     */
    NgeInlineEditingTexts.prototype.disableLinks = function () {
        this._selector.find('.inlineeditablelink').bind('click', false);
    };
    
    return NgeInlineEditingTexts;
})();