
var videoSearchPlugin = new ToolbarPlugin('video.search');
videoSearchPlugin.title="Search video";
videoSearchPlugin.description="Search a new video";
videoSearchPlugin.html='<span class="ngetoolbarplugin ngetoolbar-icon icomoon-search" data-plugin="image.search"></span>';
videoSearchPlugin.selector="ngeelement-video_search";
videoSearchPlugin.execute = function($element){
	var dataNge = jQuery($element).data('nge');
	//var contentType = dataNge.type;
	var contentType = 'image';
	loadInlineForm({url: "index.php?option=com_nge&view=inlinecontent&content=" + contentType + "&format=raw",
		    element: $element,
		    title: '<span class="icomoon-search"></span>&nbsp;Choose image',
		    backgroundColor: '204389',
		    width:  800,
		    height: 600,
		    refresh : function(element, imageName){
			element.find("img").attr("src", rootUrl+imageName);
		    },
		    submit : function(element, oldImageName, currentImageName){
			if(currentImageName !== oldImageName){
			    var elementData = JSON.parse(element.attr('data-nge'));
			    var structureData = element.closest('.ngeeditablestructure').data('nge');            
			    if (storeInline(structureData.id, structureData.type, elementData.source, currentImageName)){
				nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
			    }
			}
		    },
		    cancel : function(element, oldImageName, currentImageName){
			if(currentImageName !== oldImageName){
			    element.find("img").attr("src", rootUrl+oldImageName);
			}
		    }
		});
}
ngeElementsToolbar.addPlugin(videoSearchPlugin);    
    