
var glyphSearchPlugin = new ToolbarPlugin('glyph.search');
glyphSearchPlugin.title=COM_NGE_INLINE_SEARCHGLYPH;
glyphSearchPlugin.description=COM_NGE_INLINE_SEARCHGLYPH_DESC;
glyphSearchPlugin.html='<span class="ngetoolbarplugin ngetoolbar-icon icomoon-search"></span>';
glyphSearchPlugin.selector="ngeelement-glyph_search";

glyphSearchPlugin.update = function (item, $element, data) {
    if (data.type == "glyph")
	item.$button.show();
    else
	item.$button.hide();
}

glyphSearchPlugin.execute = function($element){
	var dataNge = jQuery($element).data('nge');
	var contentType = dataNge.type;
	var value = dataNge.value;
	var contentType = 'glyph';
	loadInlineForm({url: "index.php?option=com_nge&view=inlineconfig&format=raw&layout=form&type=element&element=glyph&form=search&value=" + value,
		    element: jQuery($element),
		    title: '<span class="icomoon-search"></span>&nbsp;' + COM_NGE_INLINE_GLYPHMANAGER,
		    backgroundColor: '#646D9C',
		    width:  800,
		    height: 600,
		    refresh : function($element, itemType, itemId){
    		    switch (itemType){
    			case 'icomoon' :
				var currentClassGlyph= $element.attr("class").split(' ').join('|');
				currentClassGlyph = currentClassGlyph+'|';
				currentClassGlyph = currentClassGlyph.match(/icomoon-([^\|]+)\|/);
				$element.removeClass("icomoon-"+currentClassGlyph[1])
				.addClass("icomoon-"+itemId);
    			    break;
			default:	
			    break;
			}
		    },
		    submit : function(element, oldItemId, currentItemId){
			if(currentItemId !== oldItemId){
			    var elementData = JSON.parse(element.attr('data-nge'));
			    var structureData = element.closest('.ngeeditablestructure').data('nge');

			    if (storeInline(structureData.id, structureData.type, elementData.source, "icomoon-"+currentItemId)){
				elementData.value = "icomoon-"+currentItemId;
				jQuery($element).attr('data-nge', JSON.stringify(elementData));
				nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
			    }
			}
		    },
		    cancel : function(element, oldItemId, currentItemId){
			console.log('OOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOOO');
			if(currentItemId !== oldItemId){
			    var currentClassGlyph= element.attr("class").split(' ').join('|');
			    currentClassGlyph = currentClassGlyph+'|';
			    currentClassGlyph = currentClassGlyph.match(/icomoon-([^\|]+)\|/);                
			    element.removeClass("icomoon-"+currentClassGlyph[1])
			    .addClass("icomoon-"+oldItemId);
			}
		    }
		});
}
ngeElementsToolbar.addPlugin(glyphSearchPlugin);    

var glyphRemovePlugin = new ToolbarPlugin('glyph.remove');
glyphRemovePlugin.title= COM_NGE_INLINE_REMOVEGLYPH;
glyphRemovePlugin.description= COM_NGE_INLINE_REMOVEGLYPH_DESC;
glyphRemovePlugin.html='<span class="ngetoolbarplugin ngetoolbar-icon icomoon-minus"></span>';

glyphRemovePlugin.update = function (item, $element, data) {
    if (data.type == "glyph")
	item.$button.show();
    else
	item.$button.hide();
}

glyphRemovePlugin.execute = function($element){
    $element = jQuery($element);
    var elementData = JSON.parse($element.attr('data-nge'));
    var structureData = $element.closest('.ngeeditablestructure').data('nge');
    if (storeInline(structureData.id, structureData.type, elementData.source, "")){
	$element.removeClass(elementData.value);
	elementData.value = '';
	$element.attr('data-nge', JSON.stringify(elementData));
	nge.showNotification( COM_NGE_JS_EDITING_CONTENT_SAVED , 'success', 3000);
    }    
}
ngeElementsToolbar.addPlugin(glyphRemovePlugin);    
