

 NgeElementsToolbar = function(){
    
    this.$toolbar = jQuery('#ngeelement-toolbar');
    this.$plugins = jQuery("#ngeelement-toolbar-plugins");
    this.$status = jQuery("#ngeelement-toolbar-status");
    this.plugins = new Array();
    this.$currentElement = '';
    var _this = this;
    
    this.addPlugin = function (item) {
	_this.plugins.push(item);
	item.$button = jQuery(item.html).appendTo(jQuery(_this.$plugins));
	item.$button.attr('title', item.description);
	    item.init();
	    jQuery(item.$button).mouseenter(function(){
		jQuery(_this.$status).html(item.title).show();
		jQuery("#ngeelement-toolbar-status").html(item.title).show();
	    }).mouseleave(function(){
		jQuery(_this.$status).html('');
	    }).click(function(){
		event.stopPropagation();
		item.execute(_this.$currentElement);
	    });
    };    
    
    /*Clear all specific options*/
    this.clear = function(){
        _this.$toolbar.find('.ngetoolbar-icon').css({
            "font-size": "", 
            "line-height": "", 
            "margin": ""
        });
        _this.$toolbar.find('.ngetoolbar-title, .ngetoolbar-status, .ngetoolbar-save').css({
            "font-size": "", 
            "line-height": "", 
        });
    };
    
    /* Update toolbar buttons when mouse over $element*/
    this.update = function($element){
	_this.$currentElement = $element;
	/* Loading data */
	var dataNge = jQuery($element).data('nge');
	if (null != dataNge){
	    var contentType = dataNge.type;
	    var elementTitle = dataNge.title;
	    _this.$toolbar.find('.ngetoolbar-status').html(elementTitle);
	    var $structure = jQuery($element).closest('.ngeeditablestructure');
	    //jQuery(this).closest(".ngeeditablestructure").find(".ngetoolbar-status").html(elementTitle).show();	    

	    /* Show/hide buttons for the current element */
	    jQuery.each(_this.plugins, function(key,item) {
		item.update(item, $element, dataNge);
	    }); 

	    //Changing color like parent structure	
	    var $structureToolbarTitle = $structure.find('.ngetoolbar').first();
	    if ($structureToolbarTitle.length > 0) {
		var $structureToolbarTitle = $structure.find('.ngetoolbar-title').first();
		var backgroundColor = $structureToolbarTitle.css('background');
	    }
	    else {
		//Part toolbar
		var backgroundColor = jQuery('#part-toolbar-title').css('background');
	    }

	    _this.$toolbar.find('.ngetoolbar-title').css('background', backgroundColor);
	    _this.$toolbar.find('.ngetoolbar-status').css('background', backgroundColor);
	    _this.$toolbar.find('.ngetoolbar-icon').css('background', backgroundColor);
	    jQuery('#ngeelement-toolbar-plugins').show();

	    /* Moving toolbar upon current element and display*/

	    var elementOffset = jQuery($element).offset();
	    var posTop = elementOffset.top - _this.$toolbar.height();
	    var posLeft = elementOffset.left;
	    _this.$toolbar.css({
		    "top":  posTop+"px",
		    "left":  posLeft+"px"
	    });

	    _this.$toolbar.addClass("toolbar-show");
	    _this.$toolbar.css('display', 'inline-block');
	    jQuery('#ngeelement-toolbar').css('display', 'inline-block');
	}
    }
    
    this.show = function(){
	_this.$toolbar.css('display', 'inline-block');        	
    }
    
    this.hide = function($element){
        _this.$toolbar.removeClass("toolbar-show");
	_this.$toolbar.css('display', 'none');
	_this.$toolbar.find('.ngetoolbar-status').html('');
	jQuery($element).closest(".ngeeditablestructure").find(".ngetoolbar-status").html('').hide();
    }
    
    this.showStatus = function(text) {
	jQuery(_this.$status).html(text).show();;
    }
    this.hideStatus = function() {
	jQuery(_this.$status).html().hide();
    }
    
};
 var ngeElementsToolbar = new NgeElementsToolbar();



var NgeElementsToolbar = (function () {
   
    function NgeInline(selector) {
        this._selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);
        this._editing = {};
        this._editing.texts = new NgeInlineEditingTexts(this._selector);
        this._editing.elements = new NgeInlineEditingElements(this._selector);
   
    }
    
    NgeInline.prototype.editing = function () {};
    
    return NgeInline;
})();


function ToolbarPlugin(name){
    this.name = name;
    this.html = '';
    this.selector=''; /* can be selector string, or function */
    this.$button='';
    var _this = this;
    
    /* First initialization when adding to the toolbar*/
    this.init = function(){
    }
    
    /* update plugin button display among current element */
    this.update = function (item, $element, data) {
	if (typeof this.selector == 'function'){
	    var pluginEnabled = _this.selector($element);
	}
	else {
	    var pluginEnabled = jQuery($element).hasClass(_this.selector);
	}
	if (pluginEnabled) 
	    _this.$button.show();
	else
	    _this.$button.hide();
    }

    /* execute plugin for the target element */
    this.execute = function ($element) {	
    }
}


    /* enableNgeInlineEditing 
     * enable inlineediting in all tags ready for that.
     * */
    enableNgeEditingElements = function (selector, isElement) {
	    var $selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);
	    var isElement = typeof isElement !== 'undefined' ? isElement : false;
	    var timerToolbarLeaving;
	    //Selectable items (glyphs, images)
            var previousElement = null;
            $selector.on("mouseenter", ".ngeelement", function (evt, isUpdate) {
                isUpdate = typeof isUpdate !== 'undefined' ? isUpdate : false;
                clearTimeout(timerToolbarLeaving);
                if(isUpdate || !jQuery(this).is(previousElement) 
                        || (jQuery(this).is(previousElement) && !ngeElementsToolbar.$toolbar.hasClass("toolbar-show"))){
                    ngeElementsToolbar.clear();
                    ngeElementsToolbar.update(this);
                }
                
                previousElement = jQuery(this);
	    }).on("mouseleave", ".ngeelement", function (e) {
                var element = e.toElement || e.relatedTarget;
                
                /*If we return over the toolbar element don't hide else hide*/
                timerToolbarLeaving = setTimeout(function () {
                    if(jQuery(element).closest(".ngetoolbar").length === 0){
                        ngeElementsToolbar.hide();
                    }
                }, 200);
	    });

	    jQuery(".ngeelement").each(function () {
		jQuery(this).addClass('ngeeditable');	    
	    });
            
            ngeElementsToolbar.$toolbar.mouseenter(function() {
                clearTimeout(timerToolbarLeaving);
            }).mouseleave(function(e){
                var element = e.toElement || e.relatedTarget;
                
                /*If we return over the ngeelement don't hide else hide*/
                timerToolbarLeaving = setTimeout(function () {
                    if(jQuery(element).closest(".ngeelement").length === 0){
                        ngeElementsToolbar.hide();
                    }
                }, 200);
            });
    };  

    disableNgeEditingElements = function (selector) {
	    var $selector = typeof selector !== 'undefined' ? jQuery(selector) : jQuery(document);
            $selector.off("mouseenter", ".ngeelement");
            $selector.off("mouseleave", ".ngeelement");
    };

    /*Triggering functions.*/
    jQuery(document).on( "ngeStartEdition", function() {
	enableNgeEditingElements();	
    });

    jQuery(document).on( "ngeDisableEdition", function() {
	disableNgeEditingElements();
    });