/*  
 * Prototype NGE 
 * @version: 1.1
 */

/* Internal list of scripts. See NGE.prototype.loadScript*/
//var ngeDocumentScripts = [];


/*jQuery fn function*/
/* Keep hover popover open when mouse move inside */
jQuery(document).ready(function () {
    var oldHide = jQuery.fn.popover.Constructor.prototype.hide;

    jQuery.fn.popover.Constructor.prototype.hide = function() {
	if (this.options.trigger === "hover" && this.tip().is(":hover")) {
	    var that = this;
	    /* try again after what would have been the delay*/
	    setTimeout(function() {
		return that.hide.call(that, arguments);
	    }, that.options.delay.hide);
	    return;
	}
	oldHide.call(this, arguments);
    };
});

var NGE = (function () {
    /**** Public attribut ****/
    this._isFirstNotification = true;

    /* Startup mode. Editor is locked */
    this.isEditing = false;


    /**** Public method ****/
    /**
     * Detect if the navigator are mobile or tablet
     */
    NGE.prototype.isMobile = function () {
        var isMobile = false; /*initiate as false*/
        
        /* device detection */
        if (/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|ipad|iris|kindle|Android|Silk|lge |maemo|midp|mmp|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows (ce|phone)|xda|xiino/i.test(navigator.userAgent)
                || /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(navigator.userAgent.substr(0, 4)))
            isMobile = true; 
        
        return isMobile;
    };
    
        
    /**
     * Init Mainbar
     */
    NGE.prototype.initMainbar = function () {
        /*Private function*/
        activeClickUnlockEdition = function (ngeEditingScriptsLoaded, mainbarTheme) {
            jQuery("#ngemainbar-button").children("span").hide();
            jQuery("#ngemainbar-button").children("img").hide();
            /*Backdrop use to disable click in the page or if we like, add a loader on the whole page*/
            jQuery("body").append('<div id="nge-backdrop-loading"></div>');
            jQuery("#ngemainbar-button").children("div.nge-loading1").show(200, function () {
                if (document.getElementById("ngemainbar-button-icon").className == "icomoon-lock") {
                    if (ngeEditingScriptsLoaded) { /* Script already loaded */
                        unlockEdition();
                    } else {

                        /* Loading all scripts for editing */
                        var url = "";
                        if (mainbarTheme === "horizontal") { /* Loading editing capabilities for workshop */
                            url = 'index.php?option=com_ngd&task=workshop.load';
                        } else {
                            url = 'index.php?option=com_nge&task=editor.load';
                        }

                        var deferreds = [];                        
		//Be sure all scripts are loaded
		//all nge editing stuff
	          deferreds.push(jQuery.ajax(url));
		  //libraries
                        deferreds.push(jQuery.ajax({url: rootUrl + 'media/com_nge/jquery-ui/jquery-ui.min.js', dataType: "script", cache:true}));
                        deferreds.push(jQuery.ajax({url: rootUrl + 'media/com_nge/bootbox/bootbox.min.js', dataType: "script", cache:true})); 
                        deferreds.push(jQuery.ajax({url: rootUrl + 'media/com_nge/tabdrop/js/bootstrap-tabdrop.js', dataType: "script", cache:true})); 
                        deferreds.push(jQuery.ajax({url: rootUrl + 'media/com_nge/sortable/Sortable.min.js', dataType: "script", cache:true}));
                        jQuery.when.apply(jQuery, deferreds).done(function (a1, a2, a3, a4, a5, a6) {
		//When other scripts are loaded
                            jQuery.ajax({url: rootUrl + 'media/com_nge/jquery-ui/jquery.ui.touch-punch.min.js',  dataType: "script", cache:true});
                            jQuery('body').append(a1[0]);
                            ngeEditingScriptsLoaded = true;
                            unlockEdition();
                            
                            /*Event mainbar help*/
                            jQuery(document).off("click", "#ngemainbarhelp-btn").on('click', "#ngemainbarhelp-btn", function(){
                                ngetools.loadModal({
                                    url : rootUrl+"index.php?option=com_nge&view=help&format=raw",
                                    title: '<span style="margin-right:5px;" class="icomoon icomoon-question"></span>&nbsp;INFORMATIONS',
                                    backgroundColor: '#00B9E6',
		    hoverColor: '#00CAE2',
                                    width:  85,
                                    height: 80,
                                    responsive: true,
                                    modalId: "ngeHelp",
                                    buttons : {
                                        cancel: {
                                            label: "FERMER",
                                            stopEventsPropagation: false,
                                            callback: function ($button) {
                                                $button.closest('.modal').modal("hide");
                                            }
                                        }
                                    },
                                    callback: function () {}
                                });
                            });
                        });
                    }
                } else {
                    lockEdition();
                }
            });
        };

        /*Mainbar Events*/
        var ngeEditingScriptsLoaded = false;
        var mainbarTheme = jQuery("#nge-editing-bar").data("nge-mainbar-theme");

        if (mainbarTheme === "horizontal") { /* Loading editing capabilities for workshop */
            activeClickUnlockEdition(ngeEditingScriptsLoaded, mainbarTheme);
        } else {
            jQuery("#ngemainbar-button").click(function () {
                activeClickUnlockEdition(ngeEditingScriptsLoaded, mainbarTheme);
            });
        }
    };

    /**
     * Show notification message when update values.
     * @param String message 
     * @param String type Message type (success, error, warning)
     * @param int duration
     */
    NGE.prototype.showNotification = function (message, type, duration) {
        var messageBox = jQuery("#nge-message-box");

        if (this._isFirstNotification) {
            var mainbar = jQuery("#nge-editing-bar");
            var messageBoxTop = 10;
            
            if(mainbar.length === 0){ /*When mainbar not exist take body*/
                mainbar = jQuery("body");
                messageBoxTop = mainbar.offset().top + 10 - jQuery(window).scrollTop();
            }else{
                messageBoxTop = mainbar.offset().top + mainbar.height() + 10 - jQuery(window).scrollTop();
            }

            messageBox.css({
                "top": messageBoxTop + "px"
            });

            this._isFirstNotification = false;
        }

        if (messageBox.length > 0) {
            var messageBoxClone = messageBox.children(".nge-message-box-first").clone(true);
            var icon = "icomoon-checkmark";

            if (type == "warning") {
                icon = "icomoon-warning";
            } else if (type == "error") {
                icon = "icomoon-cross";
            }
            messageBoxClone.removeClass("nge-message-box-first");
            messageBoxClone.addClass("nge-message-box-" + type);

            messageBoxClone.find(".icomoon").addClass(icon)
            messageBoxClone.find(".nge-message").html(message);
            messageBox.append(messageBoxClone);

            messageBoxClone.hide().show("slide", {direction: "left"}, 400, function () {
                setTimeout(function () {
                    messageBoxClone.fadeOut(400, function () {
                        messageBoxClone.remove();
                    });
                }, duration);
            });
        }
    };
    
    /**
     * getWidgetHtml
     * Get widget html
     * @param widgetId
     */
    NGE.prototype.getWidgetHtml = function (widgetId, callbackSuccess, callbackError) {
        jQuery.ajax({
            url: rootUrl+"index.php?option=com_nge&task=part.alter&pk="+widgetId,
            type: "POST",
            async:false,
            success: function (resultHtml) {
                if(typeof callbackSuccess !== undefined && typeof callbackSuccess === "function"){
                    callbackSuccess.call(this, resultHtml);
                }
            },
            error: function (error) {
                if(typeof callbackError !== undefined && typeof callbackError === "function"){
                    callbackError.call(this, error);
                }
            }
        });
    };
    /**
     * Check if user is logged
     * @param Function functionName 
     */
    NGE.prototype.checkAuthentication = function (functionName) {
        var isLogged = false;

        jQuery.ajax({
            url: tasksUrl + "&task=check_authentication.check",
            async: false,
            type: 'POST',
            success: function (resultJson) {
                /*try{*/
                json = jQuery.parseJSON(resultJson);
                if (json.result === 0) {
                    /*User not connected*/
                    jQuery.ajax({
                        url: "index.php?option=com_nge&view=check_authentication&format=raw",
                        type: 'POST',
                        success: function (result) {
                            /*try{*/
                            bootbox.hideAll();
                            bootbox.dialog({
                                message: result,
                                backdrop: false,
                                buttons: {
                                    main: {
                                        label: COM_NGE_JS_AUTH_LOGIN_BUTTON,
                                        className: "btn-primary",
                                        callback: function () {
			 var username = document.getElementById('nge-authentication-username').value;
                                            var password = document.getElementById('nge-authentication-password').value;
                                            var token = jQuery("#nge-authentication-token").find('input').attr('name');
                                            var url = "index.php?option=com_nge&task=check_authentication.login&" + token + "=1";
                                            jQuery.ajax({
                                                url: url,
                                                async: false,
                                                data: {"username": username, "password": password},
                                                success: function (resultJson) {
                                                    try {
                                                        json = jQuery.parseJSON(resultJson);
                                                        if (json.result === 0) {
                                                            nge.showNotification(json.message, 'error', 3000);
                                                            isLogged = false;
                                                        } else {
                                                            var iframeDocument = jQuery(jQuery('#partconfig_iframe')[0].contentDocument);
                                                            if (iframeDocument.length > 0) {
                                                                jQuery(iframeDocument).find("#nge-config-token > input").attr("name", json.token);
                                                            }

                                                            nge.showNotification(json.message, 'success', 3000);

                                                            if (typeof functionName === "function") {
                                                                setTimeout(function () {
                                                                    functionName.call();
                                                                }, 1000);
                                                            }

                                                            isLogged = true;
                                                        }
                                                    } catch (err) {
                                                        console.error("Error : Failed to login<br>" + err.toString());
                                                        isLogged = false;
                                                    }
                                                }
                                            });

                                            return isLogged;
                                        }
                                    },
                                    danger: {
                                        label: COM_NGE_JS_AUTH_CANCEL_BUTTON,
                                        className: "btn",
                                        callback: function () {}
                                    }
                                }
                            }).css({"z-index": "99999"});
                            /*} catch(err){                                            
                             console.error("Erreur : Failed to login<br>"+err.toString());
                             isLogged = false;
                             }*/
                        }
                    });
                } else {
                    if (typeof functionName === "function") {
                        functionName.call();
                    }
                }
                /*} catch(err){                                            
                 console.error("Erreur : Impossible de savoir si vous êtes authentifié.</br>"+err.toString());
                 isLogged = false;
                 }*/
            }
        });
    };
        
    
});

var nge = new NGE();