<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * 
 * Used to load preset designs
 * 
 * 
 */

defined('_JEXEC') or die;

require_once (NGEPATH_HELPERS . '/data/datadriver.php');

class NgePresetsDriver extends NgeDataDriver
{

    public static function load($id) {
	$db = JFactory::getDbo();
    	$sql = 'SELECT * FROM #__nge_presets WHERE id=' . (int) $id;
	return NGEDATA::loadObject($sql);
    }

    
    /**
     * Get list of designs
     * @param type $type
     * @param type $name
     * @param type $thumbnail if true, including thumbnail preview. If empty, is generated while loading
     * 
     * @return type
     */
    public static function loadList($type, $name){
	// Get the database object.
	$db = JFactory::getDbo();

	// Set the query and get the result list.
	$query = $db->getQuery(true);
	$query->select('p.id, p.title, p.description,  p.params, thumbnail');
	$query->from('#__nge_presets AS p')
	->where('p.state = 1')
	->where('p.type = ' . $db->quote($type))
	->where('p.name = ' . $db->quote($name))
	->order('ordering, title');

	$db->setQuery($query);
	$presetsList = $db->loadObjectlist();

	return $presetsList;
    }
}