<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * 
 * Used to add custom css to any item in the page
 * 
 * 
 */

defined('_JEXEC') or die;

require_once (NGEPATH_HELPERS . '/data/datadriver.php');
require_once NGEPATH_HELPERS . '/ngedata.php';

class NgePatternDriver extends NgeDataDriver
{
    /**
     * Load pattern informations
     * @param type $patternId
     * @return \stdClass
     */
    public static function load($patternId){

		    //SELECT pattern
		    $query = "SELECT id, title, description, name, type, content, params, settings FROM #__nge_patterns WHERE id=" . (int) $patternId;
		    $pattern = NGEDATA::loadObject($query);
		    if ($pattern == null){
			    $pattern = new stdClass();
		    }
		    return $pattern;
    }

    /**
     * Load Params Object
     * @param type $patternId
     * @return type
     */
    public static function loadParams($patternId){

	    $query = "SELECT params FROM #__nge_patterns WHERE id=" . (int) $patternId;
	    $content = NGEDATA::loadResult($query);	
	    if ($content != null)
		$content = json_decode($content);
	    return $content;
    }

    public static function create($type, $name, $title, $description, $content, $params, $settings, $pk){
	    $user = JFactory::getUser();
	    $db = JFactory::getDBO();

	    //Parse content. When creating from config screen (save as pattern), content is empty
	    if(is_string($content) && ($content !='')){
		parse_str($content, $content);
		//If ngejson:: prefix exists, the following value is formated as litteral json string => decode it
		//Content	    
		$keyArrayJsonContent = NGE::recursive_array_search('ngejson::',$content);
		if($keyArrayJsonContent !== false){//If value with json object string exists
		    $content = NGE::decode_json_string($content, $keyArrayJsonContent);
		}
		$content = addslashes(json_encode($content));
	    }
	    else {
		$defaultPatternContent = NGEDATA::loadResult('SELECT content FROM #__nge_parts_library WHERE part = ' . NGEDATA::quote($name));
		if ($defaultPatternContent != null)
		    $content= addslashes($defaultPatternContent); 
	    }
	    
	    //Parse params	    
	    if(is_string($params))
		parse_str($params, $params);

	    $keyArrayJsonParams = NGE::recursive_array_search('ngejson::',$params);
	    if($keyArrayJsonParams !== false){/*If value with json object string exists*/
		$params = NGE::decode_json_string($data_ngeparams, $keyArrayJsonParams);
	    }

	    //If coming from existing part, load stored params, because the form in the screen can be not complete (subforms)
	    //Merging params with existing part
	    if ($pk != 0){
		$sql = 'SELECT params FROM #__nge_parts WHERE id=' . (int) $pk;
		$storedParams = NGEDATA::loadResult($sql);
		$paramsArray = json_decode($storedParams, true);
		$mergedParams = NGE::array_merge_recursive_replace($paramsArray, $params);
		$data_ngeparams = $mergedParams;
                $registry = new JRegistry;
		$registry->loadArray($data_ngeparams);
		$params = (string) $registry;
	    }
            
            if(!is_string($params)){
                $params = json_encode($params);
            }
            
	    $params = addslashes($params);
	    
	    //Parse settings. When creating from config screen (save as pattern), content is empty
	    if (is_string($settings)){
		if ($settings !='')
		    parse_str($settings, $settings);
		else{
		    $settings = new stdClass();
		    $settings->type = $type;
		    $settings->name = $name;
		    $settings->title = $title;
		    $settings->description = $description;
		}		    
	    }
	    $settings = addslashes(json_encode($settings));	    
	    
	    $resut = array();
	    try {
                $sql = sprintf('INSERT INTO #__nge_patterns (type, name, title, description, content, params, settings, ordering, state, created, created_by) VALUES( %s, %s, %s, %s, "%s", "%s", "%s", 0, 1, NOW(), %d)' , $db->quote($type), $db->quote($name), $db->quote($title), $db->quote($description), $content, $params, $settings, $user->id);
                NGEDATA::execute($sql);
		$patternId = NGEDATA::insertid();
		$result['result'] = "1";
		$result['status'] = "The pattern was created";
		$result['pattern'] = self::load($patternId);
	    }
	    catch (Exception $e) {
		$result['result'] = "0";
		$result['status'] = JErrorPage::render($e);		    
	    }	
	    return $result;
    }

    public static function update($id, $title, $description, $content, $params, $settings){

	    if(is_string($content))
		parse_str($content, $content);

	    /*If ngejson:: prefix exists, the following value is formated as litteral json string => decode it*/
	    //Content	    
	    $keyArrayJson = NGE::recursive_array_search('ngejson::',$content);
	    if($keyArrayJson !== false){/*If value with json object string exists*/
		$content = NGE::decode_json_string($content, $keyArrayJson);
	    }
	    $content = json_encode($content);
	    
	    if(is_string($params))
		parse_str($params, $params);
	    //Params
	    $keyArrayJson = NGE::recursive_array_search('ngejson::',$params);
	    if($keyArrayJson !== false){/*If value with json object string exists*/
		$params = NGE::decode_json_string($params, $keyArrayJson);
	    }
	    $params = json_encode($params);
	    
	    //Merging content and params with existing pattern
	    $pattern = self::load($id);
	    if ($pattern->content != ''){
		$oldContentArray = json_decode($pattern->content, true);
		$addedContentArray = json_decode($content, true);
		$mergedContent = NGE::array_merge_recursive_replace($oldContentArray, $addedContentArray);
		$data_ngecontent = $mergedContent;
		$registry = new JRegistry;
		$registry->loadArray($data_ngecontent);
		$content = (string) $registry;
	    }
	    if ($pattern->params != ''){
		$oldParamsArray = json_decode($pattern->params, true);
		$addedParamsArray = json_decode($params, true);
		$mergedParams = NGE::array_merge_recursive_replace($oldParamsArray, $addedParamsArray);
		$data_ngeparams = $mergedParams;
		$registry = new JRegistry;
		$registry->loadArray($data_ngeparams);
		$params = (string) $registry;
	    }
	    
	    if(is_string($settings))
		parse_str($settings, $settings);
	    $settings = json_encode($settings);
	    	    	    
	    $resut = array();
	    try {
		//Saving and resetting thumbnail preview. Will be recreated if used in the screens
		$sql = sprintf('UPDATE #__nge_patterns SET title="%s", description="%s", content="%s", params="%s", settings="%s", thumbnail="" WHERE id=%d ',$title, $description, addslashes($content), addslashes($params), addslashes($settings), $id);
		NGEDATA::execute($sql);
		$result['result'] = "1";
		$result['status'] = "Pattern updated";
		$result['pattern'] = self::load($id);
	    }
	    catch (Exception $e) {
		$result['result'] = "0";
		$result['status'] = JErrorPage::render($e);		    
	    }	
	    return $result;
    }

    public static function duplicate($id){

	    $user = JFactory::getUser();
	    $result = array();

	    try {
		$sql = sprintf('INSERT INTO #__nge_patterns (name, type, title, description, content, params, settings, ordering, state, created, created_by) SELECT name, type, CONCAT(title, "(1)"), description, content, params, settings, ordering, state, NOW(), %d FROM #__nge_patterns WHERE id= %d' , $user->id, $id);
		NGEDATA::execute($sql);
		$patternId = NGEDATA::insertid();		    
		$result['result'] = "1";
		$result['status'] = "The pattern was duplicated";
		$result['pattern'] = self::load($patternId);
	    }
	    catch (Exception $e) {
		$result['result'] = "0";
		$result['status'] = JErrorPage::render($e);		    
	    }
	    return $result;
    }

    public static function remove($id){

	    $result = array();

	    try {
		$sql = sprintf('DELETE FROM #__nge_patterns WHERE id= %d' , $id);
		NGEDATA::execute($sql);
		$result['result'] = "1";
		$result['status'] = "The pattern was removed";
	    }
	    catch (Exception $e) {
		$result['result'] = "0";
		$result['status'] = JErrorPage::render($e);
	    }	
	    return $result;
    }
	
    public static function storeThumbnail($id, $content) {
	$content = NGE::minify($content);
	//Replace query 
	$sql = sprintf('UPDATE #__nge_patterns set thumbnail = "%s" WHERE id="%d"', addslashes($content), $id);
	return NGEDATA::execute($sql);
    }

}