<?php

/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 * 
 * 
 * Used to add custom css to any item in the page
 * 
 * 
 */
defined('_JEXEC') or die;

require_once (NGEPATH_HELPERS . '/data/datadriver.php');
require_once NGEPATH_HELPERS . '/ngedata.php';

class NgeNgePartDriver extends NgeDataDriver {
    /*
     * Basic load
     */

    public static function load($id) {

	$sql = 'SELECT p.id, p.part as name, p.title, p.alias, p.content, p.params, p.html, p.css, p.js, p.published, p.created, p.created_by ';
	$sql .= 'FROM #__nge_parts AS p ';
	$sql .= 'WHERE p.id =' . (int) $id;
	return NGEDATA::loadObject($sql);
    }

    public static function loadProperty($partId, $propertyType, $propertyPath) {

	//Property key contains the property path separated by - Example : content.header.label
	$keys = explode('.', $propertyPath);

	// If no key, error and stopping script
	if (count($keys) == 0) {
	    print('error - No property key defined');
	    exit();
	}

	// loading corresponding params
	if (($propertyType == 'content') || ($propertyType == 'params')) {
	    $sql = 'SELECT ' . $propertyType . ' FROM #__nge_parts WHERE id=' . (int) $partId;
	    $currentJson = NGEDATA::loadResult($sql);

	    if (!$currentJson) {
		print('error - No ' . $propertyType . ' found');
		exit();
	    }

	    $jsonArray = json_decode($currentJson, true);
	    //$content or params is an array of arrays.
	    //searching the corresponding pointer (notice & reference)
	    $propertyPointer = & $jsonArray;

	    for ($i = 0; $i < count($keys); $i++) {
		$propertyPointer = & $propertyPointer[$keys[$i]];
	    }

	    $result = $propertyPointer;
	} else
	    return false;

	return $result;
    }

    /*
     * Saving value for a single property
     * Value can be single, or object
     * If object, data is merged
     */

    public static function storeProperty($partId, $value, $propertyType, $propertyPath, $valueType = '', $multiSelect = []) {

	//Property key contains the property path separated by - Example : content.header.label
	$keys = explode('.', $propertyPath);

	// If no key, error and stopping script
	if (count($keys) == 0) {
	    print('error - No property key defined');
	    exit();
	}

	// loading corresponding params
	if (($propertyType == 'content') || ($propertyType == 'params')) {
	    $sql = 'SELECT ' . $propertyType . ' FROM #__nge_parts WHERE id=' . (int) $partId;
	    $currentJson = NGEDATA::loadResult($sql);

	    if (!$currentJson) {
		print('error - No ' . $propertyType . ' found');
		exit();
	    }

	    //Value can be single value or object
	    //If object : valueType = 'object'
	    if ($valueType == 'object') {
		//If exists ngejson:: prefix, decode it
		//ngejson: indicates that the following
		// value is a litteral json string
		parse_str($value, $value);
		$keyArrayJson = NGE::recursive_array_search('ngejson::', $value);
		if ($keyArrayJson !== false) {/* If value with json object string exist */
		    $value = NGE::decode_json_string($value, $keyArrayJson);
		}
	    }

	    $jsonArray = json_decode($currentJson, true);
            
	    //$content or params is an array of arrays.
	    //searching the corresponding pointer (notice & reference)
	    $propertyPointer = & $jsonArray;
	    for ($i = 0; $i < count($keys); $i++) {
		$propertyPointer = & $propertyPointer[$keys[$i]];
	    }

            /*  Multi-selection
             *  If multiselect exist add value for all elements selected*/
            if(!empty($multiSelect)){
                $pos = strrpos($multiSelect[0], ".");
                if ($pos === false) { // no multidimensional table for example row or col values
                    foreach ($multiSelect as $key => $index){
                        /*Value can be a array or null*/
                        if(isset($propertyPointer[$index]) || $propertyPointer[$index] === NULL){
                            //$value can be single value (string) or object (array)
                            if (is_array($value) && is_array($propertyPointer[$index])) {
                                $mergedArray = NGE::array_merge_recursive_replace($propertyPointer[$index], $value);
                                $propertyPointer[$index] = $mergedArray;
                            } else { //single value
                                $propertyPointer[$index] = $value;
                            }
                        }
                    }
                }else{ //Is multidimensional table like cells value
                    foreach ($multiSelect as $key => $index){
                        $valueSplit = explode(".", $index);
                        /*Value can be a array or null*/
                        if(isset($propertyPointer[intval($valueSplit[0])]) 
                            && (isset($propertyPointer[intval($valueSplit[0])][intval($valueSplit[1])]) || $propertyPointer[intval($valueSplit[0])][intval($valueSplit[1])] === NULL)){
                            //$value can be single value (string) or object (array)
                            if(is_array($value) && is_array($propertyPointer[intval($valueSplit[0])][intval($valueSplit[1])])){
                                $mergedArray = NGE::array_merge_recursive_replace($propertyPointer[intval($valueSplit[0])][intval($valueSplit[1])], $value);
                                $propertyPointer[intval($valueSplit[0])][intval($valueSplit[1])] = $mergedArray;
                            }else{
                                $propertyPointer[intval($valueSplit[0])][intval($valueSplit[1])] = $value;
                            }
                        }
                    }
                }
            }else{
                //$value can be single value (string) or object (array)
                if (is_array($value) && is_array($propertyPointer)) {
                    $mergedArray = NGE::array_merge_recursive_replace($propertyPointer, $value);
                    $propertyPointer = $mergedArray;
                } else { //single value
                    $propertyPointer = $value;
                }
            }

	    $newJson = json_encode($jsonArray);

	    //saving and resetting cache fields
	    $sql = 'update  #__nge_parts SET  ' . $propertyType . ' ="' . addslashes($newJson) . '", html="", css="", js="", thumbnail="", modified = NOW()  WHERE id=' . (int) $partId;
	    $result = NGEDATA::execute($sql);

	    //save history
	    if ($result) {
		$sql = 'INSERT INTO #__nge_parts_history (part_id, part, title, alias, content, params, language, created, created_by, modified, modified_by) '
			. 'SELECT id, part, title, alias, content, params, language, created, created_by, modified, modified_by FROM #__nge_parts WHERE id=' . (int) $partId;
		NGEDATA::execute($sql);

		// delete history over 20 records
		$sql = 'SELECT id FROM #__nge_parts_history WHERE part_id=' . (int) $partId . ' order by id desc limit 20,1 ';
		$id = NGEDATA::loadResult($sql);

		if ($id) {
		    $sql = 'delete FROM #__nge_parts_history WHERE part_id=' . (int) $partId . ' and id<=' . (int) $id;
		    NGEDATA::execute($sql);
		}
	    }
	} else
	    return false;

	return $result;
    }

    public static function storeHtml($id, $content) {
	$content = NGE::minify($content);
	//Replace query 
	$sql = sprintf('UPDATE #__nge_parts set html = "%s" WHERE id=%d', addslashes($content), $id);
	return NGEDATA::execute($sql);
    }

    public static function storeThumbnail($id, $content) {
	$content = NGE::minify($content);
	//Replace query 
	$sql = sprintf('UPDATE #__nge_parts set thumbnail = "%s" WHERE id="%d"', addslashes($content), $id);
	return NGEDATA::execute($sql);
    }

    /* Store final rendering for cache */
    /* 	public static function storeRender($id, $content){
      $db = JFactory::getDbo();

      $content = NGE::minify($content);
      //Replace query
      $sql = sprintf('UPDATE #__nge_parts set render = "%s" WHERE id="%s"', addslashes($content), $id);
      $db->setQuery($sql);
      return $db->execute();
      } */
    /* Store final rendering for cache */

    public static function storeCache($id, $css, $js) {
	//echo '---'.$id;
	/* 		$db = JFactory::getDbo();
	  //if ($css != '')	$css = NGE::minify($css);
	  //if ($js != '')	$js = NGE::minify($js);
	  //Replace query
	  $sql = sprintf('UPDATE #__nge_parts set css = "%s", js = "%s" WHERE id="%s"', addslashes($css), addslashes($js), $id);
	  $db->setQuery($sql);
	  return $db->execute(); */
    }

    /*
     * Add content when multiple content
     */

    public static function addItem($id, $source, $value, $label) {
	

	//Loading content params
	$sql = "SELECT content FROM #__nge_parts WHERE id=" . (int) $id;
	$contentParams = NGEDATA::loadResult($sql);

	if (!$contentParams) {
	    $result["result"] = "0";  // Saving result is not OK : session problem
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_NO_CONTENT_PARAMS_FOUND');
	    print(json_encode($result));
	    exit();
	}
	$paramsArray = json_decode($contentParams, true);

	//Adding new content
	$item = array();
	$item['source'] = $source;
	$item[$source] = $value;
	if ($label != '')
	    $item['label'] = $label;
	$paramsArray['content']['items'][$paramsArray['content']['count']] = $item;

	//Increase count value
	$count = $paramsArray['content']['count'];
	$count++;
	$paramsArray['content']['count'] = $count;

	//Saving and resetting html cache but not css and js cache
	$contentParams = json_encode($paramsArray);
	$sql = "update  #__nge_parts SET content ='" . addslashes($contentParams) . "' , html='', modified = NOW() WHERE id=" . (int) $id;
	return NGEDATA::execute($sql);

	if ($return) {
	    require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
	    require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
	    $result["id"] = $id;
	    $result["result"] = "1"; //Saving result is OK
	    //Sending back all html to be replaced in the parent sreen
	    //Full part html
	    //If the part is being edited, we suppose there was not conditional display filters. No conditional display test
	    $result["html"] = NgePartRendererDefault::render('[' . $id . ']');
	    echo json_encode($result);
	    exit();
	} else {
	    $result["result"] = "0"; //Saving result is OK, or session problem
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_SAVED');
	    print(json_encode($result));
	    exit();
	}
    }

    /*
     * Reorder content when multiple content
     */

    public static function reorderItem($id, $oldIndex, $newIndex) {

	//Loading content params
	$sql = "SELECT part, content FROM #__nge_parts WHERE id=" . (int) $id;
	$sqlResult = NGEDATA::loadObject($sql);

	if (!$sqlResult) {
	    $result["result"] = "0";  // Saving result is not OK : session problem
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_NO_CONTENT_PARAMS_FOUND');
	    print(json_encode($result));

	    exit();
	}
	$paramsArray = json_decode($sqlResult->content, true);

	//searching list of multiple properties for this part
	$multipleProperties = self::jsonMultipleProperties($sqlResult->part);

	//Removing item for each property
	$initalValues = array();
	foreach ($multipleProperties as $property) {
	    //Storing old values
	    $initalValue = $paramsArray[$property][$oldIndex];
	    //Switching alls values between
	    if ($newIndex > $oldIndex) {
		for ($i = $oldIndex; $i < $newIndex; $i++) {
		    $paramsArray[$property][$i] = $paramsArray[$property][$i + 1];
		}
		$paramsArray[$property][$newIndex] = $initalValue;
	    } else {
		for ($i = $oldIndex; $i > $newIndex; $i--) {
		    $paramsArray[$property][$i] = $paramsArray[$property][$i - 1];
		}
		$paramsArray[$property][$newIndex] = $initalValue;
	    }
	}

	//Saving and resetting html cache but not css and js cache
	$contentParams = json_encode($paramsArray);
	$sql = "update  #__nge_parts SET content ='" . addslashes($contentParams) . "' , html='', modified = NOW()  WHERE id=" . (int) $id;
	$return = NGEDATA::execute($sql);

	if ($return) {
	    require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
	    require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
	    $result["id"] = $id;
	    $result["result"] = "1"; //Saving result is OK
	    //Sending back all html to be replaced in the parent sreen
	    //Full part html
	    //If the part is being edited, we suppose there was not conditional display filters. No conditional display test
	    $result["html"] = NgePartRendererDefault::render('[' . $id . ']');
	    echo json_encode($result);
	    exit();
	} else {
	    $result["result"] = "0"; //Saving result is OK, or session problem
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_SAVED');
	    print(json_encode($result));
	    exit();
	}
    }

    /*
     * Remove content when multiple content
     */

    public static function removeItem($id, $source) {

	//Loading content params
	$sql = "SELECT part, content FROM #__nge_parts WHERE id=" . (int) $id;
	$sqlResult = NGEDATA::loadObject($sql);

	if (!$sqlResult) {
	    $result["result"] = "0";  // Saving result is not OK : session problem
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_ERROR_NO_CONTENT_PARAMS_FOUND');
	    print(json_encode($result));

	    exit();
	}
	$paramsArray = json_decode($sqlResult->content, true);

	$propertyPath = explode('.', $source);
	$index = $propertyPath[count($propertyPath) - 1];

	array_splice($paramsArray[$property], $index, 1);
	//Removing item from property array
	foreach ($multipleProperties as $property) {
	    array_splice($paramsArray[$property], $index, 1);
	}
	//Decreasing count value
	$paramsArray['count'] = $paramsArray['count'] - 1;

	//Saving and resetting html cache but not css and js cache
	$contentParams = json_encode($paramsArray);
	$sql = "update  #__nge_parts SET content ='" . addslashes($contentParams) . "' , html='', modified = NOW()  WHERE id=" . (int) $id;
	$return = NGEDATA::execute($sql);

	if ($return) {
	    require_once NGEPATH_HELPERS . '/ngecontenthelper.php';
	    require_once NGEPATH_HELPERS . '/parts/renderer/default.php';
	    $result["id"] = $id;
	    $result["result"] = "1"; //Saving result is OK
	    //Sending back all html to be replaced in the parent sreen
	    //Full part html
	    //If the part is being edited, we suppose there was not conditional display filters. No conditional display test
	    $result["html"] = NgePartRendererDefault::render('[' . $id . ']');
	    echo json_encode($result);
	    exit();
	} else {
	    $result["result"] = "0"; //Saving result is OK, or session problem
	    $result["message"] = NGE::translate('COM_NGE_EDITING_MSG_SAVED');
	    print(json_encode($result));
	    exit();
	}
    }

    /*
     * List all properties that are mutiple.
     * Used when reordering items.
     */

    private static function jsonMultipleProperties($partlibrary) {
	$multipleProperties = array();
	$multipleProperties['panels.accordion'] = array('labels', 'glyph_names', 'sources', 'htmls', 'articles', 'modules');
	$multipleProperties['panels.carousel'] = array('labels', 'glyph_names', 'sources', 'htmls', 'articles', 'modules', 'hover_sources', 'hover_htmls', 'hover_articles', 'hover_modules', 'hover_urls', 'header_labels', 'header_glyph_names', 'link_types', 'link_menus', 'link_articles', 'link_images', 'link_documents', 'link_urls', 'link_targets');
	$multipleProperties['panels.slider'] = array('labels', 'glyph_names', 'sources', 'htmls', 'articles', 'modules', 'hover_sources', 'hover_htmls', 'hover_articles', 'hover_modules', 'hover_urls', 'header_labels', 'header_glyph_names', 'link_types', 'link_menus', 'link_articles', 'link_images', 'link_documents', 'link_urls', 'link_targets');
	$multipleProperties['panels.tabs'] = array('labels', 'glyph_names', 'sources', 'htmls', 'articles', 'modules');
	$multipleProperties['panels.thumbnails'] = array('sources', 'htmls', 'articles', 'modules', 'hover_sources', 'hover_htmls', 'hover_articles', 'hover_modules', 'hover_urls', 'header_labels', 'header_glyph_names', 'link_types', 'link_menus', 'link_articles', 'link_images', 'link_documents', 'link_urls', 'link_targets');

	$multipleProperties['galleries.carousel'] = array('content_sources', 'content_images', 'content_video_sources', 'content_video_files', 'content_video_youtubes', 'content_video_vimeos', 'content_video_dailymotions', 'link_types', 'link_menus', 'link_articles', 'link_images', 'link_urls', 'link_targets', 'header_labels', 'header_glyph_names', 'captions', 'legends');
	$multipleProperties['galleries.gallery'] = array();     //TODO
	$multipleProperties['galleries.slider'] = array('content_sources', 'content_images', 'content_video_sources', 'content_video_files', 'content_video_youtubes', 'content_video_vimeos', 'content_video_dailymotions', 'link_types', 'link_menus', 'link_articles', 'link_images', 'link_urls', 'link_targets', 'content_captions', 'content_titles', 'content_headerglyphnames', 'content_legends');
	$multipleProperties['galleries.slideshow'] = array();     //TODO
	$multipleProperties['galleries.tabs'] = array('images', 'sources', 'htmls', 'articles', 'modules');
	$multipleProperties['galleries.thumbnails'] = array('content_sources', 'content_images', 'content_video_sources', 'content_video_files', 'content_video_youtubes', 'content_video_vimeos', 'content_video_dailymotions', 'link_types', 'link_menus', 'link_articles', 'link_images', 'link_urls', 'link_targets', 'content_captions', 'content_titles', 'content_headerglyphnames', 'content_legends');
	$multipleProperties['galleries.ticker'] = array('content_sources', 'content_images', 'link_types', 'link_menus', 'link_articles', 'link_images', 'link_urls', 'link_targets');

	$multipleProperties['navigation.buttonbar'] = array('labels', 'sublabels', 'glyph_names', 'link_types', 'link_menus', 'link_articles', 'link_urls', 'link_targets');
	$multipleProperties['navigation.dropdown'] = array('labels', 'glyph_names', 'link_types', 'link_menus', 'link_articles', 'link_urls', 'link_targets');
	//$multipleProperties['navigation.list'] =		array('labels', 'glyph_names', 'link_types', 'link_menus', 'link_articles', 'link_urls', 'link_targets');
	$multipleProperties['navigation.list'] = array('labels', 'glyph_names', 'link_types', 'link_menus', 'link_articles', 'link_urls');
	$multipleProperties['navigation.richmenu'] = array();     //TODO	    

	$multipleProperties['joomla.articles.list'] = array(); //No muliple items

	return $multipleProperties[$partlibrary];
    }

}
