<?php
/**
 * @package     NextGenEditor
 *
 * @copyright   Copyright (C) Teatis. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      TEATIS - www.nextgeneditor.com
 */

defined('_JEXEC') or die;

$com_path = JPATH_SITE.'/components/com_content/';
require_once $com_path.'helpers/route.php';

class NgeTagsDriver
{

	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  mixed  A string if successful, otherwise a Error object.
	 *
	 * @since   3.1
	 */
	
	public static function loadContent($params){
		$list = self::loadList($params);
		for ($i = 0; $i<count($list); $i++){
			$list[$i]->content = NgeJoomlaArticleDriver::load($list[$i]->id);
			
		}
	}
			
	public static function loadList($params)
	//public function display($tpl = null)
	{
		
		//$ordering = isset($params['ordering']) ? 	$params['ordering']: 'ordering';
		$tags = 	isset($params['tags']) ? 		$params['tags']: '';
		$types = 	isset($params['types']) ? 		$params['types']: '';
		$count = 	isset($params['count']) ? 		$params['count']: '5';
		
		
		$app		= JFactory::getApplication();

		//id[0]=2&types[0]=1

		JModelLegacy::addIncludePath(JPATH_SITE.'/components/com_tags/models', 'TagsModel');
		$tagsModel = JModelLegacy::getInstance('Tag', 'TagsModel', array('ignore_request' => true));

		
		// Load the parameters.
		$params = $app->getParams();
		$tagsModel->setState('params', $params);
		
		// Load state from the request.
		$ids = $app->input->get('id', array(), 'array');
		
		JArrayHelper::toInteger($ids);
		
		//$pkString = implode(',', $ids);$tags
		$pkString = implode(',', $tags);
		//$pkString = '2';
		$tagsModel->setState('tag.id', $pkString);
		
		// Get the selected list of types from the request. If none are specified all are used.
		//$typesr = $app->input->get('types', array(), 'array');
		$typesr = $types;
		if ($typesr)
		{
			// Implode is needed because the array can contain a string with a coma separated list of ids
			$typesr = implode(',', $typesr);
		
			// Sanitise
			$typesr = explode(',', $typesr);
			JArrayHelper::toInteger($typesr);
		
			$tagsModel->setState('tag.typesr', $typesr);
		}
		
		$language = $app->input->getString('tag_list_language_filter');
		$tagsModel->setState('tag.language', $language);
		
		// List state information
		$format = $app->input->getWord('format');
		
// 		if ($format == 'feed')
// 		{
// 			$limit = $app->getCfg('feed_limit');
// 		}
// 		else
// 		{
// 			if ($tagsModel->state->params->get('show_pagination_limit'))
// 			{
// 				$limit = $app->getUserStateFromRequest('global.list.limit', 'limit', $app->getCfg('list_limit'), 'uint');
// 			}
// 			else
// 			{
// 				$limit = $tagsModel->state->params->get('maximum', 20);
// 			}
// 		}
		
		$tagsModel->setState('list.limit', $count);
		
		$offset = $app->input->get('limitstart', 0, 'uint');
		$tagsModel->setState('list.start', $offset);
		
		$itemid = $pkString . ':' . $app->input->get('Itemid', 0, 'int');
		$orderCol = $app->getUserStateFromRequest('com_tags.tag.list.' . $itemid . '.filter_order', 'filter_order', '', 'string');
		//$orderCol = !$orderCol ? $tagsModel->state->params->get('tag_list_orderby', 'c.core_title') : $orderCol;
		
// 		if (!in_array($orderCol, $tagsModel->filter_fields))
// 		{
// 			$orderCol = 'c.core_title';
// 		}
		
		$orderCol = 'c.core_title';
		$tagsModel->setState('list.ordering', $orderCol);
		
// 		$listOrder = $app->getUserStateFromRequest('com_tags.tag.list.' . $itemid . '.filter_order_direction', 'filter_order_Dir', '', 'string');
// 		$listOrder = !$listOrder ? $tagsModel->state->params->get('tag_list_orderby_direction', 'ASC') : $listOrder;
		
// 		if (!in_array(strtoupper($listOrder), array('ASC', 'DESC', '')))
// 		{
			$listOrder = 'ASC';
//		}
		
		$tagsModel->setState('list.direction', $listOrder);
		
		$tagsModel->setState('tag.state', 1);
		
		// Optional filter text
		$filterSearch = $app->getUserStateFromRequest('com_tags.tag.list.' . $itemid . '.filter_search', 'filter-search', '', 'string');
		$tagsModel->setState('list.filter', $filterSearch);
				
		
		$items = $tagsModel->getItems();
		
	
		       // get article active in page?
        $current_article = 0;
        $jinput = JFactory::getApplication()->input;
        $option = $jinput->get('option','');
        $view = $jinput->get('view','');
        $idarticle = $jinput->get('id','');
        if($option=='com_content' && $view=='article') {
		  $current_article = $idarticle;
        }

	
		if ($items !== false)
		{
			foreach ($items as $itemElement)
			{
				$itemElement->event = new stdClass;
	
				
				!empty($itemElement->core_body)? $itemElement->text = $itemElement->core_body : $itemElement->text = null;
				!empty($itemElement->core_title)? $itemElement->title = $itemElement->core_title : $itemElement->title = null;
	
				$itemElement->active = false;
 	           if($itemElement->content_item_id==$current_article)
    	            $itemElement->active = true;

	
			}
		}
		return $items;

	}
	

}